/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services.entity;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.model.Equipment;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.Task;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.entity.EntityHandler;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbL2ServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileDistributionTask;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.BeanUtils;
import com.bwanms.util.DateFormatter;
import com.bwanms.util.ServerValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbL2ServiceProfileEntityHandler
implements EntityHandler<RbL2ServiceProfile> {
    private static final Logger log = Logger.getLogger(RbL2ServiceProfileEntityHandler.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfile.class);

    public RbL2ServiceProfile handleSave(RbL2ServiceProfile entity) throws ServerValidationException {
        RbServiceProfileDistributionTask task = new RbServiceProfileDistributionTask();
        task.setOperation(1);
        task.setName(String.format("%s_%s_%s", entity.getName(), DateFormatter.formatDotted((Date)new Date()), i18n.translateString("Deployment")));
        if (entity.getId() != 0L) {
            List eqs = ServiceRegistry.getServiceManagementService().findServiceProfileInstances(entity.getId());
            ArrayList<RbBaseStationEquipment> deploymentTargets = new ArrayList<RbBaseStationEquipment>();
            for (Equipment eq : eqs) {
                deploymentTargets.add((RbBaseStationEquipment)eq);
            }
            task.setEquipmentList(deploymentTargets);
            entity = this.cloneProfile(entity);
        }
        entity = (RbL2ServiceProfile)ServiceRegistry.getServiceManagementService().updateServiceProfile((ServiceProfile)entity);
        try {
            Assembly assembly = ServiceRegistry.getEntityManagerService().get(RbL2ServiceProfile.class, entity.getId(), "Edit");
            entity = (RbL2ServiceProfile)((Object)assembly.getEntity());
            task.setServiceProfileList(Arrays.asList(new RbServiceProfile[]{entity}));
            new TaskEditorFormContainer(RbServiceProfileDistributionTask.class, (Task)task);
        }
        catch (ServiceException e) {
            log.error((Object)e, (Throwable)e);
        }
        return entity;
    }

    private RbL2ServiceProfile cloneProfile(RbL2ServiceProfile entity) {
        RbL2ServiceProfile profile = new RbL2ServiceProfile();
        BeanUtils.shallowCopy((Object)((Object)entity), (Object)((Object)profile));
        profile.setId(0L);
        if (entity.getForwardingRule() != null) {
            RbForwardingRule fRule = new RbForwardingRule();
            BeanUtils.shallowCopy((Object)entity.getForwardingRule(), (Object)fRule);
            fRule.setId(0L);
            RbQoSProfile qos = this.cloneQoS(fRule.getQoS());
            fRule.setQoS(qos);
            profile.setForwardingRule(fRule);
            profile.getForwardingRule().setId(0L);
            profile.getForwardingRule().getQoS().setId(0L);
        }
        if (entity.getPolicyRule() != null) {
            RbPolicyRule pRule = new RbPolicyRule();
            BeanUtils.shallowCopy((Object)entity.getPolicyRule(), (Object)pRule);
            pRule.setId(0L);
            profile.setPolicyRule(pRule);
            pRule.setDownQoSProfile1(this.cloneQoS(profile.getPolicyRule().getDownQoSProfile1()));
            pRule.setDownQoSProfile2(this.cloneQoS(profile.getPolicyRule().getDownQoSProfile2()));
            pRule.setDownQoSProfile3(this.cloneQoS(profile.getPolicyRule().getDownQoSProfile3()));
            pRule.setDownQoSProfile4(this.cloneQoS(profile.getPolicyRule().getDownQoSProfile4()));
            pRule.setUpQoSProfile1(this.cloneQoS(profile.getPolicyRule().getUpQoSProfile1()));
            pRule.setUpQoSProfile2(this.cloneQoS(profile.getPolicyRule().getUpQoSProfile2()));
            pRule.setUpQoSProfile3(this.cloneQoS(profile.getPolicyRule().getUpQoSProfile3()));
            pRule.setUpQoSProfile4(this.cloneQoS(profile.getPolicyRule().getUpQoSProfile4()));
        }
        return profile;
    }

    private RbQoSProfile cloneQoS(RbQoSProfile qoS) {
        if (qoS == null) {
            return null;
        }
        RbQoSProfile ret = new RbQoSProfile();
        BeanUtils.shallowCopy((Object)qoS, (Object)ret);
        ret.setId(0L);
        return ret;
    }

    public RbL2ServiceProfile handleLoad(RbL2ServiceProfile entity) {
        return null;
    }
}

