/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.gui.Templates;
import com.bwanms.model.Template;
import com.bwanms.rb.model.services.RbBSPFServerValues;
import com.bwanms.rb.model.services.RbVoiceDomainGlobal;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbVoiceDomainGlobalTemplate
implements Serializable,
Template<RbVoiceDomainGlobal> {
    private static final long serialVersionUID = -2300958357157389013L;
    private long id;
    private String name;
    private RbBSPFServerValues rbBSPFServerValues;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="rbBSPFServerValuesId")
    public RbBSPFServerValues getRbBSPFServerValues() {
        return this.rbBSPFServerValues;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String rbVoiceDomainName) {
        this.name = rbVoiceDomainName;
    }

    public void setRbBSPFServerValues(RbBSPFServerValues rbBSPFServerValues) {
        this.rbBSPFServerValues = rbBSPFServerValues;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbForwardingRuleName=").append(this.name).append(", ");
        result.append("rbBSPFServer=").append(this.rbBSPFServerValues);
        result.append("]");
        return result.toString();
    }

    public RbVoiceDomainGlobal createInstanceFromTemplate() {
        RbVoiceDomainGlobal fwRule = new RbVoiceDomainGlobal();
        fwRule.setVoiceDomainName(this.getName());
        fwRule.setPrimaryPFServer(RbBSPFServerValues.createInstanceFromValues(this.getRbBSPFServerValues()));
        return fwRule;
    }

    public RbVoiceDomainGlobalTemplate createTemplateFromInstance(RbVoiceDomainGlobal instance) {
        RbVoiceDomainGlobalTemplate template = new RbVoiceDomainGlobalTemplate();
        template.setName(instance.getVoiceDomainName());
        template.setRbBSPFServerValues(RbBSPFServerValues.getValueObjectFromInstance(instance.getPrimaryPFServer()));
        return template;
    }

    public boolean matches(RbVoiceDomainGlobal toMatch) {
        return Templates.match((Object)this.name, (Object)toMatch.getVoiceDomainName()) && (this.rbBSPFServerValues == null && toMatch.getPrimaryPFServer() == null || this.rbBSPFServerValues != null && toMatch.getPrimaryPFServer() != null && this.rbBSPFServerValues.matches(toMatch.getPrimaryPFServer()));
    }
}

