/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.rb.model.services.RbBSPFServerGlobal;
import com.bwanms.util.MultipleStringList;
import java.io.Serializable;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import org.hibernate.validator.Length;

@Entity
public class RbVoiceDomainGlobal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String voiceDomainName;
    private RbBSPFServerGlobal primaryPFServer;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Length(min=1, max=32)
    public String getVoiceDomainName() {
        return this.voiceDomainName;
    }

    public void setVoiceDomainName(String name) {
        this.voiceDomainName = name;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="ipAddress", column=@Column(name="primaryPFServerIP")), @AttributeOverride(name="portNumber", column=@Column(name="primaryPFServerPort")), @AttributeOverride(name="pfVlan", column=@Column(name="primaryPFServerPfVlan")), @AttributeOverride(name="sharedString", column=@Column(name="primaryPFServerSharedString"))})
    public RbBSPFServerGlobal getPrimaryPFServer() {
        if (this.primaryPFServer == null) {
            this.primaryPFServer = new RbBSPFServerGlobal();
        }
        return this.primaryPFServer;
    }

    public void setPrimaryPFServer(RbBSPFServerGlobal pfServer) {
        this.primaryPFServer = pfServer;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("name=").append(this.getVoiceDomainName()).append(", ");
        result.append("primaryPFServer=").append(this.getPrimaryPFServer());
        result.append("]");
        return result.toString();
    }

    public void addObjectsToList(MultipleStringList attribValues) {
        attribValues.addToList(this.getVoiceDomainName());
        this.getPrimaryPFServer().addObjectsToList(attribValues);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.voiceDomainName == null ? 0 : this.voiceDomainName.hashCode());
        result = 31 * result + (this.primaryPFServer == null ? 0 : this.primaryPFServer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RbVoiceDomainGlobal other = (RbVoiceDomainGlobal)obj;
        if (this.voiceDomainName == null ? other.voiceDomainName != null : !this.voiceDomainName.equals(other.voiceDomainName)) {
            return false;
        }
        return !(this.primaryPFServer == null ? other.primaryPFServer != null : !this.primaryPFServer.equals(other.primaryPFServer));
    }
}

