/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.util.MultipleStringList;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;

@Entity
@JoinColumn(name="serviceProfileId")
public class RbVoIPServiceProfile
extends RbServiceProfile {
    private Integer maxNumberOfSimultaneousCalls;

    @WeakRange(min=0L, max=50L)
    public Integer getMaxNumberOfSimultaneousCalls() {
        return this.maxNumberOfSimultaneousCalls;
    }

    public void setMaxNumberOfSimultaneousCalls(Integer rbServiceTemplateNumberOfSimultaneousCalls) {
        this.maxNumberOfSimultaneousCalls = rbServiceTemplateNumberOfSimultaneousCalls;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("super=").append(super.toString()).append(", ");
        result.append("rbServiceTemplateType=").append(this.toStringRbServiceTemplateType()).append(", ");
        result.append("rbServiceTemplateNumberOfSimultaneousCalls=").append(this.maxNumberOfSimultaneousCalls).append(", ");
        result.append("]");
        return result.toString();
    }

    public String toStringRbServiceTemplateForwardDhcpRequest(Integer value) {
        if (null == value) {
            return null;
        }
        String result = null;
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public Integer rbServiceTemplateType() {
        return 3;
    }

    public boolean isValueEqualTo(RbServiceProfile target) {
        if (super.isValueEqualTo(target) && target instanceof RbVoIPServiceProfile) {
            RbVoIPServiceProfile targetVoIP = (RbVoIPServiceProfile)target;
            return RbVoIPServiceProfile.objectEquals(this.maxNumberOfSimultaneousCalls, targetVoIP.maxNumberOfSimultaneousCalls);
        }
        return false;
    }

    protected void addPolicyRuleObjsToList(MultipleStringList attribValues) {
        new RbPolicyRule().addObjectsToList(attribValues);
    }

    protected void addNumberOfSimultaneousCallsObjsToList(MultipleStringList attribValues) {
        attribValues.addToList(this.getMaxNumberOfSimultaneousCalls());
    }
}

