/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.model.ServiceProfile;
import com.bwanms.model.Validatable;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbServiceGroupGlobal;
import com.bwanms.rb.model.services.RbVoiceDomainGlobal;
import com.bwanms.util.MultipleStringList;
import com.bwanms.validation.WeakRange;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@JoinColumn(name="serviceProfileId")
public class RbServiceProfile
extends ServiceProfile
implements Validatable {
    public static final int VLAN_TRANSPARENCY_MODE_DISABLED = 2;
    public static final int VLAN_TRANSPARENCY_MODE_ENABLED = 1;
    public static final int PRIORITY_MARKING_MODE_TRANSPARENT = 1;
    public static final int PRIORITY_MARKING_MODE_802_1_P = 2;
    public static final int PRIORITY_MARKING_MODE_DSCP = 3;
    public static final int PRIORITY_MARKING_MODE_NOT_APPLICABLE = 4;
    public static final int PRIORITY_MARKING_MAX_VALUE_802_1_P = 7;
    public static final int PRIORITY_MARKING_MAX_VALUE_DSCP = 63;
    public static final int VPLID_TRANSPARENT = 4095;
    private Integer VPLId = 4095;
    private Integer priorityMarkingMode;
    private Integer priorityMarkingValue;
    private Integer VLANTransparencyMode;
    private RbForwardingRule forwardingRule;
    private List<RbServiceTemplateConfigEntry> serviceTemplateEntries;
    private String complexKey1;
    private String complexKey2;
    private String complexKey3;

    public Integer getVLANTransparencyMode() {
        return this.VLANTransparencyMode;
    }

    public Integer getPriorityMarkingMode() {
        return this.priorityMarkingMode;
    }

    public Integer getPriorityMarkingValue() {
        return this.priorityMarkingValue;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameFWD")), @AttributeOverride(name="type", column=@Column(name="typeFWD"))})
    public RbForwardingRule getForwardingRule() {
        if (this.forwardingRule == null) {
            this.forwardingRule = new RbForwardingRule();
        }
        return this.forwardingRule;
    }

    public void setVLANTransparencyMode(Integer transparencyMode) {
        this.VLANTransparencyMode = transparencyMode;
    }

    public void setPriorityMarkingMode(Integer rbServiceTemplateQoSMarkingMode) {
        this.priorityMarkingMode = rbServiceTemplateQoSMarkingMode;
    }

    public void setPriorityMarkingValue(Integer rbServiceTemplateQoSMarkingValue) {
        this.priorityMarkingValue = rbServiceTemplateQoSMarkingValue;
    }

    public void setForwardingRule(RbForwardingRule forwardingRule) {
        this.forwardingRule = forwardingRule;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("super=").append(super.toString()).append(", ");
        result.append("rbServiceTemplateType=").append(this.toStringRbServiceTemplateType()).append(", ");
        result.append("rbServiceTemplateVPLID=").append(this.VPLId).append(", ");
        result.append("rbServiceTemplateQoSMarkingMode=").append(RbServiceProfile.toStringRbServiceTemplateQoSMarkingMode(this.priorityMarkingMode)).append(", ");
        result.append("rbServiceTemplateQoSMarkingValue=").append(this.priorityMarkingValue).append(", ");
        result.append("forwardingRule=").append(this.forwardingRule);
        result.append("]");
        return result.toString();
    }

    public static String toStringRbServiceTemplateVLANTransparencyMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "on(1)";
                break;
            }
            case 2: {
                result = "off(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringRbServiceTemplateQoSMarkingMode(Integer value) {
        if (null == value) {
            return null;
        }
        String result = null;
        switch (value) {
            case 1: {
                result = "transparent(1)";
                break;
            }
            case 2: {
                result = "rb8021p(2)";
                break;
            }
            case 3: {
                result = "rbDSCP(3)";
                break;
            }
            case 4: {
                result = "rbNotApplicable(4)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public final String toStringRbServiceTemplateType() {
        return RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(this.rbServiceTemplateType());
    }

    public Integer rbServiceTemplateType() {
        return null;
    }

    public boolean isValueEqualTo(RbServiceProfile target) {
        return target == null ? false : RbServiceProfile.objectEquals(this.priorityMarkingMode, target.getPriorityMarkingMode()) && RbServiceProfile.objectEquals(this.priorityMarkingValue, target.getPriorityMarkingValue()) && RbServiceProfile.objectEquals(this.VLANTransparencyMode, target.getVLANTransparencyMode()) && RbServiceProfile.objectEquals(this.VPLId, target.getVPLId()) && (1 == this.VLANTransparencyMode || RbServiceProfile.forwardingRuleEquals(this.getForwardingRule(), target.getForwardingRule()));
    }

    protected static boolean objectEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected static boolean forwardingRuleEquals(RbForwardingRule r1, RbForwardingRule r2) {
        return r1 == null ? r2 == null : r1.isValueEqualTo(r2);
    }

    protected static boolean policyRuleEquals(RbPolicyRule r1, RbPolicyRule r2) {
        return r1 == null ? r2 == null : r1.isValueEqualTo(r2);
    }

    protected static boolean voiceDomainEquals(RbVoiceDomainGlobal r1, RbVoiceDomainGlobal r2) {
        return r1 == null ? r2 == null : r1.equals(r2);
    }

    protected static boolean serviceGroupEquals(RbServiceGroupGlobal r1, RbServiceGroupGlobal r2) {
        return r1 == null ? r2 == null : r1.equals(r2);
    }

    @WeakRange(min=0L, max=4096L)
    public Integer getVPLId() {
        return this.VPLId;
    }

    public void setVPLId(Integer id) {
        this.VPLId = id;
    }

    @Transient
    @Length(min=1, max=32)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getServiceProfileName() {
        return super.getName();
    }

    public void setServiceProfileName(String name) {
        super.setName(name);
    }

    public void validate(List<InvalidValue> invalidValues) {
        if (this.priorityMarkingMode != null) {
            switch (this.priorityMarkingMode) {
                case 2: {
                    if (this.priorityMarkingValue >= 0 && this.priorityMarkingValue <= 7) break;
                    invalidValues.add(new InvalidValue("Value not in range [0..7]", RbServiceProfile.class, "priorityMarkingValue", (Object)this.priorityMarkingValue, (Object)this));
                    break;
                }
                case 3: {
                    if (this.priorityMarkingValue >= 0 && this.priorityMarkingValue <= 63) break;
                    invalidValues.add(new InvalidValue("Value not in range [0..63]", RbServiceProfile.class, "priorityMarkingValue", (Object)this.priorityMarkingValue, (Object)this));
                }
            }
        }
    }

    @Transient
    public List<RbBaseStationEquipment> getSupportingEquipment() {
        List<RbServiceTemplateConfigEntry> supportedEntries = this.getServiceTemplateEntries();
        ArrayList<RbBaseStationEquipment> ret = new ArrayList<RbBaseStationEquipment>(supportedEntries.size());
        for (RbServiceTemplateConfigEntry entry : supportedEntries) {
            RbBaseStationEquipment bs;
            if (null == entry.getNRConfiguration() || ret.contains((Object)(bs = (RbBaseStationEquipment)entry.getNRConfiguration().getManagedEquipment()))) continue;
            ret.add(bs);
        }
        return ret;
    }

    @Transient
    public String getComplexKey() {
        StringBuffer ret = new StringBuffer();
        if (null != this.getComplexKey1() && !"_".equals(this.complexKey1)) {
            ret.append(this.complexKey1);
        }
        if (null != this.getComplexKey2() && !"_".equals(this.complexKey2)) {
            ret.append(this.complexKey2);
        }
        if (null != this.getComplexKey3() && !"_".equals(this.complexKey3)) {
            ret.append(this.complexKey3);
        }
        return ret.length() > 0 ? ret.toString() : null;
    }

    public void setComplexKey(String complexKey) {
        this.setComplexKey1(null != complexKey && complexKey.length() > 0 ? complexKey.substring(0, Math.min(255, complexKey.length())) : "_");
        this.setComplexKey2(null != complexKey && complexKey.length() > 255 ? complexKey.substring(255, Math.min(510, complexKey.length())) : "_");
        this.setComplexKey3(null != complexKey && complexKey.length() > 510 ? complexKey.substring(510, Math.min(765, complexKey.length())) : "_");
    }

    public void computeAndSetComplexKey() {
        MultipleStringList attribValues = new MultipleStringList();
        this.addObjectsToList(attribValues);
        this.setComplexKey(attribValues.getAsString());
    }

    public String computeComplexKey() {
        MultipleStringList attribValues = new MultipleStringList();
        this.addObjectsToList(attribValues);
        return attribValues.getAsString();
    }

    protected void addObjectsToList(MultipleStringList attribValues) {
        Integer rbServiceTemplateType = this.rbServiceTemplateType();
        if (rbServiceTemplateType == 4 || rbServiceTemplateType == 5 || Integer.valueOf(7).equals(rbServiceTemplateType)) {
            attribValues.addToList(this.getName());
            attribValues.addToList(rbServiceTemplateType);
            this.addPolicyRuleObjsToList(attribValues);
            if (rbServiceTemplateType == 4) {
                this.addServiceGroupObjsToList(attribValues);
            }
            if (Integer.valueOf(7).equals(rbServiceTemplateType)) {
                this.addNumberOfSimultaneousCallsObjsToList(attribValues);
                this.addVoiceDomainsObjsToList(attribValues);
            }
        } else {
            attribValues.addToList(this.getName());
            attribValues.addToList(rbServiceTemplateType);
            attribValues.addToList(this.getVPLId());
            attribValues.addToList(this.getVLANTransparencyMode());
            attribValues.addToList(this.getPriorityMarkingMode());
            if (this.getPriorityMarkingMode() == null) {
                attribValues.addToList((Integer)null);
            } else {
                attribValues.addToList(1 != this.getPriorityMarkingMode() ? this.getPriorityMarkingValue() : (Integer)null);
            }
            this.addNumberOfSimultaneousCallsObjsToList(attribValues);
            this.getForwardingRule().addObjectsToList(attribValues);
            this.addPolicyRuleObjsToList(attribValues);
            if (Integer.valueOf(6).equals(rbServiceTemplateType)) {
                this.addVoiceDomainsObjsToList(attribValues);
            }
        }
    }

    protected void addPolicyRuleObjsToList(MultipleStringList attribValues) {
    }

    protected void addNumberOfSimultaneousCallsObjsToList(MultipleStringList attribValues) {
    }

    protected void addVoiceDomainsObjsToList(MultipleStringList attribValues) {
    }

    protected void addServiceGroupObjsToList(MultipleStringList attribValues) {
    }

    @OneToMany
    @JoinColumns(value={@JoinColumn(name="complexKey1", referencedColumnName="complexKey1", insertable=false, updatable=false), @JoinColumn(name="complexKey2", referencedColumnName="complexKey2", insertable=false, updatable=false), @JoinColumn(name="complexKey3", referencedColumnName="complexKey3", insertable=false, updatable=false)})
    public List<RbServiceTemplateConfigEntry> getServiceTemplateEntries() {
        return this.serviceTemplateEntries;
    }

    public void setServiceTemplateEntries(List<RbServiceTemplateConfigEntry> serviceTemplateEntries) {
        this.serviceTemplateEntries = serviceTemplateEntries;
    }

    @Length(max=255)
    public String getComplexKey1() {
        return this.complexKey1;
    }

    public void setComplexKey1(String complexKey1) {
        this.complexKey1 = complexKey1;
    }

    @Length(max=255)
    public String getComplexKey2() {
        return this.complexKey2;
    }

    public void setComplexKey2(String complexKey2) {
        this.complexKey2 = complexKey2;
    }

    @Length(max=255)
    public String getComplexKey3() {
        return this.complexKey3;
    }

    public void setComplexKey3(String complexKey3) {
        this.complexKey3 = complexKey3;
    }
}

