/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.model.Equipment;
import com.bwanms.model.Service;
import com.bwanms.model.Validatable;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbServiceProfile;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@JoinColumn(name="serviceId")
public abstract class RbService
extends Service
implements Validatable {
    public static final int HYBRID_MODE_ENABLE = 1;
    public static final int HYBRID_MODE_DISABLE = 2;
    private String rbServiceClientSiteVLANList;
    private Integer rbServiceClientSiteVLANListCount;
    private Integer rbServiceVLANHybridMode;
    public static final int RbServiceVLANClassificationModeOff = 1;
    public static final int RbServiceVLANClassificationModeOn = 2;
    private Integer rbServiceVLANClassificationMode;
    private Integer rbServiceAccessVLAN;
    private RbBaseStationEquipment activeBaseStation;

    public String getRbServiceClientSiteVLANList() {
        return this.rbServiceClientSiteVLANList;
    }

    public void setRbServiceClientSiteVLANList(String rbServiceClientSiteVLANList) {
        this.rbServiceClientSiteVLANList = rbServiceClientSiteVLANList;
    }

    @Column(name="rbSrvClientSiteVLANListCount")
    public Integer getRbServiceClientSiteVLANListCount() {
        return this.rbServiceClientSiteVLANListCount;
    }

    public void setRbServiceClientSiteVLANListCount(Integer rbServiceClientSiteVLANListCount) {
        this.rbServiceClientSiteVLANListCount = rbServiceClientSiteVLANListCount;
    }

    public Integer getRbServiceVLANHybridMode() {
        return this.rbServiceVLANHybridMode;
    }

    public void setRbServiceVLANHybridMode(Integer rbServiceVLANHybridMode) {
        this.rbServiceVLANHybridMode = rbServiceVLANHybridMode;
    }

    public static String toStringRbServiceVLANHybridMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "On";
                break;
            }
            case 2: {
                result = "Off";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.6"})
    @Column(name="rbSvcVLANClassificationMode")
    public Integer getRbServiceVLANClassificationMode() {
        return this.rbServiceVLANClassificationMode;
    }

    public void setRbServiceVLANClassificationMode(Integer rbServiceVLANClassificationMode) {
        this.rbServiceVLANClassificationMode = rbServiceVLANClassificationMode;
    }

    public static String toStringRbServiceVLANClassificationMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "off(1)";
                break;
            }
            case 2: {
                result = "on(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.6"})
    public Integer getRbServiceAccessVLAN() {
        return this.rbServiceAccessVLAN;
    }

    public void setRbServiceAccessVLAN(Integer rbServiceAccessVLAN) {
        this.rbServiceAccessVLAN = rbServiceAccessVLAN;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("super=").append(super.toString()).append(", ");
        result.append("rbServiceType=").append(this.toStringRbServiceType()).append(", ");
        result.append("rbServiceClientSiteVLANList=").append(this.rbServiceClientSiteVLANList).append(", ");
        result.append("rbServiceClientSiteVLANListCount=").append(this.rbServiceClientSiteVLANListCount).append(", ");
        result.append("]");
        return result.toString();
    }

    public abstract String toStringRbServiceType();

    public boolean isValueEqualTo(RbService target) {
        return RbService.objectEquals(this.getSubscriberUnitEUID(), target.getSubscriberUnitEUID()) && RbService.objectEquals(this.rbServiceClientSiteVLANList, target.rbServiceClientSiteVLANList) && ((RbServiceProfile)this.getServiceProfile()).isValueEqualTo((RbServiceProfile)target.getServiceProfile());
    }

    protected static boolean objectEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Transient
    public String getServiceKey() {
        return this.getServiceProfile().getName() + "#" + this.getName() + "#" + this.getSubscriberUnitEUID();
    }

    @Transient
    public abstract Class<? extends RbServiceProfile> getServiceProfileClass();

    @Transient
    @Length(min=1, max=32)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getServiceName() {
        return super.getName();
    }

    public void setServiceName(String name) {
        super.setName(name);
    }

    @Transient
    public Equipment getLastActiveInstance() {
        return this.getActiveBaseStation();
    }

    public void validate(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbService.class);
        if (this.getServiceProfile() == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("serviceProfileNotNull"), RbService.class, "serviceProfile", null, (Object)this));
        }
        if (this.getSubscriber() == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("subscriberNotNull"), RbService.class, "subscriber", null, (Object)this));
        }
        if (this.getRbServiceAccessVLAN() != null) {
            if (this.getRbServiceAccessVLAN() < 4095) {
                if (this.getRbServiceVLANHybridMode() == 2 && this.getRbServiceClientSiteVLANListCount() > 0 && this.getServiceProfile() != null && ((RbServiceProfile)this.getServiceProfile()).getVLANTransparencyMode() == 1 && this.getRbServiceVLANClassificationMode() == 2) {
                    invalidValues.add(new InvalidValue(i18n.translateString("VLANListMustBeEmpty"), RbServiceConfigEntry.class, "", (Object)"", (Object)this));
                } else if (this.getRbServiceVLANHybridMode() == 1 && this.getRbServiceClientSiteVLANListCount() > 0 && this.getServiceProfile() != null && ((RbServiceProfile)this.getServiceProfile()).getVLANTransparencyMode() == 1 && this.getRbServiceVLANClassificationMode() == 2) {
                    invalidValues.add(new InvalidValue(i18n.translateString("VLANListMustBeEmpty"), RbServiceConfigEntry.class, "", (Object)"", (Object)this));
                } else if (this.getRbServiceVLANHybridMode() == 1 && this.getRbServiceClientSiteVLANListCount() > 0 && this.getServiceProfile() != null && ((RbServiceProfile)this.getServiceProfile()).getVLANTransparencyMode() == 1 && this.getRbServiceVLANClassificationMode() == 1) {
                    invalidValues.add(new InvalidValue(i18n.translateString("VLANListMustBeEmpty"), RbServiceConfigEntry.class, "", (Object)"", (Object)this));
                }
            } else if (this.getRbServiceVLANHybridMode() == 2 && this.getRbServiceClientSiteVLANListCount() == 0 && this.getServiceProfile() != null && ((RbServiceProfile)this.getServiceProfile()).getVLANTransparencyMode() == 1 && this.getRbServiceVLANClassificationMode() == 2) {
                invalidValues.add(new InvalidValue(i18n.translateString("MustDefineVLAN"), RbServiceConfigEntry.class, "", (Object)"", (Object)this));
            } else if (this.getRbServiceVLANHybridMode() == 2 && this.getRbServiceClientSiteVLANListCount() > 1 && this.getServiceProfile() != null && ((RbServiceProfile)this.getServiceProfile()).getVLANTransparencyMode() == 1 && this.getRbServiceVLANClassificationMode() == 2) {
                invalidValues.add(new InvalidValue(i18n.translateString("OnlyOneVLAN"), RbServiceConfigEntry.class, "", (Object)"", (Object)this));
            } else if (this.getRbServiceVLANHybridMode() == 1 && this.getRbServiceClientSiteVLANListCount() == 0 && this.getServiceProfile() != null && ((RbServiceProfile)this.getServiceProfile()).getVLANTransparencyMode() == 1 && this.getRbServiceVLANClassificationMode() == 2) {
                invalidValues.add(new InvalidValue(i18n.translateString("MustDefineVLAN"), RbServiceConfigEntry.class, "", (Object)"", (Object)this));
            } else if (this.getRbServiceVLANHybridMode() == 1 && this.getRbServiceClientSiteVLANListCount() > 1 && this.getServiceProfile() != null && ((RbServiceProfile)this.getServiceProfile()).getVLANTransparencyMode() == 1 && this.getRbServiceVLANClassificationMode() == 2) {
                invalidValues.add(new InvalidValue(i18n.translateString("OnlyOneVLAN"), RbServiceConfigEntry.class, "", (Object)"", (Object)this));
            }
        }
    }

    @ManyToOne
    @JoinColumn(name="activeBS_id")
    public RbBaseStationEquipment getActiveBaseStation() {
        return this.activeBaseStation;
    }

    public void setActiveBaseStation(RbBaseStationEquipment activeBaseStation) {
        this.activeBaseStation = activeBaseStation;
    }
}

