/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.Validatable;
import com.bwanms.util.MultipleStringList;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Embeddable
public class RbQoSProfile
implements Serializable,
Validatable {
    public static final int TypeRbCG = 0;
    public static final int TypeRbRT = 1;
    public static final int TypeRbNRT = 2;
    public static final int TypeRbBE = 3;
    public static final int ParamTimeNone = 0;
    public static final int ParamTimeShort = 1;
    public static final int ParamTimeMedium = 2;
    public static final int ParamTimeLong = 3;
    private String name;
    private Integer type;
    private Long param1;
    private Long param2;
    private Integer paramTime;

    @Transient
    public long getId() {
        return 0L;
    }

    public void setId(long id) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer rbQoSProfileType) {
        this.type = rbQoSProfileType;
    }

    public static String toStringType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "rbCG(0)";
                break;
            }
            case 1: {
                result = "rbRT(1)";
                break;
            }
            case 2: {
                result = "rbNRT(2)";
                break;
            }
            case 3: {
                result = "rbBE(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public Long getParam1() {
        return this.param1;
    }

    public void setParam1(Long rbQoSProfileParam1) {
        this.param1 = rbQoSProfileParam1;
    }

    public Long getParam2() {
        return this.param2;
    }

    public void setParam2(Long rbQoSProfileParam2) {
        this.param2 = rbQoSProfileParam2;
    }

    public Integer getParamTime() {
        return this.paramTime;
    }

    public void setParamTime(Integer rbQoSProfileParamTime) {
        this.paramTime = rbQoSProfileParamTime;
    }

    public static String toStringParamTime(Integer value) {
        if (null == value) {
            return null;
        }
        String result = null;
        switch (value) {
            case 1: {
                result = "short(1)";
                break;
            }
            case 2: {
                result = "medium(2)";
                break;
            }
            case 3: {
                result = "long(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbQoSProfileName=").append(this.name).append(", ");
        result.append("rbQoSProfileType=").append(RbQoSProfile.toStringType(this.type)).append(", ");
        result.append("rbQoSProfileParam1=").append(this.param1).append(", ");
        result.append("rbQoSProfileParam2=").append(this.param2).append(", ");
        result.append("rbQoSProfileParamTime=").append(RbQoSProfile.toStringParamTime(this.paramTime)).append(", ");
        result.append("]");
        return result.toString();
    }

    public boolean isValueEqualTo(RbQoSProfile target) {
        return target == null || target.isValueNull() ? this.isValueNull() : !(!RbQoSProfile.objectEquals(this.name, target.getName()) || !RbQoSProfile.objectEquals(this.type, target.getType()) || 3 != this.type && !RbQoSProfile.objectEquals(this.param1, target.getParam1()) || 1 != this.type && !RbQoSProfile.objectEquals(this.param2, target.getParam2()) || 0 != this.type && !RbQoSProfile.objectEquals(this.paramTime, target.getParamTime()));
    }

    public boolean isNameEqual(RbQoSProfile target) {
        return this.name.equals(target.getName()) && (!RbQoSProfile.objectEquals(this.type, target.getType()) || !RbQoSProfile.objectEquals(this.param1, target.getParam1()) || !RbQoSProfile.objectEquals(this.param2, target.getParam2()) || !RbQoSProfile.objectEquals(this.paramTime, target.getParamTime()));
    }

    @Transient
    public boolean isValueNull() {
        return null == this.type;
    }

    private static boolean objectEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public void validate(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbQoSProfile.class);
        if (this.type != null) {
            if (this.name == null || this.name.length() < 1 || this.name.length() > 32 || !this.name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidName"), RbQoSProfile.class, "name", (Object)this.name, (Object)this));
                System.out.println(this.toString());
            }
            if (this.type == 0) {
                String message = "ValueBetween";
                if (this.param1 == null || this.param1 < 64L || this.param1 > 1550L) {
                    invalidValues.add(new InvalidValue(i18n.translateString(message, (Object[])new String[]{"64", "1550"}), RbQoSProfile.class, "param1", (Object)this.param1, (Object)this));
                }
                if (this.param2 == null || this.param2 < 5L || this.param2 > 100L || this.param2 % 5L != 0L) {
                    message = "ValueBetweenMultiple";
                    invalidValues.add(new InvalidValue(i18n.translateString(message, (Object[])new String[]{"5", "100", "5"}), RbQoSProfile.class, "param2", (Object)this.param2, (Object)this));
                }
                this.nullCT(invalidValues, i18n);
            } else if (this.type == 1) {
                this.validateCIR(invalidValues, i18n);
                this.nullMIR(invalidValues, i18n);
                this.validateCT(invalidValues, i18n);
            } else if (this.type == 2) {
                this.validateCIR(invalidValues, i18n);
                this.validateMIR(invalidValues, i18n);
                if (this.param1 != null && this.param2 != null && this.param2 < this.param1) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", (Object[])new String[]{this.param1.toString(), "12000"}), RbQoSProfile.class, "param2", (Object)this.param2, (Object)this));
                }
                this.validateCT(invalidValues, i18n);
            } else if (this.type == 3) {
                this.validateMIR(invalidValues, i18n);
                this.nullCIR(invalidValues, i18n);
                this.validateCT(invalidValues, i18n);
            }
        }
    }

    private void validateMIR(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.param2 == null || this.param2 < 1L || this.param2 > 12000L) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", (Object[])new String[]{"1", "12000"}), RbQoSProfile.class, "param2", (Object)this.param2, (Object)this));
        }
    }

    private void validateCIR(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.param1 == null || this.param1 < 1L || this.param1 > 12000L) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", (Object[])new String[]{"1", "12000"}), RbQoSProfile.class, "param1", (Object)this.param1, (Object)this));
        }
    }

    private void nullMIR(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.param2 != null && this.param2 != 0L) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidMIR", (Object[])new String[]{"0"}), RbQoSProfile.class, "param2", (Object)this.param2, (Object)this));
        }
    }

    private void nullCIR(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.param1 != null && this.param1 != 0L) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidCIR", (Object[])new String[]{"0"}), RbQoSProfile.class, "param1", (Object)this.param1, (Object)this));
        }
    }

    private void validateCT(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.paramTime == null || this.paramTime == 0) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidCT"), RbQoSProfile.class, "paramTime", (Object)"", (Object)this));
        }
    }

    private void nullCT(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.paramTime != null && this.paramTime != 0) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidCT"), RbQoSProfile.class, "paramTime", (Object)"", (Object)this));
        }
    }

    public void makeNull() {
        this.name = null;
        this.type = null;
        this.param1 = null;
        this.param2 = null;
        this.paramTime = null;
    }

    public void addObjectsToList(MultipleStringList attribValues) {
        attribValues.addToList(this.getName());
        Integer type = this.getType();
        attribValues.addToList(type);
        if (null != this.getType()) {
            if (3 != type) {
                attribValues.addToList(this.getParam1());
            } else {
                attribValues.addNullToList();
            }
            if (1 != type) {
                attribValues.addToList(this.getParam2());
            } else {
                attribValues.addNullToList();
            }
            if (0 != type) {
                attribValues.addToList(this.getParamTime());
            } else {
                attribValues.addNullToList();
            }
        } else {
            attribValues.addNullToList();
            attribValues.addNullToList();
            attribValues.addNullToList();
        }
    }
}

