/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.util.MultipleStringList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbPolicyRule
implements Serializable {
    public static final int PriorityTypeRbDSCP = 1;
    public static final int PriorityTypeRb8021p = 2;
    public static final int MaxUpperLimitDSCP = 63;
    public static final int MaxUpperLimit8021p = 7;
    public static final String PROP_PRIORITY_TYPE = "priorityType";
    private String name;
    private RbQoSProfile upQoSProfile1;
    private Long upQoSUpperLimit1;
    private RbQoSProfile upQoSProfile2;
    private Long upQoSUpperLimit2;
    private RbQoSProfile upQoSProfile3;
    private Long upQoSUpperLimit3;
    private RbQoSProfile upQoSProfile4;
    private Long upQoSUpperLimit4;
    private RbQoSProfile downQoSProfile1;
    private Long downQoSUpperLimit1;
    private RbQoSProfile downQoSProfile2;
    private Long downQoSUpperLimit2;
    private RbQoSProfile downQoSProfile3;
    private Long downQoSUpperLimit3;
    private RbQoSProfile downQoSProfile4;
    private Long downQoSUpperLimit4;
    private long id;
    private Integer priorityType;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPriorityType() {
        return this.priorityType;
    }

    public void setPriorityType(Integer priorityType) {
        this.priorityType = priorityType;
    }

    public static String toStringPriorityType(Integer value) {
        if (null == value) {
            return null;
        }
        String result = null;
        switch (value) {
            case 1: {
                result = "rbDSCP(1)";
                break;
            }
            case 2: {
                result = "rb8021p(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameUpQoS1")), @AttributeOverride(name="type", column=@Column(name="typeUpQoS1")), @AttributeOverride(name="param1", column=@Column(name="param1UpQoS1")), @AttributeOverride(name="param2", column=@Column(name="param2UpQoS1")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeUpQoS1"))})
    public RbQoSProfile getUpQoSProfile1() {
        if (this.upQoSProfile1 == null) {
            this.upQoSProfile1 = new RbQoSProfile();
        }
        return this.upQoSProfile1;
    }

    public void setUpQoSProfile1(RbQoSProfile upQoSProfile1) {
        this.upQoSProfile1 = upQoSProfile1;
    }

    public Long getUpQoSUpperLimit1() {
        if (this.upQoSUpperLimit1 == null) {
            this.upQoSUpperLimit1 = 0L;
        }
        return this.upQoSUpperLimit1;
    }

    public void setUpQoSUpperLimit1(Long upQoSUpperLimit1) {
        this.upQoSUpperLimit1 = upQoSUpperLimit1;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameUpQoS2")), @AttributeOverride(name="type", column=@Column(name="typeUpQoS2")), @AttributeOverride(name="param1", column=@Column(name="param1UpQoS2")), @AttributeOverride(name="param2", column=@Column(name="param2UpQoS2")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeUpQoS2"))})
    public RbQoSProfile getUpQoSProfile2() {
        if (this.upQoSProfile2 == null) {
            this.upQoSProfile2 = new RbQoSProfile();
        }
        return this.upQoSProfile2;
    }

    public void setUpQoSProfile2(RbQoSProfile upQoSProfile2) {
        this.upQoSProfile2 = upQoSProfile2;
    }

    public Long getUpQoSUpperLimit2() {
        if (this.upQoSUpperLimit2 == null) {
            this.upQoSUpperLimit2 = 0L;
        }
        return this.upQoSUpperLimit2;
    }

    public void setUpQoSUpperLimit2(Long upQoSUpperLimit2) {
        this.upQoSUpperLimit2 = upQoSUpperLimit2;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameUpQoS3")), @AttributeOverride(name="type", column=@Column(name="typeUpQoS3")), @AttributeOverride(name="param1", column=@Column(name="param1UpQoS3")), @AttributeOverride(name="param2", column=@Column(name="param2UpQoS3")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeUpQoS3"))})
    public RbQoSProfile getUpQoSProfile3() {
        if (this.upQoSProfile3 == null) {
            this.upQoSProfile3 = new RbQoSProfile();
        }
        return this.upQoSProfile3;
    }

    public void setUpQoSProfile3(RbQoSProfile upQoSProfile3) {
        this.upQoSProfile3 = upQoSProfile3;
    }

    public Long getUpQoSUpperLimit3() {
        if (this.upQoSUpperLimit3 == null) {
            this.upQoSUpperLimit3 = 0L;
        }
        return this.upQoSUpperLimit3;
    }

    public void setUpQoSUpperLimit3(Long upQoSUpperLimit3) {
        this.upQoSUpperLimit3 = upQoSUpperLimit3;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameUpQoS4")), @AttributeOverride(name="type", column=@Column(name="typeUpQoS4")), @AttributeOverride(name="param1", column=@Column(name="param1UpQoS4")), @AttributeOverride(name="param2", column=@Column(name="param2UpQoS4")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeUpQoS4"))})
    public RbQoSProfile getUpQoSProfile4() {
        if (this.upQoSProfile4 == null) {
            this.upQoSProfile4 = new RbQoSProfile();
        }
        return this.upQoSProfile4;
    }

    public void setUpQoSProfile4(RbQoSProfile upQoSProfile4) {
        this.upQoSProfile4 = upQoSProfile4;
    }

    public Long getUpQoSUpperLimit4() {
        if (this.upQoSUpperLimit4 == null) {
            this.upQoSUpperLimit4 = 0L;
        }
        return this.upQoSUpperLimit4;
    }

    public void setUpQoSUpperLimit4(Long UpQoSUpperLimit4) {
        this.upQoSUpperLimit4 = UpQoSUpperLimit4;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameDownQoS1")), @AttributeOverride(name="type", column=@Column(name="typeDownQoS1")), @AttributeOverride(name="param1", column=@Column(name="param1DownQoS1")), @AttributeOverride(name="param2", column=@Column(name="param2DownQoS1")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeDownQoS1"))})
    public RbQoSProfile getDownQoSProfile1() {
        if (this.downQoSProfile1 == null) {
            this.downQoSProfile1 = new RbQoSProfile();
        }
        return this.downQoSProfile1;
    }

    public void setDownQoSProfile1(RbQoSProfile downQoSProfile1) {
        this.downQoSProfile1 = downQoSProfile1;
    }

    public Long getDownQoSUpperLimit1() {
        if (this.downQoSUpperLimit1 == null) {
            this.downQoSUpperLimit1 = 0L;
        }
        return this.downQoSUpperLimit1;
    }

    public void setDownQoSUpperLimit1(Long downQoSUpperLimit1) {
        this.downQoSUpperLimit1 = downQoSUpperLimit1;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameDownQoS2")), @AttributeOverride(name="type", column=@Column(name="typeDownQoS2")), @AttributeOverride(name="param1", column=@Column(name="param1DownQoS2")), @AttributeOverride(name="param2", column=@Column(name="param2DownQoS2")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeDownQoS2"))})
    public RbQoSProfile getDownQoSProfile2() {
        if (this.downQoSProfile2 == null) {
            this.downQoSProfile2 = new RbQoSProfile();
        }
        return this.downQoSProfile2;
    }

    public void setDownQoSProfile2(RbQoSProfile downQoSProfile2) {
        this.downQoSProfile2 = downQoSProfile2;
    }

    public Long getDownQoSUpperLimit2() {
        if (this.downQoSUpperLimit2 == null) {
            this.downQoSUpperLimit2 = 0L;
        }
        return this.downQoSUpperLimit2;
    }

    public void setDownQoSUpperLimit2(Long downQoSUpperLimit2) {
        this.downQoSUpperLimit2 = downQoSUpperLimit2;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameDownQoS3")), @AttributeOverride(name="type", column=@Column(name="typeDownQoS3")), @AttributeOverride(name="param1", column=@Column(name="param1DownQoS3")), @AttributeOverride(name="param2", column=@Column(name="param2DownQoS3")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeDownQoS3"))})
    public RbQoSProfile getDownQoSProfile3() {
        if (this.downQoSProfile3 == null) {
            this.downQoSProfile3 = new RbQoSProfile();
        }
        return this.downQoSProfile3;
    }

    public void setDownQoSProfile3(RbQoSProfile downQoSProfile3) {
        this.downQoSProfile3 = downQoSProfile3;
    }

    public Long getDownQoSUpperLimit3() {
        if (this.downQoSUpperLimit3 == null) {
            this.downQoSUpperLimit3 = 0L;
        }
        return this.downQoSUpperLimit3;
    }

    public void setDownQoSUpperLimit3(Long downQoSUpperLimit3) {
        this.downQoSUpperLimit3 = downQoSUpperLimit3;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameDownQoS4")), @AttributeOverride(name="type", column=@Column(name="typeDownQoS4")), @AttributeOverride(name="param1", column=@Column(name="param1DownQoS4")), @AttributeOverride(name="param2", column=@Column(name="param2DownQoS4")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeDownQoS4"))})
    public RbQoSProfile getDownQoSProfile4() {
        if (this.downQoSProfile4 == null) {
            this.downQoSProfile4 = new RbQoSProfile();
        }
        return this.downQoSProfile4;
    }

    public void setDownQoSProfile4(RbQoSProfile downQoSProfile4) {
        this.downQoSProfile4 = downQoSProfile4;
    }

    public Long getDownQoSUpperLimit4() {
        if (this.downQoSUpperLimit4 == null) {
            this.downQoSUpperLimit4 = 0L;
        }
        return this.downQoSUpperLimit4;
    }

    public void setDownQoSUpperLimit4(Long downQoSUpperLimit4) {
        this.downQoSUpperLimit4 = downQoSUpperLimit4;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("PriorityType=").append(RbPolicyRule.toStringPriorityType(this.priorityType)).append(", ");
        result.append("upQoSProfile1=").append(this.upQoSProfile1).append(", ");
        result.append("UpQoSUpperLimit1=").append(this.upQoSUpperLimit1).append(", ");
        result.append("upQoSProfile2=").append(this.upQoSProfile2).append(", ");
        result.append("UpQoSUpperLimit2=").append(this.upQoSUpperLimit2).append(", ");
        result.append("upQoSProfile3=").append(this.upQoSProfile3).append(", ");
        result.append("UpQoSUpperLimit3=").append(this.upQoSUpperLimit3).append(", ");
        result.append("upQoSProfile4=").append(this.upQoSProfile4).append(", ");
        result.append("UpQoSUpperLimit4=").append(this.upQoSUpperLimit4).append(", ");
        result.append("downQoSProfile1=").append(this.downQoSProfile1).append(", ");
        result.append("DownQoSUpperLimit1=").append(this.downQoSUpperLimit1).append(", ");
        result.append("downQoSProfile2=").append(this.downQoSProfile2).append(", ");
        result.append("DownQoSUpperLimit2=").append(this.downQoSUpperLimit2).append(", ");
        result.append("downQoSProfile3=").append(this.downQoSProfile3).append(", ");
        result.append("DownQoSUpperLimit3=").append(this.downQoSUpperLimit3).append(", ");
        result.append("downQoSProfile4=").append(this.downQoSProfile4).append(", ");
        result.append("DownQoSUpperLimit4=").append(this.downQoSUpperLimit4).append(", ");
        result.append("]");
        return result.toString();
    }

    public boolean isValueEqualTo(RbPolicyRule target) {
        return target == null ? false : RbPolicyRule.objectEquals(this.name, target.getName()) && RbPolicyRule.objectEquals(this.priorityType, target.getPriorityType()) && RbPolicyRule.objectEquals(this.downQoSUpperLimit1, target.getDownQoSUpperLimit1()) && RbPolicyRule.objectEquals(this.downQoSUpperLimit2, target.getDownQoSUpperLimit2()) && RbPolicyRule.objectEquals(this.downQoSUpperLimit3, target.getDownQoSUpperLimit3()) && RbPolicyRule.objectEquals(this.downQoSUpperLimit4, target.getDownQoSUpperLimit4()) && RbPolicyRule.objectEquals(this.upQoSUpperLimit1, target.getUpQoSUpperLimit1()) && RbPolicyRule.objectEquals(this.upQoSUpperLimit2, target.getUpQoSUpperLimit2()) && RbPolicyRule.objectEquals(this.upQoSUpperLimit3, target.getUpQoSUpperLimit3()) && RbPolicyRule.objectEquals(this.upQoSUpperLimit4, target.getUpQoSUpperLimit4()) && RbPolicyRule.qosProfileEquals(this.getDownQoSProfile1(), target.getDownQoSProfile1()) && RbPolicyRule.qosProfileEquals(this.getDownQoSProfile2(), target.getDownQoSProfile2()) && RbPolicyRule.qosProfileEquals(this.getDownQoSProfile3(), target.getDownQoSProfile3()) && RbPolicyRule.qosProfileEquals(this.getDownQoSProfile4(), target.getDownQoSProfile4()) && RbPolicyRule.qosProfileEquals(this.getUpQoSProfile1(), target.getUpQoSProfile1()) && RbPolicyRule.qosProfileEquals(this.getUpQoSProfile2(), target.getUpQoSProfile2()) && RbPolicyRule.qosProfileEquals(this.getUpQoSProfile3(), target.getUpQoSProfile3()) && RbPolicyRule.qosProfileEquals(this.getUpQoSProfile4(), target.getUpQoSProfile4());
    }

    private static boolean objectEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static boolean qosProfileEquals(RbQoSProfile p1, RbQoSProfile p2) {
        return p1 == null ? p2 == null : p1.isValueEqualTo(p2);
    }

    public static int maxValueForType(Integer type) {
        if (type == null) {
            return -1;
        }
        switch (type) {
            case 1: {
                return 63;
            }
            case 2: {
                return 7;
            }
        }
        return -1;
    }

    public void validateLimits(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbPolicyRule.class);
        this.validatePolicyUpperLimitsDown(invalidValues, i18n);
        this.validatePolicyUpperLimitsUp(invalidValues, i18n);
    }

    public List<InvalidValue> validatePolicyUpperLimitsDown(List<InvalidValue> values, Internationalizer i18n) {
        long minValue = 0L;
        long maxValue = RbPolicyRule.maxValueForType(this.getPriorityType());
        long highestValue = 0L;
        if (this.getDownQoSUpperLimit1() != null && this.getDownQoSUpperLimit1() != 0L || this.getDownQoSUpperLimit2() != null && this.getDownQoSUpperLimit2() != 0L || this.getDownQoSUpperLimit3() != null && this.getDownQoSUpperLimit3() != 0L || this.getDownQoSUpperLimit4() != null && this.getDownQoSUpperLimit4() != 0L) {
            ArrayList<ValidationObject> validationStuff = new ArrayList<ValidationObject>();
            validationStuff.add(new ValidationObject(this.getDownQoSUpperLimit1(), "downQoSUpperLimit1"));
            validationStuff.add(new ValidationObject(this.getDownQoSUpperLimit2(), "downQoSUpperLimit2"));
            validationStuff.add(new ValidationObject(this.getDownQoSUpperLimit3(), "downQoSUpperLimit3"));
            validationStuff.add(new ValidationObject(this.getDownQoSUpperLimit4(), "downQoSUpperLimit4"));
            ValidationObject finalCompletedObject = (ValidationObject)validationStuff.get(0);
            ValidationObject tempCompletedObject = (ValidationObject)validationStuff.get(0);
            for (ValidationObject element : validationStuff) {
                finalCompletedObject = element.getLimitValue() > 0L ? element : finalCompletedObject;
            }
            if (finalCompletedObject.getLimitValue() != maxValue) {
                values.add(new InvalidValue(i18n.translateString("highestLimitUp", new Object[]{String.valueOf(maxValue)}), RbPolicyRule.class, finalCompletedObject.getLimitString(), (Object)"", (Object)this));
            }
            for (int i = 0; i < validationStuff.indexOf(finalCompletedObject); ++i) {
                ValidationObject element;
                element = (ValidationObject)validationStuff.get(i);
                if (element != tempCompletedObject && element != finalCompletedObject && element.getLimitValue() <= tempCompletedObject.getLimitValue()) {
                    values.add(new InvalidValue(i18n.translateString("GenericValueError"), RbPolicyRule.class, element.getLimitString(), (Object)element.getLimitValue(), (Object)this));
                }
                if (element.getLimitValue() >= maxValue) {
                    values.add(new InvalidValue(i18n.translateString("higherLimitUp", new Object[]{String.valueOf(maxValue)}), RbPolicyRule.class, element.getLimitString(), (Object)element.getLimitValue(), (Object)this));
                }
                if (element.getLimitValue() < minValue || element.getLimitValue() == minValue && i != 0) {
                    values.add(new InvalidValue(i18n.translateString("lowerLimitUp", new Object[]{String.valueOf(minValue)}), RbPolicyRule.class, element.getLimitString(), (Object)element.getLimitValue(), (Object)this));
                }
                tempCompletedObject = element;
            }
        } else {
            this.validateLimit(0L, "downQoSUpperLimit1", minValue, maxValue, values, this, highestValue, i18n);
        }
        return values;
    }

    public List<InvalidValue> validatePolicyUpperLimitsUp(List<InvalidValue> values, Internationalizer i18n) {
        long minValue = 0L;
        long maxValue = RbPolicyRule.maxValueForType(this.getPriorityType());
        long highestValue = 0L;
        if (this.getUpQoSUpperLimit1() != null && this.getUpQoSUpperLimit1() != 0L || this.getUpQoSUpperLimit2() != null && this.getUpQoSUpperLimit2() != 0L || this.getUpQoSUpperLimit3() != null && this.getUpQoSUpperLimit3() != 0L || this.getUpQoSUpperLimit4() != null && this.getUpQoSUpperLimit4() != 0L) {
            ArrayList<ValidationObject> validationStuff = new ArrayList<ValidationObject>();
            validationStuff.add(new ValidationObject(this.getUpQoSUpperLimit1(), "upQoSUpperLimit1"));
            validationStuff.add(new ValidationObject(this.getUpQoSUpperLimit2(), "upQoSUpperLimit2"));
            validationStuff.add(new ValidationObject(this.getUpQoSUpperLimit3(), "upQoSUpperLimit3"));
            validationStuff.add(new ValidationObject(this.getUpQoSUpperLimit4(), "upQoSUpperLimit4"));
            ValidationObject finalCompletedObject = (ValidationObject)validationStuff.get(0);
            ValidationObject tempCompletedObject = (ValidationObject)validationStuff.get(0);
            for (ValidationObject element : validationStuff) {
                finalCompletedObject = element.getLimitValue() > 0L ? element : finalCompletedObject;
            }
            if (finalCompletedObject.getLimitValue() != maxValue) {
                values.add(new InvalidValue(i18n.translateString("highestLimitUp", new Object[]{String.valueOf(maxValue)}), RbPolicyRule.class, finalCompletedObject.getLimitString(), (Object)"", (Object)this));
            }
            for (int i = 0; i < validationStuff.indexOf(finalCompletedObject); ++i) {
                ValidationObject element;
                element = (ValidationObject)validationStuff.get(i);
                if (element != tempCompletedObject && element != finalCompletedObject && element.getLimitValue() <= tempCompletedObject.getLimitValue()) {
                    values.add(new InvalidValue(i18n.translateString("GenericValueError"), RbPolicyRule.class, element.getLimitString(), (Object)element.getLimitValue(), (Object)this));
                }
                if (element.getLimitValue() >= maxValue) {
                    values.add(new InvalidValue(i18n.translateString("higherLimitUp", new Object[]{String.valueOf(maxValue)}), RbPolicyRule.class, element.getLimitString(), (Object)element.getLimitValue(), (Object)this));
                }
                if (element.getLimitValue() < minValue || element.getLimitValue() == minValue && i != 0) {
                    values.add(new InvalidValue(i18n.translateString("lowerLimitUp", new Object[]{String.valueOf(minValue)}), RbPolicyRule.class, element.getLimitString(), (Object)element.getLimitValue(), (Object)this));
                }
                tempCompletedObject = element;
            }
        } else {
            this.validateLimit(0L, "upQoSUpperLimit1", minValue, maxValue, values, this, highestValue, i18n);
        }
        return values;
    }

    private long validateLimit(Long value, String propertyName, long minValue, long maxValue, List<InvalidValue> values, Object bean, long highestValue, Internationalizer i18n) {
        if (maxValue == 0L) {
            minValue = -1L;
        }
        if (minValue < value && value <= maxValue) {
            return highestValue > value ? highestValue : value;
        }
        String message = "ValueBetween";
        if (maxValue > 0L) {
            Object[] params = new String[]{maxValue > minValue ? String.valueOf(highestValue) : i18n.translateString("previous value"), String.valueOf(maxValue)};
            message = i18n.translateString(message, params);
        } else {
            message = i18n.translateString("MaximumValZero");
        }
        values.add(new InvalidValue(message, RbPolicyRule.class, propertyName, (Object)value, bean));
        return highestValue;
    }

    public void validateName(List<InvalidValue> invalidValues, Binder mainBinder, Internationalizer i18n) {
        String name = this.getName();
        if (name == null || name.trim().equals("") || !name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") || name.length() > 32) {
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("InvalidName"), RbPolicyRule.class, "name", (Object)"", (Object)this));
            mainBinder.toUIInvalidValues(invalidValues, iValues);
        }
    }

    public void addObjectsToList(MultipleStringList attribValues) {
        attribValues.addToList(this.getName());
        attribValues.addToList(this.getPriorityType());
        attribValues.addToList(this.getUpQoSUpperLimit1());
        attribValues.addToList(this.getUpQoSUpperLimit2());
        attribValues.addToList(this.getUpQoSUpperLimit3());
        attribValues.addToList(this.getUpQoSUpperLimit4());
        attribValues.addToList(this.getDownQoSUpperLimit1());
        attribValues.addToList(this.getDownQoSUpperLimit2());
        attribValues.addToList(this.getDownQoSUpperLimit3());
        attribValues.addToList(this.getDownQoSUpperLimit4());
        this.getUpQoSProfile1().addObjectsToList(attribValues);
        this.getUpQoSProfile2().addObjectsToList(attribValues);
        this.getUpQoSProfile3().addObjectsToList(attribValues);
        this.getUpQoSProfile4().addObjectsToList(attribValues);
        this.getDownQoSProfile1().addObjectsToList(attribValues);
        this.getDownQoSProfile2().addObjectsToList(attribValues);
        this.getDownQoSProfile3().addObjectsToList(attribValues);
        this.getDownQoSProfile4().addObjectsToList(attribValues);
    }

    private class ValidationObject {
        private Long limitValue;
        private String limitString;

        public ValidationObject(Long limitValue, String limitString) {
            this.limitValue = limitValue;
            this.limitString = limitString;
        }

        public String getLimitString() {
            return this.limitString;
        }

        public void setLimitString(String limitString) {
            this.limitString = limitString;
        }

        public Long getLimitValue() {
            return this.limitValue;
        }

        public void setLimitValue(Long limitValue) {
            this.limitValue = limitValue;
        }
    }
}

