/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.util.MultipleStringList;
import com.bwanms.validation.WeakRange;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import org.hibernate.validator.Length;

@Entity
public class RbIPModeMngVoIPServiceProfile
extends RbServiceProfile {
    private static final long serialVersionUID = -3571228290123341087L;
    private Integer maxNumberOfSimultaneousCalls;
    private RbPolicyRule policyRule;
    private String voiceDomainName;

    @WeakRange(min=0L, max=50L)
    public Integer getMaxNumberOfSimultaneousCalls() {
        return this.maxNumberOfSimultaneousCalls;
    }

    public void setMaxNumberOfSimultaneousCalls(Integer rbServiceTemplateNumberOfSimultaneousCalls) {
        this.maxNumberOfSimultaneousCalls = rbServiceTemplateNumberOfSimultaneousCalls;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="policyRuleId")
    public RbPolicyRule getPolicyRule() {
        if (this.policyRule == null) {
            this.policyRule = new RbPolicyRule();
        }
        return this.policyRule;
    }

    public void setPolicyRule(RbPolicyRule policyRule) {
        this.policyRule = policyRule;
    }

    @Length(min=1, max=32)
    public String getVoiceDomainName() {
        return this.voiceDomainName;
    }

    public void setVoiceDomainName(String voiceDomainName) {
        this.voiceDomainName = voiceDomainName;
    }

    public Integer rbServiceTemplateType() {
        return 7;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("super=").append(super.toString()).append(", ");
        result.append("rbServiceTemplateType=").append(this.toStringRbServiceTemplateType()).append(", ");
        result.append("policyRule=").append(this.policyRule).append(", ");
        result.append("voiceDomainName=").append(this.voiceDomainName);
        result.append("]");
        return result.toString();
    }

    public boolean isValueEqualTo(RbServiceProfile target) {
        if (super.isValueEqualTo(target) && target instanceof RbIPModeMngVoIPServiceProfile) {
            RbIPModeMngVoIPServiceProfile targetVoIP = (RbIPModeMngVoIPServiceProfile)target;
            return RbIPModeMngVoIPServiceProfile.objectEquals(this.maxNumberOfSimultaneousCalls, targetVoIP.maxNumberOfSimultaneousCalls) && RbIPModeMngVoIPServiceProfile.policyRuleEquals(this.getPolicyRule(), targetVoIP.getPolicyRule()) && RbIPModeMngVoIPServiceProfile.objectEquals(this.getVoiceDomainName(), targetVoIP.getVoiceDomainName());
        }
        return false;
    }

    protected void addNumberOfSimultaneousCallsObjsToList(MultipleStringList attribValues) {
        attribValues.addToList(this.getMaxNumberOfSimultaneousCalls());
    }

    protected void addPolicyRuleObjsToList(MultipleStringList attribValues) {
        this.getPolicyRule().addObjectsToList(attribValues);
    }

    protected void addVoiceDomainsObjsToList(MultipleStringList attribValues) {
        attribValues.addToList(this.getVoiceDomainName());
    }
}

