/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.gui.Templates;
import com.bwanms.model.Template;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbQoSProfileValues;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbForwardingRuleTemplate
implements Serializable,
Template<RbForwardingRule> {
    private long id;
    private String name;
    private Integer multicastRelaying;
    private Integer multicastVLAN;
    private Integer type;
    private Integer unicastRelaying;
    private Integer unknownAddrPolicy;
    RbQoSProfileValues qoSProfile;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="qosValuesId")
    public RbQoSProfileValues getQoS() {
        return this.qoSProfile;
    }

    public Integer getMulticastRelaying() {
        return this.multicastRelaying;
    }

    public Integer getMulticastVLAN() {
        return this.multicastVLAN;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getUnicastRelaying() {
        return this.unicastRelaying;
    }

    public Integer getUnknownAddrPolicy() {
        return this.unknownAddrPolicy;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String rbForwardingRuleName) {
        this.name = rbForwardingRuleName;
    }

    public void setQoS(RbQoSProfileValues rainbowQoS) {
        this.qoSProfile = rainbowQoS;
    }

    public void setMulticastRelaying(Integer rbForwardingRuleMulticastRelaying) {
        this.multicastRelaying = rbForwardingRuleMulticastRelaying;
    }

    public void setMulticastVLAN(Integer rbForwardingRuleMulticastVLAN) {
        this.multicastVLAN = rbForwardingRuleMulticastVLAN;
    }

    public void setType(Integer rbForwardingRuleType) {
        this.type = rbForwardingRuleType;
    }

    public void setUnicastRelaying(Integer rbForwardingRuleUnicastRelaying) {
        this.unicastRelaying = rbForwardingRuleUnicastRelaying;
    }

    public void setUnknownAddrPolicy(Integer rbForwardingUnknownAddrPolicy) {
        this.unknownAddrPolicy = rbForwardingUnknownAddrPolicy;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbForwardingRuleType=").append(RbForwardingRule.toStringType(this.type)).append(", ");
        result.append("rbForwardingRuleName=").append(this.name).append(", ");
        result.append("rbForwardingRuleUnicastRelaying=").append(RbForwardingRule.toStringUnicastRelaying(this.unicastRelaying)).append(", ");
        result.append("rbForwardingRuleMulticastRelaying=").append(RbForwardingRule.toStringMulticastRelaying(this.multicastRelaying)).append(", ");
        result.append("rbForwardingUnknownAddrPolicy=").append(RbForwardingRule.toStringUnknownAddrPolicy(this.unknownAddrPolicy)).append(", ");
        result.append("rbForwardingRuleMulticastVLAN=").append(this.multicastVLAN).append(", ");
        result.append("rainbowQoS=").append(this.qoSProfile).append(", ");
        result.append("]");
        return result.toString();
    }

    public RbForwardingRule createInstanceFromTemplate() {
        RbForwardingRule fwRule = new RbForwardingRule();
        fwRule.setName(this.getName());
        fwRule.setType(this.getType());
        fwRule.setMulticastRelaying(this.getMulticastRelaying());
        fwRule.setMulticastVLAN(this.getMulticastVLAN());
        fwRule.setQoS(RbQoSProfileValues.createInstanceFromValues(this.getQoS()));
        fwRule.setUnicastRelaying(this.getUnicastRelaying());
        fwRule.setUnknownAddrPolicy(this.getUnknownAddrPolicy());
        return fwRule;
    }

    public boolean matches(RbForwardingRule toMatch) {
        return Templates.match((Object)this.name, (Object)toMatch.getName()) && Templates.match((Object)this.type, (Object)toMatch.getType()) && Templates.match((Object)this.multicastRelaying, (Object)toMatch.getMulticastRelaying()) && Templates.match((Object)this.multicastVLAN, (Object)toMatch.getMulticastVLAN()) && Templates.match((Object)this.unicastRelaying, (Object)toMatch.getUnicastRelaying()) && Templates.match((Object)this.unknownAddrPolicy, (Object)toMatch.getUnknownAddrPolicy()) && (this.qoSProfile == null && toMatch.getQoS() == null || this.qoSProfile != null && toMatch.getQoS() != null && this.qoSProfile.matches(toMatch.getQoS()));
    }

    public RbForwardingRuleTemplate createTemplateFromInstance(RbForwardingRule instance) {
        RbForwardingRuleTemplate template = new RbForwardingRuleTemplate();
        RbQoSProfileValues qosValues = new RbQoSProfileValues();
        qosValues = RbQoSProfileValues.getValueObjectFromInstance(instance.getQoS());
        template.setName(instance.getName());
        template.setType(instance.getType());
        template.setMulticastRelaying(instance.getMulticastRelaying());
        template.setMulticastVLAN(instance.getMulticastVLAN());
        template.setQoS(qosValues);
        template.setUnicastRelaying(instance.getUnicastRelaying());
        template.setUnknownAddrPolicy(instance.getUnknownAddrPolicy());
        return template;
    }
}

