/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.util.MultipleStringList;
import com.bwanms.validation.WeakRange;
import java.io.Serializable;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Embeddable
public class RbForwardingRule
implements Serializable {
    public static final int MulticastRelayingEnable = 1;
    public static final int MulticastRelayingDisable = 2;
    public static final int UnicastRelayingEnable = 1;
    public static final int UnicastRelayingDisable = 2;
    public static final int RbForwardingUnknownAddrPolicyReject = 1;
    public static final int RbForwardingUnknownAddrPolicyForward = 2;
    public static final int MulticastVLANNone = 4095;
    private String name;
    private Integer multicastRelaying;
    private Integer multicastVLAN;
    private Integer type;
    private Integer unicastRelaying;
    private Integer unknownAddrPolicy;
    RbQoSProfile qoSProfile;

    @Transient
    public long getId() {
        return 0L;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="nameQoS")), @AttributeOverride(name="type", column=@Column(name="typeQoS")), @AttributeOverride(name="param1", column=@Column(name="param1QoS")), @AttributeOverride(name="param2", column=@Column(name="param2QoS")), @AttributeOverride(name="paramTime", column=@Column(name="paramTimeQoS"))})
    public RbQoSProfile getQoS() {
        if (this.qoSProfile == null) {
            this.qoSProfile = new RbQoSProfile();
        }
        return this.qoSProfile;
    }

    public Integer getMulticastRelaying() {
        return this.multicastRelaying;
    }

    @WeakRange(min=0L, max=4095L)
    public Integer getMulticastVLAN() {
        return this.multicastVLAN;
    }

    @Length(min=1, max=32)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    public String getName() {
        return this.name;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getUnicastRelaying() {
        return this.unicastRelaying;
    }

    public Integer getUnknownAddrPolicy() {
        return this.unknownAddrPolicy;
    }

    public void setId(long id) {
    }

    public void setQoS(RbQoSProfile rainbowQoS) {
        this.qoSProfile = rainbowQoS;
    }

    public void setMulticastRelaying(Integer rbForwardingRuleMulticastRelaying) {
        this.multicastRelaying = rbForwardingRuleMulticastRelaying;
    }

    public void setMulticastVLAN(Integer rbForwardingRuleMulticastVLAN) {
        this.multicastVLAN = rbForwardingRuleMulticastVLAN;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Integer rbForwardingRuleType) {
        this.type = rbForwardingRuleType;
    }

    public void setUnicastRelaying(Integer rbForwardingRuleUnicastRelaying) {
        this.unicastRelaying = rbForwardingRuleUnicastRelaying;
    }

    public void setUnknownAddrPolicy(Integer rbForwardingUnknownAddrPolicy) {
        this.unknownAddrPolicy = rbForwardingUnknownAddrPolicy;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbForwardingRuleType=").append(RbForwardingRule.toStringType(this.type)).append(", ");
        result.append("rbForwardingRuleUnicastRelaying=").append(RbForwardingRule.toStringUnicastRelaying(this.unicastRelaying)).append(", ");
        result.append("rbForwardingRuleMulticastRelaying=").append(RbForwardingRule.toStringMulticastRelaying(this.multicastRelaying)).append(", ");
        result.append("rbForwardingUnknownAddrPolicy=").append(RbForwardingRule.toStringUnknownAddrPolicy(this.unknownAddrPolicy)).append(", ");
        result.append("rbForwardingRuleMulticastVLAN=").append(this.multicastVLAN).append(", ");
        result.append("rainbowQoS=").append(this.qoSProfile).append(", ");
        result.append("]");
        return result.toString();
    }

    public static String toStringType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "rbLayerII(1)";
                break;
            }
            case 2: {
                result = "rbPPPoE(2)";
                break;
            }
            case 3: {
                result = "rbVoIP(3)";
                break;
            }
            case 4: {
                result = "rbIPModeData(4)";
                break;
            }
            case 5: {
                result = "rbIPModeVoIP(5)";
                break;
            }
            case 6: {
                result = "rbManaged-VoIP(6)";
                break;
            }
            case 7: {
                result = "rbIPmode-Managed-VoIP(7)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringUnicastRelaying(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringMulticastRelaying(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringUnknownAddrPolicy(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "reject(1)";
                break;
            }
            case 2: {
                result = "forward(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public void validateMulticastVLAN(List<InvalidValue> invalidValues, Binder mainBinder, Internationalizer i18n) {
    }

    public boolean isValueEqualTo(RbForwardingRule target) {
        return target == null || target.isValueNull() ? this.isValueNull() : RbForwardingRule.objectEquals(this.name, target.getName()) && RbForwardingRule.objectEquals(this.type, target.getType()) && RbForwardingRule.objectEquals(this.multicastVLAN, target.getMulticastVLAN()) && (1 != this.type && 6 != this.type && 7 != this.type || RbForwardingRule.objectEquals(this.unicastRelaying, target.getUnicastRelaying()) && RbForwardingRule.objectEquals(this.multicastRelaying, target.getMulticastRelaying()) && RbForwardingRule.objectEquals(this.unknownAddrPolicy, target.getUnknownAddrPolicy())) && RbForwardingRule.qosProfileEquals(this.getQoS(), target.getQoS());
    }

    private static boolean objectEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static boolean qosProfileEquals(RbQoSProfile p1, RbQoSProfile p2) {
        return p1 == null ? p2 == null : p1.isValueEqualTo(p2);
    }

    public void makeNull() {
        this.type = null;
        this.name = null;
        this.multicastRelaying = null;
        this.multicastVLAN = null;
        this.unicastRelaying = null;
        this.unknownAddrPolicy = null;
        this.getQoS().makeNull();
    }

    @Transient
    public boolean isValueNull() {
        return null == this.type || null == this.name;
    }

    public void addObjectsToList(MultipleStringList attribValues) {
        attribValues.addToList(this.getName());
        attribValues.addToList(this.getType());
        attribValues.addToList(this.getMulticastVLAN());
        if (null != this.type && (1 == this.type || 6 == this.type || 7 == this.type)) {
            attribValues.addToList(this.getMulticastRelaying());
            attribValues.addToList(this.getUnicastRelaying());
            attribValues.addToList(this.getUnknownAddrPolicy());
        } else {
            attribValues.addNullToList();
            attribValues.addNullToList();
            attribValues.addNullToList();
        }
        this.getQoS().addObjectsToList(attribValues);
    }
}

