/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.services;

import com.bwanms.util.MultipleStringList;
import com.bwanms.validation.IPv4Address;
import com.bwanms.validation.WeakRange;
import java.io.Serializable;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class RbBSPFServerGlobal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String ipAddress;
    private Integer portNumber;
    private Integer pfVlan;
    private String sharedString;

    @Transient
    public long getId() {
        return 0L;
    }

    public void setId(long id) {
    }

    @IPv4Address(acceptAnyIp=true)
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @WeakRange(min=1L, max=65535L)
    public Integer getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

    @WeakRange(min=0L, max=4095L)
    public Integer getPfVlan() {
        return this.pfVlan;
    }

    public void setPfVlan(Integer pfVlan) {
        this.pfVlan = pfVlan;
    }

    public String getSharedString() {
        return this.sharedString;
    }

    public void setSharedString(String sharedString) {
        this.sharedString = sharedString;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("IpAddress=").append(this.ipAddress).append(", ");
        result.append("PortNumber=").append(this.portNumber).append(", ");
        result.append("PfVlan=").append(this.pfVlan).append(", ");
        result.append("SharedString=").append(this.sharedString).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public boolean isValueNull() {
        return null == this.portNumber;
    }

    public void addObjectsToList(MultipleStringList attribValues) {
        attribValues.addToList(this.getIpAddress());
        attribValues.addToList(this.getPortNumber());
        attribValues.addToList(this.getPfVlan());
        attribValues.addToList(this.getSharedString());
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.pfVlan == null ? 0 : this.pfVlan.hashCode());
        result = 31 * result + (this.portNumber == null ? 0 : this.portNumber.hashCode());
        result = 31 * result + (this.sharedString == null ? 0 : this.sharedString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RbBSPFServerGlobal other = (RbBSPFServerGlobal)obj;
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.pfVlan == null ? other.pfVlan != null : !this.pfVlan.equals(other.pfVlan)) {
            return false;
        }
        if (this.portNumber == null ? other.portNumber != null : !this.portNumber.equals(other.portNumber)) {
            return false;
        }
        return !(this.sharedString == null ? other.sharedString != null : !this.sharedString.equals(other.sharedString));
    }
}

