/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model.constants;

import com.bwanms.model.fault.constants.EventFilterConstantsProvider;
import com.bwanms.rb.model.constants.RbMOType;
import com.bwanms.rb.model.constants.RbNEType;
import com.bwanms.rb.model.constants.RbTrapType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbEvtFilterConstantsProvider
implements EventFilterConstantsProvider {
    public boolean accept(Enum<?> arg) {
        if (arg == null) {
            return false;
        }
        Class<?> clazz = arg.getClass();
        return RbNEType.class.isAssignableFrom(clazz) || RbMOType.class.isAssignableFrom(clazz) || RbTrapType.class.isAssignableFrom(clazz);
    }

    public Enum<?>[] getNETypes() {
        return RbNEType.values();
    }

    public Enum<?>[] getMOTypes() {
        return RbMOType.values();
    }

    public Enum<?>[] getTrapTypes() {
        return RbTrapType.values();
    }

    public Enum<?>[] getMOTypes(Enum<?> neType) {
        if (neType == null || !RbNEType.class.isAssignableFrom(neType.getClass())) {
            throw new IllegalArgumentException("NE Type not accepted or null");
        }
        if (RbNEType.BMAX_BS.equals(neType)) {
            return new RbMOType[]{RbMOType.BS, RbMOType.NPU, RbMOType.AU, RbMOType.PSU, RbMOType.PIU, RbMOType.ACU, RbMOType.ACU_FAN, RbMOType.SU, RbMOType.RC, RbMOType.ODU, RbMOType.CHNL, RbMOType.SBSCR, RbMOType.SRVC, RbMOType.POLICY, RbMOType.QOS, RbMOType.FRWRD, RbMOType.TMPL, RbMOType.FLTR2, RbMOType.FLTR3, RbMOType.FLTRIFC, RbMOType.FLTR, RbMOType.DENY, RbMOType.AUTH_MNG, RbMOType.TRAP, RbMOType.AUTH_SERV, RbMOType.ACCT_SERV, RbMOType.QINQ, RbMOType.VOICE_DOMAIN, RbMOType.PF_SERV, RbMOType.PF_CONFIG, RbMOType.SERVICE_GROUP, RbMOType.PMTM};
        }
        if (RbNEType.BMAX_MBS.equals(neType)) {
            return new RbMOType[]{RbMOType.MicroBST, RbMOType.SU, RbMOType.RC, RbMOType.ODU, RbMOType.CHNL, RbMOType.SBSCR, RbMOType.SRVC, RbMOType.POLICY, RbMOType.QOS, RbMOType.FRWRD, RbMOType.TMPL, RbMOType.FLTR2, RbMOType.FLTR3, RbMOType.FLTRIFC, RbMOType.FLTR, RbMOType.DENY, RbMOType.AUTH_MNG, RbMOType.TRAP, RbMOType.AUTH_SERV, RbMOType.ACCT_SERV, RbMOType.QINQ, RbMOType.VOICE_DOMAIN, RbMOType.PF_SERV, RbMOType.PF_CONFIG, RbMOType.SERVICE_GROUP};
        }
        return RbMOType.values();
    }

    public Enum<?>[] getTrapTypes(Enum<?> moType) {
        if (moType == null || !RbMOType.class.isAssignableFrom(moType.getClass())) {
            throw new IllegalArgumentException("MO Type not accepted or null");
        }
        switch ((RbMOType)((Object)RbMOType.class.cast(moType))) {
            case MicroBST: {
                return new RbTrapType[]{RbTrapType.rbShelfPeripheralEquipmentFaultOn, RbTrapType.rbShelfPeripheralEquipmentFaultOff, RbTrapType.rbShelfEnvParamFaultOn, RbTrapType.rbShelfEnvParamFaultOff, RbTrapType.rbResetOn, RbTrapType.rbDiagnosticsHwFaultOn, RbTrapType.rbDiagnosticsHwFaultOff, RbTrapType.rbMonitorAccessOn, RbTrapType.rbMonitorAccessOff, RbTrapType.rbAuNetworkEntryStatus, RbTrapType.rbParameterSetFailure, RbTrapType.rbMbstLicense, RbTrapType.rbMbstCPEQuantityExceed, RbTrapType.rbLicenseFileLoadStatus, RbTrapType.rbOduCrcErrorOn, RbTrapType.rbOduCrcErrorOff, RbTrapType.rbOduCommErrorOn, RbTrapType.rbOduCommErrorOff, RbTrapType.rbOduBandMismatchOn, RbTrapType.rbOduBandMismatchOff, RbTrapType.rbOduPowerMismatch, RbTrapType.rbSwDownloadStart, RbTrapType.rbSwDownloadEnd, RbTrapType.rbSwDownloadError, RbTrapType.rbSwSwitchFailed, RbTrapType.rbSwSwitchSucceed, RbTrapType.rbConfigurationChanged, RbTrapType.rbMbstLicenseChanged};
            }
            case BS: {
                return RbTrapType.values();
            }
            case NPU: {
                return new RbTrapType[]{RbTrapType.rbShelfCardExtractionOn, RbTrapType.rbShelfCardInsertionOn, RbTrapType.rbShelfEnvParamFaultOn, RbTrapType.rbShelfEnvParamFaultOff, RbTrapType.rbResetOn, RbTrapType.rbCPELicenseAssigned, RbTrapType.rbBackupFileSwitchingModeMismatch, RbTrapType.rbDiagnosticsHwFaultOn, RbTrapType.rbDiagnosticsHwFaultOff, RbTrapType.rbFreqBandDownloadStatus, RbTrapType.rbMonitorAccessOn, RbTrapType.rbMonitorAccessOff, RbTrapType.rbParameterSetFailure, RbTrapType.rbLicenseFileLoadStatus, RbTrapType.rbSwDownloadStart, RbTrapType.rbSwDownloadEnd, RbTrapType.rbSwDownloadError, RbTrapType.rbSwSwitchFailed, RbTrapType.rbSwSwitchSucceed, RbTrapType.rbGPSComFailureOn, RbTrapType.rbGPSComFailureOff, RbTrapType.rbGPSHealthyFailureOn, RbTrapType.rbGPSHealthyFailureOff, RbTrapType.rbGPSSysUpDateAndTime, RbTrapType.rbConfigurationChanged, RbTrapType.rbXMLDownloadStatus, RbTrapType.rbServiceDown, RbTrapType.rbServiceUp, RbTrapType.rbServiceChanged, RbTrapType.rbServiceGeneralError, RbTrapType.rbSwitchedAuthenticationServer, RbTrapType.rbSwitchedAccountingServer, RbTrapType.rbServiceEstablishmentFailure, RbTrapType.rbUserAuthenticationTimeout, RbTrapType.rbUserAuthenticationReject, RbTrapType.rbAuthenticationServerKeepAliveTimeoutOff, RbTrapType.rbAuthenticationServerKeepAliveTimeoutOn, RbTrapType.rbAccountingServerKeepAliveTimeoutOff, RbTrapType.rbAccountingServerKeepAliveTimeoutOn, RbTrapType.rbExternal1PPSFailureOff, RbTrapType.rbExternal1PPSFailureOn, RbTrapType.rbInternal1PPSFailureOff, RbTrapType.rbInternal1PPSFailureOn, RbTrapType.rbExternal16MHzFailureOff, RbTrapType.rbExternal16MHzFailureOn, RbTrapType.rbInternal16MHzFailureOff, RbTrapType.rbInternal16MHzFailureOn, RbTrapType.rbMin4SatSyncFailureOff, RbTrapType.rbMin4SatSyncFailureOn, RbTrapType.rbIPCSModeConfigurationError};
            }
            case AU: {
                return new RbTrapType[]{RbTrapType.rbShelfCardExtractionOn, RbTrapType.rbShelfCardInsertionOn, RbTrapType.rbResetOn, RbTrapType.rbDiagnosticsHwFaultOn, RbTrapType.rbDiagnosticsHwFaultOff, RbTrapType.rbAuNetworkEntryStatus, RbTrapType.rbAUExternal1PPSFailureOn, RbTrapType.rbAUExternal1PPSFailureOff, RbTrapType.rbAUHoldOverEnteredOn, RbTrapType.rbAUHoldOverEnteredOff, RbTrapType.rbAUHoldOverTimeoutPassedOn, RbTrapType.rbAUHoldOverTimeoutPassedOff, RbTrapType.rbAUHoldOverTxStoppedOn, RbTrapType.rbAUHoldOverTxStoppedOff, RbTrapType.rbBERTestFinished, RbTrapType.rbBERTestStarted, RbTrapType.rbModeConflictOn, RbTrapType.rbModeConflictOff, RbTrapType.rbParameterSetFailure, RbTrapType.rbOduCrcErrorOn, RbTrapType.rbOduCrcErrorOff, RbTrapType.rbOduCommErrorOn, RbTrapType.rbOduCommErrorOff, RbTrapType.rbOduBandMismatchOn, RbTrapType.rbOduBandMismatchOff, RbTrapType.rbOduPowerMismatch, RbTrapType.rbOduFailureOn, RbTrapType.rbOduFailureOff, RbTrapType.rbShelfPeripheralEquipmentFaultOn, RbTrapType.rbShelfPeripheralEquipmentFaultOff, RbTrapType.rbSwFileConflict, RbTrapType.rbSwDownloadStart, RbTrapType.rbSwDownloadEnd, RbTrapType.rbSwDownloadError, RbTrapType.rbSwSwitchFailed, RbTrapType.rbSwSwitchSucceed, RbTrapType.rbAUSpecAnalyzerTestStatus, RbTrapType.rbConfigurationChanged};
            }
            case PSU: {
                return new RbTrapType[]{RbTrapType.rbShelfCardExtractionOn, RbTrapType.rbShelfPeripheralEquipmentFaultOn, RbTrapType.rbShelfPeripheralEquipmentFaultOff, RbTrapType.rbShelfCardInsertionOn};
            }
            case PIU: {
                return new RbTrapType[]{RbTrapType.rbShelfCardExtractionOn, RbTrapType.rbShelfCardInsertionOn, RbTrapType.rbShelfPeripheralEquipmentFaultOn, RbTrapType.rbShelfPeripheralEquipmentFaultOff};
            }
            case ACU: {
                return new RbTrapType[]{RbTrapType.rbShelfCardExtractionOn, RbTrapType.rbShelfCardInsertionOn, RbTrapType.rbShelfPeripheralEquipmentFaultOn, RbTrapType.rbShelfPeripheralEquipmentFaultOff};
            }
            case ACU_FAN: {
                return new RbTrapType[]{RbTrapType.rbShelfPeripheralEquipmentFaultOn};
            }
            case SU: {
                return new RbTrapType[]{RbTrapType.rbResetOn, RbTrapType.rbDiagnosticsHwFaultOn, RbTrapType.rbDiagnosticsHwFaultOff, RbTrapType.rbMonitorAccessOn, RbTrapType.rbMonitorAccessOff, RbTrapType.rbParameterSetFailure, RbTrapType.rbSuMaxTxPowerReached, RbTrapType.rbSuMinTxPowerReached, RbTrapType.rbSuLicense, RbTrapType.rbSuDuplicateName, RbTrapType.rbSwDownloadStart, RbTrapType.rbSwDownloadEnd, RbTrapType.rbSwDownloadError, RbTrapType.rbSwSwitchFailed, RbTrapType.rbSwSwitchSucceed, RbTrapType.rbBERTestFinished, RbTrapType.rbBERTestStarted, RbTrapType.rbNetworkingError, RbTrapType.rbSuNetworkEntryStatus, RbTrapType.rbConfigurationChanged, RbTrapType.rbModeConflictOn, RbTrapType.rbModeConflictOff, RbTrapType.rbOptimalRSSIConflict, RbTrapType.rbShelfCardExtractionOn, RbTrapType.rbShelfCardInsertionOn, RbTrapType.rbSwFileConflict};
            }
            case RC: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case ODU: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case CHNL: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case SBSCR: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case SRVC: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case POLICY: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case QOS: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case FRWRD: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case TMPL: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case FLTR2: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case FLTR3: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case FLTRIFC: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case FLTR: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case DENY: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case AUTH_MNG: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case TRAP: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case AUTH_SERV: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case ACCT_SERV: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case QINQ: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case VOICE_DOMAIN: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case PF_SERV: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case PF_CONFIG: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case SERVICE_GROUP: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
            case PMTM: {
                return new RbTrapType[]{RbTrapType.rbConfigurationChanged};
            }
        }
        return RbTrapType.values();
    }

    public Enum<?> findMOType(int value) {
        RbMOType moType = RbMOType.fromValue(value);
        return moType.equals((Object)RbMOType.unexpectedValue) ? null : moType;
    }

    public Enum<?> findNEType(int value) {
        RbNEType neType = RbNEType.fromValue(value);
        return neType.equals((Object)RbNEType.unexpectedValue) ? null : neType;
    }

    public Enum<?> findTrapType(String oid) {
        for (RbTrapType trapType : RbTrapType.values()) {
            if (!trapType.oid().equals(oid)) continue;
            return trapType;
        }
        return null;
    }
}

