/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.mediation.NetworkResourceHandler;
import com.bwanms.mediation.snmp.SNMPNetworkResourceHandler;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.model.ManagementInterface;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.rb.model.RbSuPrimaryNetworkResourceConfiguration;
import javax.persistence.Entity;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbSUEquipmentConfiguration
extends EquipmentConfiguration {
    public void createPrimaryNetworkResource() {
        RbSuPrimaryNetworkResourceConfiguration primary = new RbSuPrimaryNetworkResourceConfiguration();
        primary.setName("SU");
        primary.setConfiguration(this);
        this.addNetworkResourceConfiguration(primary);
    }

    @Transient
    public NetworkResourceHandler getNetworkResourceHandler(Class<? extends ManagementInterface> managementInterfaceClass) {
        if (SNMPManagementInterface.class.isAssignableFrom(managementInterfaceClass)) {
            return new SUNetworkResourceHandler();
        }
        throw new RuntimeException("This configuration does not support " + managementInterfaceClass.getName());
    }

    @Transient
    public String getPrimaryNetworkResourceConfigurationName() {
        return "SU";
    }

    private static class SUNetworkResourceHandler
    implements SNMPNetworkResourceHandler {
        private SUNetworkResourceHandler() {
        }

        public SNMPManagementInterface getAgentInfo(SNMPManagementInterface equipmentAgentInfo, String networkResource) {
            if ("BS".equals(networkResource)) {
                String suReadComm = equipmentAgentInfo.getReadCommunity();
                String suWriteComm = equipmentAgentInfo.getWriteCommunity();
                return new SNMPManagementInterface(equipmentAgentInfo.getIp(), equipmentAgentInfo.getPort(), suReadComm.substring(0, suReadComm.indexOf("@")), suWriteComm.substring(0, suWriteComm.indexOf("@")), equipmentAgentInfo.getRetries().intValue(), equipmentAgentInfo.getTimeout().longValue());
            }
            return equipmentAgentInfo;
        }
    }
}

