/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.gui.configuration.EquipmentManagerNotFoundException;
import com.bwanms.model.ConfigurableEquipment;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentManager;
import com.bwanms.model.Manageable;
import com.bwanms.model.ManagedEquipment;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.StandardSoftwareVersions;
import com.bwanms.model.fault.constants.MOType;
import com.bwanms.model.license.Licensable;
import com.bwanms.rb.command.RbSuCommand;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
@javax.persistence.Table(uniqueConstraints={@UniqueConstraint(columnNames={"macAddress"})})
@Table(name="RbSU", indexes={@Index(name="IDX_RBSU_LICENSEID", columnNames={"licenseID"})})
public class RbSU
extends Equipment
implements Manageable,
ManagedEquipment,
ConfigurableEquipment,
Licensable,
StandardSoftwareVersions {
    private static final long serialVersionUID = 8308405809892096309L;
    private String operationalSoftwareVersion;
    private String shadowSoftwareVersion;
    private Integer operationMode;
    private Long licenseID = Licensable.UNLICENSED;
    private String macAddress;
    private Integer servingAUId;
    private Boolean VGpresent = false;
    private Boolean NGpresent = false;
    private String suIduType;
    private String managerBSName;
    private RbBaseStationEquipment managerBS;
    private Integer auSlotNumber;
    public static final Integer RbSuOperationModeTypeA = 1;
    public static final Integer RbSuOperationModeTypeSi = 2;

    @Transient
    public SNMPManagementInterface getManagementInterface() {
        RbBaseStationEquipment managerBS = this.getManagerBS();
        if (managerBS == null) {
            throw new EquipmentManagerNotFoundException("Equipment Manager Not Found");
        }
        SNMPManagementInterface bsMgmtIf = managerBS.getManagementInterface();
        String suMacAddrOctetStr = MacAddress.fromSimpleString((String)this.macAddress).toDashedString();
        return new SNMPManagementInterface(bsMgmtIf.getIp(), bsMgmtIf.getPort(), bsMgmtIf.getReadCommunity() + "@SU." + suMacAddrOctetStr, bsMgmtIf.getWriteCommunity() + "@SU." + suMacAddrOctetStr, bsMgmtIf.getRetries().intValue(), bsMgmtIf.getTimeout().longValue());
    }

    @Transient
    public String getIPAddress() {
        RbBaseStationEquipment managerBS = this.getManagerBS();
        return null != managerBS ? managerBS.getIPAddress() : null;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public Integer getServingAUId() {
        return this.servingAUId;
    }

    public void setServingAUId(Integer servingAUId) {
        this.servingAUId = servingAUId;
    }

    public Boolean getVGpresent() {
        return this.VGpresent;
    }

    public void setVGpresent(Boolean VGpresent) {
        this.VGpresent = VGpresent == null ? Boolean.valueOf(false) : VGpresent;
    }

    public Boolean getNGpresent() {
        return this.NGpresent;
    }

    public void setNGpresent(Boolean NGpresent) {
        this.NGpresent = NGpresent == null ? Boolean.valueOf(false) : NGpresent;
    }

    public String getSuIduType() {
        return this.suIduType;
    }

    public void setSuIduType(String suIduType) {
        this.suIduType = suIduType;
    }

    public String getManagerBSName() {
        return this.managerBSName;
    }

    public void setManagerBSName(String managerBSName) {
        this.managerBSName = managerBSName;
    }

    public EquipmentManager findEquipmentManager() {
        return this.getManagerBS();
    }

    public String getOperationalSoftwareVersion() {
        return this.operationalSoftwareVersion;
    }

    public void setOperationalSoftwareVersion(String operationalSoftwareVersion) {
        this.operationalSoftwareVersion = operationalSoftwareVersion;
    }

    public String getShadowSoftwareVersion() {
        return this.shadowSoftwareVersion;
    }

    public void setShadowSoftwareVersion(String shadowSoftwareVersion) {
        this.shadowSoftwareVersion = shadowSoftwareVersion;
    }

    @Transient
    public String getRunningSoftwareVersion() {
        return this.getFirmwareVersion();
    }

    public void setRunningSoftwareVersion(String runningSoftwareVersion) {
        this.setFirmwareVersion(runningSoftwareVersion);
    }

    private RbSuCommand initCommand() {
        RbSuCommand rbSuCommand = new RbSuCommand();
        rbSuCommand.setEquipmentId(this.getManagerBS().getId());
        rbSuCommand.setRbSuMacAddr(MacAddress.fromSimpleString((String)this.getMacAddress()).toOctetString());
        return rbSuCommand;
    }

    public RbSuCommand createDefaultsCommand(int commandOperation) {
        RbSuCommand rbSuCommand = this.initCommand();
        rbSuCommand.setRbSuSetDefaults(commandOperation);
        return rbSuCommand;
    }

    public RbSuCommand createCommand(int commandOperation, String fileName) {
        RbSuCommand rbSuCommand = this.initCommand();
        rbSuCommand.setRbSuUnitControl(commandOperation);
        if (fileName != null) {
            rbSuCommand.setRbSuUpgradeSwFileName(fileName);
        }
        return rbSuCommand;
    }

    public RbSuCommand createResetCountersCommand() {
        RbSuCommand rbSuCommand = this.initCommand();
        return rbSuCommand;
    }

    public RbSuCommand createLoadFactoryDfltCommand() {
        return this.createDefaultsCommand(2);
    }

    public RbSuCommand createResetCommand() {
        return this.createCommand(2, null);
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public void setLicenseID(Long licenseID) {
        this.licenseID = licenseID;
    }

    @ManyToOne
    @JoinColumn(name="associatedBs_id")
    public RbBaseStationEquipment getManagerBS() {
        return this.managerBS;
    }

    public void setManagerBS(RbBaseStationEquipment managerBS) {
        this.managerBS = managerBS;
        if (managerBS != null) {
            this.setIpAddr(managerBS.getIpAddr());
        } else {
            this.setIpAddr(null);
        }
    }

    public Integer getAuSlotNumber() {
        return this.auSlotNumber;
    }

    public void setAuSlotNumber(Integer auSlotNumber) {
        this.auSlotNumber = auSlotNumber;
    }

    public Integer getOperationMode() {
        return this.operationMode;
    }

    public void setOperationMode(Integer operationMode) {
        this.operationMode = operationMode;
    }

    @Transient
    public boolean isOperationModeSi() {
        return RbSuOperationModeTypeSi.equals(this.operationMode);
    }

    @Transient
    public boolean isSI() {
        if (this.getModel().equals("CPE_2_SI")) {
            return true;
        }
        if (this.getModel().equals("CPE_2_SI_L")) {
            return true;
        }
        if (this.getModel().equals("CPE_SI")) {
            return true;
        }
        return this.getModel().equals("CPE_SI_L");
    }

    @Transient
    public boolean hasLimittedCapabilities() {
        if (this.getModel().equals("CPE_2_PRO_L")) {
            return true;
        }
        if (this.getModel().equals("CPE_2_SI_L")) {
            return true;
        }
        if (this.getModel().equals("CPE_PRO_L")) {
            return true;
        }
        return this.getModel().equals("CPE_SI_L");
    }

    @Transient
    public Version getSoftwareVersion() {
        String ver = this.getFirmwareVersion();
        if (ver.startsWith("Rel_")) {
            return VersionFactory.getInstance().createVersion(ver.substring(4), "_");
        }
        return VersionFactory.getInstance().createVersion(ver);
    }

    @Transient
    public Version getManagerBSSoftwareVersion() {
        if (this.managerBS == null) {
            return null;
        }
        return this.managerBS.getSoftwareVersion();
    }

    @Transient
    public String getManagedObjectId() {
        return "SU." + MacAddress.fromSimpleString((String)this.getMacAddress()).toDashedString().toUpperCase();
    }

    @Transient
    public int getMOType() {
        return MOType.CPE.value();
    }

    @Transient
    public String getMOInstance() {
        return MacAddress.fromSimpleString((String)this.getMacAddress()).toDashedString().toUpperCase();
    }
}

