/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.model.file.AbstractFile;
import com.bwanms.model.file.FileUtil;
import com.bwanms.services.ServiceException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbPMTMCollectionFile
extends AbstractFile {
    private static final long serialVersionUID = 1489600845409243997L;
    public static final int TYPE_BASIC = 1;
    public static final int TYPE_ADVANCED = 2;
    private FileType customType;
    private ManagedEntityWeakAssociation equipmentAssoc;
    private String equipmentName;
    private String locationName;
    private Long equipmentIp;
    private boolean orphaned;
    private String pmTMFileName;

    public RbPMTMCollectionFile() {
        this.initializeFromEquipment();
    }

    public RbPMTMCollectionFile(Equipment equipment, String pmTMFileName) {
        this.equipmentAssoc = new ManagedEntityWeakAssociation((ManagedEntity)equipment);
        this.pmTMFileName = pmTMFileName;
        this.setFileName(this.pmTMFileName);
        this.initializeFromEquipment();
    }

    private void initializeFromEquipment() {
        this.initializeEquipmentName();
        this.initializeLocationName();
        this.initializeEquipmentIp();
    }

    @Transient
    public FileType getCustomType() {
        return this.customType;
    }

    public void setCustomType(FileType fileType) {
        this.customType = fileType;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public ManagedEntityWeakAssociation getEquipmentAssoc() {
        return this.equipmentAssoc;
    }

    public void setEquipmentAssoc(ManagedEntityWeakAssociation equipmentAssoc) {
        this.equipmentAssoc = equipmentAssoc;
    }

    public String getFileType() {
        return this.customType != null ? this.customType.name() : null;
    }

    protected void setFileType(String fileType) {
        if (fileType != null) {
            this.setCustomType(FileType.valueOf(fileType));
        } else {
            this.setCustomType(null);
        }
    }

    public Integer getType() {
        return this.customType != null ? Integer.valueOf(this.customType.value()) : null;
    }

    public void setType(Integer type) {
        if (type == null) {
            this.customType = null;
        } else {
            switch (type) {
                case 1: {
                    this.customType = FileType.RbPMTMBasic;
                    break;
                }
                case 2: {
                    this.customType = FileType.RbPMTMAdvanced;
                }
            }
        }
    }

    @Transient
    public List<String> getAvailableFileTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (FileType fileType : FileType.values()) {
            types.add(fileType.name());
        }
        return types;
    }

    @Transient
    public byte[] getConfigurationFile() throws ServiceException {
        return FileUtil.getFileBytes((AbstractFile)this);
    }

    @Transient
    public void setConfigurationFile(byte[] configFile) {
        FileUtil.setFileBytes((AbstractFile)this, (byte[])configFile);
    }

    @Transient
    public Date getDate() {
        return new Date(this.getTimestamp());
    }

    public Long getEquipmentIp() {
        return this.equipmentIp;
    }

    public void setEquipmentIp(long equipmentIp) {
        this.equipmentIp = equipmentIp;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String equipmentLocation) {
        this.locationName = equipmentLocation;
    }

    public String getEquipmentName() {
        return this.equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public boolean isOrphaned() {
        return this.orphaned;
    }

    public void setOrphaned(boolean deleted) {
        this.orphaned = deleted;
    }

    private void initializeEquipmentName() {
        Equipment equipment;
        this.equipmentName = "";
        if (null != this.equipmentAssoc && null != (equipment = (Equipment)this.equipmentAssoc.getManagedEntity())) {
            this.equipmentName = equipment.getName();
        }
    }

    private void initializeLocationName() {
        Location result;
        Equipment equipment;
        this.locationName = "";
        if (null != this.equipmentAssoc && null != (equipment = (Equipment)this.equipmentAssoc.getManagedEntity()) && null != (result = equipment.getLocation())) {
            this.locationName = result.getName();
        }
    }

    private void initializeEquipmentIp() {
        Equipment equipment;
        this.equipmentIp = -1L;
        if (null != this.equipmentAssoc && null != (equipment = (Equipment)this.equipmentAssoc.getManagedEntity())) {
            this.equipmentIp = equipment.getIpAddr();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        RbPMTMBasic(1, 1),
        RbPMTMAdvanced(2, 2);

        int value;
        int mibValue;

        private FileType(int value, int mibValue) {
            this.value = value;
            this.mibValue = mibValue;
        }

        public int value() {
            return this.value;
        }

        public int mibValue() {
            return this.mibValue;
        }
    }
}

