/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentManager;
import com.bwanms.model.Manageable;
import com.bwanms.model.ManagedEquipment;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.StandardSoftwareVersions;
import com.bwanms.rb.command.RbNpuCommand;
import com.bwanms.rb.command.RbSwDeleteFiles;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.constants.RbMOType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
public class RbNPU
extends Equipment
implements Manageable,
ManagedEquipment,
StandardSoftwareVersions {
    private static final long serialVersionUID = 2320802675772505073L;
    private int faultStatus;
    private int redundancyStatus;
    private String operationalSoftwareVersion;
    private String shadowSoftwareVersion;
    private int slotNumber;
    private RbBS managerBS;

    public void setManagerBS(RbBS managerBS, int slotNumber) {
        this.setManagerBS(managerBS);
        this.setSlotNumber(slotNumber);
    }

    public EquipmentManager findEquipmentManager() {
        return this.getManagerBS();
    }

    @Transient
    public SNMPManagementInterface getManagementInterface() {
        RbBS managerBS = this.getManagerBS();
        int slotNumber = this.getSlotNumber();
        if (managerBS == null) {
            throw new RuntimeException("Equipment Manager not found");
        }
        SNMPManagementInterface bsMgmtIf = managerBS.getManagementInterface();
        return new SNMPManagementInterface(bsMgmtIf.getIp(), bsMgmtIf.getPort(), bsMgmtIf.getReadCommunity() + "@NPU." + slotNumber, bsMgmtIf.getWriteCommunity() + "@NPU." + slotNumber, bsMgmtIf.getRetries().intValue(), bsMgmtIf.getTimeout().longValue());
    }

    public int getFaultStatus() {
        return this.faultStatus;
    }

    public void setFaultStatus(int faultStatus) {
        this.faultStatus = faultStatus;
    }

    public int getRedundancyStatus() {
        return this.redundancyStatus;
    }

    public void setRedundancyStatus(int redundancyStatus) {
        this.redundancyStatus = redundancyStatus;
    }

    public RbNpuCommand createResetCommand() {
        return this.createCommand(2);
    }

    public RbNpuCommand createResetAndRunFromShadowCommand() {
        return this.createCommand(4);
    }

    public RbNpuCommand createMakeRunningVersionOperationalCommand() {
        return this.createCommand(5);
    }

    public RbNpuCommand createFactoryDefaultsCommand() {
        return this.createDefaultsCommand(2);
    }

    public RbSwDeleteFiles createDeleteSwFilesCommand(String swFile) {
        RbSwDeleteFiles rbCommands = new RbSwDeleteFiles();
        rbCommands.setEquipmentId(this.getId());
        rbCommands.setRbSwDeleteFiles(swFile);
        return rbCommands;
    }

    private RbNpuCommand createDefaultsCommand(int commandOperation) {
        RbNpuCommand rbCommands = this.initCommand();
        rbCommands.setRbNpuSetDefaults(commandOperation);
        return rbCommands;
    }

    private RbNpuCommand createCommand(int commandOperation) {
        RbNpuCommand rbCommands = this.initCommand();
        rbCommands.setRbNpuUnitControl(commandOperation);
        return rbCommands;
    }

    private RbNpuCommand initCommand() {
        RbNpuCommand rbCommands = new RbNpuCommand();
        rbCommands.setEquipmentId(this.getId());
        rbCommands.setRbSlotNumber(this.getSlotNumber());
        return rbCommands;
    }

    public RbNpuCommand createResetCountersCommand() {
        RbNpuCommand rbNPUCommand = this.initCommand();
        return rbNPUCommand;
    }

    public String getOperationalSoftwareVersion() {
        return this.operationalSoftwareVersion;
    }

    public void setOperationalSoftwareVersion(String operationalSoftwareVersion) {
        this.operationalSoftwareVersion = operationalSoftwareVersion;
    }

    @Transient
    public String getRunningSoftwareVersion() {
        return this.getFirmwareVersion();
    }

    public void setRunningSoftwareVersion(String runningSoftwareVersion) {
        this.setFirmwareVersion(runningSoftwareVersion);
    }

    public String getShadowSoftwareVersion() {
        return this.shadowSoftwareVersion;
    }

    public void setShadowSoftwareVersion(String shadowSoftwareVersion) {
        this.shadowSoftwareVersion = shadowSoftwareVersion;
    }

    @ManyToOne
    @JoinColumn(name="managerBS_id")
    public RbBS getManagerBS() {
        return this.managerBS;
    }

    public void setManagerBS(RbBS managerBS) {
        this.managerBS = managerBS;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    @Transient
    public String getManagedObjectId() {
        return "NPU.Slot#" + this.slotNumber;
    }

    @Transient
    public int getMOType() {
        return RbMOType.NPU.value();
    }

    @Transient
    public String getMOInstance() {
        return String.valueOf(this.slotNumber);
    }
}

