/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.mediation.NetworkResourceHandler;
import com.bwanms.mediation.snmp.SNMPNetworkResourceHandler;
import com.bwanms.mo.EquipmentConfigurationConsistencyStrategy;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.ManagementInterface;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.rb.model.RbBaseStationEquipmentConfiguration;
import com.bwanms.rb.model.RbMBSEquipmentConfigurationConsistencyStrategy;
import com.bwanms.rb.model.RbMBSNRConfiguration;
import javax.persistence.Entity;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbMBSEquipmentConfiguration
extends RbBaseStationEquipmentConfiguration {
    private static final long serialVersionUID = -1910693738705428767L;

    public void createBSNrConfiguration() {
        NetworkResourceConfiguration config = this.findNetworkResourceConfiguration("BS");
        if (config != null) {
            throw new RuntimeException("BS NR already exists");
        }
        RbMBSNRConfiguration ret = new RbMBSNRConfiguration();
        ret.setName("BS");
        ret.setConfiguration(this);
        this.addNetworkResourceConfiguration(ret);
    }

    @Transient
    public EquipmentConfigurationConsistencyStrategy getChangeStrategy() {
        return new RbMBSEquipmentConfigurationConsistencyStrategy(this);
    }

    public NetworkResourceHandler getNetworkResourceHandler(Class<? extends ManagementInterface> managementInterfaceClass) {
        if (SNMPManagementInterface.class.isAssignableFrom(managementInterfaceClass)) {
            return new RbMBSNetworkResourceHandler();
        }
        throw new RuntimeException("This configuration does not support " + managementInterfaceClass.getName());
    }

    private class RbMBSNetworkResourceHandler
    implements SNMPNetworkResourceHandler {
        private RbMBSNetworkResourceHandler() {
        }

        public SNMPManagementInterface getAgentInfo(SNMPManagementInterface equipmentAgentInfo, String networkResource) {
            if ("BS".equals(networkResource)) {
                return equipmentAgentInfo;
            }
            return new SNMPManagementInterface(equipmentAgentInfo.getIp(), equipmentAgentInfo.getPort(), equipmentAgentInfo.getReadCommunity() + "@" + networkResource, equipmentAgentInfo.getWriteCommunity() + "@" + networkResource, equipmentAgentInfo.getRetries().intValue(), equipmentAgentInfo.getTimeout().longValue());
        }
    }
}

