/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.rb.command.RbMbsCommand;
import com.bwanms.rb.command.RbSwDeleteFiles;
import com.bwanms.rb.model.RbBaseStationEquipment;
import javax.persistence.Entity;
import javax.persistence.Transient;

@Entity
@AlwaysValidate
@org.hibernate.annotations.Entity(dynamicUpdate=true)
public class RbMBS
extends RbBaseStationEquipment {
    private Integer rbMBSTIduType;

    public Integer getRbMBSTIduType() {
        return this.rbMBSTIduType;
    }

    public void setRbMBSTIduType(Integer rbMBSTIduType) {
        this.rbMBSTIduType = rbMBSTIduType;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(RbMBS.class.getName()).append('[');
        result.append(super.toString()).append(", ");
        result.append("IPAddress=").append(this.getIPAddress()).append(", ");
        result.append("]");
        return result.toString();
    }

    private RbMbsCommand initCommand() {
        RbMbsCommand rbMbsCommand = new RbMbsCommand();
        rbMbsCommand.setEquipmentId(this.getId());
        return rbMbsCommand;
    }

    private RbMbsCommand createDefaultsCommand(int commandOperation) {
        RbMbsCommand rbMbsCommand = this.initCommand();
        rbMbsCommand.setRbMBSTSetDefaults(commandOperation);
        return rbMbsCommand;
    }

    private RbMbsCommand createControlCommand(int commandOperation) {
        RbMbsCommand rbMbsCommand = this.initCommand();
        rbMbsCommand.setRbMBSTUnitControl(commandOperation);
        return rbMbsCommand;
    }

    public RbMbsCommand createFactoryDefaultsCommand() {
        return this.createDefaultsCommand(2);
    }

    public RbMbsCommand createResetCommand() {
        return this.createControlCommand(2);
    }

    public RbMbsCommand createResetAndRunFromShadowCommand() {
        return this.createControlCommand(4);
    }

    public RbMbsCommand createMakeRunningVersionOperationalCommand() {
        return this.createControlCommand(5);
    }

    public RbSwDeleteFiles createDeleteSwFilesCommand(String swFile) {
        RbSwDeleteFiles rbCommands = new RbSwDeleteFiles();
        rbCommands.setEquipmentId(this.getId());
        rbCommands.setRbSwDeleteFiles(swFile);
        return rbCommands;
    }

    public RbMbsCommand createResetCountersCommand() {
        RbMbsCommand rbMbsCommand = this.initCommand();
        return rbMbsCommand;
    }

    @Transient
    public String getManagedObjectId() {
        return "MBS." + this.getEUID();
    }
}

