/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.Identifiable;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.MultipleStringList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"gpsChainNumber"})})
public class RbGPSChain
implements Identifiable,
Serializable {
    public static final String PROP_CHAIN_NUMBER = "gpsChainNumber";
    public static final String PROP_STOP_TX_AFTER_HOLD_OVER_TIMEOUT = "stopTxAfterHoldOverTimeout";
    public static final String PROP_HOLD_OVER_PASSED_TIMEOUT = "holdOverPassedTimeout";
    public static final String PROP_GPS_TYPE = "gpsType";
    public static final String PROP_TIME_ZONE_OFFSET_FROM_UTC = "timeZoneOffsetFromUTC";
    public static final String PROP_DAYLIGHT_SAVING_STATUS = "daylightSavingStatus";
    public static final String PROP_DAYLIGHT_SAVING_DATE_START = "daylightSavingDateStart";
    public static final String PROP_DAYLIGHT_SAVING_DATE_STOP = "daylightSavingDateStop";
    public static final String PROP_DAYLIGHT_SAVING_ADV_FACTOR = "daylightSavingAdvFactor";
    private Long id = 0L;
    private Long gpsChainNumber;
    private Integer gpsType;
    private String timeZoneOffsetFromUTC;
    private Integer stopTxAfterHoldOverTimeout;
    private Long holdOverPassedTimeout;
    private Integer daylightSavingStatus;
    private String daylightSavingDateStart;
    private String daylightSavingDateStop;
    private String daylightSavingAdvFactor;
    private List<RbBaseStationEquipment> equipmentList = new ArrayList<RbBaseStationEquipment>();

    @Id
    public long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public Long getGpsChainNumber() {
        return this.gpsChainNumber;
    }

    public void setGpsChainNumber(Long gpsChainNumber) {
        this.gpsChainNumber = gpsChainNumber;
        this.id = gpsChainNumber;
    }

    @OneToMany(mappedBy="gpsChainNumber")
    public List<RbBaseStationEquipment> getEquipmentList() {
        return this.equipmentList;
    }

    public void setEquipmentList(List<RbBaseStationEquipment> equipmentList) {
        this.equipmentList = equipmentList;
    }

    public String getDaylightSavingAdvFactor() {
        return this.daylightSavingAdvFactor;
    }

    public void setDaylightSavingAdvFactor(String daylightSavingAdvFactor) {
        this.daylightSavingAdvFactor = daylightSavingAdvFactor;
    }

    public String getDaylightSavingDateStart() {
        return this.daylightSavingDateStart;
    }

    public void setDaylightSavingDateStart(String daylightSavingDateStart) {
        this.daylightSavingDateStart = daylightSavingDateStart;
    }

    public String getDaylightSavingDateStop() {
        return this.daylightSavingDateStop;
    }

    public void setDaylightSavingDateStop(String daylightSavingDateStop) {
        this.daylightSavingDateStop = daylightSavingDateStop;
    }

    public Integer getDaylightSavingStatus() {
        return this.daylightSavingStatus;
    }

    public void setDaylightSavingStatus(Integer daylightSavingStatus) {
        this.daylightSavingStatus = daylightSavingStatus;
    }

    public Integer getGpsType() {
        return this.gpsType;
    }

    public void setGpsType(Integer gpsType) {
        this.gpsType = gpsType;
    }

    public Long getHoldOverPassedTimeout() {
        return this.holdOverPassedTimeout;
    }

    public void setHoldOverPassedTimeout(Long holdOverPassedTimeout) {
        this.holdOverPassedTimeout = holdOverPassedTimeout;
    }

    public Integer getStopTxAfterHoldOverTimeout() {
        return this.stopTxAfterHoldOverTimeout;
    }

    public void setStopTxAfterHoldOverTimeout(Integer stopTxAfterHoldOverTimeout) {
        this.stopTxAfterHoldOverTimeout = stopTxAfterHoldOverTimeout;
    }

    public String getTimeZoneOffsetFromUTC() {
        return this.timeZoneOffsetFromUTC;
    }

    public void setTimeZoneOffsetFromUTC(String timeZoneOffsetFromUTC) {
        this.timeZoneOffsetFromUTC = timeZoneOffsetFromUTC;
    }

    public String toString() {
        return "GPS Chain " + this.gpsChainNumber;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.gpsChainNumber == null ? 0 : this.gpsChainNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RbGPSChain other = (RbGPSChain)obj;
        return !(this.gpsChainNumber == null ? other.gpsChainNumber != null : !this.gpsChainNumber.equals(other.gpsChainNumber));
    }

    @Transient
    public int getAlarmState() {
        List<RbBaseStationEquipment> bsEqList = this.getEquipmentList();
        if (bsEqList.isEmpty()) {
            return Severity.Other.value();
        }
        int alarmState = Severity.Cleared.value();
        for (RbBaseStationEquipment bsEq : this.getEquipmentList()) {
            if (bsEq.getState() == -1 || bsEq.getState() == 1) {
                alarmState = Severity.Critical.value();
                break;
            }
            if (bsEq.getAlarmState() <= alarmState) continue;
            alarmState = bsEq.getAlarmState();
        }
        return alarmState;
    }

    @Transient
    public String getComplexKey() {
        MultipleStringList stringList = new MultipleStringList();
        stringList.addToList(this.gpsChainNumber);
        stringList.addToList(this.gpsType);
        stringList.addToList(this.timeZoneOffsetFromUTC);
        stringList.addToList(this.stopTxAfterHoldOverTimeout);
        stringList.addToList(this.holdOverPassedTimeout);
        stringList.addToList(this.daylightSavingStatus);
        if (new Integer(1).equals(this.daylightSavingStatus)) {
            stringList.addToList(this.daylightSavingDateStart);
            stringList.addToList(this.daylightSavingDateStop);
            stringList.addToList(this.daylightSavingAdvFactor);
        } else {
            stringList.addNullToList();
            stringList.addNullToList();
            stringList.addNullToList();
        }
        return stringList.getAsString();
    }
}

