/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.ConfigFileImporter;
import com.bwanms.model.file.AbstractFile;
import com.bwanms.model.file.BackupConfigFile;
import com.bwanms.model.file.FileUtil;
import com.bwanms.rb.configfile.ConfigFile;
import com.bwanms.rb.model.RbBackupConfigFile;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class RbConfigFileImporter
implements ConfigFileImporter {
    private static final Logger log = Logger.getLogger(RbConfigFileImporter.class);
    private static final List<String> resNames = new ArrayList<String>();
    private byte[] content;
    private List<String> foundRes = new ArrayList<String>();

    public boolean accept(byte[] content) {
        try {
            this.content = null;
            this.foundRes.clear();
            ConfigFile file = ConfigFile.parse(new ByteArrayInputStream(content));
            Collection<ConfigFile.Resource> resources = file.getResources();
            for (ConfigFile.Resource resource : resources) {
                log.info((Object)(" - found resource " + resource.getName()));
                if (!resNames.contains(resource.getName())) continue;
                this.foundRes.add(resource.getName());
            }
            if (this.foundRes.size() > 0) {
                this.content = content;
                return true;
            }
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
        }
        return false;
    }

    public BackupConfigFile getBackup() {
        if (this.content != null) {
            RbBackupConfigFile backup = new RbBackupConfigFile();
            backup.setTimestamp(Calendar.getInstance().getTimeInMillis());
            backup.setCustomType(this.getFileType());
            FileUtil.setFileBytes((AbstractFile)backup, (byte[])this.content);
            return backup;
        }
        return null;
    }

    private RbBackupConfigFile.FileType getFileType() {
        if (this.foundRes.contains(resNames.get(0))) {
            return RbBackupConfigFile.FileType.RbFullConfig;
        }
        if (this.foundRes.contains(resNames.get(2))) {
            return RbBackupConfigFile.FileType.RbServices;
        }
        if (this.foundRes.contains(resNames.get(1))) {
            return RbBackupConfigFile.FileType.RbServiceProfiles;
        }
        if (this.foundRes.contains(resNames.get(3))) {
            return RbBackupConfigFile.FileType.RbTraps;
        }
        if (this.foundRes.contains(resNames.get(4))) {
            return RbBackupConfigFile.FileType.RbFilters;
        }
        if (this.foundRes.contains(resNames.get(5))) {
            return RbBackupConfigFile.FileType.RbLicensing;
        }
        return null;
    }

    static {
        resNames.add("AU_CHANNEL.db");
        resNames.add("SERVICE_PROFILE.db");
        resNames.add("SERVICE_PIPE.db");
        resNames.add("TRAP_SEV.db");
        resNames.add("FLTR_FILTERS.db");
        resNames.add("LicenseInventory.res");
    }
}

