/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.entity.persisters.EquipmentPersister;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.model.RbBackupConfigFile;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.ServiceException;
import java.util.List;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBaseStationPersister<C extends RbBaseStationEquipment>
extends EquipmentPersister<C> {
    public void persistBeforeDelete(C entity) throws ServiceException {
        super.persistBeforeDelete(entity);
        String sqlQuery = "from " + RbBackupConfigFile.class.getName() + " c where c.equipmentAssoc.managedEntity = :equipment order by timestamp asc";
        Query query = Datastore.session().createQuery(sqlQuery);
        query.setEntity("equipment", entity);
        List temp = query.list();
        for (RbBackupConfigFile file : temp) {
            file.setStatus(3);
            Datastore.session().saveOrUpdate((Object)file);
        }
    }

    protected RbBaseStationEquipment findBaseStationByIPAddress(Class<C> bsClass, String ipAddress) {
        Query query = Datastore.session().createQuery(" from " + bsClass.getName() + " where IPAddress = :ipAddress ").setString("ipAddress", ipAddress);
        return (RbBaseStationEquipment)((Object)query.uniqueResult());
    }
}

