/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.LegacyManagedObjects;
import com.bwanms.meta.mo.ManagedObjects;
import com.bwanms.meta.mo.Shortcut;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.Equipment;
import com.bwanms.rb.mo.RbAuthorizedManagersEntry;
import com.bwanms.rb.mo.RbAuthorizedManagersTable;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbBSPFServersTable;
import com.bwanms.rb.mo.RbBSPmTmConfigParameters;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.RbBsRFModeParameters;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.mo.RbFilterEntry;
import com.bwanms.rb.mo.RbFilterTable;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbGPSInfo;
import com.bwanms.rb.mo.RbInterfaceFilteringEntry;
import com.bwanms.rb.mo.RbInterfaceFilteringTable;
import com.bwanms.rb.mo.RbL2FilteringRuleEntry;
import com.bwanms.rb.mo.RbL2FilteringRuleTable;
import com.bwanms.rb.mo.RbL3L4FilteringRuleEntry;
import com.bwanms.rb.mo.RbL3L4FilteringRuleTable;
import com.bwanms.rb.mo.RbMACAddressDenyListEntry;
import com.bwanms.rb.mo.RbMACAddressDenyListTable;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbPFGeneralParameters;
import com.bwanms.rb.mo.RbQinQConfig;
import com.bwanms.rb.mo.RbQinQEntry;
import com.bwanms.rb.mo.RbQinQTable;
import com.bwanms.rb.mo.RbRadioClusterEntry;
import com.bwanms.rb.mo.RbRadioClusterTable;
import com.bwanms.rb.mo.RbRadiusAccountServerEntry;
import com.bwanms.rb.mo.RbRadiusAccountServerTable;
import com.bwanms.rb.mo.RbRadiusAuthServerEntry;
import com.bwanms.rb.mo.RbRadiusAuthServerTable;
import com.bwanms.rb.mo.RbRadiusClientGeneralParameters;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.RbSwAuConfigEntry;
import com.bwanms.rb.mo.RbSwAuConfigTable;
import com.bwanms.rb.mo.RbSwRegisteredSuEntry;
import com.bwanms.rb.mo.RbSwRegisteredSuTable;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.mo.RbSystemGroup;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.mo.RbTrapConfigTable;
import com.bwanms.rb.mo.SipAwareFilter;
import com.bwanms.rb.mo.SwitchingModeOrVersionFilter;
import com.bwanms.rb.mo.VersionAndModelFilter;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateEntry;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateTable;
import com.bwanms.rb.mo.services.RbFDDDefaultServiceGroupScalar;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigTable;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigTable;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigTable;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigTable;
import com.bwanms.rb.mo.services.RbServiceGeneralConfig;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceGroupTable;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbSubscriberTable;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbBaseStationNRConfiguration
extends NetworkResourceConfiguration {
    private List<RbServiceGeneralConfig> serviceGeneralConfig;
    private List<RbSystemGroup> systemGroup;
    private List<RbBsRadioParameters> rbBsRadioParameters;
    private List<RbAuthorizedManagersEntry> rbAuthorizedManagersEntries;
    private List<RbQinQEntry> rbQinQEntries;
    private List<RbQinQConfig> rbQinQConfigs;
    private List<RbRegisteredSuEntry> rbRegisteredSuEntries;
    private List<RbDfltServiceTemplateEntry> rbDfltServiceTemplateEntries;
    private List<RbServiceTemplateConfigEntry> rbServiceTemplateConfigEntries;
    private List<RbServiceConfigEntry> rbServiceConfigEntries;
    private List<RbQoSProfileConfigEntry> rbQoSProfileConfigEntries;
    private List<RbPolicyRuleConfigEntry> rbPolicyRuleConfigEntries;
    private List<RbForwardingRuleConfigEntry> rbForwardingRuleConfigEntries;
    private List<RbSubscriberEntry> rbSubscriberEntries;
    private List<RbMACAddressDenyListEntry> rbMACAddressDenyListEntries;
    private List<RbFrequencyBandsEntry> rbFrequencyBandsEntries;
    private List<RbRadioClusterEntry> rbRadioClusterEntries;
    private List<RbOduConfigEntry> rbOduConfigEntries;
    private List<RbL2FilteringRuleEntry> rbL2FilteringRuleEntries;
    private List<RbL3L4FilteringRuleEntry> rbL3L4FilteringRuleEntries;
    private List<RbFilterEntry> rbFilterEntries;
    private List<RbInterfaceFilteringEntry> rbInterfaceFilteringEntries;
    private List<RbTrapConfigEntry> rbTrapConfigEntries;
    private List<RbSwUpgrade> rbSwUpgrade;
    private List<RbBSSwitchingModeParameters> rbBSSwitchingModeParameters;
    private List<RbRadiusClientGeneralParameters> rbRadiusClientGeneralParameters;
    private List<RbRadiusAccountServerEntry> rbRadiusAccountServerEntries;
    private List<RbRadiusAuthServerEntry> rbRadiusAuthServerEntries;
    private List<RbGPSInfo> rbGPSInfo;
    private List<RbBSClockConfigParameters> rbBSClockConfigParameters;
    private List<RbChainConfig> rbChainConfig;
    private List<RbServiceGroupEntry> rbServiceGroupEntries;
    private List<RbVoiceDomainsEntry> rbVoiceDomainsEntries;
    private List<RbBSPFServersEntry> rbBSPFServersEntries;
    private List<RbPFGeneralParameters> rbPFGeneralParameters;
    private List<RbSwAuConfigEntry> rbSwAuConfigEntries;
    private List<RbSwRegisteredSuEntry> rbSwRegisteredSuEntries;
    private List<RbBsRFModeParameters> rbBsRFModeParameters;
    private List<RbBSPmTmConfigParameters> rbBSPmTmConfigParameters;
    private List<RbFDDDefaultServiceGroupScalar> rbFDDDefaultServiceGroupScalar;

    @Transient
    public Equipment getManagedEquipment() {
        return this.getConfigurationEquipment();
    }

    @Transient
    public List<Class<? extends ManagedObject>> getManagedObjectClasses() {
        List superRet = super.getManagedObjectClasses();
        ArrayList<Class<? extends ManagedObject>> ret = new ArrayList<Class<? extends ManagedObject>>();
        if (((RbBaseStationEquipment)this.getConfigurationEquipment()).getFirmwareVersion() != null) {
            for (Class moClass : superRet) {
                if (RbServiceTemplateConfigEntry.class.equals((Object)moClass) || RbForwardingRuleConfigEntry.class.equals((Object)moClass) || RbPolicyRuleConfigEntry.class.equals((Object)moClass) || RbQoSProfileConfigEntry.class.equals((Object)moClass) || RbVoiceDomainsEntry.class.equals((Object)moClass) || RbBSPFServersEntry.class.equals((Object)moClass) || RbServiceGroupEntry.class.equals((Object)moClass)) continue;
                ret.add(moClass);
            }
            RbBaseStationEquipment configurationEquipment = (RbBaseStationEquipment)this.getConfigurationEquipment();
            if (RbVersions.V_4_2.isSupersetOf(configurationEquipment.getSoftwareVersion()) || RbVersions.V_4_5.isSupersetOf(configurationEquipment.getSoftwareVersion()) && configurationEquipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS || RbVersions.V_4_5.isSupersetOf(configurationEquipment.getSoftwareVersion()) && configurationEquipment instanceof RbMBS) {
                ret.add(RbBSPFServersEntry.class);
                ret.add(RbVoiceDomainsEntry.class);
            }
            if (RbVersions.V_4_5.isOlderOrEqualWith(configurationEquipment.getSoftwareVersion()) && configurationEquipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
                ret.add(RbServiceGroupEntry.class);
            }
            ret.add(RbQoSProfileConfigEntry.class);
            ret.add(RbPolicyRuleConfigEntry.class);
            ret.add(RbForwardingRuleConfigEntry.class);
            ret.add(RbServiceTemplateConfigEntry.class);
        }
        return ret;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbServiceGeneralConfig.class)
    public List<RbServiceGeneralConfig> getServiceGeneralConfig() {
        if (this.serviceGeneralConfig == null) {
            this.serviceGeneralConfig = new ArrayList<RbServiceGeneralConfig>();
        }
        return this.serviceGeneralConfig;
    }

    public void setServiceGeneralConfig(List<RbServiceGeneralConfig> serviceGeneralConfig) {
        this.serviceGeneralConfig = serviceGeneralConfig;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbSystemGroup.class)
    public List<RbSystemGroup> getSystemGroup() {
        if (this.systemGroup == null) {
            this.systemGroup = new ArrayList<RbSystemGroup>();
        }
        return this.systemGroup;
    }

    public void setSystemGroup(List<RbSystemGroup> systemGroup) {
        this.systemGroup = systemGroup;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbBsRadioParameters.class)
    public List<RbBsRadioParameters> getRbBsRadioParameters() {
        if (this.rbBsRadioParameters == null) {
            this.rbBsRadioParameters = new ArrayList<RbBsRadioParameters>();
        }
        return this.rbBsRadioParameters;
    }

    public void setRbBsRadioParameters(List<RbBsRadioParameters> rbBsRadioParameters) {
        this.rbBsRadioParameters = rbBsRadioParameters;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbAuthorizedManagersEntry.class)
    public List<RbAuthorizedManagersEntry> getRbAuthorizedManagersEntries() {
        if (this.rbAuthorizedManagersEntries == null) {
            this.rbAuthorizedManagersEntries = new ArrayList<RbAuthorizedManagersEntry>();
        }
        return this.rbAuthorizedManagersEntries;
    }

    public void setRbAuthorizedManagersEntries(List<RbAuthorizedManagersEntry> rbAuthorizedManagersEntries) {
        this.rbAuthorizedManagersEntries = rbAuthorizedManagersEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbAuthorizedManagersTable.class)
    public RbAuthorizedManagersTable getRbAuthorizedManagersTable() {
        RbAuthorizedManagersTable rbAuthorizedManagersTable = new RbAuthorizedManagersTable(this.getRbAuthorizedManagersEntries());
        rbAuthorizedManagersTable.setNRConfiguration(this);
        return rbAuthorizedManagersTable;
    }

    @Deprecated
    public void setRbAuthorizedManagersTable(RbAuthorizedManagersTable table) {
        table.synchronizeCollection(this.getRbAuthorizedManagersEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbQinQEntry.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", "[3.0-4.0.0]"})
    public List<RbQinQEntry> getRbQinQEntries() {
        if (this.rbQinQEntries == null) {
            this.rbQinQEntries = new ArrayList<RbQinQEntry>();
        }
        return this.rbQinQEntries;
    }

    public void setRbQinQEntries(List<RbQinQEntry> rbQinQEntries) {
        this.rbQinQEntries = rbQinQEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbQinQTable.class)
    public RbQinQTable getRbQinQTable() {
        RbQinQTable rbQinQTable = new RbQinQTable(this.getRbQinQEntries());
        rbQinQTable.setNRConfiguration(this);
        return rbQinQTable;
    }

    @Deprecated
    public void setQinQTable(RbQinQTable table) {
        table.synchronizeCollection(this.getRbQinQEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbQinQConfig.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", "[3.0-4.0.0]"})
    public List<RbQinQConfig> getRbQinQConfigs() {
        if (this.rbQinQConfigs == null) {
            this.rbQinQConfigs = new ArrayList<RbQinQConfig>();
        }
        return this.rbQinQConfigs;
    }

    public void setRbQinQConfigs(List<RbQinQConfig> rbQinQConfigs) {
        this.rbQinQConfigs = rbQinQConfigs;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbRegisteredSuEntry.class)
    public List<RbRegisteredSuEntry> getRbRegisteredSuEntries() {
        if (this.rbRegisteredSuEntries == null) {
            this.rbRegisteredSuEntries = new ArrayList<RbRegisteredSuEntry>();
        }
        return this.rbRegisteredSuEntries;
    }

    public void setRbRegisteredSuEntries(List<RbRegisteredSuEntry> rbRegisteredSuEntries) {
        this.rbRegisteredSuEntries = rbRegisteredSuEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbRegisteredSuTable.class)
    public RbRegisteredSuTable getRbRegisteredSuTable() {
        RbRegisteredSuTable rbRegisteredSuTable = new RbRegisteredSuTable(this.getRbRegisteredSuEntries());
        rbRegisteredSuTable.setNRConfiguration(this);
        return rbRegisteredSuTable;
    }

    @Deprecated
    public void setRbRegisteredSuTable(RbRegisteredSuTable table) {
        table.synchronizeCollection(this.getRbRegisteredSuEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbDfltServiceTemplateEntry.class)
    public List<RbDfltServiceTemplateEntry> getRbDfltServiceTemplateEntries() {
        if (this.rbDfltServiceTemplateEntries == null) {
            this.rbDfltServiceTemplateEntries = new ArrayList<RbDfltServiceTemplateEntry>();
        }
        return this.rbDfltServiceTemplateEntries;
    }

    public void setRbDfltServiceTemplateEntries(List<RbDfltServiceTemplateEntry> rbDfltServiceTemplateEntries) {
        this.rbDfltServiceTemplateEntries = rbDfltServiceTemplateEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbDfltServiceTemplateTable.class)
    public RbDfltServiceTemplateTable getRbDfltServiceTemplateTable() {
        RbDfltServiceTemplateTable rbDfltServiceTemplateTable = new RbDfltServiceTemplateTable(this.getRbDfltServiceTemplateEntries());
        rbDfltServiceTemplateTable.setNRConfiguration(this);
        return rbDfltServiceTemplateTable;
    }

    @Deprecated
    public void setRbDfltServiceTemplateTable(RbDfltServiceTemplateTable table) {
        table.synchronizeCollection(this.getRbDfltServiceTemplateEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbServiceTemplateConfigEntry.class)
    public List<RbServiceTemplateConfigEntry> getRbServiceTemplateConfigEntries() {
        if (this.rbServiceTemplateConfigEntries == null) {
            this.rbServiceTemplateConfigEntries = new ArrayList<RbServiceTemplateConfigEntry>();
        }
        return this.rbServiceTemplateConfigEntries;
    }

    public void setRbServiceTemplateConfigEntries(List<RbServiceTemplateConfigEntry> rbServiceTemplateConfigEntries) {
        this.rbServiceTemplateConfigEntries = rbServiceTemplateConfigEntries;
    }

    @Deprecated
    @Transient
    @Shortcut
    @LegacyManagedObjects(moClass=RbServiceTemplateConfigTable.class)
    public RbServiceTemplateConfigTable getRbServiceTemplateConfigTable() {
        RbServiceTemplateConfigTable rbServiceTemplateConfigTable = new RbServiceTemplateConfigTable(this.getRbServiceTemplateConfigEntries());
        rbServiceTemplateConfigTable.setNRConfiguration(this);
        return rbServiceTemplateConfigTable;
    }

    @Deprecated
    public void setRbServiceTemplateConfigTable(RbServiceTemplateConfigTable table) {
        table.synchronizeCollection(this.getRbServiceTemplateConfigEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbServiceConfigEntry.class)
    public List<RbServiceConfigEntry> getRbServiceConfigEntries() {
        if (this.rbServiceConfigEntries == null) {
            this.rbServiceConfigEntries = new ArrayList<RbServiceConfigEntry>();
        }
        return this.rbServiceConfigEntries;
    }

    public void setRbServiceConfigEntries(List<RbServiceConfigEntry> rbServiceConfigEntries) {
        this.rbServiceConfigEntries = rbServiceConfigEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbServiceConfigTable.class)
    public RbServiceConfigTable getRbServiceConfigTable() {
        RbServiceConfigTable rbServiceConfigTable = new RbServiceConfigTable(this.getRbServiceConfigEntries());
        rbServiceConfigTable.setNRConfiguration(this);
        return rbServiceConfigTable;
    }

    @Deprecated
    public void setRbServiceConfigTable(RbServiceConfigTable table) {
        table.synchronizeCollection(this.getRbServiceConfigEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbQoSProfileConfigEntry.class)
    public List<RbQoSProfileConfigEntry> getRbQoSProfileConfigEntries() {
        if (this.rbQoSProfileConfigEntries == null) {
            this.rbQoSProfileConfigEntries = new ArrayList<RbQoSProfileConfigEntry>();
        }
        return this.rbQoSProfileConfigEntries;
    }

    public void setRbQoSProfileConfigEntries(List<RbQoSProfileConfigEntry> rbQoSProfileConfigEntries) {
        this.rbQoSProfileConfigEntries = rbQoSProfileConfigEntries;
    }

    @Deprecated
    @Transient
    @Shortcut
    @LegacyManagedObjects(moClass=RbQoSProfileConfigTable.class)
    public RbQoSProfileConfigTable getRbQoSProfileConfigTable() {
        RbQoSProfileConfigTable rbQoSProfileConfigTable = new RbQoSProfileConfigTable(this.getRbQoSProfileConfigEntries());
        rbQoSProfileConfigTable.setNRConfiguration(this);
        return rbQoSProfileConfigTable;
    }

    @Deprecated
    public void setRbQoSProfileConfigTable(RbQoSProfileConfigTable table) {
        table.synchronizeCollection(this.getRbQoSProfileConfigEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbPolicyRuleConfigEntry.class)
    public List<RbPolicyRuleConfigEntry> getRbPolicyRuleConfigEntries() {
        if (this.rbPolicyRuleConfigEntries == null) {
            this.rbPolicyRuleConfigEntries = new ArrayList<RbPolicyRuleConfigEntry>();
        }
        return this.rbPolicyRuleConfigEntries;
    }

    public void setRbPolicyRuleConfigEntries(List<RbPolicyRuleConfigEntry> rbPolicyRuleConfigEntries) {
        this.rbPolicyRuleConfigEntries = rbPolicyRuleConfigEntries;
    }

    @Deprecated
    @Transient
    @Shortcut
    @LegacyManagedObjects(moClass=RbPolicyRuleConfigTable.class)
    public RbPolicyRuleConfigTable getRbPolicyRuleConfigTable() {
        RbPolicyRuleConfigTable rbPolicyRuleConfigTable = new RbPolicyRuleConfigTable(this.getRbPolicyRuleConfigEntries());
        rbPolicyRuleConfigTable.setNRConfiguration(this);
        return rbPolicyRuleConfigTable;
    }

    @Deprecated
    public void setRbPolicyRuleConfigTable(RbPolicyRuleConfigTable table) {
        table.synchronizeCollection(this.getRbPolicyRuleConfigEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbForwardingRuleConfigEntry.class)
    public List<RbForwardingRuleConfigEntry> getRbForwardingRuleConfigEntries() {
        if (this.rbForwardingRuleConfigEntries == null) {
            this.rbForwardingRuleConfigEntries = new ArrayList<RbForwardingRuleConfigEntry>();
        }
        return this.rbForwardingRuleConfigEntries;
    }

    public void setRbForwardingRuleConfigEntries(List<RbForwardingRuleConfigEntry> rbForwardingRuleConfigEntries) {
        this.rbForwardingRuleConfigEntries = rbForwardingRuleConfigEntries;
    }

    @Deprecated
    @Transient
    @Shortcut
    @LegacyManagedObjects(moClass=RbForwardingRuleConfigTable.class)
    public RbForwardingRuleConfigTable getRbForwardingRuleConfigTable() {
        RbForwardingRuleConfigTable rbForwardingRuleConfigTable = new RbForwardingRuleConfigTable(this.getRbForwardingRuleConfigEntries());
        rbForwardingRuleConfigTable.setNRConfiguration(this);
        return rbForwardingRuleConfigTable;
    }

    @Deprecated
    public void setRbForwardingRuleConfigTable(RbForwardingRuleConfigTable table) {
        table.synchronizeCollection(this.getRbForwardingRuleConfigEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbSubscriberEntry.class)
    public List<RbSubscriberEntry> getRbSubscriberEntries() {
        if (this.rbSubscriberEntries == null) {
            this.rbSubscriberEntries = new ArrayList<RbSubscriberEntry>();
        }
        return this.rbSubscriberEntries;
    }

    public void setRbSubscriberEntries(List<RbSubscriberEntry> rbSubscriberEntries) {
        this.rbSubscriberEntries = rbSubscriberEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbSubscriberTable.class)
    public RbSubscriberTable getRbSubscriberTable() {
        RbSubscriberTable rbSubscriberTable = new RbSubscriberTable(this.getRbSubscriberEntries());
        rbSubscriberTable.setNRConfiguration(this);
        return rbSubscriberTable;
    }

    @Deprecated
    public void setRbSubscriberTable(RbSubscriberTable table) {
        table.synchronizeCollection(this.getRbSubscriberEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbMACAddressDenyListEntry.class)
    public List<RbMACAddressDenyListEntry> getRbMACAddressDenyListEntries() {
        if (this.rbMACAddressDenyListEntries == null) {
            this.rbMACAddressDenyListEntries = new ArrayList<RbMACAddressDenyListEntry>();
        }
        return this.rbMACAddressDenyListEntries;
    }

    public void setRbMACAddressDenyListEntries(List<RbMACAddressDenyListEntry> rbMACAddressDenyListEntries) {
        this.rbMACAddressDenyListEntries = rbMACAddressDenyListEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbMACAddressDenyListTable.class)
    public RbMACAddressDenyListTable getRbMACAddressDenyListTable() {
        RbMACAddressDenyListTable rbMACAddressDenyListTable = new RbMACAddressDenyListTable(this.getRbMACAddressDenyListEntries());
        rbMACAddressDenyListTable.setNRConfiguration(this);
        return rbMACAddressDenyListTable;
    }

    @Deprecated
    public void setRbMACAddressDenyListTable(RbMACAddressDenyListTable table) {
        table.synchronizeCollection(this.getRbMACAddressDenyListEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbFrequencyBandsEntry.class)
    public List<RbFrequencyBandsEntry> getRbFrequencyBandsEntries() {
        if (this.rbFrequencyBandsEntries == null) {
            this.rbFrequencyBandsEntries = new ArrayList<RbFrequencyBandsEntry>();
        }
        return this.rbFrequencyBandsEntries;
    }

    public void setRbFrequencyBandsEntries(List<RbFrequencyBandsEntry> rbFrequencyBandsEntries) {
        this.rbFrequencyBandsEntries = rbFrequencyBandsEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbFrequencyBandsTable.class)
    public RbFrequencyBandsTable getRbFrequencyBandsTable() {
        RbFrequencyBandsTable rbFrequencyBandsTable = new RbFrequencyBandsTable(this.getRbFrequencyBandsEntries());
        rbFrequencyBandsTable.setNRConfiguration(this);
        return rbFrequencyBandsTable;
    }

    @Deprecated
    public void setRbFrequencyBandsTable(RbFrequencyBandsTable table) {
        table.synchronizeCollection(this.getRbFrequencyBandsEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbRadioClusterEntry.class)
    public List<RbRadioClusterEntry> getRbRadioClusterEntries() {
        if (this.rbRadioClusterEntries == null) {
            this.rbRadioClusterEntries = new ArrayList<RbRadioClusterEntry>();
        }
        return this.rbRadioClusterEntries;
    }

    public void setRbRadioClusterEntries(List<RbRadioClusterEntry> rbRadioClusterEntries) {
        this.rbRadioClusterEntries = rbRadioClusterEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbRadioClusterTable.class)
    public RbRadioClusterTable getRbRadioClusterTable() {
        RbRadioClusterTable rbRadioClusterTable = new RbRadioClusterTable(this.getRbRadioClusterEntries());
        rbRadioClusterTable.setNRConfiguration(this);
        return rbRadioClusterTable;
    }

    @Deprecated
    public void setRbRadioClusterTable(RbRadioClusterTable table) {
        table.synchronizeCollection(this.getRbRadioClusterEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbOduConfigEntry.class)
    public List<RbOduConfigEntry> getRbOduConfigEntries() {
        if (this.rbOduConfigEntries == null) {
            this.rbOduConfigEntries = new ArrayList<RbOduConfigEntry>();
        }
        return this.rbOduConfigEntries;
    }

    public void setRbOduConfigEntries(List<RbOduConfigEntry> rbOduConfigEntries) {
        this.rbOduConfigEntries = rbOduConfigEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbOduConfigTable.class)
    public RbOduConfigTable getRbOduConfigTable() {
        RbOduConfigTable rbOduConfigTable = new RbOduConfigTable(this.getRbOduConfigEntries());
        rbOduConfigTable.setNRConfiguration(this);
        return rbOduConfigTable;
    }

    @Deprecated
    public void setRbOduConfigTable(RbOduConfigTable table) {
        table.synchronizeCollection(this.getRbOduConfigEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbL2FilteringRuleEntry.class)
    public List<RbL2FilteringRuleEntry> getRbL2FilteringRuleEntries() {
        if (this.rbL2FilteringRuleEntries == null) {
            this.rbL2FilteringRuleEntries = new ArrayList<RbL2FilteringRuleEntry>();
        }
        return this.rbL2FilteringRuleEntries;
    }

    public void setRbL2FilteringRuleEntries(List<RbL2FilteringRuleEntry> rbL2FilteringRuleEntries) {
        this.rbL2FilteringRuleEntries = rbL2FilteringRuleEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbL2FilteringRuleTable.class)
    public RbL2FilteringRuleTable getRbL2FilteringRuleTable() {
        RbL2FilteringRuleTable rbL2FilteringRuleTable = new RbL2FilteringRuleTable(this.getRbL2FilteringRuleEntries());
        rbL2FilteringRuleTable.setNRConfiguration(this);
        return rbL2FilteringRuleTable;
    }

    @Deprecated
    public void setRbL2FilteringRuleTable(RbL2FilteringRuleTable table) {
        table.synchronizeCollection(this.getRbL2FilteringRuleEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbL3L4FilteringRuleEntry.class)
    public List<RbL3L4FilteringRuleEntry> getRbL3L4FilteringRuleEntries() {
        if (this.rbL3L4FilteringRuleEntries == null) {
            this.rbL3L4FilteringRuleEntries = new ArrayList<RbL3L4FilteringRuleEntry>();
        }
        return this.rbL3L4FilteringRuleEntries;
    }

    public void setRbL3L4FilteringRuleEntries(List<RbL3L4FilteringRuleEntry> rbL3L4FilteringRuleEntries) {
        this.rbL3L4FilteringRuleEntries = rbL3L4FilteringRuleEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbL3L4FilteringRuleTable.class)
    public RbL3L4FilteringRuleTable getRbL3L4FilteringRuleTable() {
        RbL3L4FilteringRuleTable rbL3L4FilteringRuleTable = new RbL3L4FilteringRuleTable(this.getRbL3L4FilteringRuleEntries());
        rbL3L4FilteringRuleTable.setNRConfiguration(this);
        return rbL3L4FilteringRuleTable;
    }

    @Deprecated
    public void setRbL3L4FilteringRuleTable(RbL3L4FilteringRuleTable table) {
        table.synchronizeCollection(this.getRbL3L4FilteringRuleEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbFilterEntry.class)
    public List<RbFilterEntry> getRbFilterEntries() {
        if (this.rbFilterEntries == null) {
            this.rbFilterEntries = new ArrayList<RbFilterEntry>();
        }
        return this.rbFilterEntries;
    }

    public void setRbFilterEntries(List<RbFilterEntry> rbFilterEntries) {
        this.rbFilterEntries = rbFilterEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbFilterTable.class)
    public RbFilterTable getRbFilterTable() {
        RbFilterTable rbFilterTable = new RbFilterTable(this.getRbFilterEntries());
        rbFilterTable.setNRConfiguration(this);
        return rbFilterTable;
    }

    @Deprecated
    public void setRbFilterTable(RbFilterTable table) {
        table.synchronizeCollection(this.getRbFilterEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbInterfaceFilteringEntry.class)
    public List<RbInterfaceFilteringEntry> getRbInterfaceFilteringEntries() {
        if (this.rbInterfaceFilteringEntries == null) {
            this.rbInterfaceFilteringEntries = new ArrayList<RbInterfaceFilteringEntry>();
        }
        return this.rbInterfaceFilteringEntries;
    }

    public void setRbInterfaceFilteringEntries(List<RbInterfaceFilteringEntry> rbInterfaceFilteringEntries) {
        this.rbInterfaceFilteringEntries = rbInterfaceFilteringEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbInterfaceFilteringTable.class)
    public RbInterfaceFilteringTable getRbInterfaceFilteringTable() {
        RbInterfaceFilteringTable rbInterfaceFilteringTable = new RbInterfaceFilteringTable(this.getRbInterfaceFilteringEntries());
        rbInterfaceFilteringTable.setNRConfiguration(this);
        return rbInterfaceFilteringTable;
    }

    @Deprecated
    public void setRbInterfaceFilteringTable(RbInterfaceFilteringTable table) {
        table.synchronizeCollection(this.getRbInterfaceFilteringEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbTrapConfigEntry.class)
    public List<RbTrapConfigEntry> getRbTrapConfigEntries() {
        if (this.rbTrapConfigEntries == null) {
            this.rbTrapConfigEntries = new ArrayList<RbTrapConfigEntry>();
        }
        return this.rbTrapConfigEntries;
    }

    public void setRbTrapConfigEntries(List<RbTrapConfigEntry> rbTrapConfigEntries) {
        this.rbTrapConfigEntries = rbTrapConfigEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbTrapConfigTable.class)
    public RbTrapConfigTable getRbTrapConfigTable() {
        RbTrapConfigTable rbTrapConfigTable = new RbTrapConfigTable(this.getRbTrapConfigEntries());
        rbTrapConfigTable.setNRConfiguration(this);
        return rbTrapConfigTable;
    }

    @Deprecated
    public void setRbTrapConfigTable(RbTrapConfigTable table) {
        table.synchronizeCollection(this.getRbTrapConfigEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbSwUpgrade.class)
    public List<RbSwUpgrade> getRbSwUpgrade() {
        if (this.rbSwUpgrade == null) {
            this.rbSwUpgrade = new ArrayList<RbSwUpgrade>();
        }
        return this.rbSwUpgrade;
    }

    public void setRbSwUpgrade(List<RbSwUpgrade> rbSwUpgrade) {
        this.rbSwUpgrade = rbSwUpgrade;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbBSSwitchingModeParameters.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.1"})
    public List<RbBSSwitchingModeParameters> getRbBSSwitchingModeParameters() {
        if (this.rbBSSwitchingModeParameters == null) {
            this.rbBSSwitchingModeParameters = new ArrayList<RbBSSwitchingModeParameters>();
        }
        return this.rbBSSwitchingModeParameters;
    }

    public void setRbBSSwitchingModeParameters(List<RbBSSwitchingModeParameters> rbBSProvisioningModeParameters) {
        this.rbBSSwitchingModeParameters = rbBSProvisioningModeParameters;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbRadiusClientGeneralParameters.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbRadiusClientGeneralParameters> getRbRadiusClientGeneralParameters() {
        if (this.rbRadiusClientGeneralParameters == null) {
            this.rbRadiusClientGeneralParameters = new ArrayList<RbRadiusClientGeneralParameters>();
        }
        return this.rbRadiusClientGeneralParameters;
    }

    public void setRbRadiusClientGeneralParameters(List<RbRadiusClientGeneralParameters> rbRadiusClientGeneralParameters) {
        this.rbRadiusClientGeneralParameters = rbRadiusClientGeneralParameters;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbRadiusAccountServerEntry.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbRadiusAccountServerEntry> getRbRadiusAccountServerEntries() {
        if (this.rbRadiusAccountServerEntries == null) {
            this.rbRadiusAccountServerEntries = new ArrayList<RbRadiusAccountServerEntry>();
        }
        return this.rbRadiusAccountServerEntries;
    }

    public void setRbRadiusAccountServerEntries(List<RbRadiusAccountServerEntry> rbRadiusAccountServerEntries) {
        this.rbRadiusAccountServerEntries = rbRadiusAccountServerEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbRadiusAccountServerTable.class)
    public RbRadiusAccountServerTable getRbRadiusAccountServerTable() {
        RbRadiusAccountServerTable rbRadiusAccountServerTable = new RbRadiusAccountServerTable(this.getRbRadiusAccountServerEntries());
        rbRadiusAccountServerTable.setNRConfiguration(this);
        return rbRadiusAccountServerTable;
    }

    @Deprecated
    public void setRbRadiusAccountServerTable(RbRadiusAccountServerTable table) {
        table.synchronizeCollection(this.getRbRadiusAccountServerEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbRadiusAuthServerEntry.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbRadiusAuthServerEntry> getRbRadiusAuthServerEntries() {
        if (this.rbRadiusAuthServerEntries == null) {
            this.rbRadiusAuthServerEntries = new ArrayList<RbRadiusAuthServerEntry>();
        }
        return this.rbRadiusAuthServerEntries;
    }

    public void setRbRadiusAuthServerEntries(List<RbRadiusAuthServerEntry> rbRadiusAuthServerEntries) {
        this.rbRadiusAuthServerEntries = rbRadiusAuthServerEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbRadiusAuthServerTable.class)
    public RbRadiusAuthServerTable getRbRadiusAuthServerTable() {
        RbRadiusAuthServerTable rbRadiusAuthServerTable = new RbRadiusAuthServerTable(this.getRbRadiusAuthServerEntries());
        rbRadiusAuthServerTable.setNRConfiguration(this);
        return rbRadiusAuthServerTable;
    }

    @Deprecated
    public void setRbRadiusAuthServerTable(RbRadiusAuthServerTable table) {
        table.synchronizeCollection(this.getRbRadiusAuthServerEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbGPSInfo.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbGPSInfo> getRbGPSInfo() {
        if (this.rbGPSInfo == null) {
            this.rbGPSInfo = new ArrayList<RbGPSInfo>();
        }
        return this.rbGPSInfo;
    }

    public void setRbGPSInfo(List<RbGPSInfo> rbGPSInfo) {
        this.rbGPSInfo = rbGPSInfo;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbBSClockConfigParameters.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbBSClockConfigParameters> getRbBSClockConfigParameters() {
        if (this.rbBSClockConfigParameters == null) {
            this.rbBSClockConfigParameters = new ArrayList<RbBSClockConfigParameters>();
        }
        return this.rbBSClockConfigParameters;
    }

    public void setRbBSClockConfigParameters(List<RbBSClockConfigParameters> rbBSClockConfigParameters) {
        this.rbBSClockConfigParameters = rbBSClockConfigParameters;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbChainConfig.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbChainConfig> getRbChainConfig() {
        if (this.rbChainConfig == null) {
            this.rbChainConfig = new ArrayList<RbChainConfig>();
        }
        return this.rbChainConfig;
    }

    public void setRbChainConfig(List<RbChainConfig> rbChainConfig) {
        this.rbChainConfig = rbChainConfig;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbServiceGroupEntry.class)
    @Filter(filterClass=SwitchingModeOrVersionFilter.class, values={"switchingMode", "2", "softwareVersion", ">=4.5"})
    public List<RbServiceGroupEntry> getRbServiceGroupEntries() {
        if (this.rbServiceGroupEntries == null) {
            this.rbServiceGroupEntries = new ArrayList<RbServiceGroupEntry>();
        }
        return this.rbServiceGroupEntries;
    }

    public void setRbServiceGroupEntries(List<RbServiceGroupEntry> rbServiceGroupEntries) {
        this.rbServiceGroupEntries = rbServiceGroupEntries;
    }

    @Deprecated
    @Transient
    @Shortcut
    @LegacyManagedObjects(moClass=RbServiceGroupTable.class)
    public RbServiceGroupTable getServiceGroupTable() {
        RbServiceGroupTable rbServiceGroupTable = new RbServiceGroupTable(this.getRbServiceGroupEntries());
        rbServiceGroupTable.setNRConfiguration(this);
        return rbServiceGroupTable;
    }

    @Deprecated
    public void setRbServiceGroupTable(RbServiceGroupTable table) {
        table.synchronizeCollection(this.getRbServiceGroupEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbVoiceDomainsEntry.class)
    @Filter(filterClass=SipAwareFilter.class, values={"softwareVersion", ">4.2", "model", "BreezeMAX_MBS", "switchingMode", "2", "softwareVersion", ">=4.5"})
    public List<RbVoiceDomainsEntry> getRbVoiceDomainsEntries() {
        if (this.rbVoiceDomainsEntries == null) {
            this.rbVoiceDomainsEntries = new ArrayList<RbVoiceDomainsEntry>();
        }
        return this.rbVoiceDomainsEntries;
    }

    public void setRbVoiceDomainsEntries(List<RbVoiceDomainsEntry> rbVoiceDomainsEntries) {
        this.rbVoiceDomainsEntries = rbVoiceDomainsEntries;
    }

    @Deprecated
    @Transient
    @Shortcut
    @LegacyManagedObjects(moClass=RbVoiceDomainsTable.class)
    public RbVoiceDomainsTable getVoiceDomainsTable() {
        RbVoiceDomainsTable rbVoiceDomainsTable = new RbVoiceDomainsTable(this.getRbVoiceDomainsEntries());
        rbVoiceDomainsTable.setNRConfiguration(this);
        return rbVoiceDomainsTable;
    }

    @Deprecated
    public void setRbVoiceDomainsTable(RbVoiceDomainsTable table) {
        table.synchronizeCollection(this.getRbVoiceDomainsEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbBSPFServersEntry.class)
    @Filter(filterClass=SipAwareFilter.class, values={"softwareVersion", ">4.2", "model", "BreezeMAX_MBS", "switchingMode", "2", "softwareVersion", ">=4.5"})
    public List<RbBSPFServersEntry> getRbBSPFServersEntries() {
        if (this.rbBSPFServersEntries == null) {
            this.rbBSPFServersEntries = new ArrayList<RbBSPFServersEntry>();
        }
        return this.rbBSPFServersEntries;
    }

    public void setRbBSPFServersEntries(List<RbBSPFServersEntry> rbBSPFServersEntries) {
        this.rbBSPFServersEntries = rbBSPFServersEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbBSPFServersTable.class)
    public RbBSPFServersTable getBSPFServersTable() {
        RbBSPFServersTable rbBSPFServersTable = new RbBSPFServersTable(this.getRbBSPFServersEntries());
        rbBSPFServersTable.setNRConfiguration(this);
        return rbBSPFServersTable;
    }

    @Deprecated
    public void setRbBSPFServersTable(RbBSPFServersTable table) {
        table.synchronizeCollection(this.getRbBSPFServersEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbPFGeneralParameters.class)
    @Filter(filterClass=SipAwareFilter.class, values={"softwareVersion", ">4.2", "model", "BreezeMAX_MBS", "switchingMode", "2", "softwareVersion", ">=4.5"})
    public List<RbPFGeneralParameters> getRbPFGeneralParameters() {
        if (this.rbPFGeneralParameters == null) {
            this.rbPFGeneralParameters = new ArrayList<RbPFGeneralParameters>();
        }
        return this.rbPFGeneralParameters;
    }

    public void setRbPFGeneralParameters(List<RbPFGeneralParameters> rbPFGeneralParameters) {
        this.rbPFGeneralParameters = rbPFGeneralParameters;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbSwAuConfigEntry.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbSwAuConfigEntry> getRbSwAuConfigEntries() {
        if (this.rbSwAuConfigEntries == null) {
            this.rbSwAuConfigEntries = new ArrayList<RbSwAuConfigEntry>();
        }
        return this.rbSwAuConfigEntries;
    }

    public void setRbSwAuConfigEntries(List<RbSwAuConfigEntry> rbSwAuConfigEntries) {
        this.rbSwAuConfigEntries = rbSwAuConfigEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbSwAuConfigTable.class)
    public RbSwAuConfigTable getRbSwAuConfigTable() {
        RbSwAuConfigTable rbSwAuConfigTable = new RbSwAuConfigTable(this.getRbSwAuConfigEntries());
        rbSwAuConfigTable.setNRConfiguration(this);
        return rbSwAuConfigTable;
    }

    @Deprecated
    public void setRbSwAuConfigTable(RbSwAuConfigTable table) {
        table.synchronizeCollection(this.getRbSwAuConfigEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbSwRegisteredSuEntry.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbSwRegisteredSuEntry> getRbSwRegisteredSuEntries() {
        if (this.rbSwRegisteredSuEntries == null) {
            this.rbSwRegisteredSuEntries = new ArrayList<RbSwRegisteredSuEntry>();
        }
        return this.rbSwRegisteredSuEntries;
    }

    public void setRbSwRegisteredSuEntries(List<RbSwRegisteredSuEntry> rbSwRegisteredSuEntries) {
        this.rbSwRegisteredSuEntries = rbSwRegisteredSuEntries;
    }

    @Deprecated
    @Transient
    @LegacyManagedObjects(moClass=RbSwRegisteredSuTable.class)
    public RbSwRegisteredSuTable getRbSwRegisteredSuTable() {
        RbSwRegisteredSuTable rbSwRegisteredSuTable = new RbSwRegisteredSuTable(this.getRbSwRegisteredSuEntries());
        rbSwRegisteredSuTable.setNRConfiguration(this);
        return rbSwRegisteredSuTable;
    }

    @Deprecated
    public void setRbSwRegisteredSuTable(RbSwRegisteredSuTable table) {
        table.synchronizeCollection(this.getRbSwRegisteredSuEntries());
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbBsRFModeParameters.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public List<RbBsRFModeParameters> getRbBsRFModeParameters() {
        if (this.rbBsRFModeParameters == null) {
            this.rbBsRFModeParameters = new ArrayList<RbBsRFModeParameters>();
        }
        return this.rbBsRFModeParameters;
    }

    public void setRbBsRFModeParameters(List<RbBsRFModeParameters> rbBsRFModeParameters) {
        this.rbBsRFModeParameters = rbBsRFModeParameters;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbBSPmTmConfigParameters.class)
    @Filter(filterClass=VersionAndModelFilter.class, values={"softwareVersion", ">=4.5", "model", "BreezeMAX_BS"})
    public List<RbBSPmTmConfigParameters> getRbBSPmTmConfigParameters() {
        if (this.rbBSPmTmConfigParameters == null) {
            this.rbBSPmTmConfigParameters = new ArrayList<RbBSPmTmConfigParameters>();
        }
        return this.rbBSPmTmConfigParameters;
    }

    public void setRbBSPmTmConfigParameters(List<RbBSPmTmConfigParameters> rbBSPmTmConfigParameters) {
        this.rbBSPmTmConfigParameters = rbBSPmTmConfigParameters;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbFDDDefaultServiceGroupScalar.class)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", "~3.6"})
    public List<RbFDDDefaultServiceGroupScalar> getRbFDDDefaultServiceGroupScalar() {
        if (this.rbFDDDefaultServiceGroupScalar == null) {
            this.rbFDDDefaultServiceGroupScalar = new ArrayList<RbFDDDefaultServiceGroupScalar>();
        }
        return this.rbFDDDefaultServiceGroupScalar;
    }

    public void setRbFDDDefaultServiceGroupScalar(List<RbFDDDefaultServiceGroupScalar> rbFDDDefaultServiceGroupScalar) {
        this.rbFDDDefaultServiceGroupScalar = rbFDDDefaultServiceGroupScalar;
    }
}

