/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.gui.Internationalizer;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.model.ConfigurableEquipment;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentManager;
import com.bwanms.model.Manageable;
import com.bwanms.model.ManagedEquipment;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.StandardSoftwareVersions;
import com.bwanms.model.Validatable;
import com.bwanms.model.fault.constants.MOType;
import com.bwanms.model.license.Licensable;
import com.bwanms.rb.command.RbTrapRestoreDefaults;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.IpAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@Table(name="RbBaseStationEquipment", indexes={@Index(name="IDX_RBBSEQ_LICENSEID", columnNames={"licenseID"})})
public abstract class RbBaseStationEquipment
extends Equipment
implements Manageable,
EquipmentManager,
ConfigurableEquipment,
Licensable,
Validatable,
StandardSoftwareVersions {
    public static final String BS_TIME_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private String IPAddress;
    private String snmpReadCommunity;
    private String snmpWriteCommunity;
    private Integer snmpRetries;
    private Long snmpTimeout;
    private Integer snmpPort;
    private String operationalSoftwareVersion;
    private String shadowSoftwareVersion;
    private String operatorID;
    private String cellID;
    private Integer switchingMode;
    private Long licenseID = Licensable.UNLICENSED;
    private String mngmntIfMAC;
    private long trapSeqNoBeforeReset;
    private long lastReceivedTrapSeqNo;
    private List<RbSU> associatedSUs;
    private Long gpsChainNumber;
    private Integer gpsClockMode;
    private String gpsLongitude;
    private String gpsLatitude;
    private String gpsAltitude;
    private String gpsChainComplexKey;
    private Boolean sendsTraps;
    private Long timeDiffBetweenNmsAndBs;
    public static int SWITCHING_MODE_ETHERNET_CS = 1;
    public static int SWITCHING_MODE_IP_CS = 2;

    @Transient
    public SNMPManagementInterface getManagementInterface() {
        return new SNMPManagementInterface(this.IPAddress, this.snmpPort.intValue(), this.snmpReadCommunity, this.snmpWriteCommunity, this.snmpRetries.intValue(), this.snmpTimeout.longValue());
    }

    public void setManagementInterface(SNMPManagementInterface managementInterface) {
        this.setIPAddress(managementInterface.getIp());
        this.setSnmpPort(managementInterface.getPort());
        this.setSnmpReadCommunity(managementInterface.getReadCommunity());
        this.setSnmpWriteCommunity(managementInterface.getWriteCommunity());
        this.setSnmpRetries(managementInterface.getRetries());
        this.setSnmpTimeout(managementInterface.getTimeout());
    }

    @Column(unique=true)
    public String getIPAddress() {
        return this.IPAddress;
    }

    public void setIPAddress(String address) {
        this.IPAddress = address;
        try {
            this.setIpAddr(new IpAddress(address).getIpAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMngmntIfMAC() {
        return this.mngmntIfMAC;
    }

    public void setMngmntIfMAC(String mngmntIfMAC) {
        this.mngmntIfMAC = mngmntIfMAC;
    }

    @Transient
    public List<RbSU> getManagedSUs() {
        return new ArrayList<RbSU>(this.getAssociatedSUs());
    }

    public String getOperatorID() {
        return this.operatorID;
    }

    public void setOperatorID(String operatorID) {
        this.operatorID = operatorID;
    }

    public String getCellID() {
        return this.cellID;
    }

    public void setCellID(String cellID) {
        this.cellID = cellID;
    }

    public String getOperationalSoftwareVersion() {
        return this.operationalSoftwareVersion;
    }

    public void setOperationalSoftwareVersion(String operationalSoftwareVersion) {
        this.operationalSoftwareVersion = operationalSoftwareVersion;
    }

    public String getShadowSoftwareVersion() {
        return this.shadowSoftwareVersion;
    }

    public void setShadowSoftwareVersion(String shadowSoftwareVersion) {
        this.shadowSoftwareVersion = shadowSoftwareVersion;
    }

    @Transient
    public String getRunningSoftwareVersion() {
        return this.getFirmwareVersion();
    }

    public void setRunningSoftwareVersion(String runningSoftwareVersion) {
        this.setFirmwareVersion(runningSoftwareVersion);
    }

    public Collection<ManagedEquipment> findManagedEquipment() {
        ArrayList<ManagedEquipment> ret = new ArrayList<ManagedEquipment>();
        ret.addAll(this.getManagedSUs());
        return ret;
    }

    public Equipment findSuByMacAddress(String macAddress) {
        for (RbSU su : this.getManagedSUs()) {
            if (!macAddress.equals(su.getMacAddress())) continue;
            return su;
        }
        return null;
    }

    @Transient
    public Version getSoftwareVersion() {
        return VersionFactory.getInstance().createVersion(this.getFirmwareVersion());
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public void setLicenseID(Long licenseID) {
        this.licenseID = licenseID;
    }

    public String getSnmpReadCommunity() {
        return this.snmpReadCommunity;
    }

    public void setSnmpReadCommunity(String snmpReadCommunity) {
        this.snmpReadCommunity = snmpReadCommunity;
    }

    public Integer getSnmpRetries() {
        return this.snmpRetries;
    }

    public void setSnmpRetries(Integer snmpRetries) {
        this.snmpRetries = snmpRetries;
    }

    public Long getSnmpTimeout() {
        return this.snmpTimeout;
    }

    public void setSnmpTimeout(Long snmpTimeout) {
        this.snmpTimeout = snmpTimeout;
    }

    public String getSnmpWriteCommunity() {
        return this.snmpWriteCommunity;
    }

    public void setSnmpWriteCommunity(String snmpWriteCommunity) {
        this.snmpWriteCommunity = snmpWriteCommunity;
    }

    public Integer getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(Integer snmpPort) {
        this.snmpPort = snmpPort;
    }

    public void validate(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(SNMPManagementInterface.class);
        if (!this.IPAddress.matches("^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$")) {
            invalidValues.add(new InvalidValue(i18n.translateString("SNMPManagementInterfaceInvalidIpAddress"), RbBaseStationEquipment.class, "IPAddress", (Object)this.IPAddress, (Object)this));
        }
        if (this.snmpReadCommunity == null || this.snmpReadCommunity.trim().equals("") || this.snmpReadCommunity.length() >= 255) {
            invalidValues.add(new InvalidValue(i18n.translateString("SNMPManagementInterfaceInvalidReadCommunity"), RbBaseStationEquipment.class, "snmpReadCommunity", (Object)"", (Object)this));
        }
        if (this.snmpWriteCommunity == null || this.snmpWriteCommunity.trim().equals("") || this.snmpWriteCommunity.length() >= 255) {
            invalidValues.add(new InvalidValue(i18n.translateString("SNMPManagementInterfaceInvalidWriteCommunity"), RbBaseStationEquipment.class, "snmpWriteCommunity", (Object)"", (Object)this));
        }
        if (this.snmpRetries < 0 || this.snmpRetries > 255) {
            invalidValues.add(new InvalidValue(i18n.translateString("SNMPManagementInterfaceInvalidSNMPRetries"), RbBaseStationEquipment.class, i18n.translateString("snmpRetries"), (Object)this.snmpRetries, (Object)this));
        }
        if (this.snmpTimeout < 1000L || this.snmpTimeout > 3600000L) {
            invalidValues.add(new InvalidValue(i18n.translateString("SNMPManagementInterfaceInvalidTimeOut"), RbBaseStationEquipment.class, i18n.translateString("snmpTimeOut"), (Object)(this.snmpTimeout / 1000L), (Object)this));
        }
    }

    public RbTrapRestoreDefaults createTrapsRestoreCommand(int commandOperation) {
        RbTrapRestoreDefaults rbTrapsCommand = new RbTrapRestoreDefaults();
        rbTrapsCommand.setEquipmentId(this.getId());
        rbTrapsCommand.setRbTrapRestoreDefaults(commandOperation);
        return rbTrapsCommand;
    }

    public long getTrapSeqNoBeforeReset() {
        return this.trapSeqNoBeforeReset;
    }

    public void setTrapSeqNoBeforeReset(long lastTrapSequenceNumber) {
        this.trapSeqNoBeforeReset = lastTrapSequenceNumber;
    }

    public long getLastReceivedTrapSeqNo() {
        return this.lastReceivedTrapSeqNo;
    }

    public void setLastReceivedTrapSeqNo(long trapSeqNo) {
        this.lastReceivedTrapSeqNo = trapSeqNo;
    }

    public void incrementTrapSeqNo() {
        ++this.lastReceivedTrapSeqNo;
    }

    @OneToMany
    @JoinColumn(name="associatedBs_id")
    public List<RbSU> getAssociatedSUs() {
        return this.associatedSUs;
    }

    public void setAssociatedSUs(List<RbSU> associatedSUs) {
        this.associatedSUs = associatedSUs;
    }

    public Integer getSwitchingMode() {
        if (Integer.valueOf(SWITCHING_MODE_IP_CS).equals(this.switchingMode)) {
            return SWITCHING_MODE_IP_CS;
        }
        return SWITCHING_MODE_ETHERNET_CS;
    }

    public void setSwitchingMode(Integer switchingMode) {
        this.switchingMode = switchingMode;
    }

    public Long getGpsChainNumber() {
        return this.gpsChainNumber;
    }

    public void setGpsChainNumber(Long gpsChainNumber) {
        this.gpsChainNumber = gpsChainNumber;
    }

    public Integer getGpsClockMode() {
        return this.gpsClockMode;
    }

    public void setGpsClockMode(Integer gpsClockMode) {
        this.gpsClockMode = gpsClockMode;
    }

    public String getGpsAltitude() {
        return this.gpsAltitude;
    }

    public void setGpsAltitude(String gpsAltitude) {
        this.gpsAltitude = gpsAltitude;
    }

    public String getGpsLatitude() {
        return this.gpsLatitude;
    }

    public void setGpsLatitude(String gpsLatitude) {
        this.gpsLatitude = gpsLatitude;
    }

    public String getGpsLongitude() {
        return this.gpsLongitude;
    }

    public void setGpsLongitude(String gpsLongitude) {
        this.gpsLongitude = gpsLongitude;
    }

    public String getGpsChainComplexKey() {
        return this.gpsChainComplexKey;
    }

    public void setGpsChainComplexKey(String gpsChainComplexKey) {
        this.gpsChainComplexKey = gpsChainComplexKey;
    }

    public Boolean getSendsTraps() {
        return this.sendsTraps;
    }

    public void setSendsTraps(Boolean sendsTraps) {
        this.sendsTraps = sendsTraps;
    }

    public Long getTimeDiffBetweenNmsAndBs() {
        return this.timeDiffBetweenNmsAndBs;
    }

    public void setTimeDiffBetweenNmsAndBs(Long timeDiffBetweenNmsAndBs) {
        this.timeDiffBetweenNmsAndBs = timeDiffBetweenNmsAndBs;
    }

    @Transient
    public boolean isIPCSSwitchingMode() {
        return SWITCHING_MODE_IP_CS == this.getSwitchingMode();
    }

    @Transient
    public boolean isTDDDuplexMode() {
        return this.getSoftwareVersion().compareTo((Object)RbVersions.V_4_0) >= 0;
    }

    @Transient
    public boolean isSendingTraps() {
        return this.sendsTraps != null && this.sendsTraps != false;
    }

    @Transient
    public String getManagedObjectId() {
        return "BS." + this.getEUID();
    }

    @Transient
    public int getMOType() {
        return MOType.BS.value();
    }

    @Transient
    public String getMOInstance() {
        return this.getEUID();
    }
}

