/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.entity.PersisterAdapter;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.model.RbBackupConfigFile;
import com.bwanms.services.ServiceException;
import java.util.List;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBackupConfigFilePersister
extends PersisterAdapter<RbBackupConfigFile> {
    private static int RETENTION_INTERVAL;

    public void persistBeforeSave(RbBackupConfigFile entity) throws ServiceException {
        if (entity.getEquipmentAssoc() != null) {
            String sqlQuery = "from " + RbBackupConfigFile.class.getName() + " c where c.equipmentAssoc.managedEntity = :equipment order by timestamp asc";
            Query query = Datastore.session().createQuery(sqlQuery);
            query.setEntity("equipment", (Object)entity.getEquipmentAssoc().getManagedEntity());
            List temp = query.list();
            if (temp.size() >= RETENTION_INTERVAL) {
                Datastore.session().delete(temp.get(0));
            }
        }
    }

    static {
        try {
            RETENTION_INTERVAL = Integer.parseInt(System.getProperty("RbConfigBackupRetentionInterval", "3"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            RETENTION_INTERVAL = 3;
        }
    }
}

