/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.model.file.AbstractFile;
import com.bwanms.model.file.BackupConfigFile;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbBackupConfigFile
extends AbstractFile
implements BackupConfigFile {
    private static final long serialVersionUID = 1489600845409243997L;
    public static final int TYPE_FULL = 1;
    public static final int TYPE_SERVICE_PROFILES = 2;
    public static final int TYPE_SERVICES = 3;
    public static final int TYPE_TRAPS = 4;
    public static final int TYPE_FILTERS = 5;
    public static final int TYPE_LICENSING = 8;
    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_IMPORTED = 2;
    public static final int STATUS_ORPHAN = 3;
    private FileType customType;
    private ManagedEntityWeakAssociation equipmentAssoc;
    private String equipmentName;
    private String locationName;
    private Long equipmentIp;
    private int status;

    public RbBackupConfigFile() {
        this.initializeFromEquipment();
    }

    public RbBackupConfigFile(Equipment equipment) {
        this.equipmentAssoc = new ManagedEntityWeakAssociation((ManagedEntity)equipment);
        this.initializeFromEquipment();
    }

    private void initializeFromEquipment() {
        this.initializeEquipmentName();
        this.initializeLocationName();
        this.initializeEquipmentIp();
    }

    @Transient
    public FileType getCustomType() {
        return this.customType;
    }

    public void setCustomType(FileType fileType) {
        this.customType = fileType;
        this.setFileName(RbBackupConfigFile.getBackupFileName(fileType));
    }

    @OneToOne(cascade={CascadeType.ALL})
    public ManagedEntityWeakAssociation getEquipmentAssoc() {
        return this.equipmentAssoc;
    }

    public void setEquipmentAssoc(ManagedEntityWeakAssociation equipmentAssoc) {
        this.equipmentAssoc = equipmentAssoc;
    }

    public String getFileType() {
        return this.customType != null ? this.customType.name() : null;
    }

    protected void setFileType(String fileType) {
        if (fileType != null) {
            this.setCustomType(FileType.valueOf(fileType));
        } else {
            this.setCustomType(null);
        }
    }

    public Integer getType() {
        return this.customType != null ? Integer.valueOf(this.customType.value()) : null;
    }

    public void setType(Integer type) {
        if (type == null) {
            this.customType = null;
        } else {
            switch (type) {
                case 1: {
                    this.customType = FileType.RbFullConfig;
                    break;
                }
                case 2: {
                    this.customType = FileType.RbServiceProfiles;
                    break;
                }
                case 3: {
                    this.customType = FileType.RbServices;
                    break;
                }
                case 4: {
                    this.customType = FileType.RbTraps;
                    break;
                }
                case 5: {
                    this.customType = FileType.RbFilters;
                    break;
                }
                case 8: {
                    this.customType = FileType.RbLicensing;
                }
            }
        }
    }

    public static String getBackupFileName(FileType fileType) {
        switch (fileType) {
            case RbFullConfig: {
                return "backup.res";
            }
            case RbServiceProfiles: {
                return "profiles.res";
            }
            case RbServices: {
                return "profiles_srvcs.res";
            }
            case RbTraps: {
                return "Traps_Config.res";
            }
            case RbFilters: {
                return "filtering.res";
            }
            case RbLicensing: {
                return "BSLicense_";
            }
        }
        return null;
    }

    @Transient
    public List<String> getAvailableFileTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (FileType fileType : FileType.values()) {
            types.add(fileType.name());
        }
        return types;
    }

    public Long getEquipmentIp() {
        return this.equipmentIp;
    }

    public void setEquipmentIp(Long equipmentIp) {
        this.equipmentIp = equipmentIp;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String equipmentLocation) {
        this.locationName = equipmentLocation;
    }

    public String getEquipmentName() {
        return this.equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    private void initializeEquipmentName() {
        Equipment equipment;
        this.equipmentName = "";
        if (null != this.equipmentAssoc && null != (equipment = (Equipment)this.equipmentAssoc.getManagedEntity())) {
            this.equipmentName = equipment.getName();
        }
    }

    private void initializeLocationName() {
        Location result;
        Equipment equipment;
        this.locationName = "";
        if (null != this.equipmentAssoc && null != (equipment = (Equipment)this.equipmentAssoc.getManagedEntity()) && null != (result = equipment.getLocation())) {
            this.locationName = result.getName();
        }
    }

    private void initializeEquipmentIp() {
        Equipment equipment;
        this.equipmentIp = -1L;
        if (null != this.equipmentAssoc && null != (equipment = (Equipment)this.equipmentAssoc.getManagedEntity())) {
            this.equipmentIp = equipment.getIpAddr();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        RbFullConfig(1, 1),
        RbServiceProfiles(2, 2),
        RbServices(3, 3),
        RbTraps(4, 5),
        RbFilters(5, 4),
        RbLicensing(8, 8);

        int value;
        int mibValue;

        private FileType(int value, int mibValue) {
            this.value = value;
            this.mibValue = mibValue;
        }

        public int value() {
            return this.value;
        }

        public int mibValue() {
            return this.mibValue;
        }
    }
}

