/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.Equipment;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationPersister;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBSPersister
extends RbBaseStationPersister<RbBS> {
    public void persistBeforeSave(RbBS entity) throws ServiceException {
        if (entity.getId() == 0L && this.findBaseStationByIPAddress(RbBS.class, entity.getIPAddress()) != null) {
            throw new EntityAlreadyExistsException("Base Station already exists on [" + entity.getIPAddress() + "]");
        }
        super.persistBeforeSave((Equipment)entity);
    }

    public void persistAfterSave(RbBS entity) throws ServiceException {
        super.persistAfterSave((Equipment)entity);
        Datastore.session().flush();
        Datastore.session().refresh((Object)entity);
        for (RbAU au : entity.getManagedAUs()) {
            au.setLocation(entity.getLocation());
        }
        for (RbNPU npu : entity.getManagedNPUs()) {
            npu.setLocation(entity.getLocation());
        }
    }
}

