/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.mo.EquipmentConfigurationConsistencyStrategy;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectRequest;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.model.RbAuNRConfiguration;
import com.bwanms.rb.model.RbBSEquipmentConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBSEquipmentConfigurationConsistencyStrategy
implements EquipmentConfigurationConsistencyStrategy {
    private static final Logger log = Logger.getLogger(RbBSEquipmentConfigurationConsistencyStrategy.class);
    private RbBSEquipmentConfiguration configuration;

    public RbBSEquipmentConfigurationConsistencyStrategy(RbBSEquipmentConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<ManagedObjectRequest> configurationChanged(List<ManagedObject> changedMOs) {
        ArrayList<ManagedObjectRequest> ret = new ArrayList<ManagedObjectRequest>();
        for (ManagedObject mo : changedMOs) {
            if (mo instanceof RbAuConfigTable) {
                this.processRbAuConfigTableChanges((RbAuConfigTable)mo, ret);
                continue;
            }
            if (!(mo instanceof RbRegisteredSuTable)) continue;
            this.processRbRegisteredSuTableChanges((RbRegisteredSuTable)mo, ret);
        }
        return ret;
    }

    private void processRbAuConfigTableChanges(RbAuConfigTable auConfigTable, List<ManagedObjectRequest> requests) {
        log.debug((Object)"processRbAuConfigTableChanges");
        for (RbAuConfigEntry auInstance : auConfigTable.getEntries()) {
            int slotNumber = auInstance.getRbSlotNumber();
            RbAuNRConfiguration nrConfig = this.configuration.getAuNetworkResourceConfigurations().get(slotNumber);
            if (nrConfig == null) {
                log.debug((Object)("No AU NR Config found for slot: " + slotNumber));
                nrConfig = new RbAuNRConfiguration();
                nrConfig.setConfiguration(this.configuration);
                nrConfig.setName("AU." + slotNumber);
                nrConfig.setSlotNumber(slotNumber);
                this.configuration.getNetworkResources().put(nrConfig.getName(), nrConfig);
                for (Class moClass : nrConfig.getManagedObjectClasses()) {
                    requests.add(new ManagedObjectRequest(nrConfig.getName(), moClass));
                }
            }
            Datastore.session().saveOrUpdate((Object)nrConfig);
        }
    }

    private void processRbRegisteredSuTableChanges(RbRegisteredSuTable regSuTable, List<ManagedObjectRequest> requests) {
        log.debug((Object)"processRbRegisteredSuTableChanges");
    }
}

