/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.mediation.NetworkResourceHandler;
import com.bwanms.mediation.snmp.SNMPNetworkResourceHandler;
import com.bwanms.mo.EquipmentConfigurationConsistencyStrategy;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.ManagementInterface;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.rb.model.RbAuNRConfiguration;
import com.bwanms.rb.model.RbBSEquipmentConfigurationConsistencyStrategy;
import com.bwanms.rb.model.RbBSNRConfiguration;
import com.bwanms.rb.model.RbBaseStationEquipmentConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbBSEquipmentConfiguration
extends RbBaseStationEquipmentConfiguration {
    private static final long serialVersionUID = -1910693738705428866L;

    public void createBSNrConfiguration() {
        NetworkResourceConfiguration config = this.findNetworkResourceConfiguration("BS");
        if (config != null) {
            throw new RuntimeException("BS NR already exists");
        }
        RbBSNRConfiguration ret = new RbBSNRConfiguration();
        ret.setName("BS");
        ret.setConfiguration(this);
        this.addNetworkResourceConfiguration(ret);
        for (int slotNumber = 1; slotNumber <= 9; ++slotNumber) {
            if (slotNumber >= 5 && slotNumber <= 6) continue;
            RbAuNRConfiguration nrConfig = new RbAuNRConfiguration();
            nrConfig.setName("AU." + slotNumber);
            nrConfig.setConfiguration(this);
            nrConfig.setSlotNumber(slotNumber);
            this.addNetworkResourceConfiguration(nrConfig);
        }
    }

    @Transient
    public Map<Integer, RbAuNRConfiguration> getAuNetworkResourceConfigurations() {
        HashMap<Integer, RbAuNRConfiguration> ret = new HashMap<Integer, RbAuNRConfiguration>();
        for (NetworkResourceConfiguration nrConfig : this.getNetworkResources().values()) {
            if (!(nrConfig instanceof RbAuNRConfiguration)) continue;
            ret.put(((RbAuNRConfiguration)nrConfig).getSlotNumber(), (RbAuNRConfiguration)nrConfig);
        }
        return ret;
    }

    @Transient
    public EquipmentConfigurationConsistencyStrategy getChangeStrategy() {
        return new RbBSEquipmentConfigurationConsistencyStrategy(this);
    }

    public NetworkResourceHandler getNetworkResourceHandler(Class<? extends ManagementInterface> managementInterfaceClass) {
        if (SNMPManagementInterface.class.isAssignableFrom(managementInterfaceClass)) {
            return new RbBSNetworkResourceHandler();
        }
        throw new RuntimeException("This configuration does not support " + managementInterfaceClass.getName());
    }

    private class RbBSNetworkResourceHandler
    implements SNMPNetworkResourceHandler {
        private RbBSNetworkResourceHandler() {
        }

        public SNMPManagementInterface getAgentInfo(SNMPManagementInterface equipmentAgentInfo, String networkResource) {
            if ("BS".equals(networkResource)) {
                return equipmentAgentInfo;
            }
            return new SNMPManagementInterface(equipmentAgentInfo.getIp(), equipmentAgentInfo.getPort(), equipmentAgentInfo.getReadCommunity() + "@" + networkResource, equipmentAgentInfo.getWriteCommunity() + "@" + networkResource, equipmentAgentInfo.getRetries().intValue(), equipmentAgentInfo.getTimeout().longValue());
        }
    }
}

