/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.model.ManagedEquipment;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbNPU;
import java.util.Collection;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@org.hibernate.annotations.Entity(dynamicUpdate=true)
public class RbBS
extends RbBaseStationEquipment {
    private List<RbAU> managedAUs;
    private List<RbNPU> managedNPUs;
    private int activeNPU;

    public String toString() {
        StringBuffer result = new StringBuffer(RbBS.class.getName()).append('[');
        result.append(super.toString()).append(", ");
        result.append("IPAddress=").append(this.getIPAddress()).append(", ");
        result.append("]");
        return result.toString();
    }

    public RbAU findAuBySlotNumber(int slotNumber) {
        for (RbAU au : this.getManagedAUs()) {
            if (au.getSlotNumber() != slotNumber) continue;
            return au;
        }
        return null;
    }

    public RbNPU findNpuBySlotNumber(int slotNumber) {
        for (RbNPU npu : this.getManagedNPUs()) {
            if (npu.getSlotNumber() != slotNumber) continue;
            return npu;
        }
        return null;
    }

    @Override
    public Collection<ManagedEquipment> findManagedEquipment() {
        Collection<ManagedEquipment> ret = super.findManagedEquipment();
        ret.addAll(this.getManagedNPUs());
        ret.addAll(this.getManagedAUs());
        return ret;
    }

    @Transient
    public RbNPU getRunningNPU() {
        List<RbNPU> npus = this.getManagedNPUs();
        return npus.size() > 0 ? npus.get(0) : null;
    }

    @OneToMany
    @JoinColumn(name="managerBS_id")
    public List<RbAU> getManagedAUs() {
        return this.managedAUs;
    }

    public void setManagedAUs(List<RbAU> managedAUs) {
        this.managedAUs = managedAUs;
    }

    @OneToMany
    @JoinColumn(name="managerBS_id")
    public List<RbNPU> getManagedNPUs() {
        return this.managedNPUs;
    }

    public void setManagedNPUs(List<RbNPU> managedNPUs) {
        this.managedNPUs = managedNPUs;
    }

    public int getActiveNPU() {
        return this.activeNPU;
    }

    public void setActiveNPU(int activeNPU) {
        this.activeNPU = activeNPU;
    }

    @Override
    @Transient
    public String getManagedObjectId() {
        return "BS." + this.getEUID();
    }
}

