/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.meta.mo.ManagedObjects;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.Equipment;
import com.bwanms.rb.mo.RbAuATPCParametersGroup;
import com.bwanms.rb.mo.RbAuMacParametersGroup;
import com.bwanms.rb.mo.RbAuMultirateParametersGroup;
import com.bwanms.rb.mo.RbAuPhyParametersGroup;
import com.bwanms.rb.model.RbBS;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbAuNRConfiguration
extends NetworkResourceConfiguration {
    int slotNumber;
    private List<RbAuMacParametersGroup> auMacParametersGroup;
    private List<RbAuPhyParametersGroup> auPhyParametersGroup;
    private List<RbAuMultirateParametersGroup> rbAuMultirateParametersGroup;
    private List<RbAuATPCParametersGroup> auATPCParametersGroup;

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbAuMacParametersGroup.class)
    public List<RbAuMacParametersGroup> getAuMacParametersGroup() {
        if (this.auMacParametersGroup == null) {
            this.auMacParametersGroup = new ArrayList<RbAuMacParametersGroup>();
        }
        return this.auMacParametersGroup;
    }

    public void setAuMacParametersGroup(List<RbAuMacParametersGroup> auMacParametersGroup) {
        this.auMacParametersGroup = auMacParametersGroup;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbAuPhyParametersGroup.class)
    public List<RbAuPhyParametersGroup> getAuPhyParametersGroup() {
        if (this.auPhyParametersGroup == null) {
            this.auPhyParametersGroup = new ArrayList<RbAuPhyParametersGroup>();
        }
        return this.auPhyParametersGroup;
    }

    public void setAuPhyParametersGroup(List<RbAuPhyParametersGroup> auPhyParametersGroup) {
        this.auPhyParametersGroup = auPhyParametersGroup;
    }

    @Transient
    public Equipment getManagedEquipment() {
        return ((RbBS)this.getConfigurationEquipment()).findAuBySlotNumber(this.slotNumber);
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbAuMultirateParametersGroup.class)
    public List<RbAuMultirateParametersGroup> getRbAuMultirateParametersGroup() {
        if (this.rbAuMultirateParametersGroup == null) {
            this.rbAuMultirateParametersGroup = new ArrayList<RbAuMultirateParametersGroup>();
        }
        return this.rbAuMultirateParametersGroup;
    }

    public void setRbAuMultirateParametersGroup(List<RbAuMultirateParametersGroup> rbAuMultirateParametersGroup) {
        this.rbAuMultirateParametersGroup = rbAuMultirateParametersGroup;
    }

    @OneToMany(mappedBy="NRConfiguration", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @ManagedObjects(moClass=RbAuATPCParametersGroup.class)
    public List<RbAuATPCParametersGroup> getAuATPCParametersGroup() {
        if (this.auATPCParametersGroup == null) {
            this.auATPCParametersGroup = new ArrayList<RbAuATPCParametersGroup>();
        }
        return this.auATPCParametersGroup;
    }

    public void setAuATPCParametersGroup(List<RbAuATPCParametersGroup> auATPCParametersGroup) {
        this.auATPCParametersGroup = auATPCParametersGroup;
    }
}

