/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.model;

import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentManager;
import com.bwanms.model.Manageable;
import com.bwanms.model.ManagedEquipment;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.StandardSoftwareVersions;
import com.bwanms.rb.command.RbAuCommand;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.constants.RbMOType;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
public class RbAU
extends Equipment
implements Manageable,
ManagedEquipment,
StandardSoftwareVersions {
    private static final long serialVersionUID = 3982818308274821113L;
    private String operationalSoftwareVersion;
    private String shadowSoftwareVersion;
    private String iduBootVersion;
    private String iduIfCardConfiguration;
    private String iduIfCardRevision;
    private RbBS managerBS;
    private Integer slotNumber;
    private Integer faultStatus;

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Transient
    public SNMPManagementInterface getManagementInterface() {
        RbBS managerBS = this.getManagerBS();
        if (managerBS == null) {
            throw new RuntimeException("Equipment Manager not found");
        }
        SNMPManagementInterface bsMgmtIf = managerBS.getManagementInterface();
        return new SNMPManagementInterface(bsMgmtIf.getIp(), bsMgmtIf.getPort(), bsMgmtIf.getReadCommunity() + "@AU." + this.getSlotNumber(), bsMgmtIf.getWriteCommunity() + "@AU." + this.getSlotNumber(), bsMgmtIf.getRetries().intValue(), bsMgmtIf.getTimeout().longValue());
    }

    @Transient
    public void setManagerBS(RbBS managerBS, int slotNumber) {
        this.setManagerBS(managerBS);
        this.setSlotNumber(slotNumber);
    }

    public EquipmentManager findEquipmentManager() {
        return this.getManagerBS();
    }

    @Transient
    public String getIPAddress() {
        RbBS managerBS = this.getManagerBS();
        return null != managerBS ? managerBS.getIPAddress() : null;
    }

    public RbAuCommand createResetCommand() {
        return this.createCommand(2, null);
    }

    public RbAuCommand createResetAndRunFromShadowCommand(String fileName) {
        return this.createCommand(4, fileName);
    }

    public RbAuCommand createMakeRunningVersionOperationalCommand(String fileName) {
        return this.createCommand(5, fileName);
    }

    public RbAuCommand createPutToShadowCommand(String fileName) {
        return this.createCommand(3, fileName);
    }

    public RbAuCommand createLoadFactoryDfltCommand() {
        return this.createDefaultsCommand(2);
    }

    public RbAuCommand createCommand(int commandOperation, String fileName) {
        RbAuCommand rbAuCommand = this.initCommand();
        rbAuCommand.setRbAuUnitControl(commandOperation);
        if (fileName != null) {
            rbAuCommand.setRbAuUpgradeSwFileName(fileName);
        }
        return rbAuCommand;
    }

    public RbAuCommand createDefaultsCommand(int commandOperation) {
        RbAuCommand rbAuCommand = this.initCommand();
        rbAuCommand.setRbAuSetDefaults(commandOperation);
        return rbAuCommand;
    }

    private RbAuCommand initCommand() {
        RbAuCommand rbAuCommand = new RbAuCommand();
        rbAuCommand.setEquipmentId(this.getId());
        rbAuCommand.setRbSlotNumber(this.getSlotNumber());
        return rbAuCommand;
    }

    public RbAuCommand createResetCountersCommand() {
        RbAuCommand rbAuCommand = this.initCommand();
        return rbAuCommand;
    }

    public String getOperationalSoftwareVersion() {
        return this.operationalSoftwareVersion;
    }

    public void setOperationalSoftwareVersion(String operationalSoftwareVersion) {
        this.operationalSoftwareVersion = operationalSoftwareVersion;
    }

    @Transient
    public String getRunningSoftwareVersion() {
        return this.getFirmwareVersion();
    }

    public void setRunningSoftwareVersion(String runningSoftwareVersion) {
        this.setFirmwareVersion(runningSoftwareVersion);
    }

    public String getShadowSoftwareVersion() {
        return this.shadowSoftwareVersion;
    }

    public void setShadowSoftwareVersion(String shadowSoftwareVersion) {
        this.shadowSoftwareVersion = shadowSoftwareVersion;
    }

    @ManyToOne
    @JoinColumn(name="managerBS_id")
    public RbBS getManagerBS() {
        return this.managerBS;
    }

    public void setManagerBS(RbBS managerBS) {
        this.managerBS = managerBS;
    }

    public String getIduBootVersion() {
        return this.iduBootVersion;
    }

    public void setIduBootVersion(String iduBootVersion) {
        this.iduBootVersion = iduBootVersion;
    }

    public String getIduIfCardConfiguration() {
        return this.iduIfCardConfiguration;
    }

    public void setIduIfCardConfiguration(String iduIfCardConfiguration) {
        this.iduIfCardConfiguration = iduIfCardConfiguration;
    }

    public String getIduIfCardRevision() {
        return this.iduIfCardRevision;
    }

    public void setIduIfCardRevision(String iduIfCardRevision) {
        this.iduIfCardRevision = iduIfCardRevision;
    }

    public Integer getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(Integer slotNumber) {
        this.slotNumber = slotNumber;
    }

    public Integer getFaultStatus() {
        return this.faultStatus;
    }

    public void setFaultStatus(Integer faultStatus) {
        this.faultStatus = faultStatus;
    }

    @Transient
    public String getManagedObjectId() {
        return "AU.Slot#" + this.slotNumber;
    }

    @Transient
    public int getMOType() {
        return RbMOType.AU.value();
    }

    @Transient
    public String getMOInstance() {
        return this.slotNumber != null ? this.slotNumber.toString() : "";
    }

    public static Version createAUSoftwareVersion(String ver) {
        if (ver != null) {
            if (ver.startsWith("Rel_")) {
                return VersionFactory.getInstance().createVersion(ver.substring(4), "_");
            }
            return VersionFactory.getInstance().createVersion(ver);
        }
        return null;
    }
}

