/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.PF;
import com.bwanms.rb.mo.configfile.VoiceDomain;
import com.bwanms.validation.IPv4Address;
import com.bwanms.validation.WeakNotNull;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Length;

@Entity
@AlwaysValidate
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.11.1.1", indexColumns={"RbVoiceDomainIdx"})
public class RbVoiceDomainsEntry
extends DynamicTableRowMO
implements Identifiable {
    private static final long serialVersionUID = 2468648576822141741L;
    public static final int MAX_VOICE_DOMAIN_INDEX = 10;
    public static final int NEW_MAX_VOICE_DOMAIN_INDEX = 5;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private Long rbVoiceDomainIdx;
    private String rbVoiceDomainName;
    private String rbVoiceDomainPrimaryPFIpAddress;
    private String rbVoiceDomainSecondaryPFIpAddress;
    private Integer rbVoiceDomainRowStatus;
    public static final int RowStatusActive = 1;
    public static final int RowStatusCreateAndGo = 4;
    public static final int RowStatusDestroy = 6;
    protected String complexKey;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.11.1.1.1", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbVoiceDomainIdx() {
        return this.rbVoiceDomainIdx;
    }

    public void setRbVoiceDomainIdx(Long rbVoiceDomainIdx) {
        this.rbVoiceDomainIdx = rbVoiceDomainIdx;
    }

    @WeakNotNull
    @Length(min=1, max=32)
    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.11.1.1.2", type=-128)
    public String getRbVoiceDomainName() {
        return this.rbVoiceDomainName;
    }

    public void setRbVoiceDomainName(String rbVoiceDomainName) {
        this.rbVoiceDomainName = rbVoiceDomainName;
    }

    @Column(name="rbVoiceDomainPrimPFIpAddress")
    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.11.1.1.3", type=64)
    @IPv4Address(acceptAnyIp=true)
    public String getRbVoiceDomainPrimaryPFIpAddress() {
        return this.rbVoiceDomainPrimaryPFIpAddress;
    }

    public void setRbVoiceDomainPrimaryPFIpAddress(String rbVoiceDomainPrimaryPFIpAddress) {
        this.rbVoiceDomainPrimaryPFIpAddress = rbVoiceDomainPrimaryPFIpAddress;
    }

    @Column(name="rbVoiceDomainSecPFIpAddress")
    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.11.1.1.4", type=64)
    @IPv4Address(acceptAnyIp=true)
    public String getRbVoiceDomainSecondaryPFIpAddress() {
        return this.rbVoiceDomainSecondaryPFIpAddress;
    }

    public void setRbVoiceDomainSecondaryPFIpAddress(String rbVoiceDomainSecondaryPFIpAddress) {
        this.rbVoiceDomainSecondaryPFIpAddress = rbVoiceDomainSecondaryPFIpAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.11.1.1.5", type=2)
    public Integer getRowStatus() {
        return this.rbVoiceDomainRowStatus;
    }

    public void setRowStatus(Integer rbVoiceDomainRowStatus) {
        this.rbVoiceDomainRowStatus = rbVoiceDomainRowStatus;
    }

    public static String toStringRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Transient
    public String getRowKey() {
        return String.valueOf(this.rbVoiceDomainIdx);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbVoiceDomainIdx=").append(this.rbVoiceDomainIdx).append(", ");
        result.append("rbVoiceDomainName=").append(this.rbVoiceDomainName).append(", ");
        result.append("rbVoiceDomainPrimaryPFIpAddress=").append(this.rbVoiceDomainPrimaryPFIpAddress).append(", ");
        result.append("rbVoiceDomainSecondaryPFIpAddress=").append(this.rbVoiceDomainSecondaryPFIpAddress).append(", ");
        result.append("rbVoiceDomainRowStatus=").append(RbVoiceDomainsEntry.toStringRowStatus(this.rbVoiceDomainRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getComplexKey() {
        return this.complexKey;
    }

    public void setComplexKey(String complexKey) {
        this.complexKey = complexKey;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbVoiceDomainsEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbVoiceDomainsEntry>(){

            public ManagedObjectAccessHandler<RbVoiceDomainsEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbVoiceDomainsEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbVoiceDomainsEntry>(){

            public ManagedObjectAccessHandler<RbVoiceDomainsEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler<RbVoiceDomainsEntry>(RbVoiceDomainsEntry.class){

                    public void add(Equipment eq, MOAccessSession access, String networkResource, RbVoiceDomainsEntry managedObject) throws MediationException {
                        if (managedObject.getRbVoiceDomainIdx() < 0L) {
                            managedObject.setRbVoiceDomainIdx(10L);
                        }
                        super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbVoiceDomainsEntry, VoiceDomain> {
        private TreeMap<Integer, String> pfServersMap;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbVoiceDomainsEntry createEntry() {
            return new RbVoiceDomainsEntry();
        }

        @Override
        protected Class<VoiceDomain> getDataObjectClass() {
            return VoiceDomain.class;
        }

        @Override
        protected void populateEntry(RbVoiceDomainsEntry entry, VoiceDomain dataObject) {
            entry.setRbVoiceDomainIdx(dataObject.getID().longValue());
            entry.setRbVoiceDomainName(dataObject.getRbVoiceDomainName());
            entry.setRbVoiceDomainPrimaryPFIpAddress(this.pfServersMap.get(dataObject.getRbVoiceDomainPrimaryPFId()));
            entry.setRbVoiceDomainSecondaryPFIpAddress("0.0.0.0");
        }

        @Override
        public List<RbVoiceDomainsEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.prefetch(eq, access);
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        private void prefetch(Equipment eq, MOAccessSession access) throws MediationException {
            List pfServersTable = access.fetchObject(null, PF.class, null, "*");
            this.pfServersMap = new TreeMap();
            for (PF pf : pfServersTable) {
                this.pfServersMap.put(pf.getID(), pf.getRbBSPFServerAddress());
            }
            this.pfServersMap.put(0, "");
        }
    }
}

