/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.model.SubscriberEntry;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.gui.configuration.services.RbServiceConfigEntryEditorView;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.SubscriberDb_Subscriber;
import com.bwanms.rb.mo.services.RbSubscriberTable;
import com.bwanms.util.BeanUtils;
import com.bwanms.util.MultipleStringList;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.7.1.1", indexColumns={"RbSubscriberIdx"})
public class RbSubscriberEntry
extends SubscriberEntry
implements Identifiable {
    private NetworkResourceConfiguration nrConfiguration;
    private String instance;
    private Long rbSubscriberIdx;
    private String rbSubscriberID;
    private String rbSubscriberFirstName;
    private String rbSubscriberLastName;
    private Integer rbSubscriberAdminStatus;
    public static final int RbSubscriberAdminStatusEnable = 1;
    public static final int RbSubscriberAdminStatusDisable = 2;
    private String rbSubscriberInfo;
    private Integer rbASubscriberRowStatus;
    public static final int RbASubscriberRowStatusActive = 1;
    public static final int RbASubscriberRowStatusNotInService = 2;
    public static final int RbASubscriberRowStatusNotReady = 3;
    public static final int RbASubscriberRowStatusCreateAndGo = 4;
    public static final int RbASubscriberRowStatusCreateAndWait = 5;
    public static final int RbASubscriberRowStatusDestroy = 6;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.7.1.1.1", type=66)
    @IdentifierAttribute
    public Long getRbSubscriberIdx() {
        return this.rbSubscriberIdx;
    }

    public void setRbSubscriberIdx(Long rbSubscriberIdx) {
        this.rbSubscriberIdx = rbSubscriberIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.7.1.1.2", type=-128)
    @ConfigAttribute
    public String getRbSubscriberID() {
        return this.rbSubscriberID;
    }

    public void setRbSubscriberID(String rbSubscriberID) {
        this.rbSubscriberID = rbSubscriberID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.7.1.1.3", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @Length(max=50)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    @ConfigAttribute
    public String getRbSubscriberFirstName() {
        return this.rbSubscriberFirstName;
    }

    public void setRbSubscriberFirstName(String rbSubscriberFirstName) {
        this.rbSubscriberFirstName = rbSubscriberFirstName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.7.1.1.4", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @Length(max=50)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    @ConfigAttribute
    public String getRbSubscriberLastName() {
        return this.rbSubscriberLastName;
    }

    public void setRbSubscriberLastName(String rbSubscriberLastName) {
        this.rbSubscriberLastName = rbSubscriberLastName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.7.1.1.5", type=2)
    @ConfigAttribute
    public Integer getRbSubscriberAdminStatus() {
        return this.rbSubscriberAdminStatus;
    }

    public void setRbSubscriberAdminStatus(Integer rbSubscriberAdminStatus) {
        this.rbSubscriberAdminStatus = rbSubscriberAdminStatus;
    }

    public static String toStringRbSubscriberAdminStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.7.1.1.6", type=-128)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @Length(max=50)
    @Pattern(regex="^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$")
    @ConfigAttribute
    public String getRbSubscriberInfo() {
        return this.rbSubscriberInfo;
    }

    public void setRbSubscriberInfo(String rbSubscriberInfo) {
        this.rbSubscriberInfo = rbSubscriberInfo;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.7.1.1.7", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbASubscriberRowStatus;
    }

    public void setRowStatus(Integer rbASubscriberRowStatus) {
        this.rbASubscriberRowStatus = rbASubscriberRowStatus;
    }

    public String toStringRbASubscriberRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSubscriberIdx=").append(this.rbSubscriberIdx).append(", ");
        result.append("rbSubscriberID=").append(this.rbSubscriberID).append(", ");
        result.append("rbSubscriberFirstName=").append(this.rbSubscriberFirstName).append(", ");
        result.append("rbSubscriberLastName=").append(this.rbSubscriberLastName).append(", ");
        result.append("rbSubscriberAdminStatus=").append(RbSubscriberEntry.toStringRbSubscriberAdminStatus(this.rbSubscriberAdminStatus)).append(", ");
        result.append("rbSubscriberInfo=").append(this.rbSubscriberInfo).append(", ");
        result.append("rbASubscriberRowStatus=").append(this.toStringRbASubscriberRowStatus(this.rbASubscriberRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbSubscriberIdx().toString();
    }

    public void validateUndeclaredConstraints(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceConfigEntryEditorView.class);
        String name = this.getRbSubscriberID();
        if (name == null || name.trim().equals("") || !name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") || name.length() > 32) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidName"), RbSubscriberEntry.class, "rbSubscriberID", (Object)name, (Object)this));
        }
    }

    public void computeAndSetComplexKey() {
        MultipleStringList attribValues = new MultipleStringList();
        attribValues.addToList(this.getRbSubscriberID());
        attribValues.addToList(this.getRbSubscriberFirstName());
        attribValues.addToList(this.getRbSubscriberLastName());
        attribValues.addToList(this.getRbSubscriberInfo());
        this.setComplexKey(attribValues.getAsString());
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSubscriberEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSubscriberEntry>(){

            public ManagedObjectAccessHandler<RbSubscriberEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSubscriberEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSubscriberEntry>(){

            public ManagedObjectAccessHandler<RbSubscriberEntry> createHandler() {
                return new RbSubscriberTableRowMOAccessHandler(RbSubscriberEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbSubscriberTableRowMOAccessHandler
    extends SNMPDynamicTableRowMOAccessHandler<RbSubscriberEntry> {
        public RbSubscriberTableRowMOAccessHandler(Class<RbSubscriberEntry> moClass) {
            super(moClass);
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbSubscriberEntry managedObject) throws MediationException {
            if (managedObject.getRbSubscriberIdx() < 0L) {
                List data = access.fetchObject(null, RbSubscriberTable.RbSubscriberGetNewEntryId.class, new String[]{"rbGetNewSubscriberId"});
                Long idx = (Long)BeanUtils.getPropertyValue(data.get(0), (String)"rbGetNewSubscriberId");
                managedObject.setRbSubscriberIdx(idx);
            }
            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbSubscriberEntry, SubscriberDb_Subscriber> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbSubscriberEntry createEntry() {
            return new RbSubscriberEntry();
        }

        @Override
        protected Class<SubscriberDb_Subscriber> getDataObjectClass() {
            return SubscriberDb_Subscriber.class;
        }

        @Override
        protected void populateEntry(RbSubscriberEntry entry, SubscriberDb_Subscriber dataObject) {
            entry.setRbSubscriberID(dataObject.getName());
            entry.setRbSubscriberIdx(dataObject.getINDEX());
            entry.setRbSubscriberFirstName(dataObject.getFirstName());
            entry.setRbSubscriberLastName(dataObject.getFamilyName());
            entry.setRbSubscriberInfo(dataObject.getSubInfo());
            entry.setRbSubscriberAdminStatus(2 == dataObject.getAdminStatus() ? 1 : 2);
        }

        @Override
        public List<RbSubscriberEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            if (null == instanceQuery || "*".equals(instanceQuery)) {
                return super.fetch(eq, access, networkResource, instanceQuery);
            }
            if (instanceQuery.contains("*")) {
                throw new UnsupportedOperationException("Config file - fetch operation wrong instance query format");
            }
            long idx = Long.parseLong(instanceQuery);
            ArrayList<RbSubscriberEntry> entries = new ArrayList<RbSubscriberEntry>();
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, this.getDataObjectClass());
            List dataObjects = access.fetchObject(networkResource, this.getDataObjectClass(), includedProperties, instanceQuery);
            for (SubscriberDb_Subscriber dataObject : dataObjects) {
                if (idx != dataObject.getINDEX()) continue;
                RbSubscriberEntry entry = this.createEntry();
                this.populateEntry(entry, dataObject);
                entries.add(entry);
                break;
            }
            return entries;
        }
    }
}

