/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.meta.filters.ExactMatchFilter;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DataObjectTableRow;
import com.bwanms.mo.DefaultNetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.util.OctetString;
import com.bwanms.validation.WeakRange;
import javax.persistence.Column;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.3.2.1", indexColumns={"RbSuServiceMacAddress", "RbSuServiceIdx"})
public class RbSuServiceConfigEntry
implements DataObjectTableRow {
    private static final long serialVersionUID = -8535006490301031102L;
    private static final Logger log = Logger.getLogger(RbSuServiceConfigEntry.class);
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private String rbSuServiceMacAddress;
    private Long rbSuServiceIdx;
    private Integer rbSuServiceRbType;
    private String rbSuServiceName;
    private Long rbSuServiceID;
    private Long rbSuSubscriberIdx;
    private Long rbSuServiceTemplateIdx;
    private String rbSuServiceTemplateName;
    private Long rbSuServiceTemplateID;
    private Long rbSuServiceSwitchingGroupIdx;
    private Integer rbSuServiceAdminStatus;
    private Integer rbSuServiceOperStatus;
    private String rbSuServiceClientSiteVLANList;
    private Integer rbSuServiceClientSiteVLANListCount;
    private Integer rbSuServiceAUSlotNumber;
    private Integer rbSuServiceVLANHybridMode;
    private Integer rbSuServiceVLANClassificationMode;
    private Integer rbSuServiceAccessVLAN;
    private Integer rbSuServiceRowStatus;
    private Integer rbSuServiceVPLID;
    public static final int RbSuServiceAdminStatusEnable = 1;
    public static final int RbSuServiceAdminStatusDisable = 2;
    public static final int RbSuServiceOperStatusUp = 1;
    public static final int RbSuServiceOperStatusDown = 2;
    public static final int RbSuServiceOperStatusUnknown = 3;
    public static final int RbSuServiceVLANHybridModeEnable = 1;
    public static final int RbSuServiceVLANHybridModeDisable = 2;
    public static final int RbSuServiceVLANClassificationModeOff = 1;
    public static final int RbSuServiceVLANClassificationModeOn = 2;
    public static final int RowStatusActive = 1;
    public static final int RowStatusNotInService = 2;
    public static final int RowStatusNotReady = 3;
    public static final int RowStatusCreateAndGo = 4;
    public static final int RowStatusCreateAndWait = 5;
    public static final int RowStatusDestroy = 6;
    private String rbSuSubscriberID;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.1", type=112)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public String getRbSuServiceMacAddress() {
        return this.rbSuServiceMacAddress;
    }

    public void setRbSuServiceMacAddress(String rbSuServiceMacAddress) {
        this.rbSuServiceMacAddress = rbSuServiceMacAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.2", type=66, readOnly=true)
    @IdentifierAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Long getRbSuServiceIdx() {
        return this.rbSuServiceIdx;
    }

    public void setRbSuServiceIdx(Long rbSuServiceIdx) {
        this.rbSuServiceIdx = rbSuServiceIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.3", type=2, readOnly=true)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuServiceRbType() {
        return this.rbSuServiceRbType;
    }

    public void setRbSuServiceRbType(Integer rbSuServiceRbType) {
        this.rbSuServiceRbType = rbSuServiceRbType;
    }

    public static String toStringRbSuServiceRbType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "rbLayerII(1)";
                break;
            }
            case 2: {
                result = "rbPPPoE(2)";
                break;
            }
            case 3: {
                result = "rbVoIP(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.4", type=-128)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public String getRbSuServiceName() {
        return this.rbSuServiceName;
    }

    public void setRbSuServiceName(String rbSuServiceName) {
        this.rbSuServiceName = rbSuServiceName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.5", type=66, readOnly=true)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Long getRbSuServiceID() {
        return this.rbSuServiceID;
    }

    public void setRbSuServiceID(Long rbSuServiceID) {
        this.rbSuServiceID = rbSuServiceID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.6", type=66)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Long getRbSuSubscriberIdx() {
        return this.rbSuSubscriberIdx;
    }

    public void setRbSuSubscriberIdx(Long rbSuSubscriberIdx) {
        this.rbSuSubscriberIdx = rbSuSubscriberIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.7", type=66)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Long getRbSuServiceTemplateIdx() {
        return this.rbSuServiceTemplateIdx;
    }

    public void setRbSuServiceTemplateIdx(Long rbSuServiceTemplateIdx) {
        this.rbSuServiceTemplateIdx = rbSuServiceTemplateIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.8", type=-128, readOnly=true)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public String getRbSuServiceTemplateName() {
        return this.rbSuServiceTemplateName;
    }

    public void setRbSuServiceTemplateName(String rbSuServiceTemplateName) {
        this.rbSuServiceTemplateName = rbSuServiceTemplateName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.9", type=66, readOnly=true)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    public Long getRbSuServiceTemplateID() {
        return this.rbSuServiceTemplateID;
    }

    public void setRbSuServiceTemplateID(Long rbSuServiceTemplateID) {
        this.rbSuServiceTemplateID = rbSuServiceTemplateID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.10", type=66, readOnly=true)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @ConfigAttribute
    public Long getRbSuServiceSwitchingGroupIdx() {
        return this.rbSuServiceSwitchingGroupIdx;
    }

    public void setRbSuServiceSwitchingGroupIdx(Long rbSuServiceSwitchingGroupIdx) {
        this.rbSuServiceSwitchingGroupIdx = rbSuServiceSwitchingGroupIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.11", type=2)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuServiceAdminStatus() {
        return this.rbSuServiceAdminStatus;
    }

    public void setRbSuServiceAdminStatus(Integer rbSuServiceAdminStatus) {
        this.rbSuServiceAdminStatus = rbSuServiceAdminStatus;
    }

    public static String toStringRbSuServiceAdminStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.12", type=2, readOnly=true)
    @StateAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuServiceOperStatus() {
        return this.rbSuServiceOperStatus;
    }

    public void setRbSuServiceOperStatus(Integer rbSuServiceOperStatus) {
        this.rbSuServiceOperStatus = rbSuServiceOperStatus;
    }

    public static String toStringRbSuServiceOperStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "up(1)";
                break;
            }
            case 2: {
                result = "down(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.13", type=4)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public String getRbSuServiceClientSiteVLANList() {
        return this.rbSuServiceClientSiteVLANList;
    }

    public void setRbSuServiceClientSiteVLANList(String rbSuServiceClientSiteVLANList) {
        this.rbSuServiceClientSiteVLANList = rbSuServiceClientSiteVLANList;
    }

    @Column(name="rbSuSrvClientSiteVLANLstCount")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.14", type=2)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuServiceClientSiteVLANListCount() {
        return this.rbSuServiceClientSiteVLANListCount;
    }

    public void setRbSuServiceClientSiteVLANListCount(Integer rbSuServiceClientSiteVLANListCount) {
        this.rbSuServiceClientSiteVLANListCount = rbSuServiceClientSiteVLANListCount;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.15", type=2, readOnly=true)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @IdentifierAttribute
    public Integer getRbSuServiceAUSlotNumber() {
        return this.rbSuServiceAUSlotNumber;
    }

    public void setRbSuServiceAUSlotNumber(Integer rbSuServiceAUSlotNumber) {
        this.rbSuServiceAUSlotNumber = rbSuServiceAUSlotNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.16", type=2)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuServiceVLANHybridMode() {
        return this.rbSuServiceVLANHybridMode;
    }

    public void setRbSuServiceVLANHybridMode(Integer rbSuServiceVLANHybridMode) {
        this.rbSuServiceVLANHybridMode = rbSuServiceVLANHybridMode;
    }

    public static String toStringRbSuServiceVLANHybridMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.17", type=2)
    @Column(name="rbSuSvcVLANClassificationMode")
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuServiceVLANClassificationMode() {
        return this.rbSuServiceVLANClassificationMode;
    }

    public void setRbSuServiceVLANClassificationMode(Integer rbSuServiceVLANClassificationMode) {
        this.rbSuServiceVLANClassificationMode = rbSuServiceVLANClassificationMode;
    }

    public static String toStringRbSuServiceVLANClassificationMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "off(1)";
                break;
            }
            case 2: {
                result = "on(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.18", type=2)
    @WeakRange(min=0L, max=4095L)
    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbSuServiceAccessVLAN() {
        return this.rbSuServiceAccessVLAN;
    }

    public void setRbSuServiceAccessVLAN(Integer rbSuServiceAccessVLAN) {
        this.rbSuServiceAccessVLAN = rbSuServiceAccessVLAN;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.19", type=2)
    @Transient
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRowStatus() {
        return this.rbSuServiceRowStatus;
    }

    public void setRowStatus(Integer rbSuServiceRowStatus) {
        this.rbSuServiceRowStatus = rbSuServiceRowStatus;
    }

    public static String toStringRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.2.1.20", type=2, readOnly=true)
    @WeakRange(min=0L, max=4095L)
    @StateAttribute
    @Filter(filterClass=ExactMatchFilter.class, values={"switchingMode", "2"})
    public Integer getRbSuServiceVPLID() {
        return this.rbSuServiceVPLID;
    }

    public void setRbSuServiceVPLID(Integer rbSuServiceVPLID) {
        this.rbSuServiceVPLID = rbSuServiceVPLID;
    }

    public String getRbSuSubscriberID() {
        return this.rbSuSubscriberID;
    }

    public void setRbSuSubscriberID(String rbSuSubscriberID) {
        this.rbSuSubscriberID = rbSuSubscriberID;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbSuServiceMacAddress=").append(this.rbSuServiceMacAddress).append(", ");
        result.append("rbSuServiceIdx=").append(this.rbSuServiceIdx).append(", ");
        result.append("rbSuServiceRbType=").append(RbSuServiceConfigEntry.toStringRbSuServiceRbType(this.rbSuServiceRbType)).append(", ");
        result.append("rbSuServiceName=").append(this.rbSuServiceName).append(", ");
        result.append("rbSuServiceID=").append(this.rbSuServiceID).append(", ");
        result.append("rbSuSubscriberIdx=").append(this.rbSuSubscriberIdx).append(", ");
        result.append("rbSuServiceTemplateIdx=").append(this.rbSuServiceTemplateIdx).append(", ");
        result.append("rbSuServiceTemplateName=").append(this.rbSuServiceTemplateName).append(", ");
        result.append("rbSuServiceTemplateID=").append(this.rbSuServiceTemplateID).append(", ");
        result.append("rbSuServiceSwitchingGroupIdx=").append(this.rbSuServiceSwitchingGroupIdx).append(", ");
        result.append("rbSuServiceAdminStatus=").append(RbSuServiceConfigEntry.toStringRbSuServiceAdminStatus(this.rbSuServiceAdminStatus)).append(", ");
        result.append("rbSuServiceOperStatus=").append(RbSuServiceConfigEntry.toStringRbSuServiceOperStatus(this.rbSuServiceOperStatus)).append(", ");
        result.append("rbSuServiceClientSiteVLANList=").append(this.rbSuServiceClientSiteVLANList).append(", ");
        result.append("rbSuServiceClientSiteVLANListCount=").append(this.rbSuServiceClientSiteVLANListCount).append(", ");
        result.append("rbSuServiceAUSlotNumber=").append(this.rbSuServiceAUSlotNumber).append(", ");
        result.append("rbSuServiceVLANHybridMode=").append(RbSuServiceConfigEntry.toStringRbSuServiceVLANHybridMode(this.rbSuServiceVLANHybridMode)).append(", ");
        result.append("rbSuServiceVLANClassificationMode=").append(RbSuServiceConfigEntry.toStringRbSuServiceVLANClassificationMode(this.rbSuServiceVLANClassificationMode)).append(", ");
        result.append("rbSuServiceAccessVLAN=").append(this.rbSuServiceAccessVLAN).append(", ");
        result.append("rbSuServiceRowStatus=").append(RbSuServiceConfigEntry.toStringRowStatus(this.rbSuServiceRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbSuServiceIdx().toString();
    }

    @Transient
    public String getRbSuServiceClientSiteVLANListAsString() {
        StringBuffer ret = new StringBuffer();
        int[] ids = OctetString.fromOctetString((String)this.getRbSuServiceClientSiteVLANList());
        StringBuffer buf = new StringBuffer();
        if (ids != null) {
            for (int i : ids) {
                String temp = Integer.toBinaryString(i);
                for (int i2 = 0; i2 < 8 - temp.length(); ++i2) {
                    buf.append("0");
                }
                buf.append(temp);
            }
            String vlanList = buf.toString();
            for (int i = 0; i < 16; ++i) {
                ret.append(Integer.toString(Integer.parseInt(vlanList.substring(i * 12, (i + 1) * 12), 2)));
                ret.append(",");
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                ret.append("0,");
            }
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    public void setRbSuServiceClientSiteVLANListAsString(String vlanList) {
        String[] parts = vlanList.split(",");
        if (parts.length != 16) {
            throw new RuntimeException("Invalid VLAN List count");
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            int part = "".equals(parts[i]) ? 0 : Integer.parseInt(parts[i]);
            String binary = Integer.toBinaryString(part);
            if (binary.length() > 12) {
                throw new RuntimeException("Invalid VLAN Value: " + part);
            }
            for (int j = 0; j < 12 - binary.length(); ++j) {
                buf.append("0");
            }
            buf.append(binary);
        }
        String bits = buf.toString();
        int[] bytes = new int[24];
        for (int i = 0; i < 24; ++i) {
            bytes[i] = Integer.parseInt(bits.substring(i * 8, (i + 1) * 8), 2);
        }
        this.setRbSuServiceClientSiteVLANList(OctetString.toOctetString((int[])bytes));
    }

    @Transient
    public boolean isTemporary() {
        return this.id != 0L && this.rbSuSubscriberIdx == 0L;
    }

    static {
        NetworkDomainObjectAccessHandlerRegistry.registerHandler(RbSuServiceConfigEntry.class, RbConfigFile.class, (NetworkDomainObjectAccessHandler)new DefaultNetworkDomainObjectAccessHandler(RbSuServiceConfigEntry.class));
        NetworkDomainObjectAccessHandlerRegistry.registerHandler(RbSuServiceConfigEntry.class, SNMP.class, (NetworkDomainObjectAccessHandler)new DefaultNetworkDomainObjectAccessHandler(RbSuServiceConfigEntry.class));
    }
}

