/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorView;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.SwitchingModeAndVersionFilter;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.ForwardingRulesDb_ForwardingRules;
import com.bwanms.rb.mo.configfile.PriorityClassProfileDb_PriorityClassProfile;
import com.bwanms.rb.mo.configfile.ServiceProfileDb_ServiceProfile;
import com.bwanms.rb.mo.configfile.SwitchingMode_Appl;
import com.bwanms.rb.mo.configfile.VoiceDomain;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbServiceProfiles;
import com.bwanms.rb.mo.services.RbServiceProfilesGetNewEntryId;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.MultipleStringList;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import com.bwanms.validation.WeakRange;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.2.1.1", indexColumns={"RbServiceTemplateType", "RbServiceTemplateIdx"})
@Table(name="RbServiceTemplateConfigEntry", indexes={@Index(name="IDX_RBSVCTEMPLATE_NRCFGID", columnNames={"nrConfigId"}), @Index(name="IDX_RBSVCTEMPLATE_COMPLEX", columnNames={"complexKey1", "complexKey2", "complexKey3"})})
public class RbServiceTemplateConfigEntry
extends DynamicTableRowMO
implements Identifiable {
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private String instance;
    private Integer rbServiceTemplateType;
    private Long rbServiceTemplateIdx;
    private String rbServiceTemplateName;
    private Long rbServiceTemplateID;
    private Integer rbServiceTemplateBaseVLAN;
    private Integer rbServiceTemplateNumberOfSimultaneousCalls;
    private Long rbServiceTemplatePolicyRuleIdx;
    private Long rbServiceTemplateForwardingRuleIdx;
    private Integer rbAServiceTemplateRowStatus;
    public static final int RbAServiceTemplateRowStatusActive = 1;
    public static final int RbAServiceTemplateRowStatusNotInService = 2;
    public static final int RbAServiceTemplateRowStatusNotReady = 3;
    public static final int RbAServiceTemplateRowStatusCreateAndGo = 4;
    public static final int RbAServiceTemplateRowStatusCreateAndWait = 5;
    public static final int RbAServiceTemplateRowStatusDestroy = 6;
    private Integer rbServiceTemplateQoSMarkingMode;
    public static final int RbServiceTemplateQoSMarkingModeTransparent = 1;
    public static final int RbServiceTemplateQoSMarkingModeRb8021p = 2;
    public static final int RbServiceTemplateQoSMarkingModeRbDSCP = 3;
    public static final int RbServiceTemplateQoSMarkingMode_NotApplicable = 4;
    private Integer rbServiceTemplateQoSMarkingValue;
    public static final Integer RbServiceTemplateQoSMarkingValue_NotApplicable = 255;
    public static final int RbServiceTemplateVLANTransparencyModeEnabled = 1;
    public static final int RbServiceTemplateVLANTransparencyModeDisabled = 2;
    private Integer rbServiceTemplateVLANTransparencyMode;
    public static final int RbServiceTemplateClassLocal = 1;
    public static final int RbServiceTemplateClassGlobal = 2;
    private Integer rbServiceTemplateClass;
    private Long rbServiceTemplateVoiceDomainIdx;
    private String rbServiceTemplateVoiceDomainName;
    private String rbServiceTemplateGroupName;
    private String complexKey1;
    private String complexKey2;
    private String complexKey3;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.1", type=2, readOnly=true)
    @ConfigAttribute
    public Integer getRbServiceTemplateType() {
        return this.rbServiceTemplateType;
    }

    public void setRbServiceTemplateType(Integer rbServiceTemplateType) {
        this.rbServiceTemplateType = rbServiceTemplateType;
    }

    public static String toStringRbServiceTemplateType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "rbLayerII(1)";
                break;
            }
            case 2: {
                result = "rbPPPoE(2)";
                break;
            }
            case 3: {
                result = "rbVoIP(3)";
                break;
            }
            case 4: {
                result = "rbIPModeData(4)";
                break;
            }
            case 5: {
                result = "rbIPModeVoIP(5)";
                break;
            }
            case 6: {
                result = "rbManaged-VoIP(6)";
                break;
            }
            case 7: {
                result = "rbIPmode-Managed-VoIP(7)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.2", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbServiceTemplateIdx() {
        return this.rbServiceTemplateIdx;
    }

    public void setRbServiceTemplateIdx(Long rbServiceTemplateIdx) {
        this.rbServiceTemplateIdx = rbServiceTemplateIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.3", type=-128)
    @ConfigAttribute
    public String getRbServiceTemplateName() {
        return this.rbServiceTemplateName;
    }

    public void setRbServiceTemplateName(String rbServiceTemplateName) {
        this.rbServiceTemplateName = rbServiceTemplateName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.4", type=66, readOnly=true)
    @ConfigAttribute
    public Long getRbServiceTemplateID() {
        return this.rbServiceTemplateID;
    }

    public void setRbServiceTemplateID(Long rbServiceTemplateID) {
        this.rbServiceTemplateID = rbServiceTemplateID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.5", type=2)
    @WeakRange(min=0L, max=4096L)
    @Column(name="rbServiceTmplBaseVLAN")
    @ConfigAttribute
    public Integer getRbServiceTemplateBaseVLAN() {
        return this.rbServiceTemplateBaseVLAN;
    }

    public void setRbServiceTemplateBaseVLAN(Integer rbServiceTemplateBaseVLAN) {
        this.rbServiceTemplateBaseVLAN = rbServiceTemplateBaseVLAN;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.9", type=2)
    @WeakRange(min=0L, max=50L)
    @Column(name="rbServiceTmplNrOfParallCalls")
    @ConfigAttribute
    public Integer getRbServiceTemplateNumberOfSimultaneousCalls() {
        return this.rbServiceTemplateNumberOfSimultaneousCalls;
    }

    public void setRbServiceTemplateNumberOfSimultaneousCalls(Integer rbServiceTemplateNumberOfSimultaneousCalls) {
        this.rbServiceTemplateNumberOfSimultaneousCalls = rbServiceTemplateNumberOfSimultaneousCalls;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.10", type=66)
    @Column(name="rbServiceTmplPolicyRuleIdx")
    @ConfigAttribute
    public Long getRbServiceTemplatePolicyRuleIdx() {
        return this.rbServiceTemplatePolicyRuleIdx;
    }

    public void setRbServiceTemplatePolicyRuleIdx(Long rbServiceTemplatePolicyRuleIdx) {
        this.rbServiceTemplatePolicyRuleIdx = rbServiceTemplatePolicyRuleIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.12", type=66)
    @Column(name="rbServiceTmplForwardRuleIdx")
    @ConfigAttribute
    public Long getRbServiceTemplateForwardingRuleIdx() {
        return this.rbServiceTemplateForwardingRuleIdx;
    }

    public void setRbServiceTemplateForwardingRuleIdx(Long rbServiceTemplateForwardingRuleIdx) {
        this.rbServiceTemplateForwardingRuleIdx = rbServiceTemplateForwardingRuleIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.14", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbAServiceTemplateRowStatus;
    }

    public void setRowStatus(Integer rbAServiceTemplateRowStatus) {
        this.rbAServiceTemplateRowStatus = rbAServiceTemplateRowStatus;
    }

    public String toStringRbAServiceTemplateRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.15", type=2)
    @Column(name="rbServiceTmplQoSMarkingMode")
    @ConfigAttribute
    public Integer getRbServiceTemplateQoSMarkingMode() {
        return this.rbServiceTemplateQoSMarkingMode;
    }

    public void setRbServiceTemplateQoSMarkingMode(Integer rbServiceTemplateQoSMarkingMode) {
        this.rbServiceTemplateQoSMarkingMode = rbServiceTemplateQoSMarkingMode;
    }

    public static String toStringRbServiceTemplateQoSMarkingMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "transparent(1)";
                break;
            }
            case 2: {
                result = "rb8021p(2)";
                break;
            }
            case 3: {
                result = "rbDSCP(3)";
                break;
            }
            case 4: {
                result = "rbNotApplicable(4)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.16", type=2)
    @Column(name="rbServiceTmplQoSMarkingValue")
    @ConfigAttribute
    public Integer getRbServiceTemplateQoSMarkingValue() {
        return this.rbServiceTemplateQoSMarkingValue;
    }

    public void setRbServiceTemplateQoSMarkingValue(Integer rbServiceTemplateQoSMarkingValue) {
        this.rbServiceTemplateQoSMarkingValue = rbServiceTemplateQoSMarkingValue;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.17", type=2)
    @Column(name="rbServiceTmplVLANTransMode")
    @ConfigAttribute
    public Integer getRbServiceTemplateVLANTransparencyMode() {
        return this.rbServiceTemplateVLANTransparencyMode;
    }

    public void setRbServiceTemplateVLANTransparencyMode(Integer rbServiceTemplateVLANTransparencyMode) {
        this.rbServiceTemplateVLANTransparencyMode = rbServiceTemplateVLANTransparencyMode;
    }

    public static String toStringRbServiceTemplateVLANTransparencyMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "on(1)";
                break;
            }
            case 2: {
                result = "off(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.18", type=2)
    @Column(name="rbServiceTemplateClass")
    @InventoryAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbServiceTemplateClass() {
        return this.rbServiceTemplateClass;
    }

    public void setRbServiceTemplateClass(Integer rbServiceTemplateClass) {
        this.rbServiceTemplateClass = rbServiceTemplateClass;
    }

    public static String toStringRbServiceTemplateClass(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "local(1)";
                break;
            }
            case 2: {
                result = "global(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @ConfigAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.19", type=66)
    @Column(name="rbServiceTemplVPLDomainIdx")
    public Long getRbServiceTemplateVoiceDomainIdx() {
        return this.rbServiceTemplateVoiceDomainIdx;
    }

    public void setRbServiceTemplateVoiceDomainIdx(Long rbServiceTemplateVPLDomainIdx) {
        this.rbServiceTemplateVoiceDomainIdx = rbServiceTemplateVPLDomainIdx;
    }

    @InventoryAttribute
    @Length(min=0, max=32)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.2"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.20", type=-128, readOnly=true)
    @Column(name="rbServiceTemplVPLDomainName")
    public String getRbServiceTemplateVoiceDomainName() {
        return this.rbServiceTemplateVoiceDomainName;
    }

    public void setRbServiceTemplateVoiceDomainName(String rbServiceTemplateVPLDomainName) {
        this.rbServiceTemplateVoiceDomainName = rbServiceTemplateVPLDomainName;
    }

    @ConfigAttribute
    @Filter(filterClass=SwitchingModeAndVersionFilter.class, values={"switchingMode", "2", "softwareVersion", ">=4.5"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.2.1.1.21", type=-128)
    @Column(name="rbServiceTemplateGroupName")
    public String getRbServiceTemplateGroupName() {
        return this.rbServiceTemplateGroupName;
    }

    public void setRbServiceTemplateGroupName(String rbServiceTemplateGroupName) {
        this.rbServiceTemplateGroupName = rbServiceTemplateGroupName;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbServiceTemplateType=").append(RbServiceTemplateConfigEntry.toStringRbServiceTemplateType(this.rbServiceTemplateType)).append(", ");
        result.append("rbServiceTemplateIdx=").append(this.rbServiceTemplateIdx).append(", ");
        result.append("rbServiceTemplateName=").append(this.rbServiceTemplateName).append(", ");
        result.append("rbServiceTemplateID=").append(this.rbServiceTemplateID).append(", ");
        result.append("rbServiceTemplateBaseVLAN=").append(this.rbServiceTemplateBaseVLAN).append(", ");
        result.append("rbServiceTemplateNumberOfSimultaneousCalls=").append(this.rbServiceTemplateNumberOfSimultaneousCalls).append(", ");
        result.append("rbServiceTemplatePolicyRuleIdx=").append(this.rbServiceTemplatePolicyRuleIdx).append(", ");
        result.append("rbServiceTemplateForwardingRuleIdx=").append(this.rbServiceTemplateForwardingRuleIdx).append(", ");
        result.append("rbAServiceTemplateRowStatus=").append(this.toStringRbAServiceTemplateRowStatus(this.rbAServiceTemplateRowStatus)).append(", ");
        result.append("rbServiceTemplateQoSMarkingMode=").append(RbServiceTemplateConfigEntry.toStringRbServiceTemplateQoSMarkingMode(this.rbServiceTemplateQoSMarkingMode)).append(", ");
        result.append("rbServiceTemplateQoSMarkingValue=").append(this.rbServiceTemplateQoSMarkingValue).append(", ");
        result.append("rbServiceTemplateClass=").append(this.rbServiceTemplateClass);
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return RbServiceTemplateConfigEntry.getRowKeyByTypeAndIndex(this.getRbServiceTemplateType(), this.getRbServiceTemplateIdx());
    }

    public static String getRowKeyByTypeAndIndex(Integer serviceTemplateType, Long serviceTemplateIdx) {
        return -1L != serviceTemplateIdx ? serviceTemplateType.toString() + "." + serviceTemplateIdx.toString() : "-1";
    }

    public void validateUndeclaredConstraints(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileEditorView.class);
        String name = this.getRbServiceTemplateName();
        if (name == null || name.trim().equals("")) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidName"), RbServiceTemplateConfigEntry.class, "rbServiceTemplateName", (Object)"", (Object)this));
        } else if (!name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") || name.length() > 32) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidName"), RbServiceTemplateConfigEntry.class, "rbServiceTemplateName", (Object)name, (Object)this));
        }
        if (this.rbServiceTemplateQoSMarkingMode != null) {
            switch (this.rbServiceTemplateQoSMarkingMode) {
                case 1: {
                    if (this.rbServiceTemplateQoSMarkingValue == 0) break;
                    this.rbServiceTemplateQoSMarkingValue = 0;
                    break;
                }
                case 2: {
                    if (this.rbServiceTemplateQoSMarkingValue >= 0 && this.rbServiceTemplateQoSMarkingValue <= 7) break;
                    invalidValues.add(new InvalidValue("Value not in range [0..7]", RbServiceTemplateConfigEntry.class, "rbServiceTemplateQoSMarkingValue", (Object)this.rbServiceTemplateQoSMarkingValue, (Object)this));
                    break;
                }
                case 3: {
                    if (this.rbServiceTemplateQoSMarkingValue >= 0 && this.rbServiceTemplateQoSMarkingValue <= 63) break;
                    invalidValues.add(new InvalidValue("Value not in range [0..63]", RbServiceTemplateConfigEntry.class, "rbServiceTemplateQoSMarkingValue", (Object)this.rbServiceTemplateQoSMarkingValue, (Object)this));
                }
            }
        } else {
            invalidValues.add(new InvalidValue("Value not in range [0..63]", RbServiceTemplateConfigEntry.class, "rbServiceTemplateQoSMarkingValue", (Object)this.rbServiceTemplateQoSMarkingValue, (Object)this));
        }
        if (!(this.rbServiceTemplatePolicyRuleIdx != null && this.rbServiceTemplatePolicyRuleIdx != 0L || Integer.valueOf(3).equals(this.rbServiceTemplateType))) {
            invalidValues.add(new InvalidValue(i18n.translateString("policyRuleNotNull"), RbServiceTemplateConfigEntry.class, "rbServiceTemplatePolicyRuleIdx", (Object)"", (Object)this));
        }
        if (this.rbServiceTemplateForwardingRuleIdx == null || this.rbServiceTemplateForwardingRuleIdx == 0L) {
            invalidValues.add(new InvalidValue(i18n.translateString("forwardingRuleNotNull"), RbServiceTemplateConfigEntry.class, "rbServiceTemplateForwardingRuleIdx", (Object)"", (Object)this));
        }
    }

    public static int getRbServiceTypeFromConfigFileType(int cfgFileServiceType, boolean ipSwitchingMode) {
        if (ipSwitchingMode) {
            switch (cfgFileServiceType) {
                case 1: {
                    return 5;
                }
                case 3: {
                    return 4;
                }
                case 7: {
                    return 7;
                }
            }
        } else {
            switch (cfgFileServiceType) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 6;
                }
            }
        }
        return 0;
    }

    @Transient
    public String getComplexKey() {
        StringBuffer ret = new StringBuffer();
        if (null != this.getComplexKey1() && !"_".equals(this.complexKey1)) {
            ret.append(this.complexKey1);
        }
        if (null != this.getComplexKey2() && !"_".equals(this.complexKey2)) {
            ret.append(this.complexKey2);
        }
        if (null != this.getComplexKey3() && !"_".equals(this.complexKey3)) {
            ret.append(this.complexKey3);
        }
        return ret.length() > 0 ? ret.toString() : null;
    }

    public void setComplexKey(String complexKey) {
        this.setComplexKey1(null != complexKey && complexKey.length() > 0 ? complexKey.substring(0, Math.min(255, complexKey.length())) : "_");
        this.setComplexKey2(null != complexKey && complexKey.length() > 255 ? complexKey.substring(255, Math.min(510, complexKey.length())) : "_");
        this.setComplexKey3(null != complexKey && complexKey.length() > 510 ? complexKey.substring(510, Math.min(765, complexKey.length())) : "_");
    }

    @Length(max=255)
    public String getComplexKey1() {
        return this.complexKey1;
    }

    public void setComplexKey1(String complexKey1) {
        this.complexKey1 = complexKey1;
    }

    @Length(max=255)
    public String getComplexKey2() {
        return this.complexKey2;
    }

    public void setComplexKey2(String complexKey2) {
        this.complexKey2 = complexKey2;
    }

    @Length(max=255)
    public String getComplexKey3() {
        return this.complexKey3;
    }

    public void setComplexKey3(String complexKey3) {
        this.complexKey3 = complexKey3;
    }

    public void computeAndSetComplexKey(RbServiceProfiles serviceProfiles, boolean deep) {
        MultipleStringList attribValues = new MultipleStringList();
        Integer rbServTemplType = this.getRbServiceTemplateType();
        if (rbServTemplType == 4 || rbServTemplType == 5 || Integer.valueOf(7).equals(rbServTemplType)) {
            attribValues.addToList(this.getRbServiceTemplateName());
            attribValues.addToList(rbServTemplType);
            RbPolicyRuleConfigEntry policyEntry = null;
            if (this.getRbServiceTemplatePolicyRuleIdx() != null) {
                policyEntry = serviceProfiles.findPolicyRuleEntry(this.getRbServiceTemplatePolicyRuleIdx());
            }
            if (null == policyEntry) {
                attribValues.addStringListToList(RbPolicyRuleConfigEntry.getDefaultNullComplexKey());
            } else {
                if (deep) {
                    policyEntry.computeAndSetComplexKey(serviceProfiles, true);
                }
                attribValues.addStringListToList(policyEntry.getComplexKey());
            }
            if (rbServTemplType == 4) {
                attribValues.addToList(this.getRbServiceTemplateGroupName());
            }
            if (Integer.valueOf(7).equals(rbServTemplType)) {
                attribValues.addToList(this.getRbServiceTemplateNumberOfSimultaneousCalls());
                attribValues.addToList(this.getRbServiceTemplateVoiceDomainName());
            }
        } else {
            RbForwardingRuleConfigEntry forwardingEntry;
            attribValues.addToList(this.getRbServiceTemplateName());
            attribValues.addToList(rbServTemplType);
            attribValues.addToList(this.getRbServiceTemplateBaseVLAN());
            attribValues.addToList(this.getRbServiceTemplateVLANTransparencyMode());
            attribValues.addToList(this.getRbServiceTemplateQoSMarkingMode());
            if (null != this.getRbServiceTemplateQoSMarkingMode()) {
                attribValues.addToList(1 != this.getRbServiceTemplateQoSMarkingMode() ? this.getRbServiceTemplateQoSMarkingValue() : (Integer)null);
            } else {
                attribValues.addToList((Integer)null);
            }
            attribValues.addToList(2 != rbServTemplType ? this.getRbServiceTemplateNumberOfSimultaneousCalls() : (Integer)null);
            RbForwardingRuleConfigEntry rbForwardingRuleConfigEntry = forwardingEntry = 1 != this.getRbServiceTemplateVLANTransparencyMode() ? serviceProfiles.findForwardingRuleEntry(this.getRbServiceTemplateForwardingRuleIdx()) : null;
            if (null == forwardingEntry) {
                attribValues.addStringListToList(RbForwardingRuleConfigEntry.getDefaultNullComplexKey());
            } else {
                if (deep) {
                    forwardingEntry.computeAndSetComplexKey(serviceProfiles, true);
                }
                attribValues.addStringListToList(forwardingEntry.getComplexKey());
            }
            RbPolicyRuleConfigEntry policyEntry = null;
            if (this.getRbServiceTemplatePolicyRuleIdx() != null) {
                policyEntry = serviceProfiles.findPolicyRuleEntry(this.getRbServiceTemplatePolicyRuleIdx());
            }
            if (null == policyEntry) {
                attribValues.addStringListToList(RbPolicyRuleConfigEntry.getDefaultNullComplexKey());
            } else {
                if (deep) {
                    policyEntry.computeAndSetComplexKey(serviceProfiles, true);
                }
                attribValues.addStringListToList(policyEntry.getComplexKey());
            }
            if (Integer.valueOf(6).equals(rbServTemplType)) {
                attribValues.addToList(this.getRbServiceTemplateVoiceDomainName());
            }
        }
        this.setComplexKey(attribValues.getAsString());
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbServiceTemplateConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbServiceTemplateConfigEntry>(){

            public ManagedObjectAccessHandler<RbServiceTemplateConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbServiceTemplateConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbServiceTemplateConfigEntry>(){

            public ManagedObjectAccessHandler<RbServiceTemplateConfigEntry> createHandler() {
                return new RbServiceTemplConfigTableRowMOAccessHandler(RbServiceTemplateConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbServiceTemplConfigTableRowMOAccessHandler
    extends SNMPDynamicTableRowMOAccessHandler<RbServiceTemplateConfigEntry> {
        public RbServiceTemplConfigTableRowMOAccessHandler(Class<RbServiceTemplateConfigEntry> moClass) {
            super(moClass);
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbServiceTemplateConfigEntry managedObject) throws MediationException {
            if (null != managedObject.getRbServiceTemplatePolicyRuleIdx() && 0L == managedObject.getRbServiceTemplatePolicyRuleIdx()) {
                managedObject.setRbServiceTemplatePolicyRuleIdx(null);
            }
            if (null != managedObject.getRbServiceTemplateVoiceDomainIdx() && 0L == managedObject.getRbServiceTemplateVoiceDomainIdx()) {
                managedObject.setRbServiceTemplateVoiceDomainIdx(null);
            }
            if (((RbBaseStationEquipment)eq).getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
                managedObject.setRbServiceTemplateForwardingRuleIdx(null);
                managedObject.setRbServiceTemplateQoSMarkingMode(null);
                managedObject.setRbServiceTemplateVLANTransparencyMode(null);
                managedObject.setRbServiceTemplateBaseVLAN(null);
                managedObject.setRbServiceTemplateQoSMarkingValue(null);
            }
            if (!managedObject.getRbServiceTemplateType().equals(4)) {
                managedObject.setRbServiceTemplateGroupName(null);
            }
            if (managedObject.getRbServiceTemplateType().equals(2) || managedObject.getRbServiceTemplateType().equals(5)) {
                managedObject.setRbServiceTemplateNumberOfSimultaneousCalls(null);
            }
            super.update(eq, access, networkResource, (ManagedObject)managedObject);
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbServiceTemplateConfigEntry managedObject) throws MediationException {
            if (managedObject.getRbServiceTemplateIdx() < 0L) {
                Long idx = RbServiceProfilesGetNewEntryId.getNewIdxReplacement(access, "rbGetNewServiceProfileId");
                managedObject.setRbServiceTemplateIdx(idx);
            }
            if (null != managedObject.getRbServiceTemplatePolicyRuleIdx() && 0L == managedObject.getRbServiceTemplatePolicyRuleIdx()) {
                managedObject.setRbServiceTemplatePolicyRuleIdx(null);
            }
            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbServiceTemplateConfigEntry, ServiceProfileDb_ServiceProfile> {
        private TreeMap<Integer, Long> fwRuleIdIdxMap;
        private TreeMap<Integer, Long> priorityIdIdxMap;
        private TreeMap<Integer, String> voiceDomainIdNameMap;
        private boolean ipSwitchingMode;
        private boolean isSGAvailable = false;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbServiceTemplateConfigEntry createEntry() {
            return new RbServiceTemplateConfigEntry();
        }

        @Override
        protected Class<ServiceProfileDb_ServiceProfile> getDataObjectClass() {
            return ServiceProfileDb_ServiceProfile.class;
        }

        private void prefetch(Equipment eq, MOAccessSession access) throws MediationException {
            SwitchingMode_Appl sm;
            RbBaseStationEquipment bsEq = (RbBaseStationEquipment)eq;
            this.ipSwitchingMode = bsEq.getSoftwareVersion().isNewerOrEqualWith((Version)new DefaultVersion("4.1.1")) ? RbBSSwitchingModeParameters.SWITCHING_MODE_IP_CS == (sm = (SwitchingMode_Appl)access.fetchObject(null, SwitchingMode_Appl.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SwitchingMode_Appl.class), "*").get(0)).getActualProdType() : false;
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, ForwardingRulesDb_ForwardingRules.class);
            List fwRules = access.fetchObject(null, ForwardingRulesDb_ForwardingRules.class, includedProperties, "*");
            includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, PriorityClassProfileDb_PriorityClassProfile.class);
            List priorityClasses = access.fetchObject(null, PriorityClassProfileDb_PriorityClassProfile.class, includedProperties, "*");
            this.fwRuleIdIdxMap = new TreeMap();
            this.priorityIdIdxMap = new TreeMap();
            for (ForwardingRulesDb_ForwardingRules fwRule : fwRules) {
                this.fwRuleIdIdxMap.put(fwRule.getID(), fwRule.getINDEX());
            }
            this.fwRuleIdIdxMap.put(0, 0L);
            for (PriorityClassProfileDb_PriorityClassProfile priority : priorityClasses) {
                this.priorityIdIdxMap.put(priority.getID(), priority.getINDEX());
            }
            this.priorityIdIdxMap.put(0, 0L);
            if (RbFeatures.isSipAwareAvailable(bsEq)) {
                List voiceDomainList = access.fetchObject(null, VoiceDomain.class, null, "*");
                this.voiceDomainIdNameMap = new TreeMap();
                for (VoiceDomain vd : voiceDomainList) {
                    this.voiceDomainIdNameMap.put(vd.getID(), vd.getRbVoiceDomainName());
                }
                this.voiceDomainIdNameMap.put(0, "");
            }
            if (RbVersions.V_4_5.isOlderOrEqualWith(bsEq.getSoftwareVersion()) && bsEq.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
                this.isSGAvailable = true;
            }
        }

        @Override
        public List<RbServiceTemplateConfigEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.prefetch(eq, access);
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        @Override
        protected void populateEntry(RbServiceTemplateConfigEntry entry, ServiceProfileDb_ServiceProfile dataObject) {
            entry.setRbServiceTemplateID(dataObject.getID().longValue());
            entry.setRbServiceTemplateIdx(dataObject.getINDEX());
            entry.setRbServiceTemplateName(dataObject.getName());
            entry.setRbServiceTemplateType(RbServiceTemplateConfigEntry.getRbServiceTypeFromConfigFileType(dataObject.getServiceType(), this.ipSwitchingMode));
            entry.setRbServiceTemplateForwardingRuleIdx(this.fwRuleIdIdxMap.get(dataObject.getForwardingRuleId()));
            entry.setRbServiceTemplatePolicyRuleIdx(this.priorityIdIdxMap.get(dataObject.getPriorityClassProfileId()));
            entry.setRbServiceTemplateQoSMarkingMode(dataObject.getPriorityMode());
            entry.setRbServiceTemplateQoSMarkingValue(dataObject.getPriorityValue());
            entry.setRbServiceTemplateBaseVLAN(dataObject.getVPLID());
            entry.setRbServiceTemplateVLANTransparencyMode(dataObject.getTransparentMode() == 2 ? 1 : 2);
            entry.setRbServiceTemplateNumberOfSimultaneousCalls(dataObject.getMaxNumOfCalls());
            entry.setRbServiceTemplateVoiceDomainIdx(dataObject.getVoiceDomainId() == null ? null : Long.valueOf(dataObject.getVoiceDomainId().longValue()));
            if (null != dataObject.getLock()) {
                entry.setRbServiceTemplateClass(0 == dataObject.getLock() ? 1 : 2);
            }
            if (this.voiceDomainIdNameMap != null) {
                entry.setRbServiceTemplateVoiceDomainName(this.voiceDomainIdNameMap.get(dataObject.getVoiceDomainId()));
            }
            if (this.isSGAvailable) {
                entry.setRbServiceTemplateGroupName(dataObject.getServiceGroupName());
            }
        }
    }
}

