/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.domain.logic.ConfigurationHelper;
import com.bwanms.mediation.MediationException;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbBSPFServersTable;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigTable;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigTable;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigTable;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceGroupTable;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceProfiles {
    private RbServiceTemplateConfigTable serviceTemplateConfigTable;
    private RbPolicyRuleConfigTable policyRuleConfigTable;
    private RbForwardingRuleConfigTable forwardingRuleConfigTable;
    private RbQoSProfileConfigTable qosProfileConfigTable;
    private RbVoiceDomainsTable voiceDomainConfigTable;
    private RbServiceGroupTable serviceGroupConfigTable;
    private RbBSPFServersTable pfServerConfigTable;
    private NetworkResourceConfiguration NRConfiguration;

    public RbServiceProfiles(NetworkResourceConfiguration nrConfig) {
        this(nrConfig.retrieveManagedObjects(RbServiceTemplateConfigEntry.class, "*"), nrConfig.retrieveManagedObjects(RbForwardingRuleConfigEntry.class, "*"), nrConfig.retrieveManagedObjects(RbPolicyRuleConfigEntry.class, "*"), nrConfig.retrieveManagedObjects(RbQoSProfileConfigEntry.class, "*"), nrConfig.retrieveManagedObjects(RbVoiceDomainsEntry.class, "*"), nrConfig.retrieveManagedObjects(RbServiceGroupEntry.class, "*"), nrConfig.retrieveManagedObjects(RbBSPFServersEntry.class, "*"));
        this.NRConfiguration = nrConfig;
    }

    public RbServiceProfiles(List<RbServiceTemplateConfigEntry> serviceTemplateConfigEntries, List<RbForwardingRuleConfigEntry> forwardingRuleConfigEntries, List<RbPolicyRuleConfigEntry> policyRuleConfigEntries, List<RbQoSProfileConfigEntry> qosProfileConfigEntries, List<RbVoiceDomainsEntry> voiceDomainConfigEntries, List<RbServiceGroupEntry> serviceGroupConfigEntries, List<RbBSPFServersEntry> pfServerConfigEntries) {
        this.serviceTemplateConfigTable = new RbServiceTemplateConfigTable(serviceTemplateConfigEntries);
        this.forwardingRuleConfigTable = new RbForwardingRuleConfigTable(forwardingRuleConfigEntries);
        this.policyRuleConfigTable = new RbPolicyRuleConfigTable(policyRuleConfigEntries);
        this.qosProfileConfigTable = new RbQoSProfileConfigTable(qosProfileConfigEntries);
        this.voiceDomainConfigTable = new RbVoiceDomainsTable(voiceDomainConfigEntries);
        this.serviceGroupConfigTable = new RbServiceGroupTable(serviceGroupConfigEntries);
        this.pfServerConfigTable = new RbBSPFServersTable(pfServerConfigEntries);
    }

    public RbForwardingRuleConfigTable getForwardingRuleConfigTable() {
        return this.forwardingRuleConfigTable;
    }

    public RbPolicyRuleConfigTable getPolicyRuleConfigTable() {
        return this.policyRuleConfigTable;
    }

    public RbQoSProfileConfigTable getQosProfileConfigTable() {
        return this.qosProfileConfigTable;
    }

    public RbServiceTemplateConfigTable getServiceTemplateConfigTable() {
        return this.serviceTemplateConfigTable;
    }

    public RbVoiceDomainsTable getVoiceDomainConfigTable() {
        return this.voiceDomainConfigTable;
    }

    public RbServiceGroupTable getServiceGroupConfigTable() {
        return this.serviceGroupConfigTable;
    }

    public RbBSPFServersTable getPFServerConfigTable() {
        return this.pfServerConfigTable;
    }

    public void synchronizeQoSProfiles(Collection<RbQoSProfileConfigEntry> qosProfileEntries) {
        this.qosProfileConfigTable.synchronizeCollection(qosProfileEntries);
    }

    public void synchronizePolicyRules(Collection<RbPolicyRuleConfigEntry> policyRuleEntries) {
        this.policyRuleConfigTable.synchronizeCollection(policyRuleEntries);
    }

    public void synchronizeForwardingRules(Collection<RbForwardingRuleConfigEntry> forwardingRuleEntries) {
        this.forwardingRuleConfigTable.synchronizeCollection(forwardingRuleEntries);
    }

    public void synchronizeServiceTemplates(Collection<RbServiceTemplateConfigEntry> serviceTemplateEntries) {
        this.serviceTemplateConfigTable.synchronizeCollection(serviceTemplateEntries);
    }

    public RbServiceTemplateConfigEntry findServiceProfileEntry(String name) {
        return this.serviceTemplateConfigTable.findEntryByName(name);
    }

    public RbServiceTemplateConfigEntry findServiceProfileEntryByIdx(long idx) {
        for (RbServiceTemplateConfigEntry entry : this.serviceTemplateConfigTable.getEntries()) {
            if (idx != entry.getRbServiceTemplateIdx()) continue;
            return entry;
        }
        return null;
    }

    public RbQoSProfileConfigEntry findQosProfileEntry(long index) {
        return (RbQoSProfileConfigEntry)this.qosProfileConfigTable.findEntry(Long.toString(index));
    }

    public RbQoSProfileConfigEntry findQosProfileEntryByName(String name) {
        for (RbQoSProfileConfigEntry entry : this.qosProfileConfigTable.getEntries()) {
            if (!name.equals(entry.getRbQoSProfileName())) continue;
            return entry;
        }
        return null;
    }

    public RbForwardingRuleConfigEntry findForwardingRuleEntry(long index) {
        return (RbForwardingRuleConfigEntry)this.forwardingRuleConfigTable.findEntry(Long.toString(index));
    }

    public RbForwardingRuleConfigEntry findForwardingRuleEntryByName(String name) {
        for (RbForwardingRuleConfigEntry entry : this.forwardingRuleConfigTable.getEntries()) {
            if (!name.equals(entry.getRbForwardingRuleName())) continue;
            return entry;
        }
        return null;
    }

    public RbPolicyRuleConfigEntry findPolicyRuleEntry(long index) {
        return (RbPolicyRuleConfigEntry)this.policyRuleConfigTable.findEntry(Long.toString(index));
    }

    public RbPolicyRuleConfigEntry findPolicyRuleEntryByName(String name) {
        for (RbPolicyRuleConfigEntry entry : this.policyRuleConfigTable.getEntries()) {
            if (!name.equals(entry.getRbPolicyRuleName())) continue;
            return entry;
        }
        return null;
    }

    public RbVoiceDomainsEntry findVoiceDomainEntry(long index) {
        return (RbVoiceDomainsEntry)this.voiceDomainConfigTable.findEntry(Long.toString(index));
    }

    public RbVoiceDomainsEntry findVoiceDomainsEntryByName(String name) {
        for (RbVoiceDomainsEntry entry : this.voiceDomainConfigTable.getEntries()) {
            if (!name.equals(entry.getRbVoiceDomainName())) continue;
            return entry;
        }
        return null;
    }

    public RbServiceGroupEntry findServiceGroupEntry(long index) {
        return (RbServiceGroupEntry)this.serviceGroupConfigTable.findEntry(Long.toString(index));
    }

    public RbServiceGroupEntry findServiceGroupEntryByName(String name) {
        for (RbServiceGroupEntry entry : this.serviceGroupConfigTable.getEntries()) {
            if (!name.equals(entry.getRbServiceGroupName())) continue;
            return entry;
        }
        return null;
    }

    public RbBSPFServersEntry findPFServerEntry(String ipAddress) {
        return (RbBSPFServersEntry)this.pfServerConfigTable.findEntry(ipAddress);
    }

    private <M extends ManagedObject> Map<Long, Long> commitEntries(ConfigurationHelper configHelper, Class<M> moClass, List<M> mos, MOReflector<M> reflector) throws MediationException {
        HashMap<String, Long> negativeIdxByName = new HashMap<String, Long>();
        for (ManagedObject mo : mos) {
            if (reflector.getMOIdx(mo) >= 0L) continue;
            negativeIdxByName.put(reflector.getMOName(mo), reflector.getMOIdx(mo));
        }
        List newMos = configHelper.updateCurrentConfiguration(this.NRConfiguration.getConfiguration().getEquipment().getId(), this.NRConfiguration.getName(), moClass, "*", mos);
        HashMap<Long, Long> ret = new HashMap<Long, Long>();
        for (ManagedObject mo : newMos) {
            String name = reflector.getMOName(mo);
            if (!negativeIdxByName.containsKey(name)) continue;
            ret.put((Long)negativeIdxByName.get(name), reflector.getMOIdx(mo));
        }
        mos.clear();
        mos.addAll(newMos);
        return ret;
    }

    public void commit(ConfigurationHelper configHelper) throws MediationException {
        ArrayList<RbQoSProfileConfigEntry> qosEntries = new ArrayList<RbQoSProfileConfigEntry>(this.qosProfileConfigTable.getEntries());
        Map<Long, Long> qosNewIndexes = this.commitEntries(configHelper, RbQoSProfileConfigEntry.class, qosEntries, new MOReflector<RbQoSProfileConfigEntry>(){

            @Override
            public Long getMOIdx(RbQoSProfileConfigEntry mo) {
                return mo.getRbQoSProfileIdx();
            }

            @Override
            public String getMOName(RbQoSProfileConfigEntry mo) {
                return mo.getRbQoSProfileName();
            }
        });
        this.qosProfileConfigTable = new RbQoSProfileConfigTable(qosEntries);
        this.qosProfileConfigTable.setNRConfiguration(this.NRConfiguration);
        for (RbPolicyRuleConfigEntry entry : this.policyRuleConfigTable.getEntries()) {
            if (null != entry.getRbPolicyRuleUpQoSProfileIdx1() && 0L > entry.getRbPolicyRuleUpQoSProfileIdx1()) {
                entry.setRbPolicyRuleUpQoSProfileIdx1(qosNewIndexes.get(entry.getRbPolicyRuleUpQoSProfileIdx1()));
            }
            if (null != entry.getRbPolicyRuleUpQoSProfileIdx2() && 0L > entry.getRbPolicyRuleUpQoSProfileIdx2()) {
                entry.setRbPolicyRuleUpQoSProfileIdx2(qosNewIndexes.get(entry.getRbPolicyRuleUpQoSProfileIdx2()));
            }
            if (null != entry.getRbPolicyRuleUpQoSProfileIdx3() && 0L > entry.getRbPolicyRuleUpQoSProfileIdx3()) {
                entry.setRbPolicyRuleUpQoSProfileIdx3(qosNewIndexes.get(entry.getRbPolicyRuleUpQoSProfileIdx3()));
            }
            if (null != entry.getRbPolicyRuleUpQoSProfileIdx4() && 0L > entry.getRbPolicyRuleUpQoSProfileIdx4()) {
                entry.setRbPolicyRuleUpQoSProfileIdx4(qosNewIndexes.get(entry.getRbPolicyRuleUpQoSProfileIdx4()));
            }
            if (null != entry.getRbPolicyRuleDownQoSProfileIdx1() && 0L > entry.getRbPolicyRuleDownQoSProfileIdx1()) {
                entry.setRbPolicyRuleDownQoSProfileIdx1(qosNewIndexes.get(entry.getRbPolicyRuleDownQoSProfileIdx1()));
            }
            if (null != entry.getRbPolicyRuleDownQoSProfileIdx2() && 0L > entry.getRbPolicyRuleDownQoSProfileIdx2()) {
                entry.setRbPolicyRuleDownQoSProfileIdx2(qosNewIndexes.get(entry.getRbPolicyRuleDownQoSProfileIdx2()));
            }
            if (null != entry.getRbPolicyRuleDownQoSProfileIdx3() && 0L > entry.getRbPolicyRuleDownQoSProfileIdx3()) {
                entry.setRbPolicyRuleDownQoSProfileIdx3(qosNewIndexes.get(entry.getRbPolicyRuleDownQoSProfileIdx3()));
            }
            if (null == entry.getRbPolicyRuleDownQoSProfileIdx4() || 0L <= entry.getRbPolicyRuleDownQoSProfileIdx4()) continue;
            entry.setRbPolicyRuleDownQoSProfileIdx4(qosNewIndexes.get(entry.getRbPolicyRuleDownQoSProfileIdx4()));
        }
        ArrayList<RbPolicyRuleConfigEntry> policyEntries = new ArrayList<RbPolicyRuleConfigEntry>(this.policyRuleConfigTable.getEntries());
        Map<Long, Long> policyNewIndexes = this.commitEntries(configHelper, RbPolicyRuleConfigEntry.class, policyEntries, new MOReflector<RbPolicyRuleConfigEntry>(){

            @Override
            public Long getMOIdx(RbPolicyRuleConfigEntry mo) {
                return mo.getRbPolicyRuleIdx();
            }

            @Override
            public String getMOName(RbPolicyRuleConfigEntry mo) {
                return mo.getRbPolicyRuleName();
            }
        });
        this.policyRuleConfigTable = new RbPolicyRuleConfigTable(policyEntries);
        this.policyRuleConfigTable.setNRConfiguration(this.NRConfiguration);
        for (RbForwardingRuleConfigEntry entry : this.forwardingRuleConfigTable.getEntries()) {
            if (null == entry.getRbForwardingRuleMulticastQoSIdx() || 0L <= entry.getRbForwardingRuleMulticastQoSIdx()) continue;
            entry.setRbForwardingRuleMulticastQoSIdx(qosNewIndexes.get(entry.getRbForwardingRuleMulticastQoSIdx()));
        }
        ArrayList<RbForwardingRuleConfigEntry> fwdEntries = new ArrayList<RbForwardingRuleConfigEntry>(this.forwardingRuleConfigTable.getEntries());
        Map<Long, Long> fwdNewIndexes = this.commitEntries(configHelper, RbForwardingRuleConfigEntry.class, fwdEntries, new MOReflector<RbForwardingRuleConfigEntry>(){

            @Override
            public Long getMOIdx(RbForwardingRuleConfigEntry mo) {
                return mo.getRbForwardingRuleIdx();
            }

            @Override
            public String getMOName(RbForwardingRuleConfigEntry mo) {
                return mo.getRbForwardingRuleName();
            }
        });
        this.forwardingRuleConfigTable = new RbForwardingRuleConfigTable(fwdEntries);
        this.forwardingRuleConfigTable.setNRConfiguration(this.NRConfiguration);
        for (RbServiceTemplateConfigEntry entry : this.serviceTemplateConfigTable.getEntries()) {
            if (null != entry.getRbServiceTemplateForwardingRuleIdx() && 0L > entry.getRbServiceTemplateForwardingRuleIdx()) {
                entry.setRbServiceTemplateForwardingRuleIdx(fwdNewIndexes.get(entry.getRbServiceTemplateForwardingRuleIdx()));
            }
            if (null == entry.getRbServiceTemplatePolicyRuleIdx() || 0L <= entry.getRbServiceTemplatePolicyRuleIdx()) continue;
            entry.setRbServiceTemplatePolicyRuleIdx(policyNewIndexes.get(entry.getRbServiceTemplatePolicyRuleIdx()));
        }
        this.pfServerConfigTable = new RbBSPFServersTable(configHelper.updateCurrentConfiguration(this.NRConfiguration.getConfiguration().getEquipment().getId(), this.NRConfiguration.getName(), RbBSPFServersEntry.class, "*", new ArrayList(this.pfServerConfigTable.getEntries())));
        this.voiceDomainConfigTable = new RbVoiceDomainsTable(configHelper.updateCurrentConfiguration(this.NRConfiguration.getConfiguration().getEquipment().getId(), this.NRConfiguration.getName(), RbVoiceDomainsEntry.class, "*", new ArrayList(this.voiceDomainConfigTable.getEntries())));
        this.serviceGroupConfigTable = new RbServiceGroupTable(configHelper.updateCurrentConfiguration(this.NRConfiguration.getConfiguration().getEquipment().getId(), this.NRConfiguration.getName(), RbServiceGroupEntry.class, "*", new ArrayList(this.serviceGroupConfigTable.getEntries())));
        ArrayList templateEntries = new ArrayList(this.serviceTemplateConfigTable.getEntries());
        List newEntries = configHelper.updateCurrentConfiguration(this.NRConfiguration.getConfiguration().getEquipment().getId(), this.NRConfiguration.getName(), RbServiceTemplateConfigEntry.class, "*", templateEntries);
        this.serviceTemplateConfigTable = new RbServiceTemplateConfigTable(newEntries);
        this.serviceTemplateConfigTable.setNRConfiguration(this.NRConfiguration);
    }

    public void setNRConfiguration(NetworkResourceConfiguration NRConfiguration) {
        this.NRConfiguration = NRConfiguration;
        this.pfServerConfigTable.setNRConfiguration(NRConfiguration);
        this.voiceDomainConfigTable.setNRConfiguration(NRConfiguration);
        this.serviceGroupConfigTable.setNRConfiguration(NRConfiguration);
        this.qosProfileConfigTable.setNRConfiguration(NRConfiguration);
        this.forwardingRuleConfigTable.setNRConfiguration(NRConfiguration);
        this.policyRuleConfigTable.setNRConfiguration(NRConfiguration);
        this.serviceTemplateConfigTable.setNRConfiguration(NRConfiguration);
    }

    public NetworkResourceConfiguration getNRConfiguration() {
        return this.NRConfiguration;
    }

    public RbServiceProfiles clone() {
        RbServiceProfiles ret = new RbServiceProfiles(((RbServiceTemplateConfigTable)this.serviceTemplateConfigTable.clone()).getEntries(), ((RbForwardingRuleConfigTable)this.forwardingRuleConfigTable.clone()).getEntries(), ((RbPolicyRuleConfigTable)this.policyRuleConfigTable.clone()).getEntries(), ((RbQoSProfileConfigTable)this.qosProfileConfigTable.clone()).getEntries(), ((RbVoiceDomainsTable)this.voiceDomainConfigTable.clone()).getEntries(), ((RbServiceGroupTable)this.serviceGroupConfigTable.clone()).getEntries(), ((RbBSPFServersTable)this.pfServerConfigTable.clone()).getEntries());
        ret.setNRConfiguration(this.getNRConfiguration());
        return ret;
    }

    public static boolean isHandlingNPMOClass(Class<? extends ManagedObject> moClass) {
        return RbServiceTemplateConfigEntry.class.equals(moClass) || RbForwardingRuleConfigEntry.class.equals(moClass) || RbPolicyRuleConfigEntry.class.equals(moClass) || RbQoSProfileConfigEntry.class.equals(moClass) || RbVoiceDomainsEntry.class.equals(moClass) || RbServiceGroupEntry.class.equals(moClass) || RbBSPFServersEntry.class.equals(moClass);
    }

    public Set<Long> getAffectedServiceTemplateIdxByQoSProfile(Set<Long> qosIndexes) {
        TreeSet<Long> ret = new TreeSet<Long>();
        Set<Long> policyIndexes = this.getAffectedPolicyRulesByQoSProfile(qosIndexes);
        ret.addAll(this.getAffectedServiceTemplateIdxByPolicyRule(policyIndexes));
        Set<Long> forwardingIndexes = this.getAffectedForwardingRulesByQoSProfile(qosIndexes);
        ret.addAll(this.getAffectedServiceTemplateIdxByForwardingRule(forwardingIndexes));
        return ret;
    }

    public Set<Long> getAffectedServiceTemplateIdxByPolicyRule(Set<Long> policyRuleIndexes) {
        TreeSet<Long> ret = new TreeSet<Long>();
        for (RbServiceTemplateConfigEntry entry : this.serviceTemplateConfigTable.getEntries()) {
            if (null == entry.getRbServiceTemplatePolicyRuleIdx() || !policyRuleIndexes.contains(entry.getRbServiceTemplatePolicyRuleIdx())) continue;
            ret.add(entry.getRbServiceTemplateIdx());
        }
        return ret;
    }

    public Set<Long> getAffectedServiceTemplateIdxByForwardingRule(Set<Long> forwardingRuleIndexes) {
        TreeSet<Long> ret = new TreeSet<Long>();
        for (RbServiceTemplateConfigEntry entry : this.serviceTemplateConfigTable.getEntries()) {
            if (null == entry.getRbServiceTemplateForwardingRuleIdx() || !forwardingRuleIndexes.contains(entry.getRbServiceTemplateForwardingRuleIdx())) continue;
            ret.add(entry.getRbServiceTemplateIdx());
        }
        return ret;
    }

    public Set<Long> getAffectedForwardingRulesByQoSProfile(Set<Long> qosProfileIndexes) {
        TreeSet<Long> ret = new TreeSet<Long>();
        for (RbForwardingRuleConfigEntry entry : this.forwardingRuleConfigTable.getEntries()) {
            if (null == entry.getRbForwardingRuleMulticastQoSIdx() || !qosProfileIndexes.contains(entry.getRbForwardingRuleMulticastQoSIdx())) continue;
            ret.add(entry.getRbForwardingRuleIdx());
        }
        return ret;
    }

    public Set<Long> getAffectedPolicyRulesByQoSProfile(Set<Long> qosProfileIndexes) {
        TreeSet<Long> ret = new TreeSet<Long>();
        for (RbPolicyRuleConfigEntry entry : this.policyRuleConfigTable.getEntries()) {
            if (null != entry.getRbPolicyRuleUpQoSProfileIdx1() && qosProfileIndexes.contains(entry.getRbPolicyRuleUpQoSProfileIdx1())) {
                ret.add(entry.getRbPolicyRuleIdx());
                continue;
            }
            if (null != entry.getRbPolicyRuleUpQoSProfileIdx2() && qosProfileIndexes.contains(entry.getRbPolicyRuleUpQoSProfileIdx2())) {
                ret.add(entry.getRbPolicyRuleIdx());
                continue;
            }
            if (null != entry.getRbPolicyRuleUpQoSProfileIdx3() && qosProfileIndexes.contains(entry.getRbPolicyRuleUpQoSProfileIdx3())) {
                ret.add(entry.getRbPolicyRuleIdx());
                continue;
            }
            if (null != entry.getRbPolicyRuleUpQoSProfileIdx4() && qosProfileIndexes.contains(entry.getRbPolicyRuleUpQoSProfileIdx4())) {
                ret.add(entry.getRbPolicyRuleIdx());
                continue;
            }
            if (null != entry.getRbPolicyRuleDownQoSProfileIdx1() && qosProfileIndexes.contains(entry.getRbPolicyRuleDownQoSProfileIdx1())) {
                ret.add(entry.getRbPolicyRuleIdx());
                continue;
            }
            if (null != entry.getRbPolicyRuleDownQoSProfileIdx2() && qosProfileIndexes.contains(entry.getRbPolicyRuleDownQoSProfileIdx2())) {
                ret.add(entry.getRbPolicyRuleIdx());
                continue;
            }
            if (null != entry.getRbPolicyRuleDownQoSProfileIdx3() && qosProfileIndexes.contains(entry.getRbPolicyRuleDownQoSProfileIdx3())) {
                ret.add(entry.getRbPolicyRuleIdx());
                continue;
            }
            if (null == entry.getRbPolicyRuleDownQoSProfileIdx4() || !qosProfileIndexes.contains(entry.getRbPolicyRuleDownQoSProfileIdx4())) continue;
            ret.add(entry.getRbPolicyRuleIdx());
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MOReflector<M extends ManagedObject> {
        public Long getMOIdx(M var1);

        public String getMOName(M var1);
    }
}

