/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.ServiceGroup;
import com.bwanms.validation.IPv4Address;
import com.bwanms.validation.WeakNotNull;
import com.bwanms.validation.WeakRange;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.Length;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.12.1.1", indexColumns={"RbServiceGroupIndex"})
public class RbServiceGroupEntry
extends DynamicTableRowMO
implements Identifiable {
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    public static final int MAX_SERVICE_GROUP_INDEX = 10;
    private static final long serialVersionUID = 2468648576822141741L;
    private Long rbServiceGroupIndex;
    private String rbServiceGroupName;
    private Integer rbServiceGroupNomadicity;
    private Integer rbServiceGroupType;
    private String rbServiceGroupIspDomainName;
    private Integer rbServiceGroupRelayMode;
    private Integer rbServiceGroupVlanId;
    private String rbServiceGroupGateway;
    private String rbServiceGroupDhcpServerIp;
    private String rbServiceGroupGiIpAddress;
    private String rbServiceGroupGiSubnetMask;
    private Integer rbServiceGroupRowStatus;
    public static final int RbServiceGroupNomadicityYes = 1;
    public static final int RbServiceGroupNomadicityNo = 2;
    public static final int RbServiceGroupTypeDhcpProxy = 1;
    public static final int RbServiceGroupTypeDhcpRelay = 2;
    public static final int RbServiceGroupTypeDhcpTransparent = 3;
    public static final int RbServiceGroupRelayModeOp82WithRelay = 1;
    public static final int RbServiceGroupRelayModeOp82WithoutRelay = 2;
    public static final int RowStatusActive = 1;
    public static final int RowStatusNotInService = 2;
    public static final int RowStatusNotReady = 3;
    public static final int RowStatusCreateAndGo = 4;
    public static final int RowStatusCreateAndWait = 5;
    public static final int RowStatusDestroy = 6;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.1", type=66)
    @IdentifierAttribute
    public Long getRbServiceGroupIndex() {
        return this.rbServiceGroupIndex;
    }

    public void setRbServiceGroupIndex(Long rbServiceGroupIndex) {
        this.rbServiceGroupIndex = rbServiceGroupIndex;
    }

    @WeakNotNull
    @Length(min=1, max=32)
    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.2", type=-128)
    public String getRbServiceGroupName() {
        return this.rbServiceGroupName;
    }

    public void setRbServiceGroupName(String rbServiceGroupName) {
        this.rbServiceGroupName = rbServiceGroupName;
    }

    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.3", type=2)
    public Integer getRbServiceGroupNomadicity() {
        return this.rbServiceGroupNomadicity;
    }

    public void setRbServiceGroupNomadicity(Integer rbServiceGroupNomadicity) {
        this.rbServiceGroupNomadicity = rbServiceGroupNomadicity;
    }

    public static String toStringRbServiceGroupNomadicity(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "yes(1)";
                break;
            }
            case 2: {
                result = "no(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.4", type=2)
    public Integer getRbServiceGroupType() {
        return this.rbServiceGroupType;
    }

    public void setRbServiceGroupType(Integer rbServiceGroupType) {
        this.rbServiceGroupType = rbServiceGroupType;
    }

    public static String toStringRbServiceGroupType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "dhcpProxy(1)";
                break;
            }
            case 2: {
                result = "dhcpRelay(2)";
                break;
            }
            case 3: {
                result = "dhcpTransparent(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @WeakNotNull
    @Length(min=0, max=32)
    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.5", type=-128)
    public String getRbServiceGroupIspDomainName() {
        return this.rbServiceGroupIspDomainName;
    }

    public void setRbServiceGroupIspDomainName(String rbServiceGroupIspDomainName) {
        this.rbServiceGroupIspDomainName = rbServiceGroupIspDomainName;
    }

    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.6", type=2)
    public Integer getRbServiceGroupRelayMode() {
        return this.rbServiceGroupRelayMode;
    }

    public void setRbServiceGroupRelayMode(Integer rbServiceGroupRelayMode) {
        this.rbServiceGroupRelayMode = rbServiceGroupRelayMode;
    }

    public static String toStringRbServiceGroupRelayMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "op82WithRelay(1)";
                break;
            }
            case 2: {
                result = "op82WithoutRelay(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @WeakRange(min=0L, max=4095L)
    @ConfigAttribute
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.7", type=2)
    public Integer getRbServiceGroupVlanId() {
        return this.rbServiceGroupVlanId;
    }

    public void setRbServiceGroupVlanId(Integer rbServiceGroupVlanId) {
        this.rbServiceGroupVlanId = rbServiceGroupVlanId;
    }

    @ConfigAttribute
    @IPv4Address(acceptAnyIp=true)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.8", type=64)
    public String getRbServiceGroupGateway() {
        return this.rbServiceGroupGateway;
    }

    public void setRbServiceGroupGateway(String rbServiceGroupGateway) {
        this.rbServiceGroupGateway = rbServiceGroupGateway;
    }

    @ConfigAttribute
    @IPv4Address(acceptAnyIp=true)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.9", type=64)
    public String getRbServiceGroupDhcpServerIp() {
        return this.rbServiceGroupDhcpServerIp;
    }

    public void setRbServiceGroupDhcpServerIp(String rbServiceGroupDhcpServerIp) {
        this.rbServiceGroupDhcpServerIp = rbServiceGroupDhcpServerIp;
    }

    @ConfigAttribute
    @IPv4Address(acceptAnyIp=true)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.10", type=64)
    public String getRbServiceGroupGiIpAddress() {
        return this.rbServiceGroupGiIpAddress;
    }

    public void setRbServiceGroupGiIpAddress(String rbServiceGroupGiIpAddress) {
        this.rbServiceGroupGiIpAddress = rbServiceGroupGiIpAddress;
    }

    @ConfigAttribute
    @IPv4Address(acceptAnyIp=true)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.11", type=64)
    public String getRbServiceGroupGiSubnetMask() {
        return this.rbServiceGroupGiSubnetMask;
    }

    public void setRbServiceGroupGiSubnetMask(String rbServiceGroupGiSubnetMask) {
        this.rbServiceGroupGiSubnetMask = rbServiceGroupGiSubnetMask;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.12.1.1.12", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbServiceGroupRowStatus;
    }

    public void setRowStatus(Integer rbServiceGroupRowStatus) {
        this.rbServiceGroupRowStatus = rbServiceGroupRowStatus;
    }

    public static String toStringRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Transient
    public String getRowKey() {
        return String.valueOf(this.rbServiceGroupIndex);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbServiceGroupIndex=").append(this.rbServiceGroupIndex).append(", ");
        result.append("rbServiceGroupName=").append(this.rbServiceGroupName).append(", ");
        result.append("rbServiceGroupNomadicity=").append(RbServiceGroupEntry.toStringRbServiceGroupNomadicity(this.rbServiceGroupNomadicity)).append(", ");
        result.append("rbServiceGroupType=").append(RbServiceGroupEntry.toStringRbServiceGroupType(this.rbServiceGroupType)).append(", ");
        result.append("rbServiceGroupIspDomainName=").append(this.rbServiceGroupIspDomainName).append(", ");
        result.append("rbServiceGroupRelayMode=").append(RbServiceGroupEntry.toStringRbServiceGroupRelayMode(this.rbServiceGroupRelayMode)).append(", ");
        result.append("rbServiceGroupVlanId=").append(this.rbServiceGroupVlanId).append(", ");
        result.append("rbServiceGroupGateway=").append(this.rbServiceGroupGateway).append(", ");
        result.append("rbServiceGroupDhcpServerIp=").append(this.rbServiceGroupDhcpServerIp).append(", ");
        result.append("rbServiceGroupGiIpAddress=").append(this.rbServiceGroupGiIpAddress).append(", ");
        result.append("rbServiceGroupGiSubnetMask=").append(this.rbServiceGroupGiSubnetMask).append(", ");
        result.append("rbServiceGroupRowStatus=").append(RbServiceGroupEntry.toStringRowStatus(this.rbServiceGroupRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbServiceGroupEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbServiceGroupEntry>(){

            public ManagedObjectAccessHandler<RbServiceGroupEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbServiceGroupEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbServiceGroupEntry>(){

            public ManagedObjectAccessHandler<RbServiceGroupEntry> createHandler() {
                return new SNMPDynamicTableRowMOAccessHandler<RbServiceGroupEntry>(RbServiceGroupEntry.class){

                    public void add(Equipment eq, MOAccessSession access, String networkResource, RbServiceGroupEntry managedObject) throws MediationException {
                        if (managedObject.getRbServiceGroupIndex() < 0L) {
                            managedObject.setRbServiceGroupIndex(10L);
                        }
                        super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
                    }

                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbServiceGroupEntry managedObject) throws MediationException {
                        super.update(eq, access, networkResource, (ManagedObject)managedObject);
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbServiceGroupEntry, ServiceGroup> {
        private TreeMap<Integer, String> serviceGroupNameMap;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbServiceGroupEntry createEntry() {
            return new RbServiceGroupEntry();
        }

        @Override
        protected Class<ServiceGroup> getDataObjectClass() {
            return ServiceGroup.class;
        }

        @Override
        protected void populateEntry(RbServiceGroupEntry entry, ServiceGroup dataObject) {
            entry.setRbServiceGroupIndex(dataObject.getIndex().longValue());
            entry.setRbServiceGroupName(dataObject.getRbServiceGroupName());
            entry.setRbServiceGroupType(dataObject.getRbServiceGroupType());
            entry.setRbServiceGroupRelayMode(dataObject.getRbServiceGroupRelayMode());
            entry.setRbServiceGroupIspDomainName(dataObject.getRbServiceGroupIspDomainName());
            entry.setRbServiceGroupNomadicity(dataObject.getRbServiceGroupNomadicity());
            entry.setRbServiceGroupVlanId(dataObject.getRbServiceGroupVlanId());
            entry.setRbServiceGroupDhcpServerIp(dataObject.getRbServiceGroupDhcpServerIp());
            entry.setRbServiceGroupGateway(dataObject.getRbServiceGroupGateway());
            entry.setRbServiceGroupGiIpAddress(dataObject.getRbServiceGroupGiIpAddress());
            entry.setRbServiceGroupGiSubnetMask(dataObject.getRbServiceGroupGiSubnetMask());
        }

        @Override
        public List<RbServiceGroupEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            return super.fetch(eq, access, networkResource, instanceQuery);
        }
    }
}

