/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.SmCfg_Sm;
import com.bwanms.validation.Values;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbServiceGeneralConfig
extends ScalarMO {
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbServiceWorkingMode;
    public static final int RbServiceWorkingModeProfessionalMode = 1;
    public static final int RbServiceWorkingModeLightMode = 2;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Values(values={1, 2}, toStringConvertorMethodName="toStringRbServiceWorkingMode")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.1.7", type=2)
    @ConfigAttribute
    public Integer getRbServiceWorkingMode() {
        return this.rbServiceWorkingMode;
    }

    public void setRbServiceWorkingMode(Integer rbServiceWorkingMode) {
        this.rbServiceWorkingMode = rbServiceWorkingMode;
    }

    public static String toStringRbServiceWorkingMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "professionalMode(1)";
                break;
            }
            case 2: {
                result = "lightMode(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbServiceWorkingMode=").append(RbServiceGeneralConfig.toStringRbServiceWorkingMode(this.rbServiceWorkingMode)).append(", ");
        result.append("]");
        return result.toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbServiceGeneralConfig.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbServiceGeneralConfig>(){

            public ManagedObjectAccessHandler<RbServiceGeneralConfig> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbServiceGeneralConfig.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbServiceGeneralConfig>(){

            public ManagedObjectAccessHandler<RbServiceGeneralConfig> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbServiceGeneralConfig.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbServiceGeneralConfig, SmCfg_Sm> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbServiceGeneralConfig createEntry() {
            return new RbServiceGeneralConfig();
        }

        @Override
        protected Class<SmCfg_Sm> getDataObjectClass() {
            return SmCfg_Sm.class;
        }

        @Override
        protected void populateEntry(RbServiceGeneralConfig entry, SmCfg_Sm dataObject) {
            entry.setRbServiceWorkingMode(dataObject.getMode());
        }
    }
}

