/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.snmp.DynamicTableMO;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceConfigTable
extends DynamicTableMO<RbServiceConfigEntry> {
    private static final Logger logger = Logger.getLogger(RbServiceConfigTable.class);

    public RbServiceConfigTable(List<RbServiceConfigEntry> entries) {
        super(entries);
    }

    public Class<RbServiceConfigEntry> getParameterClass() {
        return RbServiceConfigEntry.class;
    }

    public RbServiceConfigEntry findEntryByName(String name) {
        for (RbServiceConfigEntry entry : this.getEntries()) {
            if (!name.equals(entry.getRbServiceName())) continue;
            return entry;
        }
        return null;
    }

    public static boolean vlanListEqual(String commaSeparated1, int count1, String commaSeparated2, int count2) {
        int[] vlanArray1 = RbServiceConfigTable.getVLANListFromCommaSeparated(commaSeparated1);
        int[] vlanArray2 = RbServiceConfigTable.getVLANListFromCommaSeparated(commaSeparated2);
        if (RbServiceConfigTable.getVLANCountIgnoreTransparent(vlanArray1, count1) != RbServiceConfigTable.getVLANCountIgnoreTransparent(vlanArray2, count2)) {
            return false;
        }
        for (int i = 0; i < count1; ++i) {
            if (4095 == vlanArray1[i]) continue;
            boolean found = false;
            for (int j = 0; j < count2; ++j) {
                if (vlanArray1[i] != vlanArray2[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static int getVLANCountIgnoreTransparent(int[] vlansArray, int maxLength) {
        int vlanCount = 0;
        for (int i = 0; i < maxLength && 0 != vlansArray[i]; ++i) {
            if (4095 == vlansArray[i]) continue;
            ++vlanCount;
        }
        return vlanCount;
    }

    public static int[] getVLANListFromCommaSeparated(String commaSeparated) {
        if ("".equals(commaSeparated)) {
            return new int[0];
        }
        String[] parts = commaSeparated.split(",");
        int[] vlanList = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            vlanList[i] = "".equals(parts[i]) ? 0 : Integer.parseInt(parts[i]);
        }
        return vlanList;
    }

    public static class RbServiceGetNewEntryId {
        private Long rbGetNewServiceId;

        @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.1.2", type=2)
        public Long getRbGetNewServiceId() {
            return this.rbGetNewServiceId;
        }

        public void setRbGetNewServiceId(Long rbGetNewServiceId) {
            this.rbGetNewServiceId = rbGetNewServiceId;
        }
    }
}

