/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.gui.configuration.services.RbServiceConfigEntryEditorView;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.ServicePipeDb_ServicePipe;
import com.bwanms.rb.mo.configfile.ServiceProfileDb_ServiceProfile;
import com.bwanms.rb.mo.configfile.SubscriberDb_Subscriber;
import com.bwanms.rb.mo.configfile.SwitchingMode_Appl;
import com.bwanms.rb.mo.configfile.VlanAssociationListDb_VlanAssociationList;
import com.bwanms.rb.mo.services.RbServiceConfigTable;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSuServiceConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.performance.RbServiceEntryWeakAssociation;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.MacAddress;
import com.bwanms.util.OctetString;
import com.bwanms.validation.WeakRange;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.3.1.1", indexColumns={"RbSubscriberIdx", "RbServiceIdx"})
public class RbServiceConfigEntry
extends DynamicTableRowMO
implements Identifiable {
    private static final long serialVersionUID = -601979789701091457L;
    private static final Logger log = Logger.getLogger(RbServiceConfigEntry.class);
    public static final int HYBRID_MODE_ENABLE = 1;
    public static final int HYBRID_MODE_DISABLE = 2;
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private String instance;
    private boolean tddDuplexMode;
    private List<RbServiceEntryWeakAssociation> weakAssociations;
    private String rbServiceName;
    private Long rbServiceServiceTemplateIdx;
    private Long rbServiceIdx;
    private Integer rbServiceType;
    private Long rbServiceID;
    private String rbServiceServiceTemplateName;
    private Integer rbServiceOperStatus;
    public static final int RbServiceOperStatusUp = 1;
    public static final int RbServiceOperStatusDown = 2;
    public static final int RbServiceOperStatusUnknown = 3;
    private String rbServiceClientSiteVLANList;
    private Integer rbServiceClientSiteVLANListCount;
    private String rbServiceSuMacAddress;
    private Long rbSubscriberIdx;
    private Integer rbServiceAdminStatus;
    public static final int RbServiceAdminStatusEnable = 1;
    public static final int RbServiceAdminStatusDisable = 2;
    private Integer rbAServiceRowStatus;
    public static final int RbAServiceRowStatusActive = 1;
    public static final int RbAServiceRowStatusNotInService = 2;
    public static final int RbAServiceRowStatusNotReady = 3;
    public static final int RbAServiceRowStatusCreateAndGo = 4;
    public static final int RbAServiceRowStatusCreateAndWait = 5;
    public static final int RbAServiceRowStatusDestroy = 6;
    public static final int RbServiceVLANHybridModeEnabled = 1;
    public static final int RbServiceVLANHybridModeDisabled = 2;
    private Integer rbServiceVLANHybridMode;
    public static final int RbServiceVLANClassificationModeOff = 1;
    public static final int RbServiceVLANClassificationModeOn = 2;
    private Integer rbServiceVLANClassificationMode;
    private Integer rbServiceAccessVLAN;
    private String rbSubscriberID;
    private Integer rbServiceAUSlotNumber;
    private Integer rbSuServiceVPLID;

    public RbServiceConfigEntry() {
        this(false);
    }

    public RbServiceConfigEntry(boolean tddDuplexMode) {
        this.tddDuplexMode = tddDuplexMode;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.3", type=-128)
    @ConfigAttribute
    public String getRbServiceName() {
        return this.rbServiceName;
    }

    public void setRbServiceName(String rbServiceName) {
        this.rbServiceName = rbServiceName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.5", type=66)
    @ConfigAttribute
    public Long getRbServiceServiceTemplateIdx() {
        return this.rbServiceServiceTemplateIdx;
    }

    public void setRbServiceServiceTemplateIdx(Long rbServiceServiceTemplateIdx) {
        this.rbServiceServiceTemplateIdx = rbServiceServiceTemplateIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.1", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbServiceIdx() {
        return this.rbServiceIdx;
    }

    public void setRbServiceIdx(Long rbServiceIdx) {
        this.rbServiceIdx = rbServiceIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.2", type=2, readOnly=true)
    @ConfigAttribute
    public Integer getRbServiceType() {
        return this.rbServiceType;
    }

    public void setRbServiceType(Integer rbServiceType) {
        this.rbServiceType = rbServiceType;
    }

    public static String toStringRbServiceType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "rbLayerII(1)";
                break;
            }
            case 2: {
                result = "rbPPPoE(2)";
                break;
            }
            case 3: {
                result = "rbVoIP(3)";
                break;
            }
            case 4: {
                result = "rbIPModeData(4)";
                break;
            }
            case 5: {
                result = "rbIPModeVoIP(5)";
                break;
            }
            case 6: {
                result = "rbManaged-VoIP(6)";
                break;
            }
            case 7: {
                result = "rbIPmode-Managed-VoIP(7)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.4", type=66, readOnly=true)
    @ConfigAttribute
    public Long getRbServiceID() {
        return this.rbServiceID;
    }

    public void setRbServiceID(Long rbServiceID) {
        this.rbServiceID = rbServiceID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.6", type=-128, readOnly=true)
    @ConfigAttribute
    public String getRbServiceServiceTemplateName() {
        return this.rbServiceServiceTemplateName;
    }

    public void setRbServiceServiceTemplateName(String rbServiceServiceTemplateName) {
        this.rbServiceServiceTemplateName = rbServiceServiceTemplateName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.10", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbServiceOperStatus() {
        return this.rbServiceOperStatus;
    }

    public void setRbServiceOperStatus(Integer rbServiceOperStatus) {
        this.rbServiceOperStatus = rbServiceOperStatus;
    }

    public static String toStringRbServiceOperStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "up(1)";
                break;
            }
            case 2: {
                result = "down(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.12", type=4)
    @ConfigAttribute
    public String getRbServiceClientSiteVLANList() {
        return this.rbServiceClientSiteVLANList;
    }

    public void setRbServiceClientSiteVLANList(String rbServiceClientSiteVLANList) {
        this.rbServiceClientSiteVLANList = rbServiceClientSiteVLANList;
    }

    @Column(name="rbSrvClientSiteVLANListCount")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.13", type=2)
    @ConfigAttribute
    public Integer getRbServiceClientSiteVLANListCount() {
        return this.rbServiceClientSiteVLANListCount;
    }

    public void setRbServiceClientSiteVLANListCount(Integer rbServiceClientSiteVLANListCount) {
        this.rbServiceClientSiteVLANListCount = rbServiceClientSiteVLANListCount;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.14", type=112)
    @ConfigAttribute
    public String getRbServiceSuMacAddress() {
        return this.rbServiceSuMacAddress;
    }

    public void setRbServiceSuMacAddress(String rbServiceSuMacAddress) {
        this.rbServiceSuMacAddress = rbServiceSuMacAddress != null ? rbServiceSuMacAddress.toUpperCase() : rbServiceSuMacAddress;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.7.1.1.1", type=66, readOnly=true)
    @ConfigAttribute
    public Long getRbSubscriberIdx() {
        return this.rbSubscriberIdx;
    }

    public void setRbSubscriberIdx(Long rbSubscriberIdx) {
        this.rbSubscriberIdx = rbSubscriberIdx;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbServiceIdx=").append(this.rbServiceIdx).append(", ");
        result.append("rbServiceType=").append(RbServiceConfigEntry.toStringRbServiceType(this.rbServiceType)).append(", ");
        result.append("rbServiceName=").append(this.rbServiceName).append(", ");
        result.append("rbServiceID=").append(this.rbServiceID).append(", ");
        result.append("rbServiceServiceTemplateIdx=").append(this.rbServiceServiceTemplateIdx).append(", ");
        result.append("rbServiceServiceTemplateName=").append(this.rbServiceServiceTemplateName).append(", ");
        result.append("rbServiceAdminStatus=").append(this.toStringRbServiceAdminStatus(this.rbServiceAdminStatus)).append(", ");
        result.append("rbServiceOperStatus=").append(RbServiceConfigEntry.toStringRbServiceOperStatus(this.rbServiceOperStatus)).append(", ");
        result.append("rbAServiceRowStatus=").append(this.toStringRbAServiceRowStatus(this.rbAServiceRowStatus)).append(", ");
        result.append("rbServiceClientSiteVLANList=").append(this.rbServiceClientSiteVLANList).append(", ");
        result.append("rbServiceClientSiteVLANListCount=").append(this.rbServiceClientSiteVLANListCount).append(", ");
        result.append("rbServiceSuMacAddress=").append(this.rbServiceSuMacAddress).append(", ");
        result.append("rbSubscriberIdx=").append(this.rbSubscriberIdx).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        if (this.isTddDuplexMode()) {
            if (this.getRbServiceSuMacAddress() == null || this.getRbServiceIdx() == null) {
                return "-1";
            }
            return MacAddress.fromString((String)this.getRbServiceSuMacAddress().replace(':', '-')).toInstanceString() + "." + this.getRbServiceIdx().toString();
        }
        if (this.getRbSubscriberIdx() == null || this.getRbServiceIdx() == null) {
            return "-1";
        }
        return this.getRbSubscriberIdx().toString() + "." + this.getRbServiceIdx().toString();
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.9", type=2)
    @ConfigAttribute
    public Integer getRbServiceAdminStatus() {
        return this.rbServiceAdminStatus;
    }

    public void setRbServiceAdminStatus(Integer rbServiceAdminStatus) {
        this.rbServiceAdminStatus = rbServiceAdminStatus;
    }

    public String toStringRbServiceAdminStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.11", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbAServiceRowStatus;
    }

    public void setRowStatus(Integer rbAServiceRowStatus) {
        this.rbAServiceRowStatus = rbAServiceRowStatus;
    }

    public String toStringRbAServiceRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.16", type=2)
    @ConfigAttribute
    public Integer getRbServiceVLANHybridMode() {
        return this.rbServiceVLANHybridMode;
    }

    public void setRbServiceVLANHybridMode(Integer rbServiceVLANHybridMode) {
        this.rbServiceVLANHybridMode = rbServiceVLANHybridMode;
    }

    public static String toStringRbServiceVLANHybridMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "On";
                break;
            }
            case 2: {
                result = "Off";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.6"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.17", type=2)
    @Column(name="rbSvcVLANClassificationMode")
    @ConfigAttribute
    public Integer getRbServiceVLANClassificationMode() {
        return this.rbServiceVLANClassificationMode;
    }

    public void setRbServiceVLANClassificationMode(Integer rbServiceVLANClassificationMode) {
        this.rbServiceVLANClassificationMode = rbServiceVLANClassificationMode;
    }

    @OneToMany
    @JoinColumn(name="entry_id")
    private List<RbServiceEntryWeakAssociation> getWeakAssociations() {
        return this.weakAssociations;
    }

    private void setWeakAssociations(List<RbServiceEntryWeakAssociation> weakAssociations) {
        this.weakAssociations = weakAssociations;
    }

    public static String toStringRbServiceVLANClassificationMode(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "off(1)";
                break;
            }
            case 2: {
                result = "on(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=2.1.1.6"})
    @WeakRange(min=0L, max=4095L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.18", type=2)
    @ConfigAttribute
    public Integer getRbServiceAccessVLAN() {
        return this.rbServiceAccessVLAN;
    }

    public void setRbServiceAccessVLAN(Integer rbServiceAccessVLAN) {
        this.rbServiceAccessVLAN = rbServiceAccessVLAN;
    }

    public String getRbSubscriberID() {
        if (this.rbSubscriberID == null) {
            return "";
        }
        return this.rbSubscriberID;
    }

    public void setRbSubscriberID(String rbSubscriberID) {
        this.rbSubscriberID = rbSubscriberID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.3.1.1.15", type=2)
    @InventoryAttribute
    public Integer getRbServiceAUSlotNumber() {
        return this.rbServiceAUSlotNumber;
    }

    public void setRbServiceAUSlotNumber(Integer rbServiceAUSlotNumber) {
        this.rbServiceAUSlotNumber = rbServiceAUSlotNumber;
    }

    public Integer getRbSuServiceVPLID() {
        return this.rbSuServiceVPLID;
    }

    public void setRbSuServiceVPLID(Integer rbSuServiceVPLID) {
        this.rbSuServiceVPLID = rbSuServiceVPLID;
    }

    @Transient
    public String getRbServiceClientSiteVLANListAsString() {
        StringBuffer ret = new StringBuffer();
        int[] ids = OctetString.fromOctetString((String)this.getRbServiceClientSiteVLANList());
        StringBuffer buf = new StringBuffer();
        if (ids != null) {
            for (int i : ids) {
                String temp = Integer.toBinaryString(i);
                for (int i2 = 0; i2 < 8 - temp.length(); ++i2) {
                    buf.append("0");
                }
                buf.append(temp);
            }
            String vlanList = buf.toString();
            for (int i = 0; i < 16; ++i) {
                ret.append(Integer.toString(Integer.parseInt(vlanList.substring(i * 12, (i + 1) * 12), 2)));
                ret.append(",");
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                ret.append("0,");
            }
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    public void setRbServiceClientSiteVLANListAsString(String vlanList) {
        String[] parts = vlanList.split(",");
        if (parts.length != 16) {
            throw new RuntimeException("Invalid VLAN List count");
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            int part = "".equals(parts[i]) ? 0 : Integer.parseInt(parts[i]);
            String binary = Integer.toBinaryString(part);
            if (binary.length() > 12) {
                throw new RuntimeException("Invalid VLAN Value: " + part);
            }
            for (int j = 0; j < 12 - binary.length(); ++j) {
                buf.append("0");
            }
            buf.append(binary);
        }
        String bits = buf.toString();
        int[] bytes = new int[24];
        for (int i = 0; i < 24; ++i) {
            bytes[i] = Integer.parseInt(bits.substring(i * 8, (i + 1) * 8), 2);
        }
        this.setRbServiceClientSiteVLANList(OctetString.toOctetString((int[])bytes));
    }

    @Transient
    public boolean isTemporary() {
        return this.id != 0L && this.rbSubscriberIdx == 0L;
    }

    public void validateUndeclaredConstraints(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceConfigEntryEditorView.class);
        String name = this.getRbServiceName();
        if (name == null || name.trim().equals("") || !name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") || name.length() > 32) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidServiceName"), RbServiceConfigEntry.class, "rbServiceName", (Object)name, (Object)this));
        }
        if (this.rbServiceServiceTemplateIdx == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("serviceProfileNotNull"), RbServiceConfigEntry.class, "rbServiceServiceTemplateIdx", (Object)"", (Object)this));
        }
        if (this.rbServiceSuMacAddress == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("serviceMACNotNull"), RbServiceConfigEntry.class, i18n.translateString("SuNameMACAddress"), (Object)"", (Object)this));
        }
        if (this.rbSubscriberIdx == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("subscriberNotNull"), RbServiceConfigEntry.class, "rbSubscriberIdx", (Object)"", (Object)this));
        }
    }

    private static void fillServiceEntry(RbServiceConfigEntry entry, RbSuServiceConfigEntry suEntry) {
        entry.setRbServiceAccessVLAN(suEntry.getRbSuServiceAccessVLAN());
        entry.setRbServiceAdminStatus(suEntry.getRbSuServiceAdminStatus());
        entry.setRbServiceClientSiteVLANList(suEntry.getRbSuServiceClientSiteVLANList());
        entry.setRbServiceClientSiteVLANListCount(suEntry.getRbSuServiceClientSiteVLANListCount());
        entry.setRbServiceID(suEntry.getRbSuServiceID());
        entry.setRbServiceIdx(suEntry.getRbSuServiceIdx());
        entry.setRbServiceName(suEntry.getRbSuServiceName());
        entry.setRbServiceOperStatus(suEntry.getRbSuServiceOperStatus());
        entry.setRbServiceServiceTemplateIdx(suEntry.getRbSuServiceTemplateIdx());
        entry.setRbServiceServiceTemplateName(suEntry.getRbSuServiceTemplateName());
        entry.setRbServiceSuMacAddress(suEntry.getRbSuServiceMacAddress());
        entry.setRbServiceType(suEntry.getRbSuServiceRbType());
        entry.setRbServiceVLANClassificationMode(suEntry.getRbSuServiceVLANClassificationMode());
        entry.setRbServiceVLANHybridMode(suEntry.getRbSuServiceVLANHybridMode());
        entry.setRbServiceAUSlotNumber(suEntry.getRbSuServiceAUSlotNumber());
        entry.setRbSubscriberIdx(suEntry.getRbSuSubscriberIdx());
        entry.setRbSuServiceVPLID(suEntry.getRbSuServiceVPLID());
        entry.setRbSubscriberID(suEntry.getRbSuSubscriberID());
    }

    private static void fillSuServiceEntry(RbSuServiceConfigEntry suEntry, RbServiceConfigEntry entry) {
        suEntry.setRbSuServiceAccessVLAN(entry.getRbServiceAccessVLAN());
        suEntry.setRbSuServiceAdminStatus(entry.getRbServiceAdminStatus());
        suEntry.setRbSuServiceClientSiteVLANList(entry.getRbServiceClientSiteVLANList());
        suEntry.setRbSuServiceClientSiteVLANListCount(entry.getRbServiceClientSiteVLANListCount());
        suEntry.setRbSuServiceID(entry.getRbServiceID());
        suEntry.setRbSuServiceIdx(entry.getRbServiceIdx());
        suEntry.setRbSuServiceName(entry.getRbServiceName());
        suEntry.setRbSuServiceOperStatus(entry.getRbServiceOperStatus());
        suEntry.setRbSuServiceTemplateIdx(entry.getRbServiceServiceTemplateIdx());
        suEntry.setRbSuServiceTemplateName(entry.getRbServiceServiceTemplateName());
        suEntry.setRbSuServiceMacAddress(entry.getRbServiceSuMacAddress());
        suEntry.setRbSuServiceRbType(entry.getRbServiceType());
        suEntry.setRbSuServiceVLANClassificationMode(entry.getRbServiceVLANClassificationMode());
        suEntry.setRbSuServiceVLANHybridMode(entry.getRbServiceVLANHybridMode());
        suEntry.setRbSuServiceAUSlotNumber(entry.getRbServiceAUSlotNumber());
        suEntry.setRbSuSubscriberIdx(entry.getRbSubscriberIdx());
        suEntry.setRbSuServiceVPLID(entry.getRbSuServiceVPLID());
        suEntry.setRbSuSubscriberID(entry.getRbSubscriberID());
    }

    private boolean isTddDuplexMode() {
        return this.tddDuplexMode;
    }

    private void setTddDuplexMode(boolean duplexMode) {
        this.tddDuplexMode = duplexMode;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbServiceConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbServiceConfigEntry>(){

            public ManagedObjectAccessHandler<RbServiceConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbServiceConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbServiceConfigEntry>(){

            public ManagedObjectAccessHandler<RbServiceConfigEntry> createHandler() {
                return new RbServiceConfigTableRowMOAccessHandler(RbServiceConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbServiceConfigTableRowMOAccessHandler
    extends SNMPDynamicTableRowMOAccessHandler<RbServiceConfigEntry> {
        public RbServiceConfigTableRowMOAccessHandler(Class<RbServiceConfigEntry> moClass) {
            super(moClass);
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbServiceConfigEntry managedObject) throws MediationException {
            RbServiceConfigTable.RbServiceGetNewEntryId idGetter = (RbServiceConfigTable.RbServiceGetNewEntryId)access.fetchObject(null, RbServiceConfigTable.RbServiceGetNewEntryId.class).get(0);
            managedObject.setRbServiceIdx(idGetter.getRbGetNewServiceId());
            if (((RbBaseStationEquipment)eq).isTDDDuplexMode()) {
                RbSuServiceConfigEntry suEntry = new RbSuServiceConfigEntry();
                RbServiceConfigEntry.fillSuServiceEntry(suEntry, managedObject);
                suEntry.setRowStatus(4);
                access.commitObject(networkResource, (Object)suEntry);
            } else {
                super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
            }
        }

        public void delete(Equipment eq, MOAccessSession access, String networkResource, RbServiceConfigEntry managedObject) throws MediationException {
            if (((RbBaseStationEquipment)eq).isTDDDuplexMode()) {
                RbSuServiceConfigEntry suEntry = new RbSuServiceConfigEntry();
                RbServiceConfigEntry.fillSuServiceEntry(suEntry, managedObject);
                suEntry.setRowStatus(6);
                access.commitObject(networkResource, (Object)suEntry, new String[]{"rowStatus"});
            } else {
                super.delete(eq, access, networkResource, (DynamicTableRowMO)managedObject);
            }
        }

        public List<RbServiceConfigEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            if (((RbBaseStationEquipment)eq).isTDDDuplexMode()) {
                String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, RbSuServiceConfigEntry.class);
                List suServiceEntries = access.fetchObject(networkResource, RbSuServiceConfigEntry.class, includedProperties, instanceQuery);
                if (null == suServiceEntries) {
                    return null;
                }
                ArrayList<RbServiceConfigEntry> ret = new ArrayList<RbServiceConfigEntry>(suServiceEntries.size());
                for (RbSuServiceConfigEntry suEntry : suServiceEntries) {
                    RbServiceConfigEntry entry = new RbServiceConfigEntry(true);
                    RbServiceConfigEntry.fillServiceEntry(entry, suEntry);
                    ret.add(entry);
                }
                return ret;
            }
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbServiceConfigEntry managedObject) throws MediationException {
            if (((RbBaseStationEquipment)eq).isTDDDuplexMode()) {
                RbSuServiceConfigEntry suEntry = new RbSuServiceConfigEntry();
                RbServiceConfigEntry.fillSuServiceEntry(suEntry, managedObject);
                access.commitObject(networkResource, (Object)suEntry);
            } else {
                super.update(eq, access, networkResource, (ManagedObject)managedObject);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbServiceConfigEntry, ServicePipeDb_ServicePipe> {
        private TreeMap<Integer, ServiceProfileDb_ServiceProfile> spIdIdxMap;
        private TreeMap<Integer, SubscriberDb_Subscriber> subIdMap;
        private TreeMap<Integer, StringBuffer> vlans;
        private boolean tddDuplexMode;
        private boolean ipSwitchingMode;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbServiceConfigEntry createEntry() {
            return new RbServiceConfigEntry(this.tddDuplexMode);
        }

        @Override
        protected Class<ServicePipeDb_ServicePipe> getDataObjectClass() {
            return ServicePipeDb_ServicePipe.class;
        }

        private void prefetch(Equipment eq, MOAccessSession access) throws MediationException {
            SwitchingMode_Appl sm;
            RbBaseStationEquipment bsEq = (RbBaseStationEquipment)eq;
            this.tddDuplexMode = bsEq.isTDDDuplexMode();
            this.ipSwitchingMode = bsEq.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_1_1) ? RbBSSwitchingModeParameters.SWITCHING_MODE_IP_CS == (sm = (SwitchingMode_Appl)access.fetchObject(null, SwitchingMode_Appl.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SwitchingMode_Appl.class), "*").get(0)).getActualProdType() : false;
            List sps = access.fetchObject(null, ServiceProfileDb_ServiceProfile.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, ServiceProfileDb_ServiceProfile.class));
            this.spIdIdxMap = new TreeMap();
            for (ServiceProfileDb_ServiceProfile sp : sps) {
                this.spIdIdxMap.put(sp.getID(), sp);
            }
            List subscribers = access.fetchObject(null, SubscriberDb_Subscriber.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SubscriberDb_Subscriber.class));
            this.subIdMap = new TreeMap();
            for (SubscriberDb_Subscriber subscriber : subscribers) {
                this.subIdMap.put(subscriber.getID(), subscriber);
            }
            List vlanTable = access.fetchObject(null, VlanAssociationListDb_VlanAssociationList.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, VlanAssociationListDb_VlanAssociationList.class));
            this.vlans = new TreeMap();
            for (VlanAssociationListDb_VlanAssociationList vlan : vlanTable) {
                StringBuffer vlanList = this.vlans.get(vlan.getServicePipeId());
                if (vlanList == null) {
                    vlanList = new StringBuffer(vlan.getVLANID().toString());
                    this.vlans.put(vlan.getServicePipeId(), vlanList);
                    continue;
                }
                vlanList.append(',');
                vlanList.append(vlan.getVLANID().toString());
            }
        }

        @Override
        public List<RbServiceConfigEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.prefetch(eq, access);
            return this.fetchInternal(eq, access, networkResource, instanceQuery);
        }

        @Override
        protected void populateEntry(RbServiceConfigEntry entry, ServicePipeDb_ServicePipe dataObject) {
            entry.setRbServiceID(dataObject.getID().longValue());
            entry.setRbServiceIdx(dataObject.getINDEX());
            entry.setRbServiceName(dataObject.getName());
            ServiceProfileDb_ServiceProfile sp = this.spIdIdxMap.get(dataObject.getServiceProfileId());
            if (sp == null) {
                log.error((Object)("Inconsistent backup file [SP " + dataObject.getServiceProfileId() + " not found]"));
            }
            entry.setRbServiceType(RbServiceTemplateConfigEntry.getRbServiceTypeFromConfigFileType(sp.getServiceType(), this.ipSwitchingMode));
            entry.setRbServiceServiceTemplateIdx(sp.getINDEX());
            entry.setRbServiceServiceTemplateName(sp.getName());
            SubscriberDb_Subscriber sub = this.subIdMap.get(dataObject.getSubscriberId());
            if (sub == null) {
                log.error((Object)("Inconsistent backup file [Subscriber " + dataObject.getSubscriberId() + " not found]"));
            }
            entry.setRbSubscriberIdx(sub.getINDEX());
            entry.setRbSubscriberID(sub.getName());
            entry.setRbServiceSuMacAddress(dataObject.getSUMacAddress());
            entry.setRbServiceAdminStatus(2 == dataObject.getAdminStatus() ? 1 : 2);
            this.populateVLANListParams(entry, this.vlans.get(dataObject.getID()));
            entry.setRbServiceAccessVLAN(dataObject.getAccessVlan());
            entry.setRbServiceVLANClassificationMode(dataObject.getVlanClassMode());
            entry.setRbServiceAUSlotNumber(255);
        }

        private void populateVLANListParams(RbServiceConfigEntry entry, StringBuffer vlansSB) {
            int i;
            StringBuffer sb = null != vlansSB && 0 < vlansSB.length() ? new StringBuffer(vlansSB) : new StringBuffer("0");
            int commaCount = 0;
            for (i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) != ',') continue;
                ++commaCount;
            }
            for (i = 15 - commaCount; i > 0; --i) {
                sb.append(",0");
            }
            String VLANListStr = sb.toString();
            int vlanCount = 0;
            boolean hybridModeEnable = false;
            int[] vlanArray = ConfigFileMOAccessHandler.getVLANListFromCommaSeparated(VLANListStr);
            for (int i2 = 0; i2 < vlanArray.length && vlanArray[i2] > 0; ++i2) {
                ++vlanCount;
                if (4095 != vlanArray[i2]) continue;
                hybridModeEnable = true;
            }
            entry.setRbServiceClientSiteVLANListAsString(VLANListStr);
            entry.setRbServiceClientSiteVLANListCount(vlanCount);
            entry.setRbServiceVLANHybridMode(hybridModeEnable ? 1 : 2);
        }

        private static int[] getVLANListFromCommaSeparated(String commaSeparated) {
            if ("".equals(commaSeparated)) {
                return new int[0];
            }
            String[] parts = commaSeparated.split(",");
            int[] vlanList = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                vlanList[i] = "".equals(parts[i]) ? 0 : Integer.parseInt(parts[i]);
            }
            return vlanList;
        }

        public List<RbServiceConfigEntry> fetchInternal(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            if (instanceQuery != null || "*".equals(instanceQuery)) {
                return super.fetch(eq, access, networkResource, instanceQuery);
            }
            if (instanceQuery.contains("*")) {
                throw new UnsupportedOperationException("Config file - fetch operation wrong instance query format");
            }
            long idx = Long.parseLong(instanceQuery);
            ArrayList<RbServiceConfigEntry> entries = new ArrayList<RbServiceConfigEntry>();
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, this.getDataObjectClass());
            List dataObjects = access.fetchObject(networkResource, this.getDataObjectClass(), includedProperties, instanceQuery);
            for (ServicePipeDb_ServicePipe dataObject : dataObjects) {
                if (idx != dataObject.getINDEX()) continue;
                RbServiceConfigEntry entry = this.createEntry();
                this.populateEntry(entry, dataObject);
                entries.add(entry);
                break;
            }
            return entries;
        }
    }
}

