/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.gui.configuration.services.RbQoSProfileConfigEntryEditorView;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.QosDb_Qos;
import com.bwanms.rb.mo.services.RbServiceProfilesGetNewEntryId;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.util.MultipleStringList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.4.1.1", indexColumns={"RbQoSProfileIdx"})
public class RbQoSProfileConfigEntry
extends DynamicTableRowMO
implements Identifiable {
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private String instance;
    private Long rbQoSProfileIdx;
    private String rbQoSProfileName;
    private Long rbQoSProfileID;
    private Integer rbQoSProfileType;
    public static final int RbQoSProfileTypeRbCG = 0;
    public static final int RbQoSProfileTypeRbRT = 1;
    public static final int RbQoSProfileTypeRbNRT = 2;
    public static final int RbQoSProfileTypeRbBE = 3;
    private Long rbQoSProfileParam1;
    private Long rbQoSProfileParam2;
    private Integer rbQoSProfileParamTime;
    public static final int RbQoSProfileParamTimeShort = 1;
    public static final int RbQoSProfileParamTimeMedium = 2;
    public static final int RbQoSProfileParamTimeLong = 3;
    private Integer rbAQoSProfileRowStatus;
    public static final String TRANSPARENT = "@@Transparent@@";
    public static final String IP_MODE_VOIP = "@@IP Mode VoIP@@";
    public static final int RbAQoSProfileRowStatusActive = 1;
    public static final int RbAQoSProfileRowStatusNotInService = 2;
    public static final int RbAQoSProfileRowStatusNotReady = 3;
    public static final int RbAQoSProfileRowStatusCreateAndGo = 4;
    public static final int RbAQoSProfileRowStatusCreateAndWait = 5;
    public static final int RbAQoSProfileRowStatusDestroy = 6;
    private Integer rbQoSProfileClass;
    public static final int RbQoSProfileClassLocal = 1;
    public static final int RbQoSProfileClassGlobal = 2;
    protected String complexKey;
    private static String defaultNullComplexKey;
    private boolean isSwBiggerOrEquals301 = false;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.1", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbQoSProfileIdx() {
        return this.rbQoSProfileIdx;
    }

    public void setRbQoSProfileIdx(Long rbQoSProfileIdx) {
        this.rbQoSProfileIdx = rbQoSProfileIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.2", type=-128)
    @ConfigAttribute
    public String getRbQoSProfileName() {
        return this.rbQoSProfileName;
    }

    public void setRbQoSProfileName(String rbQoSProfileName) {
        this.rbQoSProfileName = rbQoSProfileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.3", type=66, readOnly=true)
    @ConfigAttribute
    public Long getRbQoSProfileID() {
        return this.rbQoSProfileID;
    }

    public void setRbQoSProfileID(Long rbQoSProfileID) {
        this.rbQoSProfileID = rbQoSProfileID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.4", type=2)
    @ConfigAttribute
    public Integer getRbQoSProfileType() {
        return this.rbQoSProfileType;
    }

    public void setRbQoSProfileType(Integer rbQoSProfileType) {
        this.rbQoSProfileType = rbQoSProfileType;
    }

    public static String toStringRbQoSProfileType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "rbCG(0)";
                break;
            }
            case 1: {
                result = "rbRT(1)";
                break;
            }
            case 2: {
                result = "rbNRT(2)";
                break;
            }
            case 3: {
                result = "rbBE(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.5", type=66)
    @ConfigAttribute
    public Long getRbQoSProfileParam1() {
        return this.rbQoSProfileParam1;
    }

    public void setRbQoSProfileParam1(Long rbQoSProfileParam1) {
        this.rbQoSProfileParam1 = rbQoSProfileParam1;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.6", type=66)
    @ConfigAttribute
    public Long getRbQoSProfileParam2() {
        return this.rbQoSProfileParam2;
    }

    public void setRbQoSProfileParam2(Long rbQoSProfileParam2) {
        this.rbQoSProfileParam2 = rbQoSProfileParam2;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.7", type=2)
    @ConfigAttribute
    public Integer getRbQoSProfileParamTime() {
        return this.rbQoSProfileParamTime;
    }

    public void setRbQoSProfileParamTime(Integer rbQoSProfileParamTime) {
        this.rbQoSProfileParamTime = rbQoSProfileParamTime;
    }

    public static String toStringRbQoSProfileParamTime(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "short(1)";
                break;
            }
            case 2: {
                result = "medium(2)";
                break;
            }
            case 3: {
                result = "long(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.8", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbAQoSProfileRowStatus;
    }

    public void setRowStatus(Integer rbAQoSProfileRowStatus) {
        this.rbAQoSProfileRowStatus = rbAQoSProfileRowStatus;
    }

    public String toStringRbAQoSProfileRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.4.1.1.9", type=2)
    @InventoryAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbQoSProfileClass() {
        return this.rbQoSProfileClass;
    }

    public void setRbQoSProfileClass(Integer rbQoSProfileClass) {
        this.rbQoSProfileClass = rbQoSProfileClass;
    }

    public static String toStringRbQoSProfileClass(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "local(1)";
                break;
            }
            case 2: {
                result = "global(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbQoSProfileIdx=").append(this.rbQoSProfileIdx).append(", ");
        result.append("rbQoSProfileName=").append(this.rbQoSProfileName).append(", ");
        result.append("rbQoSProfileID=").append(this.rbQoSProfileID).append(", ");
        result.append("rbQoSProfileType=").append(RbQoSProfileConfigEntry.toStringRbQoSProfileType(this.rbQoSProfileType)).append(", ");
        result.append("rbQoSProfileParam1=").append(this.rbQoSProfileParam1).append(", ");
        result.append("rbQoSProfileParam2=").append(this.rbQoSProfileParam2).append(", ");
        result.append("rbQoSProfileParamTime=").append(RbQoSProfileConfigEntry.toStringRbQoSProfileParamTime(this.rbQoSProfileParamTime)).append(", ");
        result.append("rbAQoSProfileRowStatus=").append(this.toStringRbAQoSProfileRowStatus(this.rbAQoSProfileRowStatus)).append(", ");
        result.append("rbQoSProfileClass=").append(RbQoSProfileConfigEntry.toStringRbQoSProfileClass(this.rbQoSProfileClass)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbQoSProfileIdx().toString();
    }

    public void validateUndeclaredConstraints(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbQoSProfileConfigEntryEditorView.class);
        String name = this.getRbQoSProfileName();
        if (name == null || name.trim().equals("") || !name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") || name.length() > 32) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidName"), RbQoSProfileConfigEntry.class, "rbQoSProfileName", (Object)name, (Object)this));
        }
        this.validateValues(invalidValues);
    }

    public void validateValues(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbQoSProfile.class);
        if (this.rbQoSProfileType != null) {
            if (this.rbQoSProfileType == 0) {
                String message = "ValueBetween";
                if (this.rbQoSProfileParam1 == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString(message, (Object[])new String[]{"64", "1550"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam1", (Object)"", (Object)this));
                } else if (this.rbQoSProfileParam1 != Long.MAX_VALUE && (this.rbQoSProfileParam1 < 64L || this.rbQoSProfileParam1 > 1550L)) {
                    invalidValues.add(new InvalidValue(i18n.translateString(message, (Object[])new String[]{"64", "1550"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam1", (Object)this.rbQoSProfileParam1, (Object)this));
                }
                if (this.rbQoSProfileParam2 == null) {
                    message = "ValueBetweenMultiple";
                    invalidValues.add(new InvalidValue(i18n.translateString(message, (Object[])new String[]{"5", "100", "5"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam2", (Object)"", (Object)this));
                } else if (this.rbQoSProfileParam2 != Long.MAX_VALUE && (this.rbQoSProfileParam2 < 5L || this.rbQoSProfileParam2 > 100L || this.rbQoSProfileParam2 % 5L != 0L)) {
                    message = "ValueBetweenMultiple";
                    invalidValues.add(new InvalidValue(i18n.translateString(message, (Object[])new String[]{"5", "100", "5"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam2", (Object)this.rbQoSProfileParam2, (Object)this));
                }
                this.nullCT(invalidValues, i18n);
            } else if (this.rbQoSProfileType == 1) {
                this.validateCIR(invalidValues, i18n);
                this.nullMIR(invalidValues, i18n);
                this.validateCT(invalidValues, i18n);
            } else if (this.rbQoSProfileType == 2) {
                boolean validCIR = this.validateCIR(invalidValues, i18n);
                this.validateMIR(invalidValues, i18n);
                if (validCIR && this.rbQoSProfileParam1 != null && this.rbQoSProfileParam2 != null && this.rbQoSProfileParam2 < this.rbQoSProfileParam1) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", (Object[])new String[]{this.rbQoSProfileParam1.toString(), "12000"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam2", (Object)this.rbQoSProfileParam2, (Object)this));
                }
                this.validateCT(invalidValues, i18n);
            } else if (this.rbQoSProfileType == 3) {
                this.validateMIR(invalidValues, i18n);
                this.nullCIR(invalidValues, i18n);
                this.validateCT(invalidValues, i18n);
            }
        }
    }

    private void validateMIR(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.rbQoSProfileParam2 == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", (Object[])new String[]{"1", "12000"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam2", (Object)"", (Object)this));
        } else if (this.rbQoSProfileParam2 != Long.MAX_VALUE && (this.rbQoSProfileParam2 < 1L || this.rbQoSProfileParam2 > 12000L)) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", (Object[])new String[]{"1", "12000"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam2", (Object)this.rbQoSProfileParam2, (Object)this));
        }
    }

    private boolean validateCIR(List<InvalidValue> invalidValues, Internationalizer i18n) {
        int lowerLimit;
        int n = lowerLimit = this.isSwBiggerOrEquals301 ? 1 : 0;
        if (this.rbQoSProfileParam1 == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", (Object[])new String[]{String.valueOf(lowerLimit), "12000"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam1", (Object)"", (Object)this));
        } else {
            if (this.rbQoSProfileParam1 == Long.MAX_VALUE) {
                return false;
            }
            if (this.rbQoSProfileParam1 < (long)lowerLimit || this.rbQoSProfileParam1 > 12000L) {
                invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", (Object[])new String[]{String.valueOf(lowerLimit), "12000"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam1", (Object)this.rbQoSProfileParam1, (Object)this));
                return false;
            }
        }
        return true;
    }

    private void nullMIR(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.rbQoSProfileParam2 != null && this.rbQoSProfileParam2 != 0L) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidMIR", (Object[])new String[]{"0"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam2", (Object)this.rbQoSProfileParam2, (Object)this));
        }
    }

    private void nullCIR(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.rbQoSProfileParam1 != null && this.rbQoSProfileParam1 != 0L) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidCIR", (Object[])new String[]{"0"}), RbQoSProfileConfigEntry.class, "rbQoSProfileParam1", (Object)this.rbQoSProfileParam1, (Object)this));
        }
    }

    private void validateCT(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.rbQoSProfileParamTime == null || this.rbQoSProfileParamTime == 0) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidCT"), RbQoSProfileConfigEntry.class, "rbQoSProfileParamTime", (Object)"", (Object)this));
        }
    }

    private void nullCT(List<InvalidValue> invalidValues, Internationalizer i18n) {
        if (this.rbQoSProfileParamTime != null && this.rbQoSProfileParamTime != 0) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidCT"), RbQoSProfileConfigEntry.class, "rbQoSProfileParamTime", (Object)"", (Object)this));
        }
    }

    public String getComplexKey() {
        if (null == this.complexKey) {
            this.computeAndSetComplexKey();
        }
        return this.complexKey;
    }

    public void setComplexKey(String complexKey) {
        this.complexKey = complexKey;
    }

    public void computeAndSetComplexKey() {
        MultipleStringList attribValues = new MultipleStringList();
        attribValues.addToList(this.getRbQoSProfileName());
        Integer type = this.getRbQoSProfileType();
        attribValues.addToList(type);
        if (null != type) {
            if (3 != type) {
                attribValues.addToList(this.getRbQoSProfileParam1());
            } else {
                attribValues.addNullToList();
            }
            if (1 != type) {
                attribValues.addToList(this.getRbQoSProfileParam2());
            } else {
                attribValues.addNullToList();
            }
            if (0 != type) {
                attribValues.addToList(this.getRbQoSProfileParamTime());
            } else {
                attribValues.addNullToList();
            }
        } else {
            attribValues.addNullToList();
            attribValues.addNullToList();
            attribValues.addNullToList();
        }
        this.setComplexKey(attribValues.getAsString());
    }

    @Transient
    public static String getDefaultNullComplexKey() {
        if (null == defaultNullComplexKey) {
            RbQoSProfileConfigEntry entry = new RbQoSProfileConfigEntry();
            entry.computeAndSetComplexKey();
            defaultNullComplexKey = entry.getComplexKey();
        }
        return defaultNullComplexKey;
    }

    public void setSwBiggerOrEquals301(boolean b) {
        this.isSwBiggerOrEquals301 = b;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbQoSProfileConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbQoSProfileConfigEntry>(){

            public ManagedObjectAccessHandler<RbQoSProfileConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbQoSProfileConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbQoSProfileConfigEntry>(){

            public ManagedObjectAccessHandler<RbQoSProfileConfigEntry> createHandler() {
                return new RbQoSProfileConfigTableRowMOAccessHandler(RbQoSProfileConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbQoSProfileConfigTableRowMOAccessHandler
    extends SNMPDynamicTableRowMOAccessHandler<RbQoSProfileConfigEntry> {
        public RbQoSProfileConfigTableRowMOAccessHandler(Class<RbQoSProfileConfigEntry> moClass) {
            super(moClass);
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbQoSProfileConfigEntry managedObject) throws MediationException {
            if (managedObject.getRbQoSProfileIdx() < 0L) {
                Long idx = RbServiceProfilesGetNewEntryId.getNewIdxReplacement(access, "rbGetNewQoSProfileId");
                managedObject.setRbQoSProfileIdx(idx);
            }
            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbQoSProfileConfigEntry, QosDb_Qos> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbQoSProfileConfigEntry createEntry() {
            return new RbQoSProfileConfigEntry();
        }

        @Override
        protected Class<QosDb_Qos> getDataObjectClass() {
            return QosDb_Qos.class;
        }

        @Override
        protected void populateEntry(RbQoSProfileConfigEntry entry, QosDb_Qos dataObject) {
            entry.setRbQoSProfileID(dataObject.getID().longValue());
            entry.setRbQoSProfileIdx(dataObject.getINDEX());
            entry.setRbQoSProfileName(dataObject.getName());
            entry.setRbQoSProfileType(dataObject.getQoSType() - 1);
            entry.setRbQoSProfileParam1(dataObject.getQoSParamBytes1());
            entry.setRbQoSProfileParam2(0 == entry.getRbQoSProfileType() ? dataObject.getQoSParamBytes2() / 1000L : dataObject.getQoSParamBytes2());
            switch (dataObject.getQoSParamTime().intValue()) {
                case 0: {
                    entry.setRbQoSProfileParamTime(0);
                    break;
                }
                case 50000: {
                    entry.setRbQoSProfileParamTime(1);
                    break;
                }
                case 100000: {
                    entry.setRbQoSProfileParamTime(2);
                    break;
                }
                case 200000: 
                case 1000000: {
                    entry.setRbQoSProfileParamTime(3);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid ParamTime: " + dataObject.getQoSParamTime().intValue() + "  ( name = " + dataObject.getName() + " )"));
                }
            }
            if (null != dataObject.getLock()) {
                entry.setRbQoSProfileClass(0 == dataObject.getLock() ? 1 : 2);
            }
        }
    }
}

