/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.gui.configuration.services.RbQoSProfileConfigEntryEditorView;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.PriorityClassProfileDb_PriorityClassProfile;
import com.bwanms.rb.mo.configfile.QosDb_Qos;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceProfiles;
import com.bwanms.rb.mo.services.RbServiceProfilesGetNewEntryId;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.util.MultipleStringList;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.5.1.1", indexColumns={"RbPolicyRuleIdx"})
public class RbPolicyRuleConfigEntry
extends DynamicTableRowMO
implements Identifiable {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Long rbPolicyRuleIdx;
    private String rbPolicyRuleName;
    private Long rbPolicyRuleID;
    private Integer rbPolicyRulePriorityType;
    private Long rbPolicyRuleUpQoSProfileIdx1;
    private Long rbPolicyRuleUpQoSUpperLimit1;
    private Long rbPolicyRuleUpQoSProfileIdx2;
    private Long rbPolicyRuleUpQoSUpperLimit2;
    private Long rbPolicyRuleUpQoSProfileIdx3;
    private Long rbPolicyRuleUpQoSUpperLimit3;
    private Long rbPolicyRuleUpQoSProfileIdx4;
    private Long rbPolicyRuleUpQoSUpperLimit4;
    private Long rbPolicyRuleDownQoSProfileIdx1;
    private Long rbPolicyRuleDownQoSUpperLimit1;
    private Long rbPolicyRuleDownQoSProfileIdx2;
    private Long rbPolicyRuleDownQoSUpperLimit2;
    private Long rbPolicyRuleDownQoSProfileIdx3;
    private Long rbPolicyRuleDownQoSUpperLimit3;
    private Long rbPolicyRuleDownQoSProfileIdx4;
    private Long rbPolicyRuleDownQoSUpperLimit4;
    private Integer rbAPolicyRuleRowStatus;
    public static final int RbPolicyRulePriorityTypeRbDSCP = 1;
    public static final int RbPolicyRulePriorityTypeRb8021p = 2;
    public static final int RbAPolicyRuleRowStatusActive = 1;
    public static final int RbAPolicyRuleRowStatusNotInService = 2;
    public static final int RbAPolicyRuleRowStatusNotReady = 3;
    public static final int RbAPolicyRuleRowStatusCreateAndGo = 4;
    public static final int RbAPolicyRuleRowStatusCreateAndWait = 5;
    public static final int RbAPolicyRuleRowStatusDestroy = 6;
    public static final int RbPolicyRuleClassLocal = 1;
    public static final int RbPolicyRuleClassGlobal = 2;
    private Integer rbPolicyRuleClass;
    protected String complexKey;
    private static String defaultNullComplexKey;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.1", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbPolicyRuleIdx() {
        return this.rbPolicyRuleIdx;
    }

    public void setRbPolicyRuleIdx(Long rbPolicyRuleIdx) {
        this.rbPolicyRuleIdx = rbPolicyRuleIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.2", type=-128)
    @ConfigAttribute
    public String getRbPolicyRuleName() {
        return this.rbPolicyRuleName;
    }

    public void setRbPolicyRuleName(String rbPolicyRuleName) {
        this.rbPolicyRuleName = rbPolicyRuleName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.3", type=66, readOnly=true)
    @ConfigAttribute
    public Long getRbPolicyRuleID() {
        return this.rbPolicyRuleID;
    }

    public void setRbPolicyRuleID(Long rbPolicyRuleID) {
        this.rbPolicyRuleID = rbPolicyRuleID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.4", type=2)
    @ConfigAttribute
    public Integer getRbPolicyRulePriorityType() {
        return this.rbPolicyRulePriorityType;
    }

    public void setRbPolicyRulePriorityType(Integer rbPolicyRulePriorityType) {
        this.rbPolicyRulePriorityType = rbPolicyRulePriorityType;
    }

    public static String toStringRbPolicyRulePriorityType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "rbDSCP(1)";
                break;
            }
            case 2: {
                result = "rb8021p(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.6", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleUpQoSProfileIdx1() {
        return this.rbPolicyRuleUpQoSProfileIdx1;
    }

    public void setRbPolicyRuleUpQoSProfileIdx1(Long rbPolicyRuleUpQoSProfileIdx1) {
        this.rbPolicyRuleUpQoSProfileIdx1 = rbPolicyRuleUpQoSProfileIdx1;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.7", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleUpQoSUpperLimit1() {
        return this.rbPolicyRuleUpQoSUpperLimit1;
    }

    public void setRbPolicyRuleUpQoSUpperLimit1(Long rbPolicyRuleUpQoSUpperLimit1) {
        this.rbPolicyRuleUpQoSUpperLimit1 = rbPolicyRuleUpQoSUpperLimit1;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.9", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleUpQoSProfileIdx2() {
        return this.rbPolicyRuleUpQoSProfileIdx2;
    }

    public void setRbPolicyRuleUpQoSProfileIdx2(Long rbPolicyRuleUpQoSProfileIdx2) {
        this.rbPolicyRuleUpQoSProfileIdx2 = rbPolicyRuleUpQoSProfileIdx2;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.10", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleUpQoSUpperLimit2() {
        return this.rbPolicyRuleUpQoSUpperLimit2;
    }

    public void setRbPolicyRuleUpQoSUpperLimit2(Long rbPolicyRuleUpQoSUpperLimit2) {
        this.rbPolicyRuleUpQoSUpperLimit2 = rbPolicyRuleUpQoSUpperLimit2;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.12", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleUpQoSProfileIdx3() {
        return this.rbPolicyRuleUpQoSProfileIdx3;
    }

    public void setRbPolicyRuleUpQoSProfileIdx3(Long rbPolicyRuleUpQoSProfileIdx3) {
        this.rbPolicyRuleUpQoSProfileIdx3 = rbPolicyRuleUpQoSProfileIdx3;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.13", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleUpQoSUpperLimit3() {
        return this.rbPolicyRuleUpQoSUpperLimit3;
    }

    public void setRbPolicyRuleUpQoSUpperLimit3(Long rbPolicyRuleUpQoSUpperLimit3) {
        this.rbPolicyRuleUpQoSUpperLimit3 = rbPolicyRuleUpQoSUpperLimit3;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.15", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleUpQoSProfileIdx4() {
        return this.rbPolicyRuleUpQoSProfileIdx4;
    }

    public void setRbPolicyRuleUpQoSProfileIdx4(Long rbPolicyRuleUpQoSProfileIdx4) {
        this.rbPolicyRuleUpQoSProfileIdx4 = rbPolicyRuleUpQoSProfileIdx4;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.16", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleUpQoSUpperLimit4() {
        return this.rbPolicyRuleUpQoSUpperLimit4;
    }

    public void setRbPolicyRuleUpQoSUpperLimit4(Long rbPolicyRuleUpQoSUpperLimit4) {
        this.rbPolicyRuleUpQoSUpperLimit4 = rbPolicyRuleUpQoSUpperLimit4;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.18", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleDownQoSProfileIdx1() {
        return this.rbPolicyRuleDownQoSProfileIdx1;
    }

    public void setRbPolicyRuleDownQoSProfileIdx1(Long rbPolicyRuleDownQoSProfileIdx1) {
        this.rbPolicyRuleDownQoSProfileIdx1 = rbPolicyRuleDownQoSProfileIdx1;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.19", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleDownQoSUpperLimit1() {
        return this.rbPolicyRuleDownQoSUpperLimit1;
    }

    public void setRbPolicyRuleDownQoSUpperLimit1(Long rbPolicyRuleDownQoSUpperLimit1) {
        this.rbPolicyRuleDownQoSUpperLimit1 = rbPolicyRuleDownQoSUpperLimit1;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.21", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleDownQoSProfileIdx2() {
        return this.rbPolicyRuleDownQoSProfileIdx2;
    }

    public void setRbPolicyRuleDownQoSProfileIdx2(Long rbPolicyRuleDownQoSProfileIdx2) {
        this.rbPolicyRuleDownQoSProfileIdx2 = rbPolicyRuleDownQoSProfileIdx2;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.22", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleDownQoSUpperLimit2() {
        return this.rbPolicyRuleDownQoSUpperLimit2;
    }

    public void setRbPolicyRuleDownQoSUpperLimit2(Long rbPolicyRuleDownQoSUpperLimit2) {
        this.rbPolicyRuleDownQoSUpperLimit2 = rbPolicyRuleDownQoSUpperLimit2;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.24", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleDownQoSProfileIdx3() {
        return this.rbPolicyRuleDownQoSProfileIdx3;
    }

    public void setRbPolicyRuleDownQoSProfileIdx3(Long rbPolicyRuleDownQoSProfileIdx3) {
        this.rbPolicyRuleDownQoSProfileIdx3 = rbPolicyRuleDownQoSProfileIdx3;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.25", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleDownQoSUpperLimit3() {
        return this.rbPolicyRuleDownQoSUpperLimit3;
    }

    public void setRbPolicyRuleDownQoSUpperLimit3(Long rbPolicyRuleDownQoSUpperLimit3) {
        this.rbPolicyRuleDownQoSUpperLimit3 = rbPolicyRuleDownQoSUpperLimit3;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.27", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleDownQoSProfileIdx4() {
        return this.rbPolicyRuleDownQoSProfileIdx4;
    }

    public void setRbPolicyRuleDownQoSProfileIdx4(Long rbPolicyRuleDownQoSProfileIdx4) {
        this.rbPolicyRuleDownQoSProfileIdx4 = rbPolicyRuleDownQoSProfileIdx4;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.28", type=66)
    @ConfigAttribute
    public Long getRbPolicyRuleDownQoSUpperLimit4() {
        return this.rbPolicyRuleDownQoSUpperLimit4;
    }

    public void setRbPolicyRuleDownQoSUpperLimit4(Long rbPolicyRuleDownQoSUpperLimit4) {
        this.rbPolicyRuleDownQoSUpperLimit4 = rbPolicyRuleDownQoSUpperLimit4;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.29", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbAPolicyRuleRowStatus;
    }

    public void setRowStatus(Integer rbAPolicyRuleRowStatus) {
        this.rbAPolicyRuleRowStatus = rbAPolicyRuleRowStatus;
    }

    public String toStringRbAPolicyRuleRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.5.1.1.30", type=2)
    @Column(name="rbPolicyRuleClass")
    @InventoryAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbPolicyRuleClass() {
        return this.rbPolicyRuleClass;
    }

    public void setRbPolicyRuleClass(Integer rbPolicyRuleClass) {
        this.rbPolicyRuleClass = rbPolicyRuleClass;
    }

    public static String toStringRbPolicyRuleClass(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "local(1)";
                break;
            }
            case 2: {
                result = "global(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbPolicyRuleIdx=").append(this.rbPolicyRuleIdx).append(", ");
        result.append("rbPolicyRuleName=").append(this.rbPolicyRuleName).append(", ");
        result.append("rbPolicyRuleID=").append(this.rbPolicyRuleID).append(", ");
        result.append("rbPolicyRulePriorityType=").append(RbPolicyRuleConfigEntry.toStringRbPolicyRulePriorityType(this.rbPolicyRulePriorityType)).append(", ");
        result.append("rbPolicyRuleUpQoSProfileIdx1=").append(this.rbPolicyRuleUpQoSProfileIdx1).append(", ");
        result.append("rbPolicyRuleUpQoSUpperLimit1=").append(this.rbPolicyRuleUpQoSUpperLimit1).append(", ");
        result.append("rbPolicyRuleUpQoSProfileIdx2=").append(this.rbPolicyRuleUpQoSProfileIdx2).append(", ");
        result.append("rbPolicyRuleUpQoSUpperLimit2=").append(this.rbPolicyRuleUpQoSUpperLimit2).append(", ");
        result.append("rbPolicyRuleUpQoSProfileIdx3=").append(this.rbPolicyRuleUpQoSProfileIdx3).append(", ");
        result.append("rbPolicyRuleUpQoSUpperLimit3=").append(this.rbPolicyRuleUpQoSUpperLimit3).append(", ");
        result.append("rbPolicyRuleUpQoSProfileIdx4=").append(this.rbPolicyRuleUpQoSProfileIdx4).append(", ");
        result.append("rbPolicyRuleUpQoSUpperLimit4=").append(this.rbPolicyRuleUpQoSUpperLimit4).append(", ");
        result.append("rbPolicyRuleDownQoSProfileIdx1=").append(this.rbPolicyRuleDownQoSProfileIdx1).append(", ");
        result.append("rbPolicyRuleDownQoSUpperLimit1=").append(this.rbPolicyRuleDownQoSUpperLimit1).append(", ");
        result.append("rbPolicyRuleDownQoSProfileIdx2=").append(this.rbPolicyRuleDownQoSProfileIdx2).append(", ");
        result.append("rbPolicyRuleDownQoSUpperLimit2=").append(this.rbPolicyRuleDownQoSUpperLimit2).append(", ");
        result.append("rbPolicyRuleDownQoSProfileIdx3=").append(this.rbPolicyRuleDownQoSProfileIdx3).append(", ");
        result.append("rbPolicyRuleDownQoSUpperLimit3=").append(this.rbPolicyRuleDownQoSUpperLimit3).append(", ");
        result.append("rbPolicyRuleDownQoSProfileIdx4=").append(this.rbPolicyRuleDownQoSProfileIdx4).append(", ");
        result.append("rbPolicyRuleDownQoSUpperLimit4=").append(this.rbPolicyRuleDownQoSUpperLimit4).append(", ");
        result.append("rbPolicyRuleClass=").append(this.rbPolicyRuleClass).append(", ");
        result.append("rbAPolicyRuleRowStatus=").append(this.toStringRbAPolicyRuleRowStatus(this.rbAPolicyRuleRowStatus)).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbPolicyRuleIdx().toString();
    }

    public void validateName(List<InvalidValue> invalidValues, Binder mainBinder) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbQoSProfileConfigEntryEditorView.class);
        String name = this.getRbPolicyRuleName();
        if (name == null || name.trim().equals("") || !name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") || name.length() > 32) {
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("InvalidName"), RbPolicyRuleConfigEntry.class, "rbPolicyRuleName", (Object)name, (Object)this));
            mainBinder.toUIInvalidValues(invalidValues, iValues);
        }
    }

    public void validateLimits(boolean verrify, List<InvalidValue> invalidValues, Binder upBinder, Binder downBinder) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbPolicyRule.class);
        this.validatePolicyUpperLimitsDown(verrify, invalidValues, i18n, downBinder);
        this.validatePolicyUpperLimitsUp(verrify, invalidValues, i18n, upBinder);
    }

    public List<InvalidValue> validatePolicyUpperLimitsUp(boolean verrify, List<InvalidValue> iValues, Internationalizer i18n, Binder upBinder) {
        ArrayList<InvalidValue> values = new ArrayList<InvalidValue>();
        long minValue = 0L;
        long maxValue = RbPolicyRule.maxValueForType(this.getRbPolicyRulePriorityType());
        long highestValue = 0L;
        if (this.getRbPolicyRuleUpQoSUpperLimit1() != null && this.getRbPolicyRuleUpQoSUpperLimit1() != 0L || this.getRbPolicyRuleUpQoSUpperLimit2() != null && this.getRbPolicyRuleUpQoSUpperLimit2() != 0L || this.getRbPolicyRuleUpQoSUpperLimit3() != null && this.getRbPolicyRuleUpQoSUpperLimit3() != 0L || this.getRbPolicyRuleUpQoSUpperLimit4() != null && this.getRbPolicyRuleUpQoSUpperLimit4() != 0L) {
            int i;
            ValidationObject element2;
            ArrayList<ValidationObject> validationStuff = new ArrayList<ValidationObject>();
            validationStuff.add(new ValidationObject(this.getRbPolicyRuleUpQoSUpperLimit1(), "rbPolicyRuleUpQoSUpperLimit1", this.getRbPolicyRuleUpQoSProfileIdx1(), "rbPolicyRuleUpQoSProfileIdx1"));
            validationStuff.add(new ValidationObject(this.getRbPolicyRuleUpQoSUpperLimit2(), "rbPolicyRuleUpQoSUpperLimit2", this.getRbPolicyRuleUpQoSProfileIdx2(), "rbPolicyRuleUpQoSProfileIdx2"));
            validationStuff.add(new ValidationObject(this.getRbPolicyRuleUpQoSUpperLimit3(), "rbPolicyRuleUpQoSUpperLimit3", this.getRbPolicyRuleUpQoSProfileIdx3(), "rbPolicyRuleUpQoSProfileIdx3"));
            validationStuff.add(new ValidationObject(this.getRbPolicyRuleUpQoSUpperLimit4(), "rbPolicyRuleUpQoSUpperLimit4", this.getRbPolicyRuleUpQoSProfileIdx4(), "rbPolicyRuleUpQoSProfileIdx4"));
            ValidationObject finalCompletedObject = (ValidationObject)validationStuff.get(0);
            ValidationObject tempCompletedObject = (ValidationObject)validationStuff.get(0);
            for (ValidationObject element2 : validationStuff) {
                finalCompletedObject = element2.getLimitValue() > 0L ? element2 : finalCompletedObject;
            }
            if (finalCompletedObject.getLimitValue() != maxValue) {
                values.add(new InvalidValue(i18n.translateString("highestLimitUp", new Object[]{String.valueOf(maxValue)}), RbPolicyRuleConfigEntry.class, finalCompletedObject.getLimitString(), (Object)finalCompletedObject.getLimitValue(), (Object)this));
            }
            if (finalCompletedObject.getQosIdxValue() == null || finalCompletedObject.getQosIdxValue() == 0L) {
                values.add(new InvalidValue(i18n.translateString("nullQoSProfile"), RbPolicyRuleConfigEntry.class, finalCompletedObject.getQosIdxString(), (Object)finalCompletedObject.getQosIdxValue(), (Object)this));
            }
            for (i = 0; i < validationStuff.indexOf(finalCompletedObject); ++i) {
                element2 = (ValidationObject)validationStuff.get(i);
                if (element2 != tempCompletedObject && element2 != finalCompletedObject && element2.getLimitValue() <= tempCompletedObject.getLimitValue()) {
                    values.add(new InvalidValue(i18n.translateString("GenericValueError"), RbPolicyRuleConfigEntry.class, element2.getLimitString(), (Object)element2.getLimitValue(), (Object)this));
                }
                if (element2.getLimitValue() >= maxValue) {
                    values.add(new InvalidValue(i18n.translateString("higherLimitUp", new Object[]{String.valueOf(maxValue)}), RbPolicyRuleConfigEntry.class, element2.getLimitString(), (Object)element2.getLimitValue(), (Object)this));
                }
                if (element2.getLimitValue() < minValue || element2.getLimitValue() == minValue && i != 0) {
                    values.add(new InvalidValue(i18n.translateString("lowerLimitUp", new Object[]{String.valueOf(minValue)}), RbPolicyRuleConfigEntry.class, element2.getLimitString(), (Object)element2.getLimitValue(), (Object)this));
                }
                if (element2.getQosIdxValue() == null || element2.getQosIdxValue() == 0L) {
                    values.add(new InvalidValue(i18n.translateString("nullQoSProfile"), RbPolicyRuleConfigEntry.class, element2.getQosIdxString(), (Object)element2.getQosIdxValue(), (Object)this));
                }
                tempCompletedObject = element2;
            }
            for (i = Math.max(0, validationStuff.indexOf(finalCompletedObject)); i < validationStuff.size(); ++i) {
                element2 = (ValidationObject)validationStuff.get(i);
                if (element2.getLimitValue() >= minValue) continue;
                values.add(new InvalidValue(i18n.translateString("lowerLimitUp", new Object[]{String.valueOf(minValue)}), RbPolicyRuleConfigEntry.class, element2.getLimitString(), (Object)element2.getLimitValue(), (Object)this));
            }
        } else if (!verrify) {
            this.validateLimit(0L, "rbPolicyRuleUpQoSUpperLimit1", minValue, maxValue, this.getRbPolicyRuleUpQoSProfileIdx1(), "rbPolicyRuleUpQoSProfileIdx1", values, (Object)this, highestValue, i18n);
        }
        upBinder.toUIInvalidValues(iValues, values);
        return values;
    }

    public List<InvalidValue> validatePolicyUpperLimitsDown(boolean verrify, List<InvalidValue> iValues, Internationalizer i18n, Binder downBinder) {
        ArrayList<InvalidValue> values = new ArrayList<InvalidValue>();
        long minValue = 0L;
        long maxValue = RbPolicyRule.maxValueForType(this.getRbPolicyRulePriorityType());
        long highestValue = 0L;
        if (this.getRbPolicyRuleDownQoSUpperLimit1() != null && this.getRbPolicyRuleDownQoSUpperLimit1() != 0L || this.getRbPolicyRuleDownQoSUpperLimit2() != null && this.getRbPolicyRuleDownQoSUpperLimit2() != 0L || this.getRbPolicyRuleDownQoSUpperLimit3() != null && this.getRbPolicyRuleDownQoSUpperLimit3() != 0L || this.getRbPolicyRuleDownQoSUpperLimit4() != null && this.getRbPolicyRuleDownQoSUpperLimit4() != 0L) {
            int i;
            ValidationObject element2;
            ArrayList<ValidationObject> validationStuff = new ArrayList<ValidationObject>();
            validationStuff.add(new ValidationObject(this.getRbPolicyRuleDownQoSUpperLimit1(), "rbPolicyRuleDownQoSUpperLimit1", this.getRbPolicyRuleDownQoSProfileIdx1(), "rbPolicyRuleDownQoSProfileIdx1"));
            validationStuff.add(new ValidationObject(this.getRbPolicyRuleDownQoSUpperLimit2(), "rbPolicyRuleDownQoSUpperLimit2", this.getRbPolicyRuleDownQoSProfileIdx2(), "rbPolicyRuleDownQoSProfileIdx2"));
            validationStuff.add(new ValidationObject(this.getRbPolicyRuleDownQoSUpperLimit3(), "rbPolicyRuleDownQoSUpperLimit3", this.getRbPolicyRuleDownQoSProfileIdx3(), "rbPolicyRuleDownQoSProfileIdx3"));
            validationStuff.add(new ValidationObject(this.getRbPolicyRuleDownQoSUpperLimit4(), "rbPolicyRuleDownQoSUpperLimit4", this.getRbPolicyRuleDownQoSProfileIdx4(), "rbPolicyRuleDownQoSProfileIdx4"));
            ValidationObject finalCompletedObject = (ValidationObject)validationStuff.get(0);
            ValidationObject tempCompletedObject = (ValidationObject)validationStuff.get(0);
            for (ValidationObject element2 : validationStuff) {
                finalCompletedObject = element2.getLimitValue() > 0L ? element2 : finalCompletedObject;
            }
            if (finalCompletedObject.getLimitValue() != maxValue) {
                values.add(new InvalidValue(i18n.translateString("highestLimitUp", new Object[]{String.valueOf(maxValue)}), RbPolicyRuleConfigEntry.class, finalCompletedObject.getLimitString(), (Object)finalCompletedObject.getLimitValue(), (Object)this));
            }
            if (finalCompletedObject.getQosIdxValue() == null || finalCompletedObject.getQosIdxValue() == 0L) {
                values.add(new InvalidValue(i18n.translateString("nullQoSProfile"), RbPolicyRuleConfigEntry.class, finalCompletedObject.getQosIdxString(), (Object)finalCompletedObject.getQosIdxValue(), (Object)this));
            }
            for (i = 0; i < validationStuff.indexOf(finalCompletedObject); ++i) {
                element2 = (ValidationObject)validationStuff.get(i);
                if (element2 != tempCompletedObject && element2 != finalCompletedObject && element2.getLimitValue() <= tempCompletedObject.getLimitValue()) {
                    values.add(new InvalidValue(i18n.translateString("GenericValueError"), RbPolicyRuleConfigEntry.class, element2.getLimitString(), (Object)element2.getLimitValue(), (Object)this));
                }
                if (element2.getLimitValue() >= maxValue) {
                    values.add(new InvalidValue(i18n.translateString("higherLimitUp", new Object[]{String.valueOf(maxValue)}), RbPolicyRuleConfigEntry.class, element2.getLimitString(), (Object)element2.getLimitValue(), (Object)this));
                }
                if (element2.getLimitValue() < minValue || element2.getLimitValue() == minValue && i != 0) {
                    values.add(new InvalidValue(i18n.translateString("lowerLimitUp", new Object[]{String.valueOf(minValue)}), RbPolicyRuleConfigEntry.class, element2.getLimitString(), (Object)element2.getLimitValue(), (Object)this));
                }
                if (element2.getQosIdxValue() == null || element2.getQosIdxValue() == 0L) {
                    values.add(new InvalidValue(i18n.translateString("nullQoSProfile"), RbPolicyRuleConfigEntry.class, element2.getQosIdxString(), (Object)element2.getQosIdxValue(), (Object)this));
                }
                tempCompletedObject = element2;
            }
            for (i = Math.max(0, validationStuff.indexOf(finalCompletedObject)); i < validationStuff.size(); ++i) {
                element2 = (ValidationObject)validationStuff.get(i);
                if (element2.getLimitValue() >= minValue) continue;
                values.add(new InvalidValue(i18n.translateString("lowerLimitUp", new Object[]{String.valueOf(minValue)}), RbPolicyRuleConfigEntry.class, element2.getLimitString(), (Object)element2.getLimitValue(), (Object)this));
            }
        } else if (!verrify) {
            this.validateLimit(0L, "rbPolicyRuleDownQoSUpperLimit1", minValue, maxValue, this.getRbPolicyRuleDownQoSProfileIdx1(), "rbPolicyRuleDownQoSProfileIdx1", values, (Object)this, highestValue, i18n);
        }
        downBinder.toUIInvalidValues(iValues, values);
        return values;
    }

    private long validateLimit(Long value, String propertyName, long minValue, long maxValue, Long qosProfileIdx, String profilePropertyName, List<InvalidValue> values, Object bean, long highestValue, Internationalizer i18n) {
        if (value != null && value != 0L && (qosProfileIdx == null || qosProfileIdx == 0L)) {
            values.add(new InvalidValue(i18n.translateString("nullQoSProfile"), RbPolicyRuleConfigEntry.class, profilePropertyName, (Object)"", bean));
        }
        if (maxValue == 0L) {
            minValue = -1L;
        }
        if (minValue < value && value <= maxValue) {
            return highestValue > value ? highestValue : value;
        }
        String message = "ValueBetween";
        if (maxValue > 0L) {
            Object[] params = new String[]{maxValue > minValue ? String.valueOf(highestValue) : i18n.translateString("previousValue"), String.valueOf(maxValue)};
            message = i18n.translateString(message, params);
        } else {
            message = i18n.translateString("MaximumValZero");
        }
        values.add(new InvalidValue(message, RbPolicyRuleConfigEntry.class, propertyName, (Object)value, bean));
        return highestValue;
    }

    @Length(max=760)
    public String getComplexKey() {
        return this.complexKey;
    }

    public void setComplexKey(String complexKey) {
        this.complexKey = complexKey;
    }

    public void computeAndSetComplexKey(RbServiceProfiles serviceProfiles, boolean deep) {
        MultipleStringList attribValues = new MultipleStringList();
        attribValues.addToList(this.getRbPolicyRuleName());
        attribValues.addToList(this.getRbPolicyRulePriorityType());
        attribValues.addToList(Long.valueOf(this.getRbPolicyRuleUpQoSUpperLimit1() == null ? 0L : this.getRbPolicyRuleUpQoSUpperLimit1()));
        attribValues.addToList(Long.valueOf(this.getRbPolicyRuleUpQoSUpperLimit2() == null ? 0L : this.getRbPolicyRuleUpQoSUpperLimit2()));
        attribValues.addToList(Long.valueOf(this.getRbPolicyRuleUpQoSUpperLimit3() == null ? 0L : this.getRbPolicyRuleUpQoSUpperLimit3()));
        attribValues.addToList(Long.valueOf(this.getRbPolicyRuleUpQoSUpperLimit4() == null ? 0L : this.getRbPolicyRuleUpQoSUpperLimit4()));
        attribValues.addToList(Long.valueOf(this.getRbPolicyRuleDownQoSUpperLimit1() == null ? 0L : this.getRbPolicyRuleDownQoSUpperLimit1()));
        attribValues.addToList(Long.valueOf(this.getRbPolicyRuleDownQoSUpperLimit2() == null ? 0L : this.getRbPolicyRuleDownQoSUpperLimit2()));
        attribValues.addToList(Long.valueOf(this.getRbPolicyRuleDownQoSUpperLimit3() == null ? 0L : this.getRbPolicyRuleDownQoSUpperLimit3()));
        attribValues.addToList(Long.valueOf(this.getRbPolicyRuleDownQoSUpperLimit4() == null ? 0L : this.getRbPolicyRuleDownQoSUpperLimit4()));
        RbPolicyRuleConfigEntry.addQosValues(attribValues, this.getRbPolicyRuleUpQoSProfileIdx1(), serviceProfiles, deep);
        RbPolicyRuleConfigEntry.addQosValues(attribValues, this.getRbPolicyRuleUpQoSProfileIdx2(), serviceProfiles, deep);
        RbPolicyRuleConfigEntry.addQosValues(attribValues, this.getRbPolicyRuleUpQoSProfileIdx3(), serviceProfiles, deep);
        RbPolicyRuleConfigEntry.addQosValues(attribValues, this.getRbPolicyRuleUpQoSProfileIdx4(), serviceProfiles, deep);
        RbPolicyRuleConfigEntry.addQosValues(attribValues, this.getRbPolicyRuleDownQoSProfileIdx1(), serviceProfiles, deep);
        RbPolicyRuleConfigEntry.addQosValues(attribValues, this.getRbPolicyRuleDownQoSProfileIdx2(), serviceProfiles, deep);
        RbPolicyRuleConfigEntry.addQosValues(attribValues, this.getRbPolicyRuleDownQoSProfileIdx3(), serviceProfiles, deep);
        RbPolicyRuleConfigEntry.addQosValues(attribValues, this.getRbPolicyRuleDownQoSProfileIdx4(), serviceProfiles, deep);
        this.setComplexKey(attribValues.getAsString());
    }

    private static void addQosValues(MultipleStringList attribValues, Long qosIndex, RbServiceProfiles serviceProfiles, boolean deep) {
        RbQoSProfileConfigEntry qosEntry;
        RbQoSProfileConfigEntry rbQoSProfileConfigEntry = qosEntry = null != qosIndex ? serviceProfiles.findQosProfileEntry(qosIndex) : null;
        if (null == qosEntry) {
            attribValues.addStringListToList(RbQoSProfileConfigEntry.getDefaultNullComplexKey());
        } else {
            if (deep) {
                qosEntry.computeAndSetComplexKey();
            }
            attribValues.addStringListToList(qosEntry.getComplexKey());
        }
    }

    @Transient
    public static String getDefaultNullComplexKey() {
        if (null == defaultNullComplexKey) {
            RbPolicyRuleConfigEntry entry = new RbPolicyRuleConfigEntry();
            entry.computeAndSetComplexKey(null, false);
            defaultNullComplexKey = entry.getComplexKey();
        }
        return defaultNullComplexKey;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbPolicyRuleConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbPolicyRuleConfigEntry>(){

            public ManagedObjectAccessHandler<RbPolicyRuleConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbPolicyRuleConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbPolicyRuleConfigEntry>(){

            public ManagedObjectAccessHandler<RbPolicyRuleConfigEntry> createHandler() {
                return new RbPolicyRuleConfigTableRowMOAccessHandler(RbPolicyRuleConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbPolicyRuleConfigTableRowMOAccessHandler
    extends SNMPDynamicTableRowMOAccessHandler<RbPolicyRuleConfigEntry> {
        public RbPolicyRuleConfigTableRowMOAccessHandler(Class<RbPolicyRuleConfigEntry> moClass) {
            super(moClass);
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbPolicyRuleConfigEntry managedObject) throws MediationException {
            if (managedObject.getRbPolicyRuleIdx() < 0L) {
                Long idx = RbServiceProfilesGetNewEntryId.getNewIdxReplacement(access, "rbGetNewPolicyRuleId");
                managedObject.setRbPolicyRuleIdx(idx);
            }
            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbPolicyRuleConfigEntry, PriorityClassProfileDb_PriorityClassProfile> {
        private TreeMap<Integer, Long> qosIdIdxMap;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbPolicyRuleConfigEntry createEntry() {
            return new RbPolicyRuleConfigEntry();
        }

        private void prefetch(MOAccessSession access) throws MediationException {
            List qosTable = access.fetchObject(null, QosDb_Qos.class);
            this.qosIdIdxMap = new TreeMap();
            for (QosDb_Qos qos : qosTable) {
                this.qosIdIdxMap.put(qos.getID(), qos.getINDEX());
            }
            this.qosIdIdxMap.put(0, 0L);
        }

        @Override
        public List<RbPolicyRuleConfigEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.prefetch(access);
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        @Override
        protected Class<PriorityClassProfileDb_PriorityClassProfile> getDataObjectClass() {
            return PriorityClassProfileDb_PriorityClassProfile.class;
        }

        @Override
        protected void populateEntry(RbPolicyRuleConfigEntry entry, PriorityClassProfileDb_PriorityClassProfile dataObject) {
            entry.setRbPolicyRuleID(dataObject.getID().longValue());
            entry.setRbPolicyRuleIdx(dataObject.getINDEX());
            entry.setRbPolicyRuleName(dataObject.getName());
            entry.setRbPolicyRulePriorityType(dataObject.getPriorityType());
            entry.setRbPolicyRuleDownQoSProfileIdx1(this.qosIdIdxMap.get(dataObject.getQoSDn1Id()));
            entry.setRbPolicyRuleDownQoSProfileIdx2(this.qosIdIdxMap.get(dataObject.getQoSDn2Id()));
            entry.setRbPolicyRuleDownQoSProfileIdx3(this.qosIdIdxMap.get(dataObject.getQoSDn3Id()));
            entry.setRbPolicyRuleDownQoSProfileIdx4(this.qosIdIdxMap.get(dataObject.getQoSDn4Id()));
            entry.setRbPolicyRuleDownQoSUpperLimit1(dataObject.getUpperPriorityLimitDn1().longValue());
            entry.setRbPolicyRuleDownQoSUpperLimit2(dataObject.getUpperPriorityLimitDn2().longValue());
            entry.setRbPolicyRuleDownQoSUpperLimit3(dataObject.getUpperPriorityLimitDn3().longValue());
            entry.setRbPolicyRuleDownQoSUpperLimit4(dataObject.getUpperPriorityLimitDn4().longValue());
            entry.setRbPolicyRuleUpQoSProfileIdx1(this.qosIdIdxMap.get(dataObject.getQoSUp1Id()));
            entry.setRbPolicyRuleUpQoSProfileIdx2(this.qosIdIdxMap.get(dataObject.getQoSUp2Id()));
            entry.setRbPolicyRuleUpQoSProfileIdx3(this.qosIdIdxMap.get(dataObject.getQoSUp3Id()));
            entry.setRbPolicyRuleUpQoSProfileIdx4(this.qosIdIdxMap.get(dataObject.getQoSUp4Id()));
            entry.setRbPolicyRuleUpQoSUpperLimit1(dataObject.getUpperPriorityLimitUp1().longValue());
            entry.setRbPolicyRuleUpQoSUpperLimit2(dataObject.getUpperPriorityLimitUp2().longValue());
            entry.setRbPolicyRuleUpQoSUpperLimit3(dataObject.getUpperPriorityLimitUp3().longValue());
            entry.setRbPolicyRuleUpQoSUpperLimit4(dataObject.getUpperPriorityLimitUp4().longValue());
            if (null != dataObject.getLock()) {
                entry.setRbPolicyRuleClass(0 == dataObject.getLock() ? 1 : 2);
            }
        }
    }

    private class ValidationObject {
        private Long limitValue;
        private String limitString;
        private Long qosIdxValue;
        private String qosIdxString;

        public ValidationObject(Long limitValue, String limitString, Long qosIdxValue, String qosIdxString) {
            this.limitValue = limitValue;
            this.limitString = limitString;
            this.qosIdxValue = qosIdxValue;
            this.qosIdxString = qosIdxString;
        }

        public String getLimitString() {
            return this.limitString;
        }

        public void setLimitString(String limitString) {
            this.limitString = limitString;
        }

        public Long getLimitValue() {
            if (null == this.limitValue) {
                return 0L;
            }
            return this.limitValue;
        }

        public void setLimitValue(Long limitValue) {
            this.limitValue = limitValue;
        }

        public String getQosIdxString() {
            return this.qosIdxString;
        }

        public void setQosIdxString(String qosIdxString) {
            this.qosIdxString = qosIdxString;
        }

        public Long getQosIdxValue() {
            return this.qosIdxValue;
        }

        public void setQosIdxValue(Long qosIdxValue) {
            this.qosIdxValue = qosIdxValue;
        }
    }
}

