/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPDynamicTableRowMOAccessHandler;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.gui.configuration.services.RbForwardingRuleConfigEntryEditorView;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.ForwardingRulesDb_ForwardingRules;
import com.bwanms.rb.mo.configfile.QosDb_Qos;
import com.bwanms.rb.mo.configfile.SwitchingMode_Appl;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceProfiles;
import com.bwanms.rb.mo.services.RbServiceProfilesGetNewEntryId;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.util.MultipleStringList;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import com.bwanms.validation.WeakRange;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.6.2.1", indexColumns={"RbForwardingRuleType", "RbForwardingRuleIdx"})
public class RbForwardingRuleConfigEntry
extends DynamicTableRowMO
implements Identifiable {
    private long id;
    private NetworkResourceConfiguration nrConfiguration;
    private String instance;
    private Integer rbForwardingRuleType;
    private Long rbForwardingRuleIdx;
    private String rbForwardingRuleName;
    private Long rbForwardingRuleID;
    private Integer rbForwardingRuleUnicastRelaying;
    public static final int RbForwardingRuleUnicastRelayingEnable = 1;
    public static final int RbForwardingRuleUnicastRelayingDisable = 2;
    private Integer rbForwardingRuleMulticastRelaying;
    public static final int RbForwardingRuleMulticastRelayingEnable = 1;
    public static final int RbForwardingRuleMulticastRelayingDisable = 2;
    private Integer rbForwardingUnknownAddrPolicy;
    public static final int RbForwardingUnknownAddrPolicyReject = 1;
    public static final int RbForwardingUnknownAddrPolicyForward = 2;
    private Integer rbForwardingRuleMulticastVLAN;
    private Long rbForwardingRuleMulticastQoSIdx;
    private Integer rbAForwardingRuleRowStatus;
    public static final String TRANSPARENT = "@@Transparent@@";
    public static final int RbAForwardingRuleRowStatusActive = 1;
    public static final int RbAForwardingRuleRowStatusNotInService = 2;
    public static final int RbAForwardingRuleRowStatusNotReady = 3;
    public static final int RbAForwardingRuleRowStatusCreateAndGo = 4;
    public static final int RbAForwardingRuleRowStatusCreateAndWait = 5;
    public static final int RbAForwardingRuleRowStatusDestroy = 6;
    private Integer rbForwardingRuleClass;
    public static final int RbForwardingRuleClassLocal = 1;
    public static final int RbForwardingRuleClassGlobal = 2;
    protected String complexKey;
    private static String defaultNullComplexKey;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.1", type=2, readOnly=true)
    @ConfigAttribute
    public Integer getRbForwardingRuleType() {
        return this.rbForwardingRuleType;
    }

    public void setRbForwardingRuleType(Integer rbForwardingRuleType) {
        this.rbForwardingRuleType = rbForwardingRuleType;
    }

    public static String toStringRbForwardingRuleType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "rbLayerII(1)";
                break;
            }
            case 2: {
                result = "rbPPPoE(2)";
                break;
            }
            case 3: {
                result = "rbVoIP(3)";
                break;
            }
            case 4: {
                result = "rbIPModeData(4)";
                break;
            }
            case 5: {
                result = "rbIPModeVoIP(5)";
                break;
            }
            case 6: {
                result = "rbManaged-VoIP(6)";
                break;
            }
            case 7: {
                result = "rbIPmode-Managed-VoIP(7)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.2", type=66, readOnly=true)
    @IdentifierAttribute
    public Long getRbForwardingRuleIdx() {
        return this.rbForwardingRuleIdx;
    }

    public void setRbForwardingRuleIdx(Long rbForwardingRuleIdx) {
        this.rbForwardingRuleIdx = rbForwardingRuleIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.3", type=-128)
    @ConfigAttribute
    public String getRbForwardingRuleName() {
        return this.rbForwardingRuleName;
    }

    public void setRbForwardingRuleName(String rbForwardingRuleName) {
        this.rbForwardingRuleName = rbForwardingRuleName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.4", type=66, readOnly=true)
    @ConfigAttribute
    public Long getRbForwardingRuleID() {
        return this.rbForwardingRuleID;
    }

    public void setRbForwardingRuleID(Long rbForwardingRuleID) {
        this.rbForwardingRuleID = rbForwardingRuleID;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.6", type=2)
    @Column(name="rbFrwrdRuleUnicastRelaying")
    @ConfigAttribute
    public Integer getRbForwardingRuleUnicastRelaying() {
        return this.rbForwardingRuleUnicastRelaying;
    }

    public void setRbForwardingRuleUnicastRelaying(Integer rbForwardingRuleUnicastRelaying) {
        this.rbForwardingRuleUnicastRelaying = rbForwardingRuleUnicastRelaying;
    }

    public static String toStringRbForwardingRuleUnicastRelaying(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.7", type=2)
    @Column(name="rbFrwrdRuleMulticastRelaying")
    @ConfigAttribute
    public Integer getRbForwardingRuleMulticastRelaying() {
        return this.rbForwardingRuleMulticastRelaying;
    }

    public void setRbForwardingRuleMulticastRelaying(Integer rbForwardingRuleMulticastRelaying) {
        this.rbForwardingRuleMulticastRelaying = rbForwardingRuleMulticastRelaying;
    }

    public static String toStringRbForwardingRuleMulticastRelaying(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.8", type=2)
    @Column(name="rbFrwrdUnknownAddrPolicy")
    @ConfigAttribute
    public Integer getRbForwardingUnknownAddrPolicy() {
        return this.rbForwardingUnknownAddrPolicy;
    }

    public void setRbForwardingUnknownAddrPolicy(Integer rbForwardingUnknownAddrPolicy) {
        this.rbForwardingUnknownAddrPolicy = rbForwardingUnknownAddrPolicy;
    }

    public static String toStringRbForwardingUnknownAddrPolicy(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "reject(1)";
                break;
            }
            case 2: {
                result = "forward(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.9", type=2)
    @Column(name="rbFrwrdRuleMulticastVLAN")
    @WeakRange(min=0L, max=4095L)
    @ConfigAttribute
    public Integer getRbForwardingRuleMulticastVLAN() {
        return this.rbForwardingRuleMulticastVLAN;
    }

    public void setRbForwardingRuleMulticastVLAN(Integer rbForwardingRuleMulticastVLAN) {
        this.rbForwardingRuleMulticastVLAN = rbForwardingRuleMulticastVLAN;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.10", type=66)
    @Column(name="rbFrwrdRuleMulticastQoSIdx")
    @ConfigAttribute
    public Long getRbForwardingRuleMulticastQoSIdx() {
        return this.rbForwardingRuleMulticastQoSIdx;
    }

    public void setRbForwardingRuleMulticastQoSIdx(Long rbForwardingRuleMulticastQoSIdx) {
        this.rbForwardingRuleMulticastQoSIdx = rbForwardingRuleMulticastQoSIdx;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.11", type=2)
    @Transient
    public Integer getRowStatus() {
        return this.rbAForwardingRuleRowStatus;
    }

    public void setRowStatus(Integer rbAForwardingRuleRowStatus) {
        this.rbAForwardingRuleRowStatus = rbAForwardingRuleRowStatus;
    }

    public static String toStringRbAForwardingRuleRowStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "active(1)";
                break;
            }
            case 2: {
                result = "notInService(2)";
                break;
            }
            case 3: {
                result = "notReady(3)";
                break;
            }
            case 4: {
                result = "createAndGo(4)";
                break;
            }
            case 5: {
                result = "createAndWait(5)";
                break;
            }
            case 6: {
                result = "destroy(6)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.6.2.1.12", type=2)
    @InventoryAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbForwardingRuleClass() {
        return this.rbForwardingRuleClass;
    }

    public void setRbForwardingRuleClass(Integer rbForwardingRuleClass) {
        this.rbForwardingRuleClass = rbForwardingRuleClass;
    }

    public static String toStringRbForwardingRuleClass(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "local(1)";
                break;
            }
            case 2: {
                result = "global(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbForwardingRuleType=").append(RbForwardingRuleConfigEntry.toStringRbForwardingRuleType(this.rbForwardingRuleType)).append(", ");
        result.append("rbForwardingRuleIdx=").append(this.rbForwardingRuleIdx).append(", ");
        result.append("rbForwardingRuleName=").append(this.rbForwardingRuleName).append(", ");
        result.append("rbForwardingRuleID=").append(this.rbForwardingRuleID).append(", ");
        result.append("rbForwardingRuleUnicastRelaying=").append(RbForwardingRuleConfigEntry.toStringRbForwardingRuleUnicastRelaying(this.rbForwardingRuleUnicastRelaying)).append(", ");
        result.append("rbForwardingRuleMulticastRelaying=").append(RbForwardingRuleConfigEntry.toStringRbForwardingRuleMulticastRelaying(this.rbForwardingRuleMulticastRelaying)).append(", ");
        result.append("rbForwardingUnknownAddrPolicy=").append(RbForwardingRuleConfigEntry.toStringRbForwardingUnknownAddrPolicy(this.rbForwardingUnknownAddrPolicy)).append(", ");
        result.append("rbForwardingRuleMulticastVLAN=").append(this.rbForwardingRuleMulticastVLAN).append(", ");
        result.append("rbForwardingRuleMulticastQoSIdx=").append(this.rbForwardingRuleMulticastQoSIdx).append(", ");
        result.append("rbAForwardingRuleRowStatus=").append(RbForwardingRuleConfigEntry.toStringRbAForwardingRuleRowStatus(this.rbAForwardingRuleRowStatus)).append(", ");
        result.append("rbForwardingRuleClass=").append(RbForwardingRuleConfigEntry.toStringRbForwardingRuleClass(this.rbForwardingRuleClass)).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Transient
    public String getRowKey() {
        return this.getRbForwardingRuleIdx().toString();
    }

    public void validateUndeclaredConstraints(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbForwardingRuleConfigEntryEditorView.class);
        String name = this.getRbForwardingRuleName();
        if (name == null || name.trim().equals("") || !name.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") || name.length() > 32) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidName"), RbForwardingRuleConfigEntry.class, "rbForwardingRuleName", (Object)name, (Object)this));
        }
        if (this.rbForwardingRuleMulticastQoSIdx == null) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidQosIdx"), RbForwardingRuleConfigEntry.class, "rbForwardingRuleMulticastQoSIdx", (Object)"", (Object)this));
        }
    }

    public String getComplexKey() {
        return this.complexKey;
    }

    public void setComplexKey(String complexKey) {
        this.complexKey = complexKey;
    }

    public void computeAndSetComplexKey(RbServiceProfiles serviceProfiles, boolean deep) {
        RbQoSProfileConfigEntry qosEntry;
        MultipleStringList attribValues = new MultipleStringList();
        attribValues.addToList(this.getRbForwardingRuleName());
        attribValues.addToList(this.getRbForwardingRuleType());
        attribValues.addToList(this.getRbForwardingRuleMulticastVLAN());
        if (this.rbForwardingRuleType != null && (this.rbForwardingRuleType == 1 || this.rbForwardingRuleType == 6 || this.rbForwardingRuleType == 7)) {
            attribValues.addToList(this.getRbForwardingRuleMulticastRelaying());
            attribValues.addToList(this.getRbForwardingRuleUnicastRelaying());
            attribValues.addToList(this.getRbForwardingUnknownAddrPolicy());
        } else {
            attribValues.addNullToList();
            attribValues.addNullToList();
            attribValues.addNullToList();
        }
        RbQoSProfileConfigEntry rbQoSProfileConfigEntry = qosEntry = null != this.getRbForwardingRuleMulticastQoSIdx() ? serviceProfiles.findQosProfileEntry(this.getRbForwardingRuleMulticastQoSIdx()) : null;
        if (null == qosEntry) {
            attribValues.addStringListToList(RbQoSProfileConfigEntry.getDefaultNullComplexKey());
        } else {
            if (deep) {
                qosEntry.computeAndSetComplexKey();
            }
            attribValues.addStringListToList(qosEntry.getComplexKey());
        }
        this.setComplexKey(attribValues.getAsString());
    }

    @Transient
    public static String getDefaultNullComplexKey() {
        if (null == defaultNullComplexKey) {
            RbForwardingRuleConfigEntry entry = new RbForwardingRuleConfigEntry();
            entry.computeAndSetComplexKey(null, false);
            defaultNullComplexKey = entry.getComplexKey();
        }
        return defaultNullComplexKey;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbForwardingRuleConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbForwardingRuleConfigEntry>(){

            public ManagedObjectAccessHandler<RbForwardingRuleConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbForwardingRuleConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbForwardingRuleConfigEntry>(){

            public ManagedObjectAccessHandler<RbForwardingRuleConfigEntry> createHandler() {
                return new RbForwardingRuleConfigTableRowMOAccessHandler(RbForwardingRuleConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbForwardingRuleConfigTableRowMOAccessHandler
    extends SNMPDynamicTableRowMOAccessHandler<RbForwardingRuleConfigEntry> {
        public RbForwardingRuleConfigTableRowMOAccessHandler(Class<RbForwardingRuleConfigEntry> moClass) {
            super(moClass);
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbForwardingRuleConfigEntry managedObject) throws MediationException {
            if (managedObject.getRbForwardingRuleIdx() < 0L) {
                Long idx = RbServiceProfilesGetNewEntryId.getNewIdxReplacement(access, "rbGetNewForwardingRuleId");
                managedObject.setRbForwardingRuleIdx(idx);
            }
            super.add(eq, access, networkResource, (DynamicTableRowMO)managedObject);
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbForwardingRuleConfigEntry managedObject) throws MediationException {
            if (eq instanceof RbBaseStationEquipment && ((RbBaseStationEquipment)eq).getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
                managedObject.setRbForwardingRuleName(null);
            }
            super.update(eq, access, networkResource, (ManagedObject)managedObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbForwardingRuleConfigEntry, ForwardingRulesDb_ForwardingRules> {
        private TreeMap<Integer, Long> qosIdIdxMap;
        private boolean ipSwitchingMode;

        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbForwardingRuleConfigEntry createEntry() {
            return new RbForwardingRuleConfigEntry();
        }

        @Override
        protected Class<ForwardingRulesDb_ForwardingRules> getDataObjectClass() {
            return ForwardingRulesDb_ForwardingRules.class;
        }

        private void prefetch(Equipment eq, MOAccessSession access) throws MediationException {
            SwitchingMode_Appl sm;
            RbBaseStationEquipment bsEq = (RbBaseStationEquipment)eq;
            this.ipSwitchingMode = bsEq instanceof RbBS && bsEq.getSoftwareVersion().isNewerOrEqualWith((Version)new DefaultVersion("4.1.1")) ? RbBSSwitchingModeParameters.SWITCHING_MODE_IP_CS == (sm = (SwitchingMode_Appl)access.fetchObject(null, SwitchingMode_Appl.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SwitchingMode_Appl.class), "*").get(0)).getActualProdType() : false;
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, QosDb_Qos.class);
            List qosTable = access.fetchObject(null, QosDb_Qos.class, includedProperties, "*");
            this.qosIdIdxMap = new TreeMap();
            for (QosDb_Qos qos : qosTable) {
                this.qosIdIdxMap.put(qos.getID(), qos.getINDEX());
            }
            this.qosIdIdxMap.put(0, 0L);
        }

        @Override
        public List<RbForwardingRuleConfigEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.prefetch(eq, access);
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        @Override
        protected void populateEntry(RbForwardingRuleConfigEntry entry, ForwardingRulesDb_ForwardingRules dataObject) {
            entry.setRbForwardingRuleID(dataObject.getID().longValue());
            entry.setRbForwardingRuleIdx(dataObject.getINDEX());
            entry.setRbForwardingRuleName(dataObject.getName());
            if (this.ipSwitchingMode) {
                switch (dataObject.getServiceType()) {
                    case 1: {
                        entry.setRbForwardingRuleType(5);
                        break;
                    }
                    case 3: {
                        entry.setRbForwardingRuleType(4);
                    }
                }
            } else {
                switch (dataObject.getServiceType()) {
                    case 1: {
                        entry.setRbForwardingRuleType(1);
                        break;
                    }
                    case 2: {
                        entry.setRbForwardingRuleType(2);
                        break;
                    }
                    case 6: {
                        entry.setRbForwardingRuleType(3);
                        break;
                    }
                    case 7: {
                        entry.setRbForwardingRuleType(6);
                    }
                }
            }
            entry.setRbForwardingRuleMulticastQoSIdx(this.qosIdIdxMap.get(dataObject.getMcastQoSId()));
            entry.setRbForwardingRuleMulticastRelaying(2 == dataObject.getMcastRelaying() ? 1 : 2);
            entry.setRbForwardingRuleMulticastVLAN(dataObject.getMcastVLAN());
            entry.setRbForwardingRuleUnicastRelaying(2 == dataObject.getUcastRelaying() ? 1 : 2);
            entry.setRbForwardingUnknownAddrPolicy(dataObject.getUnknownAddrFowrwardingPolicy());
            if (null != dataObject.getLock()) {
                entry.setRbForwardingRuleClass(0 == dataObject.getLock() ? 1 : 2);
            }
        }
    }
}

