/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.services;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.model.Identifiable;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.ServiceProfileDb_ServiceProfile;
import com.bwanms.rb.mo.configfile.SmCfg_Sm;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.100.1.8.1", indexColumns={"RbDfltServiceTemplateType"})
public class RbDfltServiceTemplateEntry
extends StaticTableRowMO
implements Identifiable {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbDfltServiceTemplateType;
    public static final int RbDfltServiceTemplateTypeRbLayerII = 1;
    public static final int RbDfltServiceTemplateTypeRbPPPoE = 2;
    public static final int RbDfltServiceTemplateTypeRbVoIP = 3;
    private Long rbDfltServiceTemplateIdx;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.1.8.1.1", type=2, readOnly=true)
    @IdentifierAttribute
    public Integer getRbDfltServiceTemplateType() {
        return this.rbDfltServiceTemplateType;
    }

    public void setRbDfltServiceTemplateType(Integer rbDfltServiceTemplateType) {
        this.rbDfltServiceTemplateType = rbDfltServiceTemplateType;
    }

    public String toStringRbDfltServiceTemplateType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "rbLayerII(1)";
                break;
            }
            case 2: {
                result = "rbPPPoE(2)";
                break;
            }
            case 3: {
                result = "rbVoIP(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.100.1.8.1.2", type=66)
    @ConfigAttribute
    public Long getRbDfltServiceTemplateIdx() {
        return this.rbDfltServiceTemplateIdx;
    }

    public void setRbDfltServiceTemplateIdx(Long rbDfltServiceTemplateIdx) {
        this.rbDfltServiceTemplateIdx = rbDfltServiceTemplateIdx;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbDfltServiceTemplateType=").append(this.toStringRbDfltServiceTemplateType(this.rbDfltServiceTemplateType)).append(", ");
        result.append("rbDfltServiceTemplateIdx=").append(this.rbDfltServiceTemplateIdx).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbDfltServiceTemplateType().toString();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbDfltServiceTemplateEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbDfltServiceTemplateEntry>(){

            public ManagedObjectAccessHandler<RbDfltServiceTemplateEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbDfltServiceTemplateEntry.class);
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbDfltServiceTemplateEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbDfltServiceTemplateEntry>(){

            public ManagedObjectAccessHandler<RbDfltServiceTemplateEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    implements ManagedObjectAccessHandler<RbDfltServiceTemplateEntry> {
        private Class<RbDfltServiceTemplateEntry> moClass = RbDfltServiceTemplateEntry.class;

        private ConfigFileMOAccessHandler() {
        }

        public List<RbDfltServiceTemplateEntry> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            List serviceProfiles = access.fetchObject(null, ServiceProfileDb_ServiceProfile.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, ServiceProfileDb_ServiceProfile.class), "*");
            SmCfg_Sm sm = (SmCfg_Sm)access.fetchObject(null, SmCfg_Sm.class, AttributeFilterUtil.getMatchedAttributes((Object)eq, SmCfg_Sm.class), "*").get(0);
            Integer[] defaults = new Integer[]{sm.getDefaultProfileId1(), sm.getDefaultProfileId2(), sm.getDefaultProfileId3()};
            ArrayList<RbDfltServiceTemplateEntry> ret = new ArrayList<RbDfltServiceTemplateEntry>();
            block0: for (int i = 0; i < 3; ++i) {
                RbDfltServiceTemplateEntry entry = new RbDfltServiceTemplateEntry();
                entry.setRbDfltServiceTemplateType(i + 1);
                ret.add(entry);
                for (ServiceProfileDb_ServiceProfile sp : serviceProfiles) {
                    if ((long)sp.getID().intValue() != defaults[i].longValue()) continue;
                    entry.setRbDfltServiceTemplateIdx(sp.getINDEX());
                    continue block0;
                }
            }
            return ret;
        }

        public void add(Equipment eq, MOAccessSession access, String networkResource, RbDfltServiceTemplateEntry managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot add [" + this.moClass.getName() + "]");
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbDfltServiceTemplateEntry managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot update [" + this.moClass.getName() + "]");
        }

        public void delete(Equipment eq, MOAccessSession access, String networkResource, RbDfltServiceTemplateEntry managedObject) throws MediationException {
            throw new UnsupportedOperationException("Cannot delete [" + this.moClass.getName() + "]");
        }
    }
}

