/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.pm;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultNetworkDomainObjectAccessHandler;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkDomainObject;
import com.bwanms.mo.NetworkDomainObjectAccessHandler;
import com.bwanms.mo.NetworkDomainObjectAccessHandlerRegistry;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbSuMultirateParametersGroup;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import java.util.ArrayList;
import java.util.List;

public class RbSuMultirateCountersGroup
implements NetworkDomainObject {
    private Double rbSuTxPower;
    private Double rbSuUlSNR;
    private Double rbSuUlRSSI;
    private Double rbSuDlSNR;
    private Double rbSuDlRSSI;
    private Integer rbSuUlCurrentRate;
    private Integer rbSuDlCurrentRate;
    public static final int RbSuDlCurrentRateNotDefined = 0;
    public static final int RbSuDlCurrentRateRBpsk12 = 1;
    public static final int RbSuDlCurrentRateRBpsk34 = 2;
    public static final int RbSuDlCurrentRateRQpsk12 = 3;
    public static final int RbSuDlCurrentRateRQpsk34 = 4;
    public static final int RbSuDlCurrentRateR16Qam12 = 5;
    public static final int RbSuDlCurrentRateR16Qam34 = 6;
    public static final int RbSuDlCurrentRateR64Qam23 = 7;
    public static final int RbSuDlCurrentRateR64Qam34 = 8;
    private Integer rbAuId;
    public static final int RbSuUlCurrentRateNotDefined = 0;
    public static final int RbSuUlCurrentRateRBpsk12 = 1;
    public static final int RbSuUlCurrentRateRBpsk34 = 2;
    public static final int RbSuUlCurrentRateRQpsk12 = 3;
    public static final int RbSuUlCurrentRateRQpsk34 = 4;
    public static final int RbSuUlCurrentRateR16Qam12 = 5;
    public static final int RbSuUlCurrentRateR16Qam34 = 6;
    public static final int RbSuUlCurrentRateR64Qam23 = 7;
    public static final int RbSuUlCurrentRateR64Qam34 = 8;

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.1", type=66, readOnly=true)
    @StateAttribute
    public Integer getRbAuId() {
        return this.rbAuId;
    }

    public void setRbAuId(Integer rbAuId) {
        this.rbAuId = rbAuId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.8", type=66)
    public Integer getRbSuDlCurrentRate() {
        return this.rbSuDlCurrentRate;
    }

    public void setRbSuDlCurrentRate(Integer rbSuDlCurrentRate) {
        this.rbSuDlCurrentRate = rbSuDlCurrentRate;
    }

    public static String toStringRbSuDlCurrentRate(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "notDefined";
                break;
            }
            case 1: {
                result = "rBpsk12";
                break;
            }
            case 2: {
                result = "rBpsk34";
                break;
            }
            case 3: {
                result = "rQpsk12";
                break;
            }
            case 4: {
                result = "rQpsk34";
                break;
            }
            case 5: {
                result = "r16Qam12";
                break;
            }
            case 6: {
                result = "r16Qam34";
                break;
            }
            case 7: {
                result = "r64Qam23";
                break;
            }
            case 8: {
                result = "r64Qam34";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.5", type=66)
    public Integer getRbSuUlCurrentRate() {
        return this.rbSuUlCurrentRate;
    }

    public void setRbSuUlCurrentRate(Integer rbSuUlCurrentRate) {
        this.rbSuUlCurrentRate = rbSuUlCurrentRate;
    }

    public static String toStringRbSuUlCurrentRate(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "notDefined";
                break;
            }
            case 1: {
                result = "rBpsk12";
                break;
            }
            case 2: {
                result = "rBpsk34";
                break;
            }
            case 3: {
                result = "rQpsk12";
                break;
            }
            case 4: {
                result = "rQpsk34";
                break;
            }
            case 5: {
                result = "r16Qam12";
                break;
            }
            case 6: {
                result = "r16Qam34";
                break;
            }
            case 7: {
                result = "r64Qam23";
                break;
            }
            case 8: {
                result = "r64Qam34";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.1", type=66)
    public Double getRbSuTxPower() {
        return this.rbSuTxPower;
    }

    public void setRbSuTxPower(Double rbSuTxPower) {
        this.rbSuTxPower = rbSuTxPower;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.3", type=66)
    public Double getRbSuUlSNR() {
        return this.rbSuUlSNR;
    }

    public void setRbSuUlSNR(Double rbSuUlSNR) {
        this.rbSuUlSNR = rbSuUlSNR;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.4", type=66)
    public Double getRbSuUlRSSI() {
        return this.rbSuUlRSSI;
    }

    public void setRbSuUlRSSI(Double rbSuUlRSSI) {
        this.rbSuUlRSSI = rbSuUlRSSI;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.6", type=66)
    public Double getRbSuDlSNR() {
        return this.rbSuDlSNR;
    }

    public void setRbSuDlSNR(Double rbSuDlSNR) {
        this.rbSuDlSNR = rbSuDlSNR;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.5.7", type=66)
    public Double getRbSuDlRSSI() {
        return this.rbSuDlRSSI;
    }

    public void setRbSuDlRSSI(Double rbSuDlRSSI) {
        this.rbSuDlRSSI = rbSuDlRSSI;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbSuTxPower=").append(this.rbSuTxPower).append(", ");
        result.append("rbSuUlSNR=").append(this.rbSuUlSNR).append(", ");
        result.append("rbSuUlRSSI=").append(this.rbSuUlRSSI).append(", ");
        result.append("rbSuDlSNR=").append(this.rbSuDlSNR).append(", ");
        result.append("rbSuDlRSSI=").append(this.rbSuDlRSSI).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getRowKey() {
        return "0";
    }

    static {
        NetworkDomainObjectAccessHandlerRegistry.registerHandler(RbSuMultirateCountersGroup.class, SNMP.class, (NetworkDomainObjectAccessHandler)new RbSuMultirateCountersAccessHandler(RbSuMultirateCountersGroup.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbSuMultirateCountersAccessHandler
    extends DefaultNetworkDomainObjectAccessHandler<RbSuMultirateCountersGroup> {
        Class<? extends ManagedObject> delegateClass = RbSuMultirateParametersGroup.class;

        public RbSuMultirateCountersAccessHandler(Class<RbSuMultirateCountersGroup> ndoClass) {
            super(ndoClass);
        }

        public List fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, this.delegateClass);
            RbSuMultirateParametersGroup paramsGroup = (RbSuMultirateParametersGroup)((Object)access.fetchObject(networkResource, this.delegateClass, includedProperties, instanceQuery).get(0));
            RbSuMultirateCountersGroup countersGroup = new RbSuMultirateCountersGroup();
            try {
                countersGroup.setRbSuTxPower(Double.valueOf(paramsGroup.getRbSuTxPower()));
            }
            catch (Exception e) {
                countersGroup.setRbSuTxPower(0.0);
            }
            try {
                countersGroup.setRbSuDlRSSI(Double.valueOf(paramsGroup.getRbSuDlRSSI()));
            }
            catch (Exception e) {
                countersGroup.setRbSuDlRSSI(0.0);
            }
            try {
                countersGroup.setRbSuDlSNR(Double.valueOf(paramsGroup.getRbSuDlSNR()));
            }
            catch (Exception e) {
                countersGroup.setRbSuDlSNR(0.0);
            }
            try {
                countersGroup.setRbSuUlRSSI(Double.valueOf(paramsGroup.getRbSuUlRSSI()));
            }
            catch (Exception e) {
                countersGroup.setRbSuUlRSSI(0.0);
            }
            try {
                countersGroup.setRbSuUlSNR(Double.valueOf(paramsGroup.getRbSuUlSNR()));
            }
            catch (Exception e) {
                countersGroup.setRbSuUlSNR(0.0);
            }
            try {
                countersGroup.setRbSuUlCurrentRate(paramsGroup.getRbSuUlCurrentRate());
            }
            catch (Exception e) {
                countersGroup.setRbSuUlCurrentRate(0);
            }
            try {
                countersGroup.setRbSuDlCurrentRate(paramsGroup.getRbSuDlCurrentRate());
            }
            catch (Exception e) {
                countersGroup.setRbSuDlCurrentRate(0);
            }
            try {
                RbRegisteredSuEntry suEntry = (RbRegisteredSuEntry)((Object)access.fetchObject(networkResource, RbRegisteredSuEntry.class, new String[]{"rbAuId"}, MacAddress.fromSimpleString((String)((RbSU)eq).getMacAddress()).toInstanceString()).get(0));
                countersGroup.setRbAuId(suEntry.getRbAuId());
            }
            catch (Exception e) {
                countersGroup.setRbAuId(null);
            }
            ArrayList<RbSuMultirateCountersGroup> list = new ArrayList<RbSuMultirateCountersGroup>();
            list.add(countersGroup);
            return list;
        }

        public void update(Equipment eq, MOAccessSession access, String networkResource, RbSuMultirateCountersGroup managedObject) throws MediationException {
        }
    }
}

