/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo.configfile;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.filters.AttributeFilterUtil;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.model.Equipment;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigFileMOAccessHandler<E extends ManagedObject, D>
implements ManagedObjectAccessHandler<E> {
    protected abstract Class<D> getDataObjectClass();

    protected abstract E createEntry();

    protected abstract void populateEntry(E var1, D var2);

    public List<E> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
        ArrayList<E> entries = new ArrayList<E>();
        if (instanceQuery != null && "*".compareTo(instanceQuery) != 0) {
            throw new UnsupportedOperationException("Config file - fetch operation wrong instance query format");
        }
        String[] includedProperties = AttributeFilterUtil.getMatchedAttributes((Object)eq, this.getDataObjectClass());
        List dataObjects = access.fetchObject(networkResource, this.getDataObjectClass(), includedProperties, instanceQuery);
        for (Object dataObject : dataObjects) {
            E entry = this.createEntry();
            this.populateEntry(entry, dataObject);
            entries.add(entry);
        }
        return entries;
    }

    public void add(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
        throw new UnsupportedOperationException("Config file - add operation not supported");
    }

    public void update(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
        throw new UnsupportedOperationException("Config file - update operation not supported");
    }

    public void delete(Equipment eq, MOAccessSession access, String networkResource, E managedObject) throws MediationException {
        throw new UnsupportedOperationException("Config file - delete operation not supported");
    }
}

