/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.gui.configuration.TrapsControlPanelControllerSw411;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.TrapSevDb_TrapSev;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.validation.WeakRange;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.6.2.1", indexColumns={"TrapEnterprizeId", "TrapId"})
public class RbTrapConfigEntry
extends StaticTableRowMO {
    private static final long serialVersionUID = -2804105218551754591L;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer trapEnterprizeId;
    private Integer trapId;
    private Integer trapEnable;
    private Integer trapSeverity;
    private Integer trapSuppressionInterval;
    public static final int TrapEnterprizeIdSnmp = 1;
    public static final int TrapEnterprizeIdRainbow = 2;
    public static final int TrapEnterprizeIdOther = 3;
    public static final int TrapEnableEnable = 1;
    public static final int TrapEnableDisable = 2;
    public static final int TrapSeverityNone = 0;
    public static final int TrapSeverityCritical = 1;
    public static final int TrapSeverityMajor = 2;
    public static final int TrapSeverityMinor = 3;
    public static final int TrapSeverityWarning = 4;
    public static final int TrapSeverityInfo = 5;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.2.1.1", type=2)
    @IdentifierAttribute
    public Integer getTrapEnterprizeId() {
        return this.trapEnterprizeId;
    }

    public void setTrapEnterprizeId(Integer trapEnterprizeId) {
        this.trapEnterprizeId = trapEnterprizeId;
    }

    public static String toStringTrapEnterprizeId(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "snmp(1)";
                break;
            }
            case 2: {
                result = "rainbow(2)";
                break;
            }
            case 3: {
                result = "other(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.2.1.2", type=2)
    @IdentifierAttribute
    public Integer getTrapId() {
        return this.trapId;
    }

    public void setTrapId(Integer trapId) {
        this.trapId = trapId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.2.1.3", type=2)
    @ConfigAttribute
    public Integer getTrapEnable() {
        return this.trapEnable;
    }

    public void setTrapEnable(Integer trapEnable) {
        this.trapEnable = trapEnable;
    }

    public static String toStringTrapEnable(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enable(1)";
                break;
            }
            case 2: {
                result = "disable(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.2.1.4", type=2)
    @ConfigAttribute
    public Integer getTrapSeverity() {
        return this.trapSeverity;
    }

    public void setTrapSeverity(Integer trapSeverity) {
        this.trapSeverity = trapSeverity;
    }

    public static String toStringTrapSeverity(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "none(0)";
                break;
            }
            case 1: {
                result = "critical(1)";
                break;
            }
            case 2: {
                result = "major(2)";
                break;
            }
            case 3: {
                result = "minor(3)";
                break;
            }
            case 4: {
                result = "warning(4)";
                break;
            }
            case 5: {
                result = "info(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringTrapSeveritySw411(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = TrapsControlPanelControllerSw411.Severity.NONE.toString();
                break;
            }
            case 1: {
                result = TrapsControlPanelControllerSw411.Severity.CRITICAL.toString();
                break;
            }
            case 2: {
                result = TrapsControlPanelControllerSw411.Severity.MAJOR.toString();
                break;
            }
            case 3: {
                result = TrapsControlPanelControllerSw411.Severity.MINOR.toString();
                break;
            }
            case 4: {
                result = TrapsControlPanelControllerSw411.Severity.WARNING.toString();
                break;
            }
            case 5: {
                result = TrapsControlPanelControllerSw411.Severity.INFO.toString();
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @WeakRange(min=0L, max=86400L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.6.2.1.5", type=2)
    @ConfigAttribute
    public Integer getTrapSuppressionInterval() {
        return this.trapSuppressionInterval;
    }

    public void setTrapSuppressionInterval(Integer trapSuppressionInterval) {
        this.trapSuppressionInterval = trapSuppressionInterval;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("trapEnterprizeId=").append(RbTrapConfigEntry.toStringTrapEnterprizeId(this.trapEnterprizeId)).append(", ");
        result.append("trapId=").append(this.trapId).append(", ");
        result.append("trapEnable=").append(RbTrapConfigEntry.toStringTrapEnable(this.trapEnable)).append(", ");
        result.append("trapSeverity=").append(RbTrapConfigEntry.toStringTrapSeverity(this.trapSeverity)).append(", ");
        result.append("trapSuppressionInterval=").append(this.trapSuppressionInterval).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.trapEnterprizeId + "." + this.trapId;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbTrapConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbTrapConfigEntry>(){

            public ManagedObjectAccessHandler<RbTrapConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbTrapConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbTrapConfigEntry>(){

            public ManagedObjectAccessHandler<RbTrapConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler<RbTrapConfigEntry>(RbTrapConfigEntry.class){

                    public void add(Equipment eq, MOAccessSession access, String networkResource, RbTrapConfigEntry managedObject) throws MediationException {
                        boolean isTDD = false;
                        if (VersionFactory.getInstance().createVersion(eq.getRunningSoftwareVersion()).compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) >= 0) {
                            isTDD = true;
                        }
                        if (!isTDD && managedObject.getTrapId() > 132) {
                            return;
                        }
                        super.add(eq, access, networkResource, (ManagedObject)managedObject);
                    }

                    public void update(Equipment eq, MOAccessSession access, String networkResource, RbTrapConfigEntry managedObject) throws MediationException {
                        boolean isTDD = false;
                        if (VersionFactory.getInstance().createVersion(eq.getRunningSoftwareVersion()).compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) >= 0) {
                            isTDD = true;
                        }
                        if (!isTDD && managedObject.getTrapId() > 132) {
                            return;
                        }
                        super.update(eq, access, networkResource, (ManagedObject)managedObject);
                    }
                };
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbTrapConfigEntry, TrapSevDb_TrapSev> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbTrapConfigEntry createEntry() {
            return new RbTrapConfigEntry();
        }

        @Override
        protected Class<TrapSevDb_TrapSev> getDataObjectClass() {
            return TrapSevDb_TrapSev.class;
        }

        @Override
        protected void populateEntry(RbTrapConfigEntry entry, TrapSevDb_TrapSev dataObject) {
            entry.setTrapEnable(dataObject.getTrapAdmin() == 1 ? 2 : 1);
            entry.setTrapSuppressionInterval(dataObject.getSuppressionInterval().intValue());
            int trapID = dataObject.getID();
            if (128 <= trapID && trapID <= 132) {
                entry.setTrapEnterprizeId(1);
                entry.setTrapId(trapID - 128);
            } else {
                entry.setTrapEnterprizeId(2);
                entry.setTrapId(trapID);
            }
            entry.setTrapSeverity(dataObject.getSev().intValue());
        }
    }
}

