/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.NullConfigFileMOAccessHandler;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
public class RbSysMicroBSTConfig
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String rbMBSTSerialNo;
    private String rbMBSTIduHwRevision;
    private String rbMBSTIduHwConfigDescription;
    private String rbMBSTOduHwRevision;
    private String rbMBSTOduHwConfigDescription;
    private String rbMBSTOperSwFileName;
    private String rbMBSTOperSwVersion;
    private Integer rbMBSTOperVersionValidity;
    private String rbMBSTShadowSwFileName;
    private String rbMBSTShadowSwVersion;
    private Integer rbMBSTShadowVersionValidity;
    private Integer rbMBSTRunningSoftware;
    private Integer rbMBSTManagementInterface;
    private Long rbMBSTCumulativePowerOnTime;
    private Integer rbMBSTIduTemperature;
    private String rbMBSTIduBootVersion;
    private Integer rbMBSTIduType;
    private String rbMBSTIduIfCardConfiguration;
    private String rbMBSTIduIfCardRevision;
    private Integer rbSysFaultStatus;
    private Integer rbMBSTRedundantCPLDVersion;
    public static final int RbMBSTRunningSoftwareOperational = 1;
    public static final int RbMBSTRunningSoftwareShadow = 2;
    public static final int RbMBSTRunningSoftwareUnknown = 3;
    public static final int RbMBSTManagementInterfaceManagementPort = 1;
    public static final int RbMBSTManagementInterfaceManagementAndDataPort = 2;
    public static final int RbMBSTIduTypeUnknown = 0;
    public static final int RbMBSTIduTypeTwoChannels = 1;
    public static final int RbMBSTIduTypeFourChannels = 2;
    public static final int RbMBSTIduTypeTwoChannelsHP = 3;
    public static final int RbMBSTIduTypeFourChannelsHP = 4;
    public static final int RbSysFaultStatusNoFaults = 1;
    public static final int RbSysFaultStatusMinor = 2;
    public static final int RbSysFaultStatusMajor = 3;
    public static final int RbSysFaultStatusCritical = 4;
    public static final int RbSysFaultStatusDisconnected = 5;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.1", type=-128)
    @InventoryAttribute
    public String getRbMBSTSerialNo() {
        return this.rbMBSTSerialNo;
    }

    public void setRbMBSTSerialNo(String rbMBSTSerialNo) {
        this.rbMBSTSerialNo = rbMBSTSerialNo;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.3", type=-128)
    @InventoryAttribute
    public String getRbMBSTIduHwRevision() {
        return this.rbMBSTIduHwRevision;
    }

    public void setRbMBSTIduHwRevision(String rbMBSTIduHwRevision) {
        this.rbMBSTIduHwRevision = rbMBSTIduHwRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.4", type=-128)
    @InventoryAttribute
    public String getRbMBSTIduHwConfigDescription() {
        return this.rbMBSTIduHwConfigDescription;
    }

    public void setRbMBSTIduHwConfigDescription(String rbMBSTIduHwConfigDescription) {
        this.rbMBSTIduHwConfigDescription = rbMBSTIduHwConfigDescription;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.5", type=-128)
    @InventoryAttribute
    public String getRbMBSTOduHwRevision() {
        return this.rbMBSTOduHwRevision;
    }

    public void setRbMBSTOduHwRevision(String rbMBSTOduHwRevision) {
        this.rbMBSTOduHwRevision = rbMBSTOduHwRevision;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.6", type=-128)
    @InventoryAttribute
    public String getRbMBSTOduHwConfigDescription() {
        return this.rbMBSTOduHwConfigDescription;
    }

    public void setRbMBSTOduHwConfigDescription(String rbMBSTOduHwConfigDescription) {
        this.rbMBSTOduHwConfigDescription = rbMBSTOduHwConfigDescription;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.7", type=-128)
    @InventoryAttribute
    public String getRbMBSTOperSwFileName() {
        return this.rbMBSTOperSwFileName;
    }

    public void setRbMBSTOperSwFileName(String rbMBSTOperSwFileName) {
        this.rbMBSTOperSwFileName = rbMBSTOperSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.8", type=-128)
    @InventoryAttribute
    public String getRbMBSTOperSwVersion() {
        return this.rbMBSTOperSwVersion;
    }

    public void setRbMBSTOperSwVersion(String rbMBSTOperSwVersion) {
        this.rbMBSTOperSwVersion = rbMBSTOperSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.10", type=-128)
    @InventoryAttribute
    public String getRbMBSTShadowSwFileName() {
        return this.rbMBSTShadowSwFileName;
    }

    public void setRbMBSTShadowSwFileName(String rbMBSTShadowSwFileName) {
        this.rbMBSTShadowSwFileName = rbMBSTShadowSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.11", type=-128)
    @InventoryAttribute
    public String getRbMBSTShadowSwVersion() {
        return this.rbMBSTShadowSwVersion;
    }

    public void setRbMBSTShadowSwVersion(String rbMBSTShadowSwVersion) {
        this.rbMBSTShadowSwVersion = rbMBSTShadowSwVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.13", type=2)
    @InventoryAttribute
    public Integer getRbMBSTRunningSoftware() {
        return this.rbMBSTRunningSoftware;
    }

    public void setRbMBSTRunningSoftware(Integer rbMBSTRunningSoftware) {
        this.rbMBSTRunningSoftware = rbMBSTRunningSoftware;
    }

    public static String toStringRbMBSTRunningSoftware(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "operational(1)";
                break;
            }
            case 2: {
                result = "shadow(2)";
                break;
            }
            case 3: {
                result = "unknown(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.16", type=2)
    @StateAttribute
    public Integer getRbMBSTManagementInterface() {
        return this.rbMBSTManagementInterface;
    }

    public void setRbMBSTManagementInterface(Integer rbMBSTManagementInterface) {
        this.rbMBSTManagementInterface = rbMBSTManagementInterface;
    }

    public static String toStringRbMBSTManagementInterface(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "managementPort(1)";
                break;
            }
            case 2: {
                result = "managementAndDataPort(2)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.21", type=66)
    @StateAttribute
    public Long getRbMBSTCumulativePowerOnTime() {
        return this.rbMBSTCumulativePowerOnTime;
    }

    public void setRbMBSTCumulativePowerOnTime(Long rbMBSTCumulativePowerOnTime) {
        this.rbMBSTCumulativePowerOnTime = rbMBSTCumulativePowerOnTime;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.26", type=2)
    @StateAttribute
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    public Integer getRbMBSTRedundantCPLDVersion() {
        return this.rbMBSTRedundantCPLDVersion;
    }

    public void setRbMBSTRedundantCPLDVersion(Integer rbMBSTRedundantCPLDVersion) {
        this.rbMBSTRedundantCPLDVersion = rbMBSTRedundantCPLDVersion;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbMBSTSerialNo=").append(this.rbMBSTSerialNo).append(", ");
        result.append("rbMBSTIduHwRevision=").append(this.rbMBSTIduHwRevision).append(", ");
        result.append("rbMBSTIduType=").append(this.rbMBSTIduType).append(", ");
        result.append("rbMBSTIduHwConfigDescription=").append(this.rbMBSTIduHwConfigDescription).append(", ");
        result.append("rbMBSTOduHwRevision=").append(this.rbMBSTOduHwRevision).append(", ");
        result.append("rbMBSTOduHwConfigDescription=").append(this.rbMBSTOduHwConfigDescription).append(", ");
        result.append("rbMBSTOperSwFileName=").append(this.rbMBSTOperSwFileName).append(", ");
        result.append("rbMBSTOperSwVersion=").append(this.rbMBSTOperSwVersion).append(", ");
        result.append("rbMBSTShadowSwFileName=").append(this.rbMBSTShadowSwFileName).append(", ");
        result.append("rbMBSTShadowSwVersion=").append(this.rbMBSTShadowSwVersion).append(", ");
        result.append("rbMBSTRunningSoftware=").append(RbSysMicroBSTConfig.toStringRbMBSTRunningSoftware(this.rbMBSTRunningSoftware)).append(", ");
        result.append("rbMBSTManagementInterface=").append(RbSysMicroBSTConfig.toStringRbMBSTManagementInterface(this.rbMBSTManagementInterface)).append(", ");
        result.append("rbMBSTCumulativePowerOnTime=").append(this.rbMBSTCumulativePowerOnTime).append(", ");
        result.append("rbMBSTRedundantCPLDVersion=").append(this.rbMBSTRedundantCPLDVersion).append(", ");
        result.append("rbMBSTIduTemperature=").append(this.rbMBSTIduTemperature).append(", ");
        result.append("]");
        return result.toString();
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.2", type=2)
    @InventoryAttribute
    public Integer getRbMBSTIduTemperature() {
        return this.rbMBSTIduTemperature;
    }

    public void setRbMBSTIduTemperature(Integer rbMBSTIduTemperature) {
        this.rbMBSTIduTemperature = rbMBSTIduTemperature;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.18.3", type=-128)
    @StateAttribute
    public String getRbMBSTIduBootVersion() {
        return this.rbMBSTIduBootVersion;
    }

    public void setRbMBSTIduBootVersion(String rbMBSTIduBootVersion) {
        this.rbMBSTIduBootVersion = rbMBSTIduBootVersion;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.18.7", type=2, readOnly=true)
    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", "[3.5-4.0.0]"})
    @StateAttribute
    public Integer getRbMBSTIduType() {
        return this.rbMBSTIduType;
    }

    public void setRbMBSTIduType(Integer rbMBSTIduType) {
        this.rbMBSTIduType = rbMBSTIduType;
    }

    public static String toStringRbMBSTIduType(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "twoChannels(1)";
                break;
            }
            case 2: {
                result = "fourChannels(2)";
                break;
            }
            case 3: {
                result = "twoChannels-HP(3)";
                break;
            }
            case 4: {
                result = "fourChannels-HP(4)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.18.2", type=-128)
    @StateAttribute
    public String getRbMBSTIduIfCardConfiguration() {
        return this.rbMBSTIduIfCardConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.4.1.18.1", type=-128)
    @StateAttribute
    public String getRbMBSTIduIfCardRevision() {
        return this.rbMBSTIduIfCardRevision;
    }

    public void setRbMBSTIduIfCardConfiguration(String rbMBSTIduIfCardConfiguration) {
        this.rbMBSTIduIfCardConfiguration = rbMBSTIduIfCardConfiguration;
    }

    public void setRbMBSTIduIfCardRevision(String rbMBSTIduIfCardRevision) {
        this.rbMBSTIduIfCardRevision = rbMBSTIduIfCardRevision;
    }

    @Transient
    public String getRuningSwVersion() {
        switch (this.rbMBSTRunningSoftware) {
            case 1: {
                return this.rbMBSTOperSwVersion;
            }
            case 2: {
                return this.rbMBSTShadowSwVersion;
            }
        }
        return "unknown(3)";
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.1.1.1", type=2)
    @StateAttribute
    public Integer getRbSysFaultStatus() {
        return this.rbSysFaultStatus;
    }

    public void setRbSysFaultStatus(Integer rbSysFaultStatus) {
        this.rbSysFaultStatus = rbSysFaultStatus;
    }

    public static String toStringRbSysFaultStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "noFaults(1)";
                break;
            }
            case 2: {
                result = "minor(2)";
                break;
            }
            case 3: {
                result = "major(3)";
                break;
            }
            case 4: {
                result = "critical(4)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Transient
    public boolean isConnected() {
        return this.rbSysFaultStatus != 5;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSysMicroBSTConfig.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSysMicroBSTConfig>(){

            public ManagedObjectAccessHandler<RbSysMicroBSTConfig> createHandler() {
                return new NullConfigFileMOAccessHandler<RbSysMicroBSTConfig>();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSysMicroBSTConfig.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSysMicroBSTConfig>(){

            public ManagedObjectAccessHandler<RbSysMicroBSTConfig> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbSysMicroBSTConfig.class);
            }
        });
    }
}

