/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.filters.Filter;
import com.bwanms.meta.filters.VersionFilter;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.InventoryAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.SuDb_Su;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.1.1", indexColumns={"RbSuMacAddr"})
public class RbSwRegisteredSuEntry
extends StaticTableRowMO {
    private static final long serialVersionUID = -325903715968178193L;
    private long id;
    private String instance;
    private NetworkResourceConfiguration nrConfiguration;
    private Integer rbAuId;
    private String rbSuMacAddr;
    private String rbSuSysName;
    private Integer rbSuUnitControl;
    private String rbSuUpgradeSwFileName;
    public static final int RbSuUnitControlNone = 1;
    public static final int RbSuUnitControlReset = 2;
    public static final int RbSuUnitControlPutToShadow = 3;
    public static final int RbSuUnitControlResetAndRunFromShadow = 4;
    public static final int RbSuUnitControlMakeRunningVersionOperational = 5;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.1", type=2)
    @StateAttribute
    public Integer getRbAuId() {
        return this.rbAuId;
    }

    public void setRbAuId(Integer rbAuId) {
        this.rbAuId = rbAuId;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112)
    @IdentifierAttribute
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.7", type=-128)
    @InventoryAttribute
    public String getRbSuSysName() {
        return this.rbSuSysName;
    }

    public void setRbSuSysName(String rbSuSysName) {
        this.rbSuSysName = rbSuSysName;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.17", type=2)
    @ConfigAttribute
    public Integer getRbSuUnitControl() {
        return this.rbSuUnitControl;
    }

    public void setRbSuUnitControl(Integer rbSuUnitControl) {
        this.rbSuUnitControl = rbSuUnitControl;
    }

    public static String toStringRbSuUnitControl(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 2: {
                result = "reset(2)";
                break;
            }
            case 3: {
                result = "putToShadow(3)";
                break;
            }
            case 4: {
                result = "resetAndRunFromShadow(4)";
                break;
            }
            case 5: {
                result = "makeRunningVersionOperational(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @Filter(filterClass=VersionFilter.class, values={"softwareVersion", ">=4.0"})
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.25", type=-128)
    @ConfigAttribute
    public String getRbSuUpgradeSwFileName() {
        return this.rbSuUpgradeSwFileName;
    }

    public void setRbSuUpgradeSwFileName(String rbSuUpgradeSwFileName) {
        this.rbSuUpgradeSwFileName = rbSuUpgradeSwFileName;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbAuId=").append(this.rbAuId).append(", ");
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbSuSysName=").append(this.rbSuSysName).append(", ");
        result.append("rbSuUnitControl=").append(RbSwRegisteredSuEntry.toStringRbSuUnitControl(this.rbSuUnitControl)).append(", ");
        result.append("rbSuUpgradeSwFileName=").append(this.rbSuUpgradeSwFileName).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.rbSuMacAddr;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSwRegisteredSuEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSwRegisteredSuEntry>(){

            public ManagedObjectAccessHandler<RbSwRegisteredSuEntry> createHandler() {
                return new AbstractConfigFileMOAccessHandler<RbSwRegisteredSuEntry, SuDb_Su>(){

                    @Override
                    protected Class<SuDb_Su> getDataObjectClass() {
                        return SuDb_Su.class;
                    }

                    @Override
                    protected RbSwRegisteredSuEntry createEntry() {
                        return new RbSwRegisteredSuEntry();
                    }

                    @Override
                    protected void populateEntry(RbSwRegisteredSuEntry entry, SuDb_Su dataObject) {
                        entry.setRbSuMacAddr(dataObject.getMACAddress().toUpperCase());
                        entry.setRbSuUpgradeSwFileName(dataObject.getSWFileName());
                    }
                };
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbSwRegisteredSuEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbSwRegisteredSuEntry>(){

            public ManagedObjectAccessHandler<RbSwRegisteredSuEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbSwRegisteredSuEntry.class);
            }
        });
    }
}

